/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.ICoreContext;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.ServiceConfigStorageObject;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinitionInfo;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import com.sap.caf.mp.core.user.IUserContext;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ServiceRegistryPersistenceImpl {
    private static final String m_stmtServiceSelect = "SELECT * FROM CAF_RT_SVCDEF WHERE SVC_ID=?";
    private static final String m_stmtServiceSelectAll = "SELECT * FROM CAF_RT_SVCDEF";
    private static final String m_smtServiceSelectByServiceTypeName = "SELECT * FROM CAF_RT_SVCDEF WHERE SVC_TYPE_NAME=?";
    private static final String m_stmtServiceInsert = "INSERT INTO CAF_RT_SVCDEF(SVC_ID,SVC_TYPE_NAME,PORT_TYPE_ID,CREATOR,CREATED,CHANGER,CHANGED) VALUES(?,?,?,?,?,?,?)";
    private static final String m_stmtServiceUpdate = "UPDATE CAF_RT_SVCDEF SET SVC_TYPE_NAME=?, PORT_TYPE_ID=?, CHANGER=?, CHANGED=? WHERE SVC_ID=?";
    private static final String m_stmtServiceDelete = "DELETE FROM CAF_RT_SVCDEF WHERE SVC_ID=?";
    private ICNConnectionPool m_connectionPool;
    private IDataServiceFactory m_dataServiceFactory;
    private ICoreContext m_coreContext;

    public ServiceRegistryPersistenceImpl(ICNConnectionPool connectionPool, IDataServiceFactory dataServiceFactory, ICoreContext coreContext) {
        this.m_connectionPool = connectionPool;
        this.m_dataServiceFactory = dataServiceFactory;
        this.m_coreContext = coreContext;
    }

    public boolean checkServiceDefExists(String serviceId) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtServiceSelect);
            stmt.setString(1, serviceId);
            ResultSet rs = stmt.executeQuery();
            boolean exists = rs.next();
            rs.close();
            stmt.close();
            conn.close();
            return exists;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public void deleteServiceDefinition(String id) throws InvocationException, EngineException {
        Connection conn = null;
        long now = GregorianCalendar.getInstance().getTime().getTime();
        try {
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtServiceDelete);
            stmt.setString(1, id);
            stmt.execute();
            stmt.close();
            this.m_coreContext.deleteFromSecureStore(id);
            BaseLogManager.info(this.getClass(), (String)("deleted props from secure store for " + id));
            conn.commit();
            conn.close();
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public ServiceDefinition getServiceDefinition(String id) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtServiceSelect);
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new InvocationException("The service definition does not exist.");
            }
            String svcTypeName = rs.getString("SVC_TYPE_NAME");
            String portTypeId = rs.getString("PORT_TYPE_ID");
            String creator = rs.getString("CREATOR");
            long created = rs.getLong("CREATED");
            String changer = rs.getString("CHANGER");
            long changed = rs.getLong("CHANGED");
            ServiceDefinition def = new ServiceDefinition(svcTypeName, id, creator, new Date(created), changer, new Date(changed), this.m_dataServiceFactory);
            def.setPortTypeId(portTypeId);
            rs.close();
            stmt.close();
            ServiceConfigStorageObject serviceConfig = (ServiceConfigStorageObject)this.m_coreContext.getFromSecureStore(id);
            BaseLogManager.info(this.getClass(), (String)("retrieved props from secure store for " + id));
            if (serviceConfig != null) {
                def.setPortTypeProperties(serviceConfig.getPortTypeConfig());
                def.setOperationProperties(serviceConfig.getOperationProperties());
                BaseLogManager.info(this.getClass(), (String)("set props from secure store to " + id));
            }
            conn.close();
            return def;
        }
        catch (InvocationException ex) {
            PersistenceManagers.recoverAndClose(conn);
            throw ex;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public Vector getServiceDefinitionInfos() throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtServiceSelectAll);
            ResultSet rs = stmt.executeQuery();
            Vector<ServiceDefinitionInfo> result = new Vector<ServiceDefinitionInfo>();
            while (rs.next()) {
                String svcId = rs.getString("SVC_ID");
                String svcTypeName = rs.getString("SVC_TYPE_NAME");
                String portTypeId = rs.getString("PORT_TYPE_ID");
                ServiceDefinitionInfo info = new ServiceDefinitionInfo(svcId, portTypeId, svcTypeName);
                result.add(info);
            }
            rs.close();
            stmt.close();
            conn.close();
            return result;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public Vector getServiceDefinitionInfos(String typeName) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_smtServiceSelectByServiceTypeName);
            stmt.setString(1, typeName);
            ResultSet rs = stmt.executeQuery();
            Vector<ServiceDefinitionInfo> result = new Vector<ServiceDefinitionInfo>();
            while (rs.next()) {
                String svcId = rs.getString("SVC_ID");
                String portTypeId = rs.getString("PORT_TYPE_ID");
                ServiceDefinitionInfo info = new ServiceDefinitionInfo(svcId, portTypeId, typeName);
                result.add(info);
            }
            rs.close();
            stmt.close();
            conn.close();
            return result;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public void writeServiceDefinition(IServiceDefinition definition, IUserContext ctxt) throws InvocationException, EngineException {
        boolean exists = this.checkServiceDefExists(definition.getId());
        Connection conn = null;
        long now = GregorianCalendar.getInstance().getTime().getTime();
        try {
            PreparedStatement stmt;
            String uniqueId = ctxt.getUniqueId();
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            if (exists) {
                stmt = conn.prepareStatement(m_stmtServiceUpdate);
                stmt.setString(1, definition.getTypeName());
                stmt.setString(2, definition.getPortTypeId());
                stmt.setString(3, uniqueId);
                stmt.setLong(4, now);
                stmt.setString(5, definition.getId());
            } else {
                stmt = conn.prepareStatement(m_stmtServiceInsert);
                stmt.setString(1, definition.getId());
                stmt.setString(2, definition.getTypeName());
                stmt.setString(3, definition.getPortTypeId());
                stmt.setString(4, uniqueId);
                stmt.setLong(5, now);
                stmt.setString(6, uniqueId);
                stmt.setLong(7, now);
            }
            stmt.execute();
            stmt.close();
            ServiceConfigStorageObject serviceConfig = new ServiceConfigStorageObject(definition.getPortTypeProperties(), definition.getOperationProperties());
            this.m_coreContext.setToSecureStore(definition.getId(), (Serializable)serviceConfig);
            BaseLogManager.info(this.getClass(), (String)("saved config for " + definition.getId()));
            conn.commit();
            conn.close();
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            try {
                this.m_coreContext.deleteFromSecureStore(definition.getId());
            }
            catch (Exception e) {
                BaseLogManager.error(this.getClass(), (Exception)e);
            }
            throw new EngineException(ex);
        }
    }
}

