/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.mapping;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.uuid.BaseUUIDManager;
import com.sap.caf.mp.core.data.mapping.api.IMappingRule;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.service.mapping.MappingRulesPersistenceImpl;
import com.sap.caf.mp.core.user.IUserContext;
import java.util.Vector;

public class MappingService
implements IMappingService {
    private String m_fallbackLanguage;
    private MappingRulesPersistenceImpl m_persistence;

    public MappingService(ICNConnectionPool connectionPool, String fallbackLanguage) {
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_persistence = new MappingRulesPersistenceImpl(connectionPool);
    }

    public IMappingRule getMappingRule(String ruleId) throws InvocationException, EngineException {
        return this.m_persistence.getMappingRule(ruleId);
    }

    public void deleteMappingRule(String ruleId, IUserContext ctxt) throws InvocationException, EngineException {
        this.m_persistence.deleteMappingRule(ruleId);
    }

    public Vector getMappingRuleIds() throws EngineException {
        return this.m_persistence.getMappingRuleIds();
    }

    public void addMappingRule(IMappingRule mappingRule, IUserContext ctxt) throws InvocationException, EngineException {
        this.m_persistence.addMappingRule(mappingRule, ctxt);
    }

    public IMappingRule addMappingRule(String ruleId, String sourceMessageId, String targetMessageId, Vector mappingRuleEntries, IUserContext ctxt) throws InvocationException, EngineException {
        return this.m_persistence.addMappingRule(ruleId, sourceMessageId, targetMessageId, mappingRuleEntries, ctxt);
    }

    public IMappingRule createMappingRule(String sourceMessageId, String targetMessageId, Vector mappingRuleEntries, IUserContext ctxt) throws InvocationException, EngineException {
        String ruleId = BaseUUIDManager.getUUIDStringFromBytes((byte[])BaseUUIDManager.generateUUID(), (boolean)false);
        if (ruleId == null) {
            throw new EngineException("Unable to generate uuid for a new rule.");
        }
        return this.m_persistence.addMappingRule(ruleId, sourceMessageId, targetMessageId, mappingRuleEntries, ctxt);
    }

    public Vector getMappingRuleIds(String sourceMessageId, String targetMessageId) throws InvocationException, EngineException {
        return this.m_persistence.getMappingRuleIds(sourceMessageId, targetMessageId);
    }

    public IMappingRule changeMappingRule(IMappingRule mappingRule, IUserContext ctxt) throws InvocationException, EngineException {
        return this.m_persistence.changeMappingRule(mappingRule, ctxt);
    }

    public Vector getMappingRuleIdsBySource(String ruleId) throws EngineException {
        return this.m_persistence.getMappingRuleIdsBySource(ruleId);
    }

    public Vector getMappingRuleIdsByTarget(String ruleId) throws EngineException {
        return this.m_persistence.getMappingRuleIdsByTarget(ruleId);
    }
}

