/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.util.ExternalDate;
import com.sap.caf.mp.core.data.service.manager.wsdl11.WsdlToIMessageConverter;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.services.webservices.jaxm.soap.SOAPNameImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPToMessageValueConverter {
    private static final String XMLSCHEMA_INSTANCE_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final Location log = Location.getLocation((String)"com.sap.caf.mp.core.data.service.manager.wsdl11");
    public static final Category cat = Category.SYS_NETWORK;
    private Properties operationConfig;

    public SOAPToMessageValueConverter(Properties operationConfig) {
        this.operationConfig = operationConfig;
    }

    public IMessageValue getMessageValue(SOAPMessage soapMessage, IMessage message) throws EngineException, InvocationException {
        ArrayList elementValues;
        SOAPBody soapBody;
        MessageValue messageValue = new MessageValue(message);
        Object soapBodyElement = null;
        try {
            soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
        }
        catch (SOAPException soape) {
            throw new EngineException("Error while processing the soap response", (Exception)((Object)soape));
        }
        ComplexType complexType = new ComplexType();
        Enumeration enumeration = message.getMessagepartEnumeration();
        while (enumeration.hasMoreElements()) {
            IMessagepart messagePart = (IMessagepart)enumeration.nextElement();
            complexType.addElement((IElement)messagePart.getStructure());
        }
        try {
            elementValues = this.processComplexTypeMode((SOAPElement)soapBody, (IComplexType)complexType, true, true, 0);
        }
        catch (EngineException ee) {
            log.debugT(soapMessage.toString());
            throw ee;
        }
        catch (InvocationException ie) {
            log.debugT(soapMessage.toString());
            throw ie;
        }
        for (int i = 0; i < elementValues.size(); ++i) {
            MessagepartValue messagePartValue = new MessagepartValue(message.getMessagepart(i));
            messagePartValue.setStructureValue((IStructureValue)((IElementValue)elementValues.get(i)));
            messageValue.addMessagepartValue((IMessagepartValue)messagePartValue);
        }
        return messageValue;
    }

    private ITypeValue generateTypeValue(SOAPElement soapElement, IType type, int depth) throws EngineException, InvocationException {
        String nilAttribute;
        if (soapElement != null && "true".equals(nilAttribute = soapElement.getAttributeValue((Name)new SOAPNameImpl("nil", XMLSCHEMA_INSTANCE_NAMESPACE_URI)))) {
            return null;
        }
        if (type == null) {
            return null;
        }
        switch (type.getTypeCast()) {
            case 2: {
                ISimpleType simpleType = (ISimpleType)type;
                if (soapElement == null) {
                    return new SimpleTypeValue(simpleType);
                }
                if (simpleType.getConstantCount() > 0) {
                    String value = soapElement.getValue();
                    Enumeration enumeration = simpleType.getConstantEnumeration();
                    while (enumeration.hasMoreElements()) {
                        ISimpleTypeValue enumSimpleTypeValue = (ISimpleTypeValue)enumeration.nextElement();
                        if (!enumSimpleTypeValue.getValue().equals(value)) continue;
                        return enumSimpleTypeValue;
                    }
                    throw new EngineException("Invalid soap message received");
                }
                return SOAPToMessageValueConverter.generateSimpleTypeValue(soapElement.getValue() != null ? soapElement.getValue() : "", (ISimpleType)type);
            }
            case 1: {
                if (soapElement == null) {
                    return new ComplexTypeValue((IComplexType)type);
                }
                IComplexTypeValue typeValue = this.generateComplexTypeValue(soapElement, (IComplexType)type, depth);
                return typeValue;
            }
        }
        return null;
    }

    private boolean generateElementValue(ArrayList soapElements, IElement element, ElementValue elementValue, int depth) throws EngineException, InvocationException {
        if (soapElements.size() < element.getMinOccurs() || soapElements.size() > element.getMaxOccurs() && element.getMaxOccurs() > 0) {
            return false;
        }
        if (soapElements.size() != 0) {
            for (int i = 0; i < soapElements.size(); ++i) {
                SOAPElement soapElement = (SOAPElement)soapElements.get(i);
                String elementNamespace = soapElement.getElementName().getURI();
                WsdlToIMessageConverter.DeconstructedName deconstructedName = WsdlToIMessageConverter.deconstructName(element.getName(), this.operationConfig);
                if (!soapElement.getElementName().getLocalName().equals(deconstructedName.getLocalName()) || deconstructedName.isQualified() && (elementNamespace == null || !elementNamespace.equals(deconstructedName.getUri()))) {
                    throw new EngineException("Invalid soap message received");
                }
                ITypeValue typeValue = this.generateTypeValue(soapElement, element.getType(), depth + 1);
                if (typeValue == null) continue;
                elementValue.addTypeValue(typeValue);
            }
        }
        return true;
    }

    private IComplexTypeValue generateComplexTypeValue(SOAPElement soapElement, IComplexType complexType, int depth) throws EngineException, InvocationException {
        ArrayList elementValues = null;
        ComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);
        switch (complexType.getMode()) {
            case 2: {
                elementValues = this.processComplexTypeMode(soapElement, complexType, false, false, depth);
                break;
            }
            case 1: {
                elementValues = this.processComplexTypeMode(soapElement, complexType, true, false, depth);
                break;
            }
            case 3: {
                elementValues = this.processComplexTypeMode(soapElement, complexType, true, true, depth);
            }
        }
        for (int i = 0; i < elementValues.size(); ++i) {
            IElementValue elementValue = (IElementValue)elementValues.get(i);
            if (elementValue.getTypeValueCount() == 1 && elementValue.getTypeValue(0) != null && elementValue.getTypeValue(0) instanceof ISimpleTypeValue && ((ISimpleTypeValue)elementValue.getTypeValue(0)).getValue() == null || elementValue.getTypeValueCount() == 0) continue;
            complexTypeValue.addElementValue(elementValue);
        }
        return complexTypeValue;
    }

    private ArrayList processComplexTypeMode(SOAPElement soapElement, IComplexType complexType, boolean all, boolean ordered, int depth) throws EngineException, InvocationException {
        Hashtable elementsTable = new Hashtable();
        ArrayList<IElement> elementsOrderedBySoap = new ArrayList<IElement>();
        ArrayList<ElementValue> elementValues = new ArrayList<ElementValue>();
        Enumeration enumeration = complexType.getElementEnumeration();
        while (enumeration.hasMoreElements()) {
            elementsTable.put(enumeration.nextElement(), new ArrayList());
        }
        Iterator iter = soapElement.getChildElements();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof SOAPElement)) continue;
            SOAPElement soapChildElement = (SOAPElement)obj;
            Name soapChildElementName = soapChildElement.getElementName();
            WsdlToIMessageConverter.DeconstructedName deconstructedName = WsdlToIMessageConverter.deconstructName(soapChildElementName.getURI(), soapChildElementName.getLocalName(), this.operationConfig);
            IElement element = complexType.getElement(deconstructedName.getName());
            if (element == null) {
                throw new EngineException("Invalid soap message received");
            }
            ArrayList soapElements = (ArrayList)elementsTable.get(element);
            if (soapElements.size() == 0) {
                elementsOrderedBySoap.add(element);
            }
            soapElements.add(soapChildElement);
        }
        int valid = 0;
        int empty = 0;
        int emptyValid = 0;
        Enumeration enum2 = elementsTable.keys();
        while (enum2.hasMoreElements()) {
            IElement element = (IElement)enum2.nextElement();
            ArrayList soapElements = (ArrayList)elementsTable.get(element);
            ElementValue elementValue = new ElementValue(element);
            if (soapElements.size() == 0) {
                ++empty;
            }
            if (!this.generateElementValue(soapElements, element, elementValue, depth)) continue;
            ++valid;
            if (soapElements.size() == 0) {
                ++emptyValid;
            }
            if (!all && (all || soapElements.size() <= 0)) continue;
            elementValues.add(elementValue);
        }
        if (all ? valid != complexType.getElementCount() : complexType.getElementCount() != empty && (valid - emptyValid != 1 || complexType.getElementCount() - (valid + empty - emptyValid) != 0)) {
            throw new EngineException("Invalid soap message received");
        }
        if (ordered) {
            int j = 0;
            for (int i = 0; i < complexType.getElementCount() && j < elementsOrderedBySoap.size(); ++i) {
                if (!complexType.getElement(i).equals(elementsOrderedBySoap.get(j))) continue;
                ++j;
            }
            if (j < elementsOrderedBySoap.size()) {
                throw new EngineException("Invalid soap message received");
            }
        }
        return elementValues;
    }

    public static ISimpleTypeValue generateSimpleTypeValue(String value, ISimpleType simpleType) throws InvocationException {
        SimpleTypeValue simpleTypeValue = new SimpleTypeValue(simpleType);
        switch (simpleType.getBase()) {
            case 1: {
                byte[] byteArray = BASE64Decoder.decode((byte[])value.getBytes());
                if (byteArray.length > simpleType.getMaxLength() && simpleType.getMaxLength() > 0) {
                    throw new InvocationException("Invalid {0} type {1} value {2}");
                }
                simpleTypeValue.setValueByteArray(byteArray);
                break;
            }
            case 4: 
            case 13: 
            case 14: {
                Date timeStamp = ExternalDate.parseTimeStamp((String)value);
                simpleTypeValue.setValueDate(timeStamp);
                break;
            }
            case 2: {
                if (value.equals("true") || value.equals("1")) {
                    simpleTypeValue.setValueBoolean(new Boolean(true));
                    break;
                }
                if (value.equals("false") || value.equals("0")) {
                    simpleTypeValue.setValueBoolean(new Boolean(false));
                    break;
                }
                throw new InvocationException("Invalid {0} type {1} value {2}");
            }
            case 7: {
                try {
                    Float.parseFloat(value);
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 6: {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 12: {
                if (value.length() > simpleType.getMaxLength() && simpleType.getMaxLength() > 0) {
                    throw new InvocationException("Invalid {0} type {1} value {2}");
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 5: 
            case 9: {
                simpleTypeValue.setValue(value);
                break;
            }
            case 10: {
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 8: {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 11: {
                try {
                    Short.parseShort(value);
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 3: {
                try {
                    Byte.parseByte(value);
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                try {
                    long l = Long.parseLong(value);
                    if (l < 0L) {
                        throw new InvocationException("Invalid {0} type {1} value {2}");
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new InvocationException("Invalid {0} type {1} value {2}", (Exception)nfe);
                }
                simpleTypeValue.setValue(value);
            }
        }
        return simpleTypeValue;
    }
}

