/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.data.service.manager.wsdl11.TraceMessageValue;
import com.sap.caf.mp.core.data.service.manager.wsdl11.WsdlToIMessageConverter;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.CalendarConverter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageValueToSOAPConverter {
    private static final String XMLSCHEMA_INSTANCE_NAMESPACE_PREFIX = "xsi";
    private static final String XMLSCHEMA_INSTANCE_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XMLSCHEMA_NAMESPACE_PREFIX = "xsd";
    private static final String XMLSCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    public static final Location log = Location.getLocation((String)"com.sap.caf.mp.core.data.service.manager.wsdl11");
    public static final Category cat = Category.SYS_NETWORK;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$manager$wsdl11$MessageValueToSOAPConverter;

    public static SOAPMessage getSoapMessage(IMessageValue messageValue, Properties operationConfig) throws InvocationException {
        SOAPMessage soapMessage;
        IMessage message = messageValue.getMessage();
        try {
            soapMessage = MessageFactory.newInstance().createMessage();
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            soapEnvelope.addNamespaceDeclaration(XMLSCHEMA_INSTANCE_NAMESPACE_PREFIX, XMLSCHEMA_INSTANCE_NAMESPACE_URI);
            soapEnvelope.addNamespaceDeclaration(XMLSCHEMA_NAMESPACE_PREFIX, XMLSCHEMA_NAMESPACE_URI);
            for (int i = 0; i < messageValue.getMessagepartValueCount(); ++i) {
                IMessagepartValue messagePartValue = messageValue.getMessagepartValue(i);
                MessageValueToSOAPConverter.addMessagePart((SOAPElement)soapBody, soapEnvelope, messagePartValue, operationConfig);
            }
        }
        catch (SOAPException soape) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$data$service$manager$wsdl11$MessageValueToSOAPConverter == null ? (class$com$sap$caf$mp$core$data$service$manager$wsdl11$MessageValueToSOAPConverter = MessageValueToSOAPConverter.class$("com.sap.caf.mp.core.data.service.manager.wsdl11.MessageValueToSOAPConverter")) : class$com$sap$caf$mp$core$data$service$manager$wsdl11$MessageValueToSOAPConverter), (Exception)((Object)soape));
            throw new InvocationException("Web service error", (Exception)((Object)soape));
        }
        catch (InvocationException ie) {
            log.debugT(cat, ie.toString());
            log.debugT(cat, TraceMessageValue.traceMessageValue(messageValue));
            throw ie;
        }
        return soapMessage;
    }

    private static void addMessagePart(SOAPElement soapBodyElement, SOAPEnvelope soapEnvelope, IMessagepartValue messagePartValue, Properties operationConfig) throws InvocationException, SOAPException {
        IStructureValue structureValue = messagePartValue.getStructureValue();
        IMessagepart messagePart = messagePartValue.getMessagepart();
        IStructure structure = messagePart.getStructure();
        if (structure == null) {
            return;
        }
        block0 : switch (structure.getStructureCast()) {
            case 1: {
                MessageValueToSOAPConverter.addElement(soapBodyElement, soapEnvelope, (IElementValue)structureValue, 0, operationConfig);
                break;
            }
            case 2: {
                ITypeValue typeValue = (ITypeValue)structureValue;
                IType type = typeValue.getType();
                switch (type.getTypeCast()) {
                    case 2: {
                        MessageValueToSOAPConverter.addSimpleType(soapBodyElement, soapEnvelope, (ISimpleTypeValue)typeValue, messagePart.getName());
                        break block0;
                    }
                    case 1: {
                        MessageValueToSOAPConverter.addComplexType(soapBodyElement, soapEnvelope, (IComplexTypeValue)typeValue, 0, operationConfig);
                    }
                }
            }
        }
    }

    private static void addSimpleType(SOAPElement soapElement, SOAPEnvelope soapEnvelope, ISimpleTypeValue simpleTypeValue, String name) throws SOAPException, InvocationException {
        String value = simpleTypeValue.getValue();
        ISimpleType type = simpleTypeValue.getSimpleType();
        if (type.getConstantCount() > 0 && value != null) {
            for (int i = 0; i < type.getConstantCount(); ++i) {
                if (!type.getConstant(i).getValue().equals(value)) continue;
                soapElement.addTextNode(value);
                return;
            }
            throw new InvocationException(MessageFormat.format("Simple type value {0} not in the type enumeration", value));
        }
        if (value == null) {
            soapElement.addAttribute(soapEnvelope.createName("nil", XMLSCHEMA_INSTANCE_NAMESPACE_PREFIX, XMLSCHEMA_INSTANCE_NAMESPACE_URI), "true");
        } else {
            switch (type.getBase()) {
                case 1: {
                    byte[] byteArray = simpleTypeValue.getValueByteArray();
                    if (byteArray.length > type.getMaxLength() && type.getMaxLength() > 0) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("length of byte array", name, value));
                    }
                    value = new String(BASE64Encoder.encode((byte[])byteArray));
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    Date date = simpleTypeValue.getValueDate();
                    Calendar calendar = GregorianCalendar.getInstance();
                    calendar.setTime(new Date());
                    value = CalendarConverter.getRelative((Calendar)calendar);
                    break;
                }
                case 2: {
                    if (value.equals("true") || value.equals("1") || value.equals("false") || value.equals("0")) break;
                    throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("boolean", name, value));
                }
                case 7: {
                    try {
                        Float.parseFloat(value);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("float", name, value), (Exception)nfe);
                    }
                }
                case 6: {
                    try {
                        Double.parseDouble(value);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("double", name, value), (Exception)nfe);
                    }
                }
                case 12: {
                    if (type.getPatternCount() == 1) {
                        for (int i = 0; i < type.getPatternCount(); ++i) {
                            Pattern pattern = Pattern.compile(type.getPattern(i));
                            Matcher matcher = pattern.matcher(value);
                            if (matcher.matches()) continue;
                            throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("pattern string", name, value));
                        }
                    }
                    if (value.length() <= type.getMaxLength() || type.getMaxLength() <= 0) break;
                    throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("string length", name, value));
                }
                case 5: 
                case 9: {
                    break;
                }
                case 10: {
                    try {
                        Long.parseLong(value);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("long", name, value), (Exception)nfe);
                    }
                }
                case 8: {
                    try {
                        Integer.parseInt(value);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("int", name, value), (Exception)nfe);
                    }
                }
                case 11: {
                    try {
                        Short.parseShort(value);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("short", name, value), (Exception)nfe);
                    }
                }
                case 3: {
                    try {
                        Byte.parseByte(value);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("byte", name, value), (Exception)nfe);
                    }
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    try {
                        long l = Long.parseLong(value);
                        if (l < 0L) {
                            throw new InvocationException("Invalid {0} type {1} value {2}");
                        }
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvocationException(MessageValueToSOAPConverter.createInvalidSimpleTypeErrorMessage("unsigned", name, value), (Exception)nfe);
                    }
                }
            }
            soapElement.addTextNode(value);
        }
    }

    private static String createInvalidSimpleTypeErrorMessage(String type, String name, String value) {
        return MessageFormat.format("Invalid {0} type {1} value {2}", type, name, value);
    }

    private static void addComplexType(SOAPElement soapElement, SOAPEnvelope soapEnvelope, IComplexTypeValue complexTypeValue, int depth, Properties operationConfig) throws SOAPException, InvocationException {
        IComplexType complexType = complexTypeValue.getComplexType();
        switch (complexType.getMode()) {
            case 2: {
                if (complexTypeValue.getElementValueCount() <= 0 || complexTypeValue.getElementValue(0) == null) break;
                MessageValueToSOAPConverter.addElement(soapElement, soapEnvelope, complexTypeValue.getElementValue(0), depth, operationConfig);
                break;
            }
            case 1: 
            case 3: {
                Enumeration enumeration = complexType.getElementEnumeration();
                while (enumeration.hasMoreElements()) {
                    IElement element = (IElement)enumeration.nextElement();
                    if (element.getMinOccurs() <= 0 || complexTypeValue.getElementValue(element.getName()) != null) continue;
                    throw new InvocationException(MessageFormat.format("Missing element {0} value", element.getName()));
                }
                enumeration = complexTypeValue.getElementValueEnumeration();
                while (enumeration.hasMoreElements()) {
                    IElementValue elementValue = (IElementValue)enumeration.nextElement();
                    MessageValueToSOAPConverter.addElement(soapElement, soapEnvelope, elementValue, depth, operationConfig);
                }
                break;
            }
        }
    }

    private static void addElement(SOAPElement parentSoapElement, SOAPEnvelope soapEnvelope, IElementValue elementValue, int depth, Properties operationConfig) throws SOAPException, InvocationException {
        IElement element = elementValue.getElement();
        IType type = element.getType();
        if (type == null) {
            WsdlToIMessageConverter.DeconstructedName deconstructedName = WsdlToIMessageConverter.deconstructName(element.getName(), operationConfig);
            Name name = deconstructedName.isQualified() ? soapEnvelope.createName(deconstructedName.getLocalName(), deconstructedName.getPrefix(), deconstructedName.getUri()) : soapEnvelope.createName(deconstructedName.getLocalName());
            SOAPElement soapElement = parentSoapElement.addChildElement(name);
            return;
        }
        if (element.getMaxOccurs() > 0 && elementValue.getTypeValueCount() > element.getMaxOccurs()) {
            throw new InvocationException(MessageFormat.format("More element values than allowed by element {0} max occurs attribute", element.getName()));
        }
        if (element.getMinOccurs() > 0 && elementValue.getTypeValueCount() == 0) {
            WsdlToIMessageConverter.DeconstructedName deconstructedName = WsdlToIMessageConverter.deconstructName(element.getName(), operationConfig);
            Name name = deconstructedName.isQualified() ? soapEnvelope.createName(deconstructedName.getLocalName(), deconstructedName.getPrefix(), deconstructedName.getUri()) : soapEnvelope.createName(deconstructedName.getLocalName());
            SOAPElement soapElement = parentSoapElement.addChildElement(name);
            soapElement.addAttribute(soapEnvelope.createName("nil", XMLSCHEMA_INSTANCE_NAMESPACE_PREFIX, XMLSCHEMA_INSTANCE_NAMESPACE_URI), "true");
            return;
        }
        switch (type.getTypeCast()) {
            case 2: {
                Enumeration enumeration = elementValue.getTypeValueEnumeration();
                while (enumeration.hasMoreElements()) {
                    WsdlToIMessageConverter.DeconstructedName deconstructedName = WsdlToIMessageConverter.deconstructName(element.getName(), operationConfig);
                    Name name = deconstructedName.isQualified() ? soapEnvelope.createName(deconstructedName.getLocalName(), deconstructedName.getPrefix(), deconstructedName.getUri()) : soapEnvelope.createName(deconstructedName.getLocalName());
                    SOAPElement soapElement = parentSoapElement.addChildElement(name);
                    ITypeValue typeValue = (ITypeValue)enumeration.nextElement();
                    MessageValueToSOAPConverter.addSimpleType(soapElement, soapEnvelope, (ISimpleTypeValue)typeValue, element.getName());
                }
                break;
            }
            case 1: {
                Enumeration enumeration = elementValue.getTypeValueEnumeration();
                while (enumeration.hasMoreElements()) {
                    WsdlToIMessageConverter.DeconstructedName deconstructedName = WsdlToIMessageConverter.deconstructName(element.getName(), operationConfig);
                    Name name = deconstructedName.isQualified() ? soapEnvelope.createName(deconstructedName.getLocalName(), deconstructedName.getPrefix(), deconstructedName.getUri()) : soapEnvelope.createName(deconstructedName.getLocalName());
                    SOAPElement soapElement = parentSoapElement.addChildElement(name);
                    ITypeValue typeValue = (ITypeValue)enumeration.nextElement();
                    MessageValueToSOAPConverter.addComplexType(soapElement, soapEnvelope, (IComplexTypeValue)typeValue, depth + 1, operationConfig);
                }
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

