/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import java.util.Date;
import java.util.Enumeration;

public class GenerateTestValue {
    public static IMessageValue generateMessageValue(IMessage message) throws InvocationException {
        MessageValue messageValue = new MessageValue(message);
        Enumeration enumeration = message.getMessagepartEnumeration();
        while (enumeration.hasMoreElements()) {
            IMessagepart messagePart = (IMessagepart)enumeration.nextElement();
            messageValue.addMessagepartValue(GenerateTestValue.generateMessageValueParts(messagePart));
        }
        return messageValue;
    }

    private static IMessagepartValue generateMessageValueParts(IMessagepart messagePart) throws InvocationException {
        MessagepartValue messagePartValue = new MessagepartValue(messagePart);
        IStructureValue structureValue = GenerateTestValue.generateStructureValue(messagePart.getStructure());
        messagePartValue.setStructureValue(structureValue);
        return messagePartValue;
    }

    private static IStructureValue generateStructureValue(IStructure structure) throws InvocationException {
        switch (structure.getStructureCast()) {
            case 1: {
                return GenerateTestValue.generateElementValue((IElement)structure);
            }
            case 2: {
                return GenerateTestValue.generateTypeValue((IType)structure);
            }
        }
        return null;
    }

    private static ITypeValue generateTypeValue(IType type) throws InvocationException {
        switch (type.getTypeCast()) {
            case 2: {
                return GenerateTestValue.generateSimpleTypeValue((ISimpleType)type);
            }
            case 1: {
                return GenerateTestValue.generateComplexTypeValue((IComplexType)type);
            }
        }
        return null;
    }

    private static IElementValue generateElementValue(IElement element) throws InvocationException {
        int maxOccurs;
        ElementValue elementValue = new ElementValue(element);
        IType type = element.getType();
        int n = maxOccurs = element.getMaxOccurs() == 0 ? 5 : element.getMaxOccurs();
        if (type != null) {
            for (int i = 0; i < maxOccurs; ++i) {
                elementValue.addTypeValue(GenerateTestValue.generateTypeValue(type));
            }
        }
        return elementValue;
    }

    private static ISimpleTypeValue generateSimpleTypeValue(ISimpleType simpleType) throws InvocationException {
        SimpleTypeValue simpleTypeValue = new SimpleTypeValue(simpleType);
        switch (simpleType.getBase()) {
            case 1: {
                simpleTypeValue.setValueByteArray(new byte[]{1, 2, 3, 4});
                break;
            }
            case 4: 
            case 13: 
            case 14: {
                simpleTypeValue.setValueDate(new Date());
                break;
            }
            case 2: {
                simpleTypeValue.setValue("true");
                break;
            }
            case 6: 
            case 7: {
                simpleTypeValue.setValueDouble(new Double(100.0));
                break;
            }
            case 12: {
                simpleTypeValue.setValue("1");
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                simpleTypeValue.setValue("100");
            }
        }
        return simpleTypeValue;
    }

    private static IComplexTypeValue generateComplexTypeValue(IComplexType complexType) throws InvocationException {
        ComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);
        Enumeration enumeration = complexType.getElementEnumeration();
        while (enumeration.hasMoreElements()) {
            complexTypeValue.addElementValue(GenerateTestValue.generateElementValue((IElement)enumeration.nextElement()));
        }
        return complexTypeValue;
    }
}

