/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.saprfc;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.ExternalException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.util.ClassUtils;
import com.sap.caf.mp.base.util.ExternalDate;
import com.sap.caf.mp.base.util.StringValueList;
import com.sap.caf.mp.base.uuid.BaseUUIDManager;
import com.sap.caf.mp.core.data.service.BaseServiceResponse;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.IServiceResponse;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.interfce.base.Operation;
import com.sap.caf.mp.core.data.service.interfce.base.Operationpart;
import com.sap.caf.mp.core.data.service.interfce.base.Porttype;
import com.sap.caf.mp.core.data.service.manager.api.IServiceManager;
import com.sap.caf.mp.core.data.service.manager.saprfc.SAPSystemConnector;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinition;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.types.base.Element;
import com.sap.caf.mp.core.data.types.base.Message;
import com.sap.caf.mp.core.data.types.base.Messagepart;
import com.sap.caf.mp.core.data.types.base.SimpleType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessageValueUtils;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.mw.jco.JCO;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class SAPRFCServiceManager
implements IServiceManager {
    private static final String DATE_PATTERN = "....-..-..";
    private static final String NUM_PATTERN = "\"d*";
    private static final String TIME_PATTERN = "..:..:..";
    public static final String ELEMENT_NAME_OF_STRUCTURE_OF_TABLE = "item";
    public static final String ELEMENT_NAME_OF_ABAPEXCEPTION = "Name";
    public static final String ELEMENT_NAME_OF_MESSAGEPART = "parameters";
    public static final String ELEMENT_NAME_OF_EXPORT_PARAMETER = ".Response";
    public static final String ELEMENT_NAME_OF_EXCEPTION_PARAMETER = ".Exception";
    public static final String ELEMENT_NAME_OF_OPERATION_PART_INPUT = "Input";
    public static final String ELEMENT_NAME_OF_OPERATION_PART_OUTPUT = "Output";
    public static final String ELEMENT_NAME_OF_OPERATION_PART_FAULT = "Fault";
    public static final String ELEMENT_NAME_OF_INPUT_MESSAGE = ".Input";
    public static final String ELEMENT_NAME_OF_OUTPUT_MESSAGE = ".Output";
    public static final String ELEMENT_NAME_OF_FAULT_MESSAGE = ".Fault";
    public static final String ELEMENT_NAME_OF_PORTTYPE = ".Porttype";
    private static final String NAMESPACE_OF_RFC = "urn:sap-com:document:sap:rfc:functions";
    private static final String KEY_OF_INPUT_PARAMETERS = "InputParameters";
    private static final String KEY_OF_OUTPUT_PARAMETERS = "OutputParameters";
    private static final String KEY_OF_EXCEPTION_PARAMETERS = "ExceptionParameters";
    private static final String KEY_OF_INPUT_MESSAGE = "InputMesage";
    private static final String KEY_OF_OUTPUT_MESSAGE = "OutputMesage";
    private static final String KEY_OF_EXCEPTION_MESSAGE = "ExceptionMesage";
    private static final String EXCEPTION_LOGON_DATA_NOTSET = "The properties for logging on a R/3 System must be set.";
    private static final String EXCEPTION_ENTER_NAME_FAULT_FIELD = "Please enter the name of field which contains the value of fault.";
    private static final String EXCEPTION_ENTER_DESCRIPTION_MESSAGE = "Please enter the name of field which contains the descritpion of the message.";
    private static final String EXCEPTION_ENTER_VALUE_FAULT_FIELD = "Please enter the values of field of fault, if the function module was not successfully executed.";
    private static final String EXCEPTION_PARAMETER_NOT_OPTIONAL = "The parameter is not optional, please add a value for the paramter: \"{0}\"";
    private static final String EXCEPTION_ROOT_ELEMENT_TABLE_WRONG = "The root element of a table must be defined the element: \"item\" that contains the values for one row of a table.";
    private static final String EXCEPTION_STRUC_OF_EXCEPTION_WRONG = "The structure of exception: \"{0}\" does not exist.";
    private static final String EXCEPTION_STRUC_NOT_EXIST_IMPORT_PARAMS = "The structure: \"{0}\" of import paramters does not exist anymore.";
    private static final String EXCEPTION_TABLE_WRONG_FIELD = "The table: \"{0}\" has not got the field: \"{1}\".";
    private static final String EXCEPTION_STRUC_WRONG_FIELD = "The structure: \"{0}\" has not got the field: \"{1}\" .";
    private static final String EXCEPTION_ITYPE_NOT_VALID = "The type: \"{0}\" of IType is not valid. That must be a \"SimpleType\".";
    private static final String EXCEPTION_ENTER_VALUE_ELEMENT = "You did not enter a value for the element: \"{0}\".";
    private static final String EXCEPTION_TABLE_DEFINITION = "A Element which defines a table can only have got fields that are type: \"SimpleType\".";
    private static final String EXCEPTION_WRONG_SIMPLE_TYPE = "The base: \"{0}\" of the interface: \"ISimpleType\" is not supported within a remote function call.";
    private static final String EXCEPTION_MORE_PATTERNS = "The \"SimpleType\" of the {0}: \"{1}\" has more than one Pattern.";
    private static final String EXCEPTION_TABLE_NOT_EXIST = "The table: \"{0}\" is neither part of the export nor the tables parameters.";
    private static final String EXCEPTION_TABLE_NOT_EXIST_TABLE_PARAMS = "The :\"{0}\" of table parameters does not exist anymore.";
    private static final int TABLE_PART_EXPORT = 1;
    private static final int TABLE_PART_TABLES = 2;
    public String m_rfc_function_module_name = null;
    private Hashtable m_operations;
    private Hashtable m_messages;
    private Hashtable m_messageparts;
    private Vector m_elements;
    private Hashtable m_complexTypes = new Hashtable();
    private Hashtable m_simpleTypes = new Hashtable();
    private Properties m_properties = null;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPRFCServiceManager;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPSystemConnector;

    public SAPRFCServiceManager() {
        this.m_messageparts = new Hashtable();
        this.m_messages = new Hashtable();
        this.m_operations = new Hashtable();
        this.m_elements = new Vector();
    }

    public Vector importServiceDefinition(String typeName, Properties props, IDataServiceFactory factory) throws InvocationException, EngineException {
        if (props == null) {
            throw new InvocationException(EXCEPTION_LOGON_DATA_NOTSET);
        }
        boolean executed = false;
        this.checkProperties(props, executed);
        Vector<ServiceDefinition> result = new Vector<ServiceDefinition>();
        Locale userLocale = new Locale("en");
        JCO.Function jcoFunction = this.getNonExecutedFunction(props, userLocale);
        String rfcname = jcoFunction.getName();
        this.m_rfc_function_module_name = this.convertProhibitedCharsOfFieldName(rfcname);
        JCO.ParameterList importlist = jcoFunction.getImportParameterList();
        JCO.ParameterList exportlist = jcoFunction.getExportParameterList();
        JCO.ParameterList tables = jcoFunction.getTableParameterList();
        JCO.AbapException[] abapex = jcoFunction.getExceptionList();
        Porttype porttype = this.createStructureOfService(importlist, exportlist, tables, abapex);
        String uuid = BaseUUIDManager.getUUIDStringFromBytes((byte[])BaseUUIDManager.generateUUID(), (boolean)false);
        ServiceDefinition serviceDef = new ServiceDefinition(typeName, uuid, null, null, null, null, factory);
        serviceDef.setPortType((IPorttype)porttype);
        Enumeration<Object> propsEnum = props.keys();
        while (propsEnum.hasMoreElements()) {
            String key = (String)propsEnum.nextElement();
            String value = props.getProperty(key);
            serviceDef.setProperty(key, value);
        }
        result.add(serviceDef);
        return result;
    }

    private Properties checkProperties(Properties props, boolean executed) throws InvocationException {
        Properties faultProperties = null;
        try {
            if (props.getProperty("rfc.mode") == null) {
                throw new InvocationException("The mode of remote function call must not be null");
            }
            int modeRFC = Integer.parseInt(props.getProperty("rfc.mode"));
            BaseLogManager.info(this.getClass(), (String)("The method checkProperties reached: " + props));
            if (modeRFC == 2) {
                String input_rfcName = (String)props.get("rfc.functionname");
                String input_client = (String)props.get("jco.client");
                String input_user = (String)props.get("jco.user");
                String input_passwd = (String)props.get("jco.password");
                if (this.m_properties != null) {
                    String l_rfcName = (String)this.m_properties.get("rfc.functionname");
                    String l_client = (String)this.m_properties.get("jco.client");
                    String l_user = (String)this.m_properties.get("jco.user");
                    String l_passwd = (String)this.m_properties.get("jco.password");
                    String l_language = (String)this.m_properties.get("jco.language");
                    if (!(input_rfcName.equals(l_rfcName) || input_client.equals(l_client) || input_user.equals(l_user) || input_passwd.equals(l_passwd))) {
                        throw new InvocationException("The properties for logging on a R/3 system are not valid.");
                    }
                } else {
                    this.m_properties = props;
                }
            } else if (modeRFC == 1) {
                if (props.getProperty("rfc.destination") == null) {
                    throw new InvocationException("Missing name of JCODestination of SLD");
                }
                String nameSLDJCOdestination = props.getProperty("rfc.destination");
                if (this.m_properties != null) {
                    if (!this.m_properties.getProperty("rfc.destination").equals(nameSLDJCOdestination)) {
                        throw new InvocationException("Invalid configuration of SLD JCODestination: " + nameSLDJCOdestination);
                    }
                    this.m_properties = props;
                }
            } else if (modeRFC == 3) {
                String nameEndpoint = props.getProperty("endpoint.name");
                String typeEndpoint = props.getProperty("endpoint.type");
                if (nameEndpoint == null) {
                    throw new InvocationException("The endpoint name must be set");
                }
                if (nameEndpoint.equals("")) {
                    throw new InvocationException("The endpoint name must be set");
                }
                if (typeEndpoint == null) {
                    throw new InvocationException("The endpoint type must be set");
                }
                if (typeEndpoint.equals("")) {
                    throw new InvocationException("The endpoint type must be set");
                }
            } else {
                throw new InvocationException("Invalid mode of remote function call: " + modeRFC);
            }
            if (executed) {
                BaseLogManager.info(this.getClass(), (String)"The executed is true");
                if (props.getProperty("rfc.fault.table") != null && props.getProperty("rfc.fault.structure") != null) {
                    throw new InvocationException("The exception can be defined either as a structure or a table, but can not be defined as both.");
                }
                if (props.getProperty("rfc.fault.table") != null || props.getProperty("rfc.fault.structure") != null) {
                    if (props.getProperty("rfc.fault.faultfield.name") != null) {
                        if (props.getProperty("rfc.fault.faultfield.name").length() == 0) {
                            throw new InvocationException(EXCEPTION_ENTER_NAME_FAULT_FIELD);
                        }
                    } else {
                        throw new InvocationException(EXCEPTION_ENTER_NAME_FAULT_FIELD);
                    }
                    BaseLogManager.info(this.getClass(), (String)"The name of table or structure was found");
                    if (props.getProperty("rfc.fault.faultfield.message") != null) {
                        if (props.getProperty("rfc.fault.faultfield.message").length() == 0) {
                            throw new InvocationException(EXCEPTION_ENTER_DESCRIPTION_MESSAGE);
                        }
                    } else {
                        throw new InvocationException(EXCEPTION_ENTER_DESCRIPTION_MESSAGE);
                    }
                    if (props.getProperty("rfc.fault.faultfield.faultval") != null) {
                        if (props.getProperty("rfc.fault.faultfield.faultval").length() == 0) {
                            throw new InvocationException(EXCEPTION_ENTER_VALUE_FAULT_FIELD);
                        }
                    } else {
                        throw new InvocationException(EXCEPTION_ENTER_VALUE_FAULT_FIELD);
                    }
                    faultProperties = new Properties();
                    if (props.getProperty("rfc.fault.table") != null) {
                        if (props.getProperty("rfc.fault.table").length() != 0) {
                            String tableName = props.getProperty("rfc.fault.table");
                            faultProperties.setProperty("rfc.fault.table", tableName);
                        } else {
                            throw new InvocationException("Please enter the name of table of fault.");
                        }
                    }
                    if (props.getProperty("rfc.fault.structure") != null) {
                        if (props.getProperty("rfc.fault.structure").length() != 0) {
                            String structureName = props.getProperty("rfc.fault.structure");
                            faultProperties.setProperty("rfc.fault.structure", structureName);
                        } else {
                            throw new InvocationException("Please enter the name of structure of fault.");
                        }
                    }
                    String faultField = props.getProperty("rfc.fault.faultfield.name");
                    faultProperties.setProperty("rfc.fault.faultfield.name", faultField);
                    String faultMessage = props.getProperty("rfc.fault.faultfield.message");
                    faultProperties.setProperty("rfc.fault.faultfield.message", faultMessage);
                    String faultFailed = props.getProperty("rfc.fault.faultfield.faultval");
                    faultProperties.setProperty("rfc.fault.faultfield.faultval", faultFailed);
                    BaseLogManager.info(this.getClass(), (String)"The fault properties were set.");
                }
            }
        }
        catch (NullPointerException nullPointerexception) {
            BaseLogManager.error(this.getClass(), (Exception)nullPointerexception);
            throw new InvocationException("A property was not set. Please check whether all properties were set", (Exception)nullPointerexception);
        }
        return faultProperties;
    }

    private Porttype createStructureOfService(JCO.ParameterList importlist, JCO.ParameterList exportlist, JCO.ParameterList tables, JCO.AbapException[] abapexceptions) throws InvocationException {
        String nameOutputMessage;
        Messagepart messagePart;
        Porttype porttype = null;
        if (tables == null && importlist == null && exportlist == null && abapexceptions == null) {
            return porttype;
        }
        Vector tablesParameter = this.createElementsOfParameterList(tables);
        Element importParameters = this.createStructureOfParameters(importlist, null, tablesParameter);
        Element exportParameters = this.createStructureOfParameters(exportlist, ELEMENT_NAME_OF_EXPORT_PARAMETER, tablesParameter);
        if (importParameters != null) {
            Messagepart partImportParameters = new Messagepart(ELEMENT_NAME_OF_MESSAGEPART);
            partImportParameters.setStructure((IStructure)importParameters);
            this.m_messageparts.put(KEY_OF_INPUT_PARAMETERS, partImportParameters);
        }
        if (exportParameters != null) {
            Messagepart partExportParameters = new Messagepart(ELEMENT_NAME_OF_MESSAGEPART);
            partExportParameters.setStructure((IStructure)exportParameters);
            this.m_messageparts.put(KEY_OF_OUTPUT_PARAMETERS, partExportParameters);
        }
        if (abapexceptions != null) {
            Messagepart partAbapExceptions = new Messagepart(ELEMENT_NAME_OF_MESSAGEPART);
            Element abapExceptions = this.createStrutureOfException(abapexceptions);
            partAbapExceptions.setStructure((IStructure)abapExceptions);
            this.m_messageparts.put(KEY_OF_EXCEPTION_PARAMETERS, partAbapExceptions);
        }
        if (this.m_messageparts.get(KEY_OF_INPUT_PARAMETERS) != null) {
            String nameInputMessage = this.createNameOfElement(ELEMENT_NAME_OF_INPUT_MESSAGE);
            Message inputMessage = new Message(nameInputMessage);
            messagePart = (Messagepart)this.m_messageparts.get(KEY_OF_INPUT_PARAMETERS);
            inputMessage.addMessagepart((IMessagepart)messagePart);
            this.m_messages.put(KEY_OF_INPUT_MESSAGE, inputMessage);
        }
        if (this.m_messageparts.get(KEY_OF_OUTPUT_PARAMETERS) != null) {
            nameOutputMessage = this.createNameOfElement(ELEMENT_NAME_OF_OUTPUT_MESSAGE);
            Message outputMessage = new Message(nameOutputMessage);
            messagePart = (Messagepart)this.m_messageparts.get(KEY_OF_OUTPUT_PARAMETERS);
            outputMessage.addMessagepart((IMessagepart)messagePart);
            this.m_messages.put(KEY_OF_OUTPUT_MESSAGE, outputMessage);
        }
        if (this.m_messageparts.get(KEY_OF_EXCEPTION_PARAMETERS) != null) {
            nameOutputMessage = this.createNameOfElement(ELEMENT_NAME_OF_FAULT_MESSAGE);
            Message exceptionMessage = new Message(nameOutputMessage);
            messagePart = (Messagepart)this.m_messageparts.get(KEY_OF_EXCEPTION_PARAMETERS);
            exceptionMessage.addMessagepart((IMessagepart)messagePart);
            this.m_messages.put(KEY_OF_EXCEPTION_MESSAGE, exceptionMessage);
        }
        if (this.m_messages.get(KEY_OF_INPUT_MESSAGE) != null || this.m_messages.get(KEY_OF_OUTPUT_MESSAGE) != null || this.m_messages.get(KEY_OF_EXCEPTION_MESSAGE) != null) {
            String namePorttype = this.createNameOfElement(ELEMENT_NAME_OF_PORTTYPE);
            porttype = new Porttype(namePorttype);
            porttype.addNamespace("", NAMESPACE_OF_RFC);
            Operation operationOfPorttype = new Operation(this.m_rfc_function_module_name);
            porttype.addOperation((IOperation)operationOfPorttype);
            if (this.m_messages.get(KEY_OF_INPUT_MESSAGE) != null) {
                Message inputMessage = (Message)this.m_messages.get(KEY_OF_INPUT_MESSAGE);
                String inputName = this.createNameOfElement(ELEMENT_NAME_OF_OPERATION_PART_INPUT);
                Operationpart operationPartInput = new Operationpart(inputName);
                operationPartInput.setMessage((IMessage)inputMessage);
                operationOfPorttype.setInputOperationpart((IOperationpart)operationPartInput);
            }
            if (this.m_messages.get(KEY_OF_OUTPUT_MESSAGE) != null) {
                Message outputMessage = (Message)this.m_messages.get(KEY_OF_OUTPUT_MESSAGE);
                String outputName = this.createNameOfElement(ELEMENT_NAME_OF_OPERATION_PART_OUTPUT);
                Operationpart operationPartOutput = new Operationpart(outputName);
                operationPartOutput.setMessage((IMessage)outputMessage);
                operationOfPorttype.setOutputOperationpart((IOperationpart)operationPartOutput);
            }
            if (this.m_messages.get(KEY_OF_EXCEPTION_MESSAGE) != null) {
                Message faultMessage = (Message)this.m_messages.get(KEY_OF_EXCEPTION_MESSAGE);
                String exceptionName = this.createNameOfElement(ELEMENT_NAME_OF_OPERATION_PART_FAULT);
                Operationpart operationPartFault = new Operationpart(exceptionName);
                operationPartFault.setMessage((IMessage)faultMessage);
                operationOfPorttype.addFaultOperationpart((IOperationpart)operationPartFault);
            }
        }
        return porttype;
    }

    private String createNameOfElement(String alias) {
        StringBuffer completeRfcName = new StringBuffer();
        if (alias != null) {
            completeRfcName.append(this.m_rfc_function_module_name);
            completeRfcName.append(alias);
        } else {
            completeRfcName.append(this.m_rfc_function_module_name);
        }
        return completeRfcName.toString();
    }

    private Element createStrutureOfException(JCO.AbapException[] abapException) throws InvocationException {
        Element element = null;
        if (abapException.length != 0) {
            StringBuffer elementExceptionName = new StringBuffer();
            elementExceptionName.append(this.m_rfc_function_module_name);
            elementExceptionName.append(ELEMENT_NAME_OF_EXCEPTION_PARAMETER);
            element = new Element(elementExceptionName.toString());
            ComplexType complextypeException = new ComplexType();
            complextypeException.setMode(3);
            element.setType((IType)complextypeException);
            Element nameOfAbapException = new Element(ELEMENT_NAME_OF_ABAPEXCEPTION);
            complextypeException.addElement((IElement)nameOfAbapException);
            SimpleType simpletypeAbapException = new SimpleType(12);
            nameOfAbapException.setType((IType)simpletypeAbapException);
            for (int i = 0; i < abapException.length; ++i) {
                SimpleTypeValue exceptionName = new SimpleTypeValue((ISimpleType)simpletypeAbapException);
                exceptionName.setValue(abapException[i].getKey());
                simpletypeAbapException.addConstant((ISimpleTypeValue)exceptionName);
            }
        }
        return element;
    }

    private Element createStructureOfParameters(JCO.ParameterList parameterList, String elementalias, Vector tables) throws InvocationException {
        Element element = null;
        if (parameterList != null || tables != null) {
            if (elementalias != null) {
                StringBuffer completeRfcName = new StringBuffer();
                completeRfcName.append(this.m_rfc_function_module_name);
                completeRfcName.append(elementalias);
                element = new Element(completeRfcName.toString());
                this.m_elements.addElement(element);
            } else {
                element = new Element(this.m_rfc_function_module_name);
                this.m_elements.addElement(element);
            }
            ComplexType complexType = new ComplexType();
            complexType.setMode(1);
            element.setType((IType)complexType);
            if (parameterList != null) {
                Vector parameters = this.createElementsOfParameterList(parameterList);
                for (int i = 0; i < parameters.size(); ++i) {
                    Element parameter = (Element)parameters.elementAt(i);
                    complexType.addElement((IElement)parameter);
                    this.m_elements.addElement(parameter);
                }
            }
            if (tables != null && tables.size() != 0) {
                for (int i = 0; i < tables.size(); ++i) {
                    Element elementOfTable = (Element)tables.elementAt(i);
                    complexType.addElement((IElement)elementOfTable);
                    this.m_elements.addElement(elementOfTable);
                }
            }
        } else {
            return element;
        }
        return element;
    }

    private Vector createElementsOfParameterList(JCO.ParameterList parameterList) throws InvocationException {
        Vector<Element> elements = null;
        if (parameterList != null) {
            elements = new Vector<Element>();
            block4: for (int i = 0; i < parameterList.getFieldCount(); ++i) {
                Element element = null;
                JCO.Field jcoField = parameterList.getField(i);
                BaseLogManager.info(this.getClass(), (String)("The current field is: " + jcoField.getName() + " type is: " + jcoField.getTypeAsString()));
                switch (jcoField.getType()) {
                    case 99: {
                        int j;
                        ComplexType complexTypeOfItem;
                        element = new Element(this.convertProhibitedCharsOfFieldName(jcoField.getName()));
                        elements.addElement(element);
                        element.setMinOccurs(0);
                        ComplexType complexTypeOfTable = new ComplexType();
                        complexTypeOfTable.setMode(3);
                        element.setType((IType)complexTypeOfTable);
                        Element itemOfTable = new Element(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE);
                        itemOfTable.setMinOccurs(0);
                        itemOfTable.setMaxOccurs(0);
                        complexTypeOfTable.addElement((IElement)itemOfTable);
                        if (this.m_complexTypes.get(jcoField.getTable().getName()) != null) {
                            complexTypeOfItem = (ComplexType)this.m_complexTypes.get(jcoField.getTable().getName());
                            itemOfTable.setType((IType)complexTypeOfItem);
                            continue block4;
                        }
                        complexTypeOfItem = new ComplexType();
                        complexTypeOfItem.setMode(3);
                        itemOfTable.setType((IType)complexTypeOfItem);
                        Vector elementsOfTable = this.createDataTypesofJCORecord((JCO.Record)jcoField.getTable());
                        for (j = 0; j < elementsOfTable.size(); ++j) {
                            Element elementOfTable = (Element)elementsOfTable.elementAt(j);
                            complexTypeOfItem.addElement((IElement)elementOfTable);
                        }
                        this.m_complexTypes.put(jcoField.getTable().getName(), complexTypeOfItem);
                        continue block4;
                    }
                    case 17: {
                        ComplexType complexTypeOfStructure;
                        int j;
                        element = new Element(this.convertProhibitedCharsOfFieldName(jcoField.getName()));
                        elements.addElement(element);
                        if (jcoField.isOptional()) {
                            element.setMinOccurs(0);
                        }
                        if (this.m_complexTypes.get(jcoField.getStructure().getName()) != null) {
                            complexTypeOfStructure = (ComplexType)this.m_complexTypes.get(jcoField.getStructure().getName());
                            element.setType((IType)complexTypeOfStructure);
                            continue block4;
                        }
                        complexTypeOfStructure = new ComplexType();
                        complexTypeOfStructure.setMode(3);
                        element.setType((IType)complexTypeOfStructure);
                        Vector elementsOfStructure = this.createDataTypesofJCORecord((JCO.Record)jcoField.getStructure());
                        for (j = 0; j < elementsOfStructure.size(); ++j) {
                            Element elementOfStructure = (Element)elementsOfStructure.elementAt(j);
                            complexTypeOfStructure.addElement((IElement)elementOfStructure);
                        }
                        this.m_complexTypes.put(jcoField.getStructure().getName(), complexTypeOfStructure);
                        continue block4;
                    }
                    default: {
                        BaseLogManager.info(this.getClass(), (String)("The current field is: " + jcoField.getName() + " type is: " + jcoField.getTypeAsString()));
                        element = new Element(this.convertProhibitedCharsOfFieldName(jcoField.getName()));
                        elements.addElement(element);
                        if (jcoField.isOptional()) {
                            element.setMinOccurs(0);
                        }
                        SimpleType simpleType = this.convertFieldToSimpleType(jcoField);
                        element.setType((IType)simpleType);
                    }
                }
            }
        }
        return elements;
    }

    private Vector createDataTypesofJCORecord(JCO.Record jcoRecord) throws InvocationException {
        Vector<Element> elements = new Vector<Element>();
        for (int i = 0; i < jcoRecord.getFieldCount(); ++i) {
            JCO.Field jcoField = jcoRecord.getField(i);
            Element element = new Element(this.convertProhibitedCharsOfFieldName(jcoField.getName()));
            elements.addElement(element);
            element.setMinOccurs(0);
            SimpleType simpleType = this.convertFieldToSimpleType(jcoField);
            element.setType((IType)simpleType);
        }
        return elements;
    }

    private SimpleType convertFieldToSimpleType(JCO.Field jcoField) throws InvocationException {
        SimpleType simpleType = null;
        switch (jcoField.getType()) {
            case 29: {
                StringBuffer string_key = new StringBuffer();
                string_key.append(29);
                if (this.m_simpleTypes.get(string_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(string_key.toString());
                    break;
                }
                simpleType = new SimpleType(12);
                this.m_simpleTypes.put(string_key.toString(), simpleType);
                break;
            }
            case 0: {
                StringBuffer char_key = new StringBuffer();
                char_key.append(0);
                char_key.append(jcoField.getLength());
                if (this.m_simpleTypes.get(char_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(char_key.toString());
                    break;
                }
                simpleType = new SimpleType(12);
                simpleType.setMaxLength(jcoField.getLength());
                this.m_simpleTypes.put(char_key.toString(), simpleType);
                break;
            }
            case 1: {
                StringBuffer date_key = new StringBuffer();
                date_key.append(1);
                date_key.append(DATE_PATTERN);
                if (this.m_simpleTypes.get(date_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(date_key.toString());
                    break;
                }
                simpleType = new SimpleType(12);
                simpleType.addPattern(DATE_PATTERN);
                simpleType.setMaxLength(jcoField.getLength());
                this.m_simpleTypes.put(date_key.toString(), simpleType);
                break;
            }
            case 7: {
                StringBuffer float_key = new StringBuffer();
                float_key.append(7);
                if (this.m_simpleTypes.get(float_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(float_key.toString());
                    break;
                }
                simpleType = new SimpleType(6);
                this.m_simpleTypes.put(float_key.toString(), simpleType);
                break;
            }
            case 8: {
                StringBuffer int_key = new StringBuffer();
                int_key.append(8);
                if (this.m_simpleTypes.get(int_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(int_key.toString());
                    break;
                }
                simpleType = new SimpleType(8);
                this.m_simpleTypes.put(int_key.toString(), simpleType);
                break;
            }
            case 3: {
                StringBuffer time_key = new StringBuffer();
                time_key.append(3);
                time_key.append(TIME_PATTERN);
                if (this.m_simpleTypes.get(time_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(time_key.toString());
                    break;
                }
                simpleType = new SimpleType(12);
                simpleType.addPattern(TIME_PATTERN);
                simpleType.setMaxLength(jcoField.getLength());
                this.m_simpleTypes.put(time_key.toString(), simpleType);
                break;
            }
            case 4: {
                StringBuffer byte_key = new StringBuffer();
                byte_key.append(4);
                byte_key.append(jcoField.getLength());
                if (this.m_simpleTypes.get(byte_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(byte_key.toString());
                    break;
                }
                simpleType = new SimpleType(1);
                simpleType.setMaxLength(jcoField.getLength());
                this.m_simpleTypes.put(byte_key.toString(), simpleType);
                break;
            }
            case 2: {
                StringBuffer bcd_key = new StringBuffer();
                bcd_key.append(2);
                int totalDigit_key = jcoField.getLength() * 2 - 1;
                bcd_key.append(totalDigit_key);
                bcd_key.append(jcoField.getDecimals());
                if (this.m_simpleTypes.get(bcd_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(bcd_key.toString());
                    break;
                }
                simpleType = new SimpleType(5);
                simpleType.setTotalDigits(totalDigit_key);
                simpleType.setFractionDigits(jcoField.getDecimals());
                this.m_simpleTypes.put(bcd_key.toString(), simpleType);
                break;
            }
            case 30: {
                StringBuffer xstring_key = new StringBuffer();
                xstring_key.append(30);
                if (this.m_simpleTypes.get(xstring_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(xstring_key.toString());
                    break;
                }
                simpleType = new SimpleType(1);
                this.m_simpleTypes.put(xstring_key.toString(), simpleType);
                break;
            }
            case 10: {
                StringBuffer int1_key = new StringBuffer();
                int1_key.append(10);
                if (this.m_simpleTypes.get(int1_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(int1_key.toString());
                    break;
                }
                simpleType = new SimpleType(15);
                this.m_simpleTypes.put(int1_key.toString(), simpleType);
                break;
            }
            case 9: {
                StringBuffer int2_key = new StringBuffer();
                int2_key.append(9);
                if (this.m_simpleTypes.get(int2_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(int2_key.toString());
                    break;
                }
                simpleType = new SimpleType(11);
                this.m_simpleTypes.put(int2_key.toString(), simpleType);
                break;
            }
            case 6: {
                StringBuffer num_key = new StringBuffer();
                num_key.append(6);
                num_key.append(jcoField.getLength());
                if (this.m_simpleTypes.get(num_key.toString()) != null) {
                    simpleType = (SimpleType)this.m_simpleTypes.get(num_key.toString());
                    break;
                }
                simpleType = new SimpleType(12);
                simpleType.setMaxLength(jcoField.getLength());
                simpleType.addPattern(NUM_PATTERN);
                this.m_simpleTypes.put(num_key.toString(), simpleType);
                break;
            }
            case 17: {
                BaseLogManager.info(this.getClass(), (String)("The type of the struture field is not a simple type: " + jcoField.getName()));
                throw new InvocationException("The field of a table or a structure is not a simple data type. SAP allowed that a structure or a table can have got fields which also are a table or a structure. We don't support such function module.");
            }
            case 99: {
                BaseLogManager.info(this.getClass(), (String)("The type of the table field is not a simple type: " + jcoField.getName()));
                throw new InvocationException("The field of a table or a structure is not a simple data type. SAP allowed that a structure or a table can have got fields which also are a table or a structure. We don't support such function module.");
            }
            default: {
                String message = MessageFormat.format("The type: \"{0}\" of class \"JCO\" is added newly. Please contact the support of \"Guided Procedure\".", jcoField.getTypeAsString());
                throw new InvocationException(message);
            }
        }
        return simpleType;
    }

    private String convertProhibitedCharsOfFieldName(String name) {
        StringBuffer allowed_characters = null;
        if (name != null) {
            allowed_characters = new StringBuffer();
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) >= 'a' && name.charAt(i) <= 'z' || name.charAt(i) >= 'A' && name.charAt(i) <= 'Z' || name.charAt(i) == '_') {
                    allowed_characters.append(name.charAt(i));
                    continue;
                }
                if (i == 0 && (name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) == '.')) {
                    allowed_characters.append(this.createHexValue(name.charAt(i)));
                    continue;
                }
                if (name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) == '.') {
                    allowed_characters.append(name.charAt(i));
                    continue;
                }
                if (name.charAt(i) == '/') {
                    allowed_characters.append("_-");
                    continue;
                }
                allowed_characters.append(this.createHexValue(name.charAt(i)));
            }
            return allowed_characters.toString();
        }
        return allowed_characters.toString();
    }

    private String createHexValue(char temp_char) {
        StringBuffer utf8HexValue = new StringBuffer();
        utf8HexValue.append("_--");
        utf8HexValue.append(Integer.toHexString(temp_char));
        return utf8HexValue.toString();
    }

    public IServiceResponse executeOperation(IMessageValue input, IOperation target, Properties operationConfig, Locale userLocale) throws InvocationException, EngineException {
        BaseLogManager.info(this.getClass(), (String)MessageValueUtils.dumpMessageValue((IMessageValue)input));
        BaseServiceResponse iServiceResponse = null;
        Properties faultproperties = null;
        try {
            JCO.Function jcoFunctionExec;
            block50: {
                if (operationConfig == null) {
                    throw new InvocationException(EXCEPTION_LOGON_DATA_NOTSET);
                }
                if (input == null & target == null) {
                    JCO.Function jcoFunction = SAPSystemConnector.getExecutedJCOFunctionOfFunctionModule(operationConfig, null, userLocale);
                    BaseLogManager.info(this.getClass(), (String)"The input message and the target ( IOperation ) were null.");
                    return iServiceResponse;
                }
                if (this.m_rfc_function_module_name == null) {
                    this.m_rfc_function_module_name = this.reconvertProhibitedCharacters(target.getName());
                    operationConfig.setProperty("rfc.functionname", this.m_rfc_function_module_name);
                } else {
                    operationConfig.setProperty("rfc.functionname", this.m_rfc_function_module_name);
                }
                BaseLogManager.info(this.getClass(), (String)("The name of the current function module is: " + this.m_rfc_function_module_name));
                JCO.Function jcoFunctionNonExec = null;
                BaseLogManager.info(this.getClass(), (String)"Before getting the none-executed fucntion.");
                Locale englishLocale = new Locale("en");
                jcoFunctionNonExec = this.getNonExecutedFunction(operationConfig, englishLocale);
                BaseLogManager.info(this.getClass(), (String)("After getting none-executed function: " + jcoFunctionNonExec));
                boolean executed = true;
                faultproperties = this.checkProperties(operationConfig, executed);
                BaseLogManager.info(this.getClass(), (String)("Faultproperties: " + faultproperties));
                IOperationpart iOperationpartInput = target.getInputOperationpart();
                IMessage iMessageInput = iOperationpartInput.getMessage();
                if (iMessageInput.getMessagepart(ELEMENT_NAME_OF_MESSAGEPART) == null) {
                    throw new InvocationException("The name of a part of a message must be: \" parameters\".");
                }
                IMessagepart iMessagepartInput = iMessageInput.getMessagepart(ELEMENT_NAME_OF_MESSAGEPART);
                IStructure iStructureInput = iMessagepartInput.getStructure();
                if (input.getMessagepartValue(ELEMENT_NAME_OF_MESSAGEPART) == null) {
                    throw new InvocationException("The value of input message does not have any values of message part.");
                }
                IMessagepartValue iMessagepartValue = input.getMessagepartValue(ELEMENT_NAME_OF_MESSAGEPART);
                if (iMessagepartValue.getStructureValue() == null) {
                    throw new InvocationException("The value of message part does not have any values of element.");
                }
                IStructureValue iStructureValue = iMessagepartValue.getStructureValue();
                IStructure iStructure = iStructureValue.getStructure();
                if (iStructureInput.getStructureCast() != 1 && iStructure.getStructureCast() != 1) {
                    throw new InvocationException("The root element of the import parameters must be defined as an element.");
                }
                Hashtable<String, Object> importParametersValues = new Hashtable<String, Object>();
                Element inputElement = (Element)iStructureInput;
                ElementValue elementValueinput = (ElementValue)iStructureValue;
                if (elementValueinput.getTypeValue(0) == null) {
                    throw new InvocationException("The specification: \" WSDL-for-RFC\" requires a root element for the import parameters. The name must be the same like the name of the function module.");
                }
                if (elementValueinput.getTypeValueCount() > 1) {
                    throw new InvocationException("The root element of the import parameters can only appears one time.");
                }
                IType iType = inputElement.getType();
                ITypeValue itypeValue = elementValueinput.getTypeValue(0);
                if (iType.getTypeCast() != 1) {
                    throw new InvocationException("The root element of the import parameters must be defined as a ComplexType.");
                }
                ComplexType complexTypeImportElement = (ComplexType)iType;
                if (complexTypeImportElement.getMode() != 1) {
                    throw new InvocationException("The ComplexType of the element of the import parameters must have got the mode: \"ComplexType.MODE_ALL\".");
                }
                IComplexTypeValue iComplexTypeValue = (IComplexTypeValue)itypeValue;
                Enumeration enumElements = complexTypeImportElement.getElementEnumeration();
                block16: while (enumElements.hasMoreElements()) {
                    IElement iElementImportparameter = (IElement)enumElements.nextElement();
                    String elementName = this.reconvertProhibitedCharacters(iElementImportparameter.getName());
                    boolean optionalParameter = false;
                    if (iElementImportparameter.getMinOccurs() == 0) {
                        optionalParameter = true;
                    }
                    if (iComplexTypeValue.getElementValue(iElementImportparameter.getName()) == null && !optionalParameter) {
                        String message = MessageFormat.format(EXCEPTION_PARAMETER_NOT_OPTIONAL, iElementImportparameter.getName());
                        throw new InvocationException(message);
                    }
                    IElementValue iElementValue = iComplexTypeValue.getElementValue(iElementImportparameter.getName());
                    if (iElementValue == null || iElementValue.getTypeValueCount() == 0) {
                        BaseLogManager.info(this.getClass(), (String)("The following element was skipped: " + iElementImportparameter.getName() + " of function module: " + this.m_rfc_function_module_name));
                        continue;
                    }
                    IType iTypeElementImportPar = iElementImportparameter.getType();
                    int cast = iTypeElementImportPar.getTypeCast();
                    block3 : switch (cast) {
                        case 2: {
                            String message;
                            ISimpleType iSimpletype = (ISimpleType)iTypeElementImportPar;
                            if (iElementValue.getTypeValueCount() == 0 && !optionalParameter) {
                                if (iSimpletype.getBase() == 12) {
                                    BaseLogManager.info(this.getClass(), (String)("Setting initial value for required parameter: " + iElementImportparameter.getName()));
                                    BaseLogManager.info(this.getClass(), (String)("iElementValue: " + ClassUtils.getInstanceInfo((Object)iElementValue)));
                                    BaseLogManager.info(this.getClass(), (String)("Type of iElementValue: " + ClassUtils.getInstanceInfo((Object)iElementValue.getElement().getType())));
                                    BaseLogManager.info(this.getClass(), (String)("iSimpletype: " + ClassUtils.getInstanceInfo((Object)iSimpletype)));
                                    SimpleTypeValue simpleParameterValue = new SimpleTypeValue((ISimpleType)iElementValue.getElement().getType());
                                    StringBuffer value = new StringBuffer();
                                    if (iSimpletype.getMaxLength() > 0) {
                                        BaseLogManager.info(this.getClass(), (String)("Creating blank string of size " + iSimpletype.getMaxLength()));
                                        for (int idx = 0; idx < iSimpletype.getMaxLength(); ++idx) {
                                            value.append(" ");
                                        }
                                    }
                                    simpleParameterValue.setValue(value.toString());
                                    iElementValue.addTypeValue((ITypeValue)simpleParameterValue);
                                } else {
                                    BaseLogManager.info(this.getClass(), (String)("Unable to set initial value for required parameter: " + iElementImportparameter.getName()));
                                    message = MessageFormat.format(EXCEPTION_PARAMETER_NOT_OPTIONAL, iElementImportparameter.getName());
                                    throw new InvocationException(message);
                                }
                            }
                            if (iElementValue.getTypeValueCount() == 0) {
                                message = MessageFormat.format("The element: \"{0}\" has not got a value. Please add either a value or do not declare that element.", iElementImportparameter.getName());
                                throw new InvocationException(message);
                            }
                            if (iElementValue.getTypeValueCount() > 1) {
                                throw new InvocationException("The defined elements of import parameter may appear only one time, because there is only one value allowed.");
                            }
                            ITypeValue iTypeValue = iElementValue.getTypeValue(0);
                            ISimpleTypeValue simpleValue = (ISimpleTypeValue)iTypeValue;
                            ISimpleTypeValue valueConversion = this.getBaseOfSimpleType(simpleValue, iElementImportparameter.getName());
                            if (valueConversion == null) continue block16;
                            importParametersValues.put(elementName, valueConversion);
                            break;
                        }
                        case 1: {
                            IComplexType iComplextype = (IComplexType)iElementImportparameter.getType();
                            int typeOfComplexType = this.isComplexTypeStrucOrTable(iComplextype);
                            if (iElementValue.getTypeValueCount() > 1) {
                                throw new InvocationException("The defined element of a table or a structure can only appear one time.");
                            }
                            if (typeOfComplexType == 99 && iElementValue.getTypeValue(0) == null) continue block16;
                            IComplexTypeValue iComplextypeValue = (IComplexTypeValue)iElementValue.getTypeValue(0);
                            switch (typeOfComplexType) {
                                case 99: {
                                    if (iComplextype.getElement(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE) == null) {
                                        throw new InvocationException(EXCEPTION_ROOT_ELEMENT_TABLE_WRONG);
                                    }
                                    IElement iElement = iComplextype.getElement(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE);
                                    if (iElement.getMaxOccurs() != 0) {
                                        throw new InvocationException("The element: \"item\" can appears unbounded that means the attribut: \"MacOccurs\" must be set with the value: \"0\" .");
                                    }
                                    IType iTypeTable = iElement.getType();
                                    if (iTypeTable.getTypeCast() == 2) {
                                        throw new InvocationException("The element: \"item\" must refer to a ComplexType and can not refer to a SimpleType.");
                                    }
                                    IComplexType iComplexType = (IComplexType)iTypeTable;
                                    JCO.Record jcoRecordMetadataTable = this.createMetaData(elementName, 99, jcoFunctionNonExec);
                                    IElementValue ielementValueItem = iComplextypeValue.getElementValue(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE);
                                    if (ielementValueItem.getTypeValueCount() == 0) continue block16;
                                    JCO.Table jcoTableValues = this.fillJCOTable((JCO.Table)jcoRecordMetadataTable, ielementValueItem.getTypeValueEnumeration());
                                    importParametersValues.put(elementName, jcoTableValues);
                                    break block3;
                                }
                                case 17: {
                                    if (iElementValue.getTypeValue(0) == null) {
                                        String message = MessageFormat.format("The defined structure: \"{0}\" does not contain any values. Please add either values or do not mention that element.", iElementImportparameter.getName());
                                        throw new InvocationException(message);
                                    }
                                    JCO.Record jcoRecordMetadataStruc = this.createMetaData(elementName, 17, jcoFunctionNonExec);
                                    JCO.Structure jcoStrucValues = this.fillJCOStructure((JCO.Structure)jcoRecordMetadataStruc, iComplextypeValue);
                                    importParametersValues.put(elementName, jcoStrucValues);
                                    break block3;
                                }
                            }
                            String message = MessageFormat.format("The defined element: \"{0}\" is neither a structure or a table.", elementName);
                            throw new InvocationException(message);
                        }
                        default: {
                            throw new InvocationException("The specification: \" WSDL-for-RFC\" (defined by SAP) only allows \"ComplexType\" either \"SimpleType\" for the definition of parameters of a function module.");
                        }
                    }
                }
                jcoFunctionExec = null;
                String defaultLang = operationConfig.getProperty("jco.language");
                try {
                    jcoFunctionExec = SAPSystemConnector.getExecutedJCOFunctionOfFunctionModule(operationConfig, importParametersValues, userLocale);
                    BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPRFCServiceManager == null ? (class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPRFCServiceManager = SAPRFCServiceManager.class$("com.sap.caf.mp.core.data.service.manager.saprfc.SAPRFCServiceManager")) : class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPRFCServiceManager), (String)("Got the jcoFunction from SAPSystemConnector: " + jcoFunctionExec));
                }
                catch (JCO.Exception jcoEx) {
                    int modeRfc = Integer.parseInt(operationConfig.getProperty("rfc.mode"));
                    if (jcoEx.getGroup() == 103) {
                        String language = null;
                        if (modeRfc == 1) {
                            language = "en";
                        } else if (modeRfc == 2) {
                            language = defaultLang;
                        }
                        Locale locale = new Locale(language);
                        BaseLogManager.info(this.getClass(), (String)("The default language is: " + locale.getLanguage()));
                        try {
                            jcoFunctionExec = SAPSystemConnector.getExecutedJCOFunctionOfFunctionModule(operationConfig, importParametersValues, locale);
                        }
                        catch (JCO.Exception ex) {
                            if (jcoEx.getGroup() == 103) {
                                Locale defaultLocale = new Locale("en");
                                jcoFunctionExec = SAPSystemConnector.getExecutedJCOFunctionOfFunctionModule(operationConfig, importParametersValues, defaultLocale);
                                break block50;
                            }
                            this.handleJCOException(ex, operationConfig, new Locale("en"));
                        }
                    }
                    this.handleJCOException(jcoEx, operationConfig, userLocale);
                }
                catch (ExternalException ExtEx) {
                    throw new EngineException((Exception)((Object)ExtEx));
                }
            }
            if (target.getOutputOperationpart() != null) {
                IOperationpart outputOperationpart = target.getOutputOperationpart();
                iServiceResponse = this.getSerivceResponse(jcoFunctionExec, faultproperties, outputOperationpart, userLocale);
            }
            return iServiceResponse;
        }
        catch (ExternalException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            iServiceResponse = new BaseServiceResponse((Exception)((Object)ex));
            return iServiceResponse;
        }
        catch (Exception exception) {
            BaseLogManager.error(this.getClass(), (Exception)exception);
            String message = MessageFormat.format("The followling Exception occurred: \"{0}\". When trying to execute the functiion module: \"{1}\"", exception.getMessage(), this.m_rfc_function_module_name);
            throw new EngineException(message, exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IServiceResponse getSerivceResponse(JCO.Function jcoFunction, Properties faultProperties, IOperationpart output, Locale locale) throws InvocationException, ExternalException {
        BaseServiceResponse iserviceResponse = null;
        Object tablesAsElements = null;
        Object outputElement = null;
        Object filledElementsOfTables = null;
        Object exportMessagepartValue = null;
        Object exceptionMessagepartValue = null;
        if (jcoFunction.getTableParameterList() != null || jcoFunction.getExportParameterList() != null) {
            JCO.ParameterList jcoTables = jcoFunction.getTableParameterList();
            JCO.ParameterList jcoExportParameters = jcoFunction.getExportParameterList();
            if (faultProperties != null) {
                block32: {
                    BaseLogManager.info(this.getClass(), (String)"The faultProperties are not empty");
                    try {
                        if (faultProperties.getProperty("rfc.fault.table") != null) {
                            JCO.Table jcoTableException;
                            String tableName = faultProperties.getProperty("rfc.fault.table");
                            int parameterPartTable = this.checkParameterPartOfTable(jcoTables, jcoExportParameters, tableName);
                            if (parameterPartTable == 2) {
                                jcoTableException = jcoTables.getTable(tableName);
                                iserviceResponse = this.occuredException(tableName, faultProperties, (JCO.Record)jcoTableException, 99);
                                BaseLogManager.info(this.getClass(), (String)("The iServiceResponse within the table: " + iserviceResponse));
                            } else {
                                if (parameterPartTable != 1) {
                                    String message = MessageFormat.format("The table of exception: \"{0}\" does not exist.", tableName);
                                    throw new InvocationException(message);
                                }
                                jcoTableException = jcoExportParameters.getTable(tableName);
                                iserviceResponse = this.occuredException(tableName, faultProperties, (JCO.Record)jcoTableException, 99);
                            }
                        }
                        if (faultProperties.getProperty("rfc.fault.structure") == null) break block32;
                        String structureName = faultProperties.getProperty("rfc.fault.structure");
                        try {
                            if (!jcoExportParameters.isExport(structureName)) {
                                String message = MessageFormat.format(EXCEPTION_STRUC_OF_EXCEPTION_WRONG, structureName);
                                throw new InvocationException(message);
                            }
                            JCO.Structure jcoStrucException = jcoExportParameters.getStructure(structureName);
                            iserviceResponse = this.occuredException(structureName, faultProperties, (JCO.Record)jcoStrucException, 17);
                        }
                        catch (JCO.Exception jcoException) {
                            if (jcoException.getGroup() == 127) {
                                throw new ExternalException((Exception)((Object)jcoException));
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            String message = MessageFormat.format(EXCEPTION_STRUC_OF_EXCEPTION_WRONG, structureName);
                            throw new InvocationException(message, (Exception)nullPointerException);
                        }
                    }
                    catch (JCO.Exception exception) {
                        throw new ExternalException((Exception)((Object)exception));
                    }
                }
                if (iserviceResponse != null && iserviceResponse.getFaultMessage() != null) {
                    BaseLogManager.info(this.getClass(), (String)("The serivce response: " + iserviceResponse.getFaultMessage()));
                    return iserviceResponse;
                }
            }
            IMessage iMessageOutput = output.getMessage();
            MessageValue messageValue = new MessageValue(iMessageOutput);
            iserviceResponse = new BaseServiceResponse((IMessageValue)messageValue);
            if (iMessageOutput.getMessagepart(ELEMENT_NAME_OF_MESSAGEPART) == null) {
                throw new InvocationException("The name of a part of a message must be: \" parameters\" .");
            }
            IMessagepart iMessagepartOutput = iMessageOutput.getMessagepart(ELEMENT_NAME_OF_MESSAGEPART);
            MessagepartValue messagePartvalue = new MessagepartValue(iMessagepartOutput);
            messageValue.addMessagepartValue((IMessagepartValue)messagePartvalue);
            IStructure iStructureResponse = iMessagepartOutput.getStructure();
            if (iStructureResponse.getStructureCast() != 1) {
                throw new InvocationException("The root element of the export parameters must be defined as an element.");
            }
            IElement iElementResponse = (IElement)iStructureResponse;
            ElementValue elementValueResponse = new ElementValue(iElementResponse);
            messagePartvalue.setStructureValue((IStructureValue)elementValueResponse);
            IType iTypeElementResponse = iElementResponse.getType();
            if (iTypeElementResponse.getTypeCast() != 1) {
                throw new InvocationException("The root element of the export parameter must be a \"ComplexType\".");
            }
            IComplexType iComplextypeResponse = (IComplexType)iTypeElementResponse;
            ComplexTypeValue complexTypevalueResponse = new ComplexTypeValue(iComplextypeResponse);
            elementValueResponse.addTypeValue((ITypeValue)complexTypevalueResponse);
            Enumeration enumExportElements = iComplextypeResponse.getElementEnumeration();
            while (enumExportElements.hasMoreElements()) {
                IElement ielementExportPar = (IElement)enumExportElements.nextElement();
                String elementName = this.reconvertProhibitedCharacters(ielementExportPar.getName());
                ElementValue elementValueExportPar = null;
                IType itypeExportPar = ielementExportPar.getType();
                int castExportPar = itypeExportPar.getTypeCast();
                block2 : switch (castExportPar) {
                    case 2: {
                        ISimpleType isimpleTypeExportPar;
                        SimpleTypeValue simpleTypevalueExportPar;
                        if (jcoExportParameters.getString(elementName) == null || (simpleTypevalueExportPar = this.getBasicSimpleTypeValue(isimpleTypeExportPar = (ISimpleType)itypeExportPar, (JCO.Record)jcoExportParameters, elementName, locale)) == null) break;
                        elementValueExportPar = new ElementValue(ielementExportPar);
                        complexTypevalueResponse.addElementValue((IElementValue)elementValueExportPar);
                        elementValueExportPar.addTypeValue((ITypeValue)simpleTypevalueExportPar);
                        break;
                    }
                    case 1: {
                        IComplexType icomplexTypeExportPar = (IComplexType)itypeExportPar;
                        int typeComplexType = this.isComplexTypeStrucOrTable(icomplexTypeExportPar);
                        switch (typeComplexType) {
                            case 17: {
                                if (jcoExportParameters.getStructure(elementName) == null) break block2;
                                JCO.Structure jcoStructure = jcoExportParameters.getStructure(elementName);
                                Vector<JCO.Field> values = new Vector<JCO.Field>();
                                for (int i = 0; i < jcoStructure.getFieldCount(); ++i) {
                                    JCO.Field jcoField = jcoStructure.getField(i);
                                    if (jcoField.getValue() == null) continue;
                                    values.addElement(jcoField);
                                }
                                if (values.isEmpty()) break block2;
                                elementValueExportPar = new ElementValue(ielementExportPar);
                                complexTypevalueResponse.addElementValue((IElementValue)elementValueExportPar);
                                ComplexTypeValue complexTypevalue = new ComplexTypeValue(icomplexTypeExportPar);
                                elementValueExportPar.addTypeValue((ITypeValue)complexTypevalue);
                                JCO.Structure jcoStruture = jcoExportParameters.getStructure(elementName);
                                Vector elementValuesStruc = this.createElementValueOfStruc(ielementExportPar, jcoStruture, locale);
                                for (int i = 0; i < elementValuesStruc.size(); ++i) {
                                    ElementValue elementValue = (ElementValue)elementValuesStruc.elementAt(i);
                                    complexTypevalue.addElementValue((IElementValue)elementValue);
                                }
                                break;
                            }
                            case 99: {
                                ComplexTypeValue complextypeValue;
                                JCO.Table jcoTable;
                                elementValueExportPar = new ElementValue(ielementExportPar);
                                complexTypevalueResponse.addElementValue((IElementValue)elementValueExportPar);
                                if (icomplexTypeExportPar.getElement(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE) == null) {
                                    throw new InvocationException(EXCEPTION_ROOT_ELEMENT_TABLE_WRONG);
                                }
                                IElement ielementItem = icomplexTypeExportPar.getElement(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE);
                                if (ielementItem.getType().getTypeCast() == 2) {
                                    throw new InvocationException("The element: \"item\" must be defined as a \"ComplexType\".");
                                }
                                IComplexType icomplexTypeItem = (IComplexType)ielementItem.getType();
                                Enumeration enumElementsofItem = icomplexTypeItem.getElementEnumeration();
                                int parameterPartTable = this.checkParameterPartOfTable(jcoTables, jcoExportParameters, elementName);
                                if (parameterPartTable == 2) {
                                    jcoTable = jcoTables.getTable(elementName);
                                    if (jcoTable.getNumRows() == 0) break block2;
                                    complextypeValue = this.fillElementsOfTable(icomplexTypeExportPar, jcoTable, locale);
                                    elementValueExportPar.addTypeValue((ITypeValue)complextypeValue);
                                    break;
                                }
                                if (parameterPartTable != 1) {
                                    String message = MessageFormat.format("The table: \"{0}\" does not exist.", ielementExportPar.getName());
                                    throw new InvocationException(message);
                                }
                                jcoTable = jcoExportParameters.getTable(elementName);
                                if (jcoTable.getNumRows() == 0) break block2;
                                complextypeValue = this.fillElementsOfTable(icomplexTypeExportPar, jcoTable, locale);
                                elementValueExportPar.addTypeValue((ITypeValue)complextypeValue);
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        return iserviceResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int checkParameterPartOfTable(JCO.ParameterList jcoTables, JCO.ParameterList exportParameters, String elementName) throws ExternalException {
        int partTable = 0;
        if (jcoTables != null) {
            try {
                if (!jcoTables.isTable(elementName)) return partTable;
                return 2;
            }
            catch (JCO.Exception jcoException) {
                if (jcoException.getGroup() != 127) throw new ExternalException((Exception)((Object)jcoException));
                if (exportParameters != null) {
                    try {
                        if (!exportParameters.isTable(elementName)) return partTable;
                        return 1;
                    }
                    catch (JCO.Exception fieldException) {
                        if (fieldException.getGroup() != 127) throw new ExternalException((Exception)((Object)fieldException));
                        String message = MessageFormat.format(EXCEPTION_TABLE_NOT_EXIST, elementName);
                        throw new ExternalException(message, (Exception)((Object)fieldException));
                    }
                }
                String message = MessageFormat.format(EXCEPTION_TABLE_NOT_EXIST, elementName);
                throw new ExternalException(message, (Exception)((Object)jcoException));
            }
        }
        if (exportParameters != null) {
            try {
                if (!exportParameters.isTable(elementName)) return partTable;
                return 1;
            }
            catch (JCO.Exception fieldException) {
                if (fieldException.getGroup() != 127) throw new ExternalException((Exception)((Object)fieldException));
                String message = MessageFormat.format(EXCEPTION_TABLE_NOT_EXIST, elementName);
                throw new ExternalException(message, (Exception)((Object)fieldException));
            }
        }
        String message = MessageFormat.format(EXCEPTION_TABLE_NOT_EXIST, elementName);
        throw new ExternalException(message);
    }

    private Vector createElementValueOfStruc(IElement ielementStruc, JCO.Structure jcoStructure, Locale locale) throws InvocationException {
        Vector<ElementValue> elementValuesStruc = new Vector<ElementValue>();
        IComplexType icomplexTypeStruc = (IComplexType)ielementStruc.getType();
        Enumeration enumEleemntStruc = icomplexTypeStruc.getElementEnumeration();
        while (enumEleemntStruc.hasMoreElements()) {
            IElement ielementField = (IElement)enumEleemntStruc.nextElement();
            String elmentName = this.reconvertProhibitedCharacters(ielementField.getName());
            if (jcoStructure.getString(elmentName) == null) continue;
            IType itypeStruc = ielementField.getType();
            if (itypeStruc.getTypeCast() == 1) {
                throw new InvocationException("A field of a structure can only be a \"SimpleType\".");
            }
            ISimpleType isimpleType = (ISimpleType)ielementField.getType();
            SimpleTypeValue simpletypeValue = this.getBasicSimpleTypeValue(isimpleType, (JCO.Record)jcoStructure, elmentName, locale);
            if (simpletypeValue == null) continue;
            ElementValue elementValueStruc = new ElementValue(ielementField);
            elementValueStruc.addTypeValue((ITypeValue)simpletypeValue);
            elementValuesStruc.addElement(elementValueStruc);
        }
        return elementValuesStruc;
    }

    private IServiceResponse occuredException(String recordName, Properties faultProperties, JCO.Record jcoRecord, int recordtype) throws InvocationException {
        BaseServiceResponse iserviceReponse = null;
        String faultFieldname = faultProperties.getProperty("rfc.fault.faultfield.name");
        BaseLogManager.info(this.getClass(), (String)("The name of fault field: " + faultFieldname));
        String faultFieldDescription = faultProperties.getProperty("rfc.fault.faultfield.message");
        BaseLogManager.info(this.getClass(), (String)("The name of fault field description: " + faultFieldDescription));
        String faultValues = faultProperties.getProperty("rfc.fault.faultfield.faultval");
        BaseLogManager.info(this.getClass(), (String)("The following values are given: " + faultValues));
        StringValueList valuelistFaults = new StringValueList(faultValues);
        if (recordtype == 99) {
            BaseLogManager.info(this.getClass(), (String)"The fault is a table.");
            JCO.Table exceptionTable = (JCO.Table)jcoRecord;
            if (exceptionTable.getNumRows() > 0) {
                StringBuffer faultMessages = null;
                for (int i = 0; i < exceptionTable.getNumRows(); ++i) {
                    String message;
                    exceptionTable.setRow(i);
                    int row = 0;
                    row = i != exceptionTable.getNumRows() - 1 ? i + 1 : exceptionTable.getNumRows();
                    try {
                        if (exceptionTable.getField(faultFieldname) == null) {
                            String message2 = MessageFormat.format(EXCEPTION_TABLE_WRONG_FIELD, recordName, faultFieldname);
                            throw new InvocationException(message2);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        message = MessageFormat.format(EXCEPTION_TABLE_WRONG_FIELD, recordName, faultFieldname);
                        throw new InvocationException(message, (Exception)nullPointerException);
                    }
                    if (exceptionTable.getString(faultFieldname) == null) continue;
                    BaseLogManager.info(this.getClass(), (String)("The field was found within the table: " + faultFieldname));
                    String valueFaultfieldName = exceptionTable.getString(faultFieldname);
                    if (!valuelistFaults.containsValue(valueFaultfieldName)) continue;
                    BaseLogManager.info(this.getClass(), (String)("The given fault value was found within the table:" + valueFaultfieldName));
                    try {
                        if (exceptionTable.getField(faultFieldDescription) == null) {
                            message = MessageFormat.format(EXCEPTION_TABLE_WRONG_FIELD, recordName, faultFieldDescription);
                            throw new InvocationException(message);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        String message3 = MessageFormat.format(EXCEPTION_TABLE_WRONG_FIELD, recordName, faultFieldDescription);
                        throw new InvocationException(message3, (Exception)nullPointerException);
                    }
                    if (exceptionTable.getString(faultFieldDescription) != null) {
                        String exceptionDescription;
                        if (faultMessages == null) {
                            faultMessages = new StringBuffer();
                            faultMessages.append("The following exceptions occured: ");
                        }
                        if ((exceptionDescription = exceptionTable.getString(faultFieldDescription)).length() == 0) {
                            faultMessages.append(" ");
                            faultMessages.append(row);
                            faultMessages.append(". ");
                            faultMessages.append(" ");
                            faultMessages.append("There is no description of the exception: \"");
                            faultMessages.append(exceptionTable.getString(valueFaultfieldName));
                            faultMessages.append("\" avaiable. ");
                            continue;
                        }
                        faultMessages.append(" ");
                        faultMessages.append(row);
                        faultMessages.append(". ");
                        faultMessages.append(" ");
                        faultMessages.append(exceptionDescription);
                        continue;
                    }
                    faultMessages.append(" ");
                    faultMessages.append(row);
                    faultMessages.append(". ");
                    faultMessages.append(" ");
                    faultMessages.append("There is no description of the exception: \"");
                    faultMessages.append(exceptionTable.getString(valueFaultfieldName));
                    faultMessages.append("\" avaiable. ");
                }
                if (faultMessages != null) {
                    ExternalException externalException = new ExternalException(faultMessages.toString());
                    iserviceReponse = new BaseServiceResponse((Exception)((Object)externalException));
                    BaseLogManager.info(this.getClass(), (String)("The follolwing exception of table was known: " + faultMessages.toString()));
                }
                return iserviceReponse;
            }
        }
        if (recordtype == 17) {
            BaseLogManager.info(this.getClass(), (String)"The fault is a structure.");
            JCO.Structure exceptionStructure = (JCO.Structure)jcoRecord;
            try {
                if (exceptionStructure.getField(faultFieldname) == null) {
                    String message = MessageFormat.format(EXCEPTION_STRUC_WRONG_FIELD, recordName, faultFieldname);
                    throw new InvocationException(message);
                }
            }
            catch (NullPointerException nullPointerException) {
                String message = MessageFormat.format(EXCEPTION_STRUC_WRONG_FIELD, recordName, faultFieldname);
                throw new InvocationException(message, (Exception)nullPointerException);
            }
            if (exceptionStructure.getString(faultFieldname) != null) {
                BaseLogManager.info(this.getClass(), (String)("The field was found within the structure: " + faultFieldname));
                String valueFaultfieldName = exceptionStructure.getString(faultFieldname);
                if (valuelistFaults.containsValue(valueFaultfieldName)) {
                    BaseLogManager.info(this.getClass(), (String)("The given fault value was found within the structure:" + valueFaultfieldName));
                    if (exceptionStructure.getField(faultFieldDescription) == null) {
                        String message = MessageFormat.format(EXCEPTION_STRUC_WRONG_FIELD, recordName, faultFieldDescription);
                        throw new InvocationException(message);
                    }
                    ExternalException externalException = null;
                    if (exceptionStructure.getString(faultFieldDescription) != null) {
                        String exceptionDescription = exceptionStructure.getString(faultFieldDescription);
                        if (exceptionDescription.length() == 0) {
                            StringBuffer stringBufferexcep = new StringBuffer();
                            stringBufferexcep.append("There is no description of the exception: \"");
                            stringBufferexcep.append(exceptionStructure.getString(valueFaultfieldName));
                            stringBufferexcep.append("\" avaiable. ");
                            externalException = new ExternalException(stringBufferexcep.toString());
                        } else {
                            externalException = new ExternalException(exceptionDescription);
                        }
                    } else {
                        StringBuffer stringBufferexcep = new StringBuffer();
                        stringBufferexcep.append("There is no description of the exception: \"");
                        stringBufferexcep.append(exceptionStructure.getString(valueFaultfieldName));
                        stringBufferexcep.append("\" avaiable. ");
                        externalException = new ExternalException(stringBufferexcep.toString());
                    }
                    iserviceReponse = new BaseServiceResponse((Exception)((Object)externalException));
                    BaseLogManager.info(this.getClass(), (String)("The follolwing exception of table was known: " + externalException.getMessage()));
                    return iserviceReponse;
                }
            }
        }
        return iserviceReponse;
    }

    private JCO.Table fillJCOTable(JCO.Table jcoTable, Enumeration enumeration) throws InvocationException {
        if (jcoTable != null && enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ITypeValue itypevalue = (ITypeValue)enumeration.nextElement();
                if (itypevalue.getType().getTypeCast() == 2) {
                    throw new InvocationException("The element: \"item\" must be defined as a \"ComplexType\" and can not be fined as \"SimpleType\".");
                }
                IComplexTypeValue icomplextypeValue = (IComplexTypeValue)itypevalue;
                Enumeration enumRow = icomplextypeValue.getElementValueEnumeration();
                jcoTable.appendRow();
                while (enumRow.hasMoreElements()) {
                    String message;
                    IElementValue ielementValueRow = (IElementValue)enumRow.nextElement();
                    String elementName = this.reconvertProhibitedCharacters(ielementValueRow.getElement().getName());
                    if (jcoTable.getField(elementName) == null) {
                        message = MessageFormat.format("The element: \"{0}\" is not defined in the table.", ielementValueRow.getElement().getName());
                        throw new InvocationException(message);
                    }
                    if (ielementValueRow.getTypeValueCount() == 0) {
                        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPSystemConnector == null ? SAPRFCServiceManager.class$("com.sap.caf.mp.core.data.service.manager.saprfc.SAPSystemConnector") : class$com$sap$caf$mp$core$data$service$manager$saprfc$SAPSystemConnector), (String)("The following element of table was skipped: " + ielementValueRow.getElement().getName()));
                        continue;
                    }
                    if (ielementValueRow.getTypeValueCount() > 1) {
                        message = MessageFormat.format("The element: \"{0}\" can only have got one value within the element: \"item\".", ielementValueRow.getElement().getName());
                        throw new InvocationException(message);
                    }
                    ITypeValue itypevalueRow = ielementValueRow.getTypeValue(0);
                    if (itypevalueRow.getType().getTypeCast() == 1) {
                        String message2 = MessageFormat.format("The element: \"{0}\" can only contains a \"SimpleType\" and can not contain a \"ComplexType\" .", ielementValueRow.getElement().getName());
                        throw new InvocationException(message2);
                    }
                    if (itypevalueRow.getType().getTypeCast() != 2) {
                        String type = String.valueOf(itypevalueRow.getType().getTypeCast());
                        String message3 = MessageFormat.format(EXCEPTION_ITYPE_NOT_VALID, type);
                        throw new InvocationException(message3);
                    }
                    ISimpleTypeValue iSimpletypevalue = (ISimpleTypeValue)itypevalueRow;
                    ISimpleType iSimpletype = iSimpletypevalue.getSimpleType();
                    ISimpleTypeValue ConversionValue = this.getBaseOfSimpleType(iSimpletypevalue, ielementValueRow.getElement().getName());
                    jcoTable.setValue(ConversionValue.getValue(), elementName);
                }
            }
        }
        return jcoTable;
    }

    private ComplexTypeValue fillElementsOfTable(IComplexType icomplextypeTable, JCO.Table jcoTable, Locale locale) throws InvocationException {
        BaseLogManager.info(this.getClass(), (String)("Filling elements for table: " + jcoTable.getName()));
        ComplexTypeValue complexTypevalueTable = new ComplexTypeValue(icomplextypeTable);
        Element elementItem = (Element)icomplextypeTable.getElement(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE);
        ComplexType complexTypeItem = (ComplexType)elementItem.getType();
        for (int i = 0; i < jcoTable.getNumRows(); ++i) {
            jcoTable.setRow(i);
            ElementValue elementValueItem = (ElementValue)complexTypevalueTable.getElementValue(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE);
            if (elementValueItem == null) {
                elementValueItem = new ElementValue((IElement)elementItem);
                complexTypevalueTable.addElementValue((IElementValue)elementValueItem);
            }
            ComplexTypeValue complexTypevalueItem = new ComplexTypeValue((IComplexType)complexTypeItem);
            elementValueItem.addTypeValue((ITypeValue)complexTypevalueItem);
            for (int j = 0; j < complexTypeItem.getElementCount(); ++j) {
                Element element = (Element)complexTypeItem.getElement(j);
                String fieldName = this.reconvertProhibitedCharacters(element.getName());
                ISimpleType iSimpletypeField = (ISimpleType)element.getType();
                SimpleTypeValue simpleTypeValue = this.getBasicSimpleTypeValue(iSimpletypeField, (JCO.Record)jcoTable, fieldName, locale);
                if (simpleTypeValue == null) continue;
                ElementValue elementValueField = new ElementValue((IElement)element);
                complexTypevalueItem.addElementValue((IElementValue)elementValueField);
                elementValueField.addTypeValue((ITypeValue)simpleTypeValue);
            }
        }
        return complexTypevalueTable;
    }

    private SimpleTypeValue getBasicSimpleTypeValue(ISimpleType iSimpletypeRecord, JCO.Record jcoRecord, String fieldName, Locale locale) throws InvocationException {
        BaseLogManager.info(this.getClass(), (String)("Field: " + fieldName));
        SimpleTypeValue simpleTypevalueRecord = null;
        int datatypeOfRecord = iSimpletypeRecord.getBase();
        if (jcoRecord.getField(fieldName) != null) {
            if (jcoRecord.getField(fieldName).getType() == 1 && (jcoRecord.getString(fieldName).equals("0000-00-00") || jcoRecord.getString(fieldName).equals(""))) {
                return simpleTypevalueRecord;
            }
            if (jcoRecord.getField(fieldName).getType() == 3 && (jcoRecord.getString(fieldName).equals("00:00:00") || jcoRecord.getString(fieldName).equals(""))) {
                return simpleTypevalueRecord;
            }
            simpleTypevalueRecord = new SimpleTypeValue(iSimpletypeRecord);
            switch (datatypeOfRecord) {
                case 12: {
                    if (iSimpletypeRecord.getPatternCount() != 0) {
                        if (iSimpletypeRecord.getPatternCount() > 1) {
                            String message = MessageFormat.format(EXCEPTION_MORE_PATTERNS, jcoRecord.getField(fieldName).getName(), "field");
                            throw new InvocationException(message);
                        }
                        if (iSimpletypeRecord.getPattern(0).equals(DATE_PATTERN)) {
                            String dateValue = jcoRecord.getString(fieldName);
                            BaseLogManager.info(this.getClass(), (String)("The date from R/3 is: " + dateValue));
                            dateValue = dateValue == null ? "" : dateValue.trim();
                            if (dateValue.length() == 0) {
                                dateValue = "0000-00-00";
                            }
                            Date dateRepres = ExternalDate.buildJavaDate((String)dateValue, (int)1, (Locale)locale);
                            simpleTypevalueRecord.setValueDate(dateRepres);
                        }
                        if (iSimpletypeRecord.getPattern(0).equals(TIME_PATTERN)) {
                            String timeValue = jcoRecord.getString(fieldName);
                            BaseLogManager.info(this.getClass(), (String)("The time from R/3 is: " + timeValue));
                            timeValue = timeValue == null ? "" : timeValue.trim();
                            if (timeValue.length() == 0) {
                                timeValue = "00:00:00";
                            }
                            Date timeRepres = ExternalDate.buildJavaDate((String)timeValue, (int)2, (Locale)locale);
                            simpleTypevalueRecord.setValueDate(timeRepres);
                        }
                        if (!iSimpletypeRecord.getPattern(0).equals(NUM_PATTERN)) break;
                        String numValue = jcoRecord.getString(fieldName);
                        numValue = numValue == null ? "" : numValue.trim();
                        if (numValue.length() == 0) {
                            numValue = "0";
                        }
                        simpleTypevalueRecord.setValue(numValue);
                        break;
                    }
                    String value = jcoRecord.getString(fieldName);
                    BaseLogManager.info(this.getClass(), (String)("Value: " + value));
                    simpleTypevalueRecord.setValue(value);
                    break;
                }
                case 5: {
                    try {
                        simpleTypevalueRecord.setValueBigDecimal(jcoRecord.getBigDecimal(fieldName));
                    }
                    catch (NegativeArraySizeException ex) {
                        BaseLogManager.warn(this.getClass(), (String)("Unable to receive decoded value of BDC field: " + ex.getMessage()));
                        simpleTypevalueRecord.setValueBigDecimal(new BigDecimal(0.0));
                    }
                    break;
                }
                case 11: {
                    Integer integerShort = new Integer(jcoRecord.getInt(fieldName));
                    simpleTypevalueRecord.setValueInteger(integerShort);
                    break;
                }
                case 6: {
                    Double baseDouble = new Double(jcoRecord.getDouble(fieldName));
                    simpleTypevalueRecord.setValueDouble(baseDouble);
                    break;
                }
                case 8: {
                    Integer integerInt = new Integer(jcoRecord.getInt(fieldName));
                    simpleTypevalueRecord.setValueInteger(integerInt);
                    break;
                }
                case 1: {
                    simpleTypevalueRecord.setValueByteArray(jcoRecord.getByteArray(fieldName));
                    break;
                }
                case 15: {
                    Integer integerUnsignedByte = new Integer(jcoRecord.getInt(fieldName));
                    simpleTypevalueRecord.setValueInteger(integerUnsignedByte);
                    break;
                }
                default: {
                    String type = String.valueOf(iSimpletypeRecord.getBase());
                    String message = MessageFormat.format("The basic type: \"{0}\" is not allowed for remote function calls.", new Object[0]);
                    throw new InvocationException(message);
                }
            }
        }
        return simpleTypevalueRecord;
    }

    private JCO.Structure fillJCOStructure(JCO.Structure jcoStructure, IComplexTypeValue iComplextypeValue) throws InvocationException {
        if (jcoStructure != null && iComplextypeValue != null) {
            Enumeration complexValue = iComplextypeValue.getElementValueEnumeration();
            while (complexValue.hasMoreElements()) {
                IElementValue elementValue = (IElementValue)complexValue.nextElement();
                IElement iElement = elementValue.getElement();
                String elementName = this.reconvertProhibitedCharacters(iElement.getName());
                if (elementValue.getTypeValueCount() == 0) continue;
                for (int i = 0; i < elementValue.getTypeValueCount(); ++i) {
                    ISimpleTypeValue stv = (ISimpleTypeValue)elementValue.getTypeValue(i);
                }
                if (elementValue.getTypeValueCount() > 1) {
                    String message = MessageFormat.format("The element: \"{0}\" can only have got one value for each element of structure.", elementValue.getElement().getName());
                    throw new InvocationException(message);
                }
                IType iType = iElement.getType();
                int castType = iType.getTypeCast();
                if (castType == 1) {
                    throw new InvocationException(EXCEPTION_TABLE_DEFINITION);
                }
                if (castType != 2) {
                    String type = String.valueOf(castType);
                    String message = MessageFormat.format(EXCEPTION_ITYPE_NOT_VALID, type);
                    throw new InvocationException(message);
                }
                ISimpleType iSimpletype = (ISimpleType)iType;
                ITypeValue iTypeValue = elementValue.getTypeValue(0);
                ISimpleTypeValue iSimpletypeValue = (ISimpleTypeValue)iTypeValue;
                ISimpleTypeValue ConversionValue = this.getBaseOfSimpleType(iSimpletypeValue, iElement.getName());
                jcoStructure.setValue(ConversionValue.getValue(), elementName);
            }
        }
        return jcoStructure;
    }

    private JCO.Record createMetaData(String recordName, int recordType, JCO.Function jcoFunction) throws InvocationException {
        JCO.Record jcoRecord = null;
        if (recordType != 99 && recordType != 17) {
            String type = String.valueOf(recordType);
            String message = MessageFormat.format("The entered recordtype: \"{0}\" is not valid.", type);
            throw new InvocationException(message);
        }
        if (recordType == 99) {
            jcoRecord = this.getTable(recordName, jcoFunction);
        }
        if (recordType == 17) {
            JCO.ParameterList jcoImportParams = jcoFunction.getImportParameterList();
            if (jcoImportParams == null) {
                throw new InvocationException("The function module does not have export parameters anymore.");
            }
            try {
                jcoRecord = jcoImportParams.getStructure(recordName);
                return jcoRecord;
            }
            catch (JCO.Exception jcoException) {
                if (jcoException.getGroup() == 127) {
                    String message = MessageFormat.format(EXCEPTION_STRUC_NOT_EXIST_IMPORT_PARAMS, recordName);
                    throw new InvocationException(message, (Exception)((Object)jcoException));
                }
                throw new InvocationException((Exception)((Object)jcoException));
            }
        }
        return jcoRecord;
    }

    private JCO.Record getTable(String tableName, JCO.Function function) throws InvocationException {
        JCO.Table table;
        block12: {
            block11: {
                block10: {
                    BaseLogManager.info(this.getClass(), (String)("The given Table is: " + tableName));
                    table = null;
                    if (function.getTableParameterList() != null) {
                        try {
                            table = function.getTableParameterList().getTable(tableName);
                            BaseLogManager.info(this.getClass(), (String)("The table is part of the table paramters: " + tableName));
                        }
                        catch (JCO.Exception jcoException) {
                            if (jcoException.getGroup() == 127) break block10;
                            throw new InvocationException((Exception)((Object)jcoException));
                        }
                    }
                }
                if (table == null && function.getImportParameterList() != null) {
                    try {
                        table = function.getImportParameterList().getTable(tableName);
                        BaseLogManager.info(this.getClass(), (String)("The table is part of the import paramters: " + tableName));
                    }
                    catch (JCO.Exception jcoException) {
                        if (jcoException.getGroup() == 127) break block11;
                        throw new InvocationException((Exception)((Object)jcoException));
                    }
                }
            }
            if (table == null && function.getExportParameterList() != null) {
                try {
                    table = function.getExportParameterList().getTable(tableName);
                    BaseLogManager.info(this.getClass(), (String)("The table is part of the export paramters: " + tableName));
                }
                catch (JCO.Exception jcoException) {
                    if (jcoException.getGroup() == 127) break block12;
                    throw new InvocationException((Exception)((Object)jcoException));
                }
            }
        }
        if (table == null) {
            throw new InvocationException(MessageFormat.format("The table: \"{0}\" does not exist anymore. It could not find within the import, the export or the table parameters", tableName));
        }
        return table;
    }

    private int addJCOSimpleTypeProp(int jcoSimpletype, ISimpleType iSimpletype) throws InvocationException {
        int simpleTypeProp = 0;
        try {
            switch (jcoSimpletype) {
                case 0: {
                    simpleTypeProp = iSimpletype.getMaxLength();
                    break;
                }
                case 4: {
                    simpleTypeProp = iSimpletype.getMaxLength();
                    break;
                }
                case 6: {
                    simpleTypeProp = iSimpletype.getMaxLength();
                    break;
                }
                case 2: {
                    simpleTypeProp = iSimpletype.getFractionDigits();
                    break;
                }
                case 1: {
                    simpleTypeProp = iSimpletype.getMaxLength();
                    break;
                }
                case 3: {
                    simpleTypeProp = iSimpletype.getMaxLength();
                    break;
                }
                default: {
                    return simpleTypeProp;
                }
            }
        }
        catch (Exception exception) {
            throw new InvocationException("The property, e.g. the length of character, was not set.", exception);
        }
        return simpleTypeProp;
    }

    private int createJCODataTypeOfSimpleType(ISimpleType iSimpletype) throws InvocationException {
        int caseSimpleType = iSimpletype.getBase();
        switch (caseSimpleType) {
            case 12: {
                if (iSimpletype.getPatternCount() > 1) {
                    throw new InvocationException("The XML-Schema definition of the simple types: \"JCO.TYPE_DATE\", \"JCO.TYPE_TIME\" and \"JCO.TYPE_NUM\" must have got exactly one pattern. That was defined by SAP.");
                }
                if (iSimpletype.getPatternCount() == 1) {
                    if (!(iSimpletype.getPattern(0).equals(DATE_PATTERN) || iSimpletype.getPattern(0).equals(TIME_PATTERN) || iSimpletype.getPattern(0).equals(NUM_PATTERN))) {
                        String message = MessageFormat.format("The pattern: \"{0}\" is not allowed within a remote function call. ", iSimpletype.getPattern(0));
                        throw new InvocationException(message);
                    }
                    if (iSimpletype.getPattern(0).equals(DATE_PATTERN)) {
                        caseSimpleType = 1;
                        break;
                    }
                    if (iSimpletype.getPattern(0).equals(TIME_PATTERN)) {
                        caseSimpleType = 3;
                        break;
                    }
                    if (iSimpletype.getPattern(0).equals(NUM_PATTERN)) {
                        caseSimpleType = 6;
                        break;
                    }
                }
                if (iSimpletype.getMaxLength() < 1) {
                    caseSimpleType = 29;
                    break;
                }
                caseSimpleType = 0;
                break;
            }
            case 6: {
                caseSimpleType = 7;
                break;
            }
            case 8: {
                caseSimpleType = 8;
                break;
            }
            case 1: {
                if (iSimpletype.getMaxLength() < 1) {
                    caseSimpleType = 30;
                    break;
                }
                caseSimpleType = 4;
                break;
            }
            case 5: {
                caseSimpleType = 2;
                break;
            }
            case 15: {
                caseSimpleType = 10;
                break;
            }
            case 11: {
                caseSimpleType = 9;
                break;
            }
            default: {
                String type = String.valueOf(iSimpletype.getBase());
                String message = MessageFormat.format(EXCEPTION_WRONG_SIMPLE_TYPE, type);
                throw new InvocationException(message);
            }
        }
        return caseSimpleType;
    }

    private ISimpleTypeValue getBaseOfSimpleType(ISimpleTypeValue simpleValue, String elementName) throws InvocationException {
        ISimpleType iSimpletype = simpleValue.getSimpleType();
        int baseSimpleType = iSimpletype.getBase();
        SimpleTypeValue valueConversion = new SimpleTypeValue(iSimpletype);
        switch (baseSimpleType) {
            case 12: {
                if (iSimpletype.getPatternCount() != 0) {
                    if (iSimpletype.getPatternCount() > 1) {
                        String message = MessageFormat.format(EXCEPTION_MORE_PATTERNS, elementName, "element");
                        throw new InvocationException(message);
                    }
                    if (iSimpletype.getPattern(0).equals(DATE_PATTERN)) {
                        BaseLogManager.info(this.getClass(), (String)("The given date from simple value is : " + simpleValue.getValueDate()));
                        String dateR3Respres = ExternalDate.buildR3Date((Date)simpleValue.getValueDate());
                        BaseLogManager.info(this.getClass(), (String)("The converted R/3 date is: " + dateR3Respres));
                        valueConversion.setValue(dateR3Respres);
                    }
                    if (iSimpletype.getPattern(0).equals(TIME_PATTERN)) {
                        BaseLogManager.info(this.getClass(), (String)("The given time from simple value is : " + simpleValue.getValueDate()));
                        String timeR3Respres = ExternalDate.buildR3Time((Date)simpleValue.getValueDate());
                        BaseLogManager.info(this.getClass(), (String)("The converted R/3 time is: " + timeR3Respres));
                        valueConversion.setValue(timeR3Respres);
                    }
                    if (!iSimpletype.getPattern(0).equals(NUM_PATTERN)) break;
                    valueConversion.setValue(simpleValue.getValue());
                    break;
                }
                valueConversion.setValue(simpleValue.getValue());
                break;
            }
            case 5: {
                valueConversion.setValueBigDecimal(simpleValue.getValueBigDecimal());
                break;
            }
            case 11: {
                Integer integerShort = simpleValue.getValueInteger();
                String valueShort = Integer.toString(integerShort);
                valueConversion.setValue(valueShort);
                break;
            }
            case 6: {
                valueConversion.setValueDouble(simpleValue.getValueDouble());
                break;
            }
            case 8: {
                Integer integerInt = simpleValue.getValueInteger();
                String valueInt = Integer.toString(integerInt);
                valueConversion.setValue(valueInt);
                break;
            }
            case 1: {
                valueConversion.setValueByteArray(simpleValue.getValueByteArray());
                break;
            }
            case 15: {
                Integer integerUnsignedByte = simpleValue.getValueInteger();
                String valueUnsignedByte = Integer.toString(integerUnsignedByte);
                valueConversion.setValue(valueUnsignedByte);
                break;
            }
            default: {
                String base = String.valueOf(baseSimpleType);
                String message = MessageFormat.format(EXCEPTION_WRONG_SIMPLE_TYPE, base);
                throw new InvocationException(message);
            }
        }
        return valueConversion;
    }

    public int isComplexTypeStrucOrTable(IComplexType iComplextype) throws InvocationException {
        int strucOrTable = 0;
        if (iComplextype.getElementCount() == 0) {
            throw new InvocationException("The defined element does not contain any elements, so it is not possible to identify, if you mean either a structure or a table. Please clarify that by defining the particular element.");
        }
        strucOrTable = iComplextype.getElement(ELEMENT_NAME_OF_STRUCTURE_OF_TABLE) == null ? 17 : 99;
        return strucOrTable;
    }

    public String reconvertProhibitedCharacters(String name) throws InvocationException {
        StringBuffer prohibitedChars = null;
        try {
            if (name != null) {
                prohibitedChars = new StringBuffer();
                int remainLength = name.length();
                int i = 0;
                while (i < name.length()) {
                    if (remainLength > 4) {
                        if (name.charAt(i) == '_' && name.charAt(i + 1) == '-' && name.charAt(i + 2) == '-') {
                            StringBuffer reconvertHex = new StringBuffer();
                            reconvertHex.append(name.charAt(i + 3));
                            reconvertHex.append(name.charAt(i + 4));
                            int hexValue = Integer.parseInt(reconvertHex.toString(), 16);
                            char hexValueAsChar = (char)hexValue;
                            String normalCharacter = String.valueOf(hexValueAsChar);
                            prohibitedChars.append(normalCharacter);
                            i += 5;
                            remainLength -= 5;
                            continue;
                        }
                        if (name.charAt(i) == '_' && name.charAt(i + 1) == '-') {
                            prohibitedChars.append('/');
                            i += 2;
                            remainLength -= 2;
                            continue;
                        }
                        prohibitedChars.append(name.charAt(i));
                        ++i;
                        --remainLength;
                        continue;
                    }
                    if (remainLength > 1) {
                        if (name.charAt(i) == '_' && name.charAt(i + 1) == '-') {
                            prohibitedChars.append('/');
                            i += 2;
                            remainLength -= 2;
                            continue;
                        }
                        prohibitedChars.append(name.charAt(i));
                        ++i;
                        --remainLength;
                        continue;
                    }
                    prohibitedChars.append(name.charAt(i));
                    ++i;
                    --remainLength;
                }
                return prohibitedChars.toString();
            }
        }
        catch (Exception exception) {
            throw new InvocationException(exception);
        }
        return prohibitedChars.toString();
    }

    private JCO.Function getNonExecutedFunction(Properties props, Locale locale) throws EngineException, InvocationException {
        JCO.Function jcoFunction;
        block10: {
            jcoFunction = null;
            try {
                jcoFunction = SAPSystemConnector.getNonExcecutedJCOFunctionOfFunctionModule(props, locale);
            }
            catch (JCO.Exception jcoEx) {
                int modeRfc = Integer.parseInt(props.getProperty("rfc.mode"));
                if (jcoEx.getGroup() == 103) {
                    String defaultLang = props.getProperty("jco.language");
                    Locale defaultLocale = new Locale(defaultLang);
                    BaseLogManager.info(this.getClass(), (String)("The default language is: " + defaultLocale.getLanguage()));
                    try {
                        jcoFunction = SAPSystemConnector.getNonExcecutedJCOFunctionOfFunctionModule(props, defaultLocale);
                    }
                    catch (JCO.Exception ex) {
                        if (jcoEx.getGroup() == 103) {
                            Locale englishLocale = new Locale("en");
                            try {
                                jcoFunction = SAPSystemConnector.getNonExcecutedJCOFunctionOfFunctionModule(props, englishLocale);
                                break block10;
                            }
                            catch (ExternalException ExtEx) {
                                throw new EngineException((Exception)((Object)ExtEx));
                            }
                        }
                        this.handleJCOException(jcoEx, props, locale);
                        break block10;
                    }
                    catch (ExternalException ex) {
                        throw new EngineException((Exception)((Object)ex));
                    }
                }
                this.handleJCOException(jcoEx, props, locale);
            }
            catch (ExternalException ex) {
                throw new EngineException((Exception)((Object)ex));
            }
        }
        return jcoFunction;
    }

    private void handleJCOException(JCO.Exception jcoEx, Properties props, Locale locale) throws EngineException {
        int modeRfc = Integer.parseInt(props.getProperty("rfc.mode"));
        if (modeRfc == 1) {
            String nameJCODes = props.getProperty("rfc.destination");
            String message = MessageFormat.format("The following exception ocurred: \"{0}\". When trying to access the function module: \"{1}\" using the SLD JCO-Destination name: \"{2}\". ", jcoEx.getMessage(), this.m_rfc_function_module_name, nameJCODes);
            throw new EngineException(message);
        }
        if (modeRfc == 2) {
            String client = props.getProperty("jco.client");
            String user = props.getProperty("jco.user");
            int modeSrv = Integer.parseInt(props.getProperty("jco.mode"));
            if (modeSrv == 1) {
                String msgSrv = props.getProperty("jco.msgsrv");
                String systemId = props.getProperty("jco.systemid");
                String message = MessageFormat.format("The following exception ocurred: \"{0}\". When trying to access the function module: \"{1}\" using the client: \"{2}\", the user: \"{3}\", the message server: \"{4}\" and the system identifier: \"{5}\". ", jcoEx.getMessage(), this.m_rfc_function_module_name, client, user, msgSrv, systemId);
                throw new EngineException(message);
            }
            if (modeSrv == 2) {
                String applSrv = props.getProperty("jco.applsrv");
                String systemNr = props.getProperty("jco.sysnr");
                String message = MessageFormat.format("The following exception ocurred: \"{0}\". When trying to access the function module: \"{1}\" using the client: \"{2}\", the user: \"{3}\", the application server: \"{4}\" and the system number: \"{5}\". ", jcoEx.getMessage(), this.m_rfc_function_module_name, client, user, applSrv, systemNr);
                throw new EngineException(message);
            }
        } else if (modeRfc == 3) {
            String endpointName = props.getProperty("endpoint.name");
            String endpointType = props.getProperty("endpoint.type");
            String message = MessageFormat.format("The following exception ocurred: \"{0}\". When trying to access the function module: \"{1}\" using the endpoint: \"{2}\" of endpoint type: \"{3}\".", jcoEx.getMessage(), this.m_rfc_function_module_name, endpointName, endpointType);
            throw new EngineException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

