/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.endpoint.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.text.TitleText;
import com.sap.caf.mp.base.text.TitleTextList;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.service.endpoint.types.EndpointTypeDef;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDef;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDefConstants;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDefs;
import com.sap.caf.mp.core.data.service.endpoint.types.PropertyParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDef;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDefEnumeration;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefConstants;
import com.sap.caf.mp.core.data.service.registry.types.IUsageConstraintDef;
import com.sap.caf.mp.core.data.service.registry.types.IUsageConstraintValueDef;
import com.sap.caf.mp.core.data.service.registry.types.ServiceProviderTypeDefs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EndpointTypeDefs
implements IServiceProviderTypeDefConstants,
IEndpointTypeDefConstants,
IEndpointTypeDefs {
    private static final String ELEMENT_NAME_ENDPOINTTYPES = "EndpointTypes";
    private Hashtable m_typeDefs;
    private String m_fallbackLanguage;
    private ICoreFactory m_coreFactory;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs;

    public EndpointTypeDefs(ICoreFactory coreFactory, InputStream stream, String fallbackLanguage, Locale locale) throws EngineException {
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_coreFactory = coreFactory;
        this.m_typeDefs = new Hashtable();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals(ELEMENT_NAME_ENDPOINTTYPES)) {
                throw new EngineException("The xml file is invalid.");
            }
            NodeList children = docEl.getChildNodes();
            int count = children.getLength();
            for (int i = 0; i < count; ++i) {
                Node child = children.item(i);
                String localName = child.getLocalName();
                if (localName == null) continue;
                EndpointTypeDef typeDef = new EndpointTypeDef((Element)child, fallbackLanguage, locale);
                this.m_typeDefs.put(typeDef.getName(), typeDef);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new EngineException("Unable to create xml parser instance.", (Exception)ex);
        }
        catch (SAXException ex) {
            throw new EngineException("Unable to parse input file.", (Exception)ex);
        }
        catch (IOException ex) {
            throw new EngineException("Unable to read input file.", (Exception)ex);
        }
    }

    public Enumeration getEndpointTypeDefs() {
        return this.m_typeDefs.elements();
    }

    /*
     * Loose catch block
     */
    public void updateEndpointTypeDef(IEndpointTypeDef newEndpointTypeDef, Element newEndpointTypeDefElement, Locale locale) throws EngineException, InvocationException {
        block21: {
            OutputStream out = null;
            InputStream is = null;
            EndpointTypeDef oldEndpointTypeDef = null;
            is = this.m_coreFactory.getCoreContext().getPersistenFile("service_provider_type_definitions.xml");
            String fallBackLanguage = this.m_coreFactory.getCoreContext().getFallbackLanguage();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals(ELEMENT_NAME_ENDPOINTTYPES)) {
                throw new EngineException("The xml file is invalid.");
            }
            Document documentOut = builder.newDocument();
            Element documentElementOut = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:EndpointTypes");
            documentOut.appendChild(documentElementOut);
            NodeList children = docEl.getChildNodes();
            int count = children.getLength();
            for (int index = 0; index < count; ++index) {
                Node child = children.item(index);
                String localName = child.getLocalName();
                if (localName == null || localName.equals(newEndpointTypeDef.getName())) continue;
                EndpointTypeDef typeDef = new EndpointTypeDef((Element)child, fallBackLanguage, locale);
                documentElementOut.appendChild(child);
            }
            documentElementOut.appendChild(newEndpointTypeDefElement);
            out = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult stream = new StreamResult(out);
            DOMSource source = new DOMSource(documentElementOut);
            transformer.transform(source, stream);
            this.m_coreFactory.getCoreContext().updatePersistentFile("service_provider_type_definitions.xml", (InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray()));
            oldEndpointTypeDef = (EndpointTypeDef)this.m_typeDefs.remove(newEndpointTypeDef.getName());
            this.m_typeDefs.put(newEndpointTypeDef.getName(), newEndpointTypeDef);
            Object var21_24 = null;
            try {
                if (out != null) {
                    out.flush();
                    ((ByteArrayOutputStream)out).close();
                }
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            try {
                if (is != null) {
                    is.close();
                }
                break block21;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            break block21;
            {
                catch (EngineException ex) {
                    BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
                    try {
                        if (oldEndpointTypeDef != null) {
                            this.m_typeDefs.put(oldEndpointTypeDef.getName(), oldEndpointTypeDef);
                        }
                    }
                    catch (Exception ex1) {
                        BaseLogManager.error(this.getClass(), (Exception)ex1);
                    }
                    throw new InvocationException((Exception)((Object)ex));
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                    throw new InvocationException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var21_25 = null;
                try {
                    if (out != null) {
                        out.flush();
                        ((ByteArrayOutputStream)out).close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    private void appendServiceProviderTypeDef(EndpointTypeDef endpointTypeDef, Element parent, Document document, Locale locale) throws EngineException {
        try {
            Element element = document.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:EndpointType");
            element.setAttribute("name", endpointTypeDef.getName());
            element.setAttribute("implementationClassName", endpointTypeDef.getImplementationClassName());
            this.appendTitleTextList(endpointTypeDef.getTitleTextList(), element, document);
            this.appendPropertyParameterList(endpointTypeDef, element, document, locale);
            parent.appendChild(element);
        }
        catch (EngineException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    private void appendPropertyParameterList(EndpointTypeDef endpointTypeDef, Element parent, Document doc, Locale locale) throws EngineException {
        Enumeration propParameters = endpointTypeDef.getPropertyParameters();
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:PropertyParameterList");
        while (propParameters.hasMoreElements()) {
            PropertyParameterDef propParameterDef = (PropertyParameterDef)propParameters.nextElement();
            Element propParameterElement = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:PropertyParameter");
            propParameterElement.setAttribute("name", propParameterDef.getName());
            propParameterElement.setAttribute("obligate", String.valueOf(propParameterDef.isObligate()));
            String type = this.getTypeAsString(propParameterDef.getType(), propParameterDef.getName(), locale);
            propParameterElement.setAttribute("type", type);
            this.appendPropertyParameterValueDefinitions(propParameterDef.getParameterValueDefEnumeration(), propParameterElement, doc);
            this.appendPropertyParameterUsageConstrataints(propParameterDef.getUsageConstraints(), propParameterElement, doc);
        }
        parent.appendChild(element);
    }

    private String getTypeAsString(int type, String objectName, Locale locale) throws EngineException {
        String typeString = null;
        switch (type) {
            case 2: {
                typeString = "enumeration";
                break;
            }
            case 4: {
                typeString = "language";
                break;
            }
            case 3: {
                typeString = "numstring";
                break;
            }
            case 5: {
                typeString = "password";
                break;
            }
            case 1: {
                typeString = "string";
                break;
            }
            case 6: {
                typeString = "boolean";
                break;
            }
            default: {
                throw new EngineException("Invalid type specified in parameter element: " + objectName);
            }
        }
        return typeString;
    }

    private void appendPropertyParameterUsageConstrataints(Vector usageConstraints, Element parent, Document doc) throws EngineException {
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:UsageConstraints");
        Enumeration enumeration = usageConstraints.elements();
        while (enumeration.hasMoreElements()) {
            IUsageConstraintDef usageConstraint = (IUsageConstraintDef)enumeration.nextElement();
            Element usageConstraintElement = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:UsageConstraint");
            Enumeration usageConstraintValueEnum = usageConstraint.getUsageConstraintValueDefs();
            while (usageConstraintValueEnum.hasMoreElements()) {
                IUsageConstraintValueDef valueDef = (IUsageConstraintValueDef)usageConstraintValueEnum.nextElement();
                Element valueElement = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:UsageConstraintValue");
                valueElement.setAttribute("name", valueDef.getName());
                valueElement.setAttribute("value", valueDef.getValue());
                usageConstraintElement.appendChild(valueElement);
            }
            element.appendChild(usageConstraintElement);
        }
        parent.appendChild(element);
    }

    private void appendPropertyParameterValueDefinitions(IParameterValueDefEnumeration parameterValueDefEnum, Element parent, Document doc) throws EngineException {
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:ParameterValueEnumeration");
        element.setAttribute("default", parameterValueDefEnum.getDefault().getName());
        Enumeration enumeration = parameterValueDefEnum.elements();
        Object root = null;
        while (enumeration.hasMoreElements()) {
            IParameterValueDef valueDef = (IParameterValueDef)enumeration.nextElement();
            Element valueDefElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ParameterValue");
            valueDefElement.setAttribute("name", valueDef.getName());
            this.appendTitleTextList(valueDef.getTitleList(), valueDefElement, doc);
            element.appendChild(valueDefElement);
        }
        parent.appendChild(element);
    }

    private void appendTitleTextList(TitleTextList titles, Element parent, Document document) {
        Element titlesElement = document.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:TitleList");
        titlesElement.setAttribute("masterLanguage", titles.getMasterLanguage());
        Enumeration enumeration = titles.elements();
        while (enumeration.hasMoreElements()) {
            TitleText title = (TitleText)enumeration.nextElement();
            Element titleElement = document.createElementNS("http://www.sap.com/caf/mp/if/EndpointTypeDefinitions_v1", "mp:Title");
            titleElement.setAttribute("language", title.getLanguage());
            titleElement.setAttribute("text", title.getText());
            titlesElement.appendChild(titleElement);
        }
        parent.appendChild(titlesElement);
    }

    public IEndpointTypeDef getEndpointTypeDef(String name) {
        return (IEndpointTypeDef)this.m_typeDefs.get(name);
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("c:\\temp\\service_provider_type_definitions.xml");
            ServiceProviderTypeDefs serviceProviderTypeDefs = new ServiceProviderTypeDefs(null, fis, "en");
        }
        catch (Exception ex) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs == null ? (class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs = EndpointTypeDefs.class$("com.sap.caf.mp.core.data.service.registry.types.ServiceProviderTypeDefs")) : class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs), (Exception)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

