/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.ExternalException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.util.ClassUtils;
import com.sap.caf.mp.base.util.ExternalDate;
import com.sap.caf.mp.base.util.MessageUtils;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.mapping.api.IMappingRule;
import com.sap.caf.mp.core.data.mapping.api.IMappingRuleEntry;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.mapping.base.SimpleMappingRule;
import com.sap.caf.mp.core.data.mapping.base.SingleValueMapping;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.persistence.base.ServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.DataServiceBridge;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.IServiceResponse;
import com.sap.caf.mp.core.data.service.endpoint.EndpointRegistry;
import com.sap.caf.mp.core.data.service.endpoint.api.IEndpointRegistry;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.manager.api.IServiceManager;
import com.sap.caf.mp.core.data.service.mapping.MappingService;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServicesRegistry;
import com.sap.caf.mp.core.data.service.registry.ServiceRegistry;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDef;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefs;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.lib.security.Base64;
import com.sap.mw.jco.JCO;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.UMException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;

public class DataServiceFactory
implements IDataServiceFactory {
    private ICoreFactory m_coreFactory;
    private DataServiceBridge m_bridge;

    public DataServiceFactory(ICoreFactory coreFactory, ApplicationServiceContext serviceContext) throws EngineException {
        this.m_coreFactory = coreFactory;
        InputStream is = coreFactory.getCoreContext().getPersistenFile("service_provider_type_definitions.xml");
        InputStream isEpt = coreFactory.getCoreContext().getPersistenFile("endpoint_type_definitions.xml");
        ServiceRegistry serviceRegistry = new ServiceRegistry(coreFactory, is, this.m_coreFactory.getPersistenceManagers().getConnectionPool(), this.m_coreFactory.getCoreContext().getFallbackLanguage(), this);
        MappingService mappingService = new MappingService(this.m_coreFactory.getPersistenceManagers().getConnectionPool(), this.m_coreFactory.getCoreContext().getFallbackLanguage());
        ServiceDescriptionPersistence descriptionPersistence = null;
        try {
            descriptionPersistence = new ServiceDescriptionPersistence(this.m_coreFactory);
        }
        catch (InvocationException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            throw new EngineException((Exception)((Object)ex));
        }
        EndpointRegistry endpointRegistry = new EndpointRegistry(coreFactory, isEpt, this.m_coreFactory.getPersistenceManagers().getConnectionPool(), this, this.m_coreFactory.getCoreContext().getFallbackLanguage(), new Locale("en"), (IServiceDescriptionPersistence)descriptionPersistence);
        BaseLogManager.info(this.getClass(), (String)("The endpoint registry was instantiated: " + endpointRegistry));
        if (endpointRegistry != null) {
            BaseLogManager.info(this.getClass(), (String)("Info about endpoint registry: " + ClassUtils.getInstanceInfo((Object)endpointRegistry)));
        }
        this.m_bridge = new DataServiceBridge(serviceRegistry, (IServiceDescriptionPersistence)descriptionPersistence, mappingService, serviceContext, endpointRegistry);
        this.m_bridge.setDataServiceFactory(this);
    }

    public IServicesRegistry getServicesRegistry() {
        return this.m_bridge;
    }

    public IServiceDescriptionPersistence getServiceDescriptionPersistence() {
        return this.m_bridge;
    }

    public IServiceResponse executeOperation(String serviceTypeName, IMessageValue input, IOperation operation, Properties operationConfig, Locale userLocale) throws InvocationException, EngineException {
        IServiceProviderTypeDefs defs = this.m_bridge.getServiceProviderTypeDefs();
        IServiceProviderTypeDef def = defs.getServiceProviderDef(serviceTypeName);
        if (def == null) {
            throw new InvocationException(MessageUtils.format((String)"There is no service provider type names {0} registered.", (String)serviceTypeName));
        }
        IServiceManager manager = null;
        try {
            manager = (IServiceManager)Class.forName(def.getImplementationClassName()).newInstance();
        }
        catch (InstantiationException e) {
            BaseLogManager.error(this.getClass(), (String)("Error instantiating class: " + def.getImplementationClassName()), (Exception)e);
            throw new InvocationException(MessageUtils.format((String)"The implementation class for the service type named {0} could not be instantiated.", (String)serviceTypeName), (Exception)e);
        }
        catch (IllegalAccessException e) {
            BaseLogManager.error(this.getClass(), (String)("Error instantiating class: " + def.getImplementationClassName()), (Exception)e);
            throw new InvocationException(MessageUtils.format((String)"The implementation class for the service type named {0} could not be instantiated due to permission settings.", (String)serviceTypeName), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            BaseLogManager.error(this.getClass(), (String)("Error instantiating class: " + def.getImplementationClassName()), (Exception)e);
            throw new InvocationException(MessageUtils.format((String)"The implementation class for the service type named {0} could not be found.", (String)serviceTypeName), (Exception)e);
        }
        IServiceResponse response = manager.executeOperation(input, operation, operationConfig, userLocale);
        return response;
    }

    public IMappingService getMappingService() {
        return this.m_bridge;
    }

    private String resolveSemanticValue(int type, IUser user, String language) throws EngineException {
        switch (type) {
            case 12: {
                if (user == null) break;
                return user.getFirstName();
            }
            case 13: {
                if (user == null) break;
                return user.getLastName();
            }
            case 15: {
                if (user == null) break;
                try {
                    IUserAccount[] account = user.getUserAccounts();
                    if (account.length == 0) {
                        return null;
                    }
                    return account[0].getLogonUid();
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case 10: {
                if (language != null) {
                    return language;
                }
                if (user == null || user.getLocale() == null) break;
                return user.getLocale().getLanguage();
            }
            case 19: {
                if (language != null) {
                    return language.toUpperCase();
                }
                if (user == null || user.getLocale() == null) break;
                return user.getLocale().getLanguage().toUpperCase();
            }
            case 16: {
                return ExternalDate.buildTimeStampRFC1123((Date)GregorianCalendar.getInstance().getTime());
            }
            case 17: {
                Locale locale = null;
                locale = language != null ? new Locale(language) : Locale.getDefault();
                return DateFormat.getDateInstance(3, locale).format(GregorianCalendar.getInstance().getTime());
            }
            case 18: {
                if (user == null) break;
                try {
                    return user.getEmail();
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    private IComplexTypeValue ensureComplexTypeMinOccurs(IComplexType type, ComplexTypeValue value) throws InvocationException {
        if (value == null) {
            value = new ComplexTypeValue(type);
        }
        Enumeration enumeration = type.getElementEnumeration();
        while (enumeration.hasMoreElements()) {
            IElement element = (IElement)enumeration.nextElement();
            if (element.getMinOccurs() <= 0) continue;
            IElementValue subElement = value.getElementValue(element.getName());
            if (subElement == null) {
                value.addElementValue(this.ensureElementMinOccurs(element, null));
                continue;
            }
            this.ensureElementMinOccurs(element, (ElementValue)subElement);
        }
        if (value.getElementValueCount() == 0) {
            return null;
        }
        return value;
    }

    private IElementValue ensureElementMinOccurs(IElement element, ElementValue elementValue) throws InvocationException {
        if (elementValue == null) {
            elementValue = new ElementValue(element);
        }
        if (element.getType() instanceof IComplexType) {
            IComplexType complexType = (IComplexType)element.getType();
            if (elementValue.getTypeValueCount() == 0) {
                IComplexTypeValue cv = this.ensureComplexTypeMinOccurs(complexType, null);
                if (cv != null) {
                    elementValue.addTypeValue((ITypeValue)cv);
                }
            } else {
                Enumeration enumeration = elementValue.getTypeValueEnumeration();
                while (enumeration.hasMoreElements()) {
                    IComplexTypeValue value = (IComplexTypeValue)enumeration.nextElement();
                    this.ensureComplexTypeMinOccurs(complexType, (ComplexTypeValue)value);
                }
            }
        }
        return elementValue;
    }

    private void ensureMinOccurs(MessageValue inboundMessage) throws InvocationException {
        IMessage message = inboundMessage.getMessage();
        Enumeration enumeration = message.getMessagepartEnumeration();
        while (enumeration.hasMoreElements()) {
            IElement element;
            IMessagepart part = (IMessagepart)enumeration.nextElement();
            MessagepartValue partValue = (MessagepartValue)inboundMessage.getMessagepartValue(part.getName());
            if (partValue == null) continue;
            if (part.getStructure() instanceof IComplexType) {
                IComplexType complexType = (IComplexType)part.getStructure();
                if (partValue.getStructureValue() != null) {
                    this.ensureComplexTypeMinOccurs(complexType, (ComplexTypeValue)partValue.getStructureValue());
                    continue;
                }
                IComplexTypeValue cv = this.ensureComplexTypeMinOccurs(complexType, null);
                if (cv == null) continue;
                partValue.setStructureValue((IStructureValue)cv);
                continue;
            }
            if (!(part.getStructure() instanceof IElement) || (element = (IElement)part.getStructure()).getMinOccurs() <= 0) continue;
            if (partValue.getStructureValue() != null) {
                this.ensureElementMinOccurs(element, (ElementValue)partValue.getStructureValue());
                continue;
            }
            partValue.setStructureValue((IStructureValue)this.ensureElementMinOccurs(element, null));
        }
    }

    private IMessageValue applyMappingRule(IMessageValue source, IMessage type, String ruleId, IUser user, String language) throws InvocationException, EngineException {
        SingleValueMapping mapping = new SingleValueMapping();
        IMappingRule mappingRule = this.getMappingService().getMappingRule(ruleId);
        Enumeration enumeration = mappingRule.getMappingRuleEntries().elements();
        block4: while (enumeration.hasMoreElements()) {
            IMappingRuleEntry entry = (IMappingRuleEntry)enumeration.nextElement();
            switch (entry.getType()) {
                case 0: {
                    mapping.addMappingRule(new SimpleMappingRule(entry.getTargetExpression(), null, entry.getSourceExpression()));
                    continue block4;
                }
                case -1: {
                    mapping.addMappingRule(new SimpleMappingRule(entry.getTargetExpression(), entry.getSourceExpression()));
                    continue block4;
                }
            }
            String value = this.resolveSemanticValue(entry.getType(), user, language);
            if (value == null) continue;
            mapping.addMappingRule(new SimpleMappingRule(entry.getTargetExpression(), null, value));
        }
        return mapping.map(type, source);
    }

    public IMessageValue executeOperation(IMessageValue sourceMessage, String mappingRuleIdIn, String serviceId, String operationName, String mappingRuleIdOut, IUserAccount callerAccount) throws InvocationException, EngineException, ExternalException {
        IUser assignedUser = null;
        try {
            assignedUser = callerAccount.getAssignedUser();
        }
        catch (UMException ume) {
            assignedUser = null;
        }
        return this.executeOperationCommon(sourceMessage, mappingRuleIdIn, serviceId, operationName, mappingRuleIdOut, callerAccount, assignedUser, assignedUser.getLocale());
    }

    private IMessageValue executeOperationCommon(IMessageValue sourceMessage, String mappingRuleIdIn, String serviceId, String operationName, String mappingRuleIdOut, IUserAccount callerAccount, IUser caller, Locale userLocale) throws InvocationException, EngineException, ExternalException {
        if (userLocale == null) {
            userLocale = Locale.getDefault();
        }
        BaseLogManager.info(this.getClass(), (String)("Data binding: Invoking: " + serviceId + "->" + operationName));
        BaseLogManager.info(this.getClass(), (String)("Data binding: retrieving the source mapping rule: " + mappingRuleIdIn));
        IMappingRule sourceRule = this.getMappingService().getMappingRule(mappingRuleIdIn);
        BaseLogManager.info(this.getClass(), (String)("Data binding: retrieving the inbound message definition: " + sourceRule.getTargetMessageId()));
        IMessage inboundMessage = this.getServiceDescriptionPersistence().readMessage(sourceRule.getTargetMessageId());
        BaseLogManager.info(this.getClass(), (String)"Data binding: constructing source message value instance ...");
        IMessageValue inboundMessageValue = this.applyMappingRule(sourceMessage, inboundMessage, mappingRuleIdIn, caller, userLocale.getLanguage());
        IMappingRule targetRule = null;
        IMessage targetDef = null;
        if (mappingRuleIdOut != null) {
            BaseLogManager.info(this.getClass(), (String)("Data binding: retrieving the target mapping rule: " + mappingRuleIdOut));
            targetRule = this.getMappingService().getMappingRule(mappingRuleIdOut);
            BaseLogManager.info(this.getClass(), (String)("Data binding: retrieving the target message definition: " + targetRule.getTargetMessageId()));
            targetDef = this.getServiceDescriptionPersistence().readMessage(targetRule.getTargetMessageId());
        }
        BaseLogManager.info(this.getClass(), (String)("Data binding: retrieving service information: " + serviceId));
        IServiceDefinition serviceDef = this.getServicesRegistry().readServiceDefinition(serviceId);
        IOperation operation = serviceDef.getPortType().getOperation(operationName);
        Properties operationConfig = serviceDef.resolveOperationProperties(operationName);
        String sncLibraryPath = this.m_coreFactory.getCoreContext().getServiceConfig().getProperty("jco.client.snc_lib");
        if (sncLibraryPath != null) {
            operationConfig.setProperty("jco.client.snc_lib", sncLibraryPath);
        }
        String sncMyName = this.m_coreFactory.getCoreContext().getServiceConfig().getProperty("jco.client.snc_myname");
        if (sncLibraryPath != null) {
            operationConfig.setProperty("jco.client.snc_myname", sncMyName);
        }
        if (inboundMessageValue instanceof MessageValue) {
            this.ensureMinOccurs((MessageValue)inboundMessageValue);
        }
        IServiceResponse response = null;
        String ssoValue = operationConfig.getProperty("jco.sso");
        X509Certificate[] certs = new X509Certificate[]{};
        try {
            certs = callerAccount != null ? callerAccount.getCertificates() : new X509Certificate[]{};
        }
        catch (UMException ume) {
            certs = new X509Certificate[]{};
        }
        catch (CertificateException ce) {
            certs = new X509Certificate[]{};
        }
        if (new Boolean(ssoValue).booleanValue()) {
            if (certs.length < 1) {
                throw new InvocationException("No X.509 certificate found!");
            }
            for (int i = 0; i < certs.length; ++i) {
                operationConfig.setProperty("jco.user", "$X509CERT$");
                byte[] certEnc = new byte[]{};
                try {
                    certEnc = certs[i].getEncoded();
                }
                catch (CertificateException ce) {
                    certEnc = new byte[]{};
                }
                String base64EncCert = "";
                try {
                    base64EncCert = new String(Base64.encode((byte[])certEnc));
                }
                catch (Exception ence) {
                    ence.printStackTrace();
                    base64EncCert = "";
                }
                operationConfig.setProperty("jco.password", base64EncCert);
                BaseLogManager.info(this.getClass(), (String)"Data binding: invoking the service ...");
                try {
                    response = this.executeOperation(serviceDef.getTypeName(), inboundMessageValue, operation, operationConfig, userLocale);
                    break;
                }
                catch (EngineException ee) {
                    if (ee.getNestedException() instanceof JCO.Exception && ((JCO.Exception)ee.getNestedException()).getGroup() == 103 && "RFC_ERROR_LOGON_FAILURE".equals(((JCO.Exception)ee.getNestedException()).getKey()) && i + 1 < certs.length) continue;
                    throw ee;
                }
            }
        } else {
            BaseLogManager.info(this.getClass(), (String)"Data binding: invoking the service ...");
            response = this.executeOperation(serviceDef.getTypeName(), inboundMessageValue, operation, operationConfig, userLocale);
        }
        if (response == null) {
            BaseLogManager.info(this.getClass(), (String)"Data binding: service invocation returned without response.");
            return null;
        }
        if (response.getFaultMessage() != null) {
            BaseLogManager.error(this.getClass(), (Exception)response.getFaultMessage());
            BaseLogManager.error(this.getClass(), (String)("Data binding: An error was reported: " + response.getFaultMessage().getMessage()));
            if (response.getFaultMessage() instanceof ExternalException) {
                throw (ExternalException)response.getFaultMessage();
            }
            throw new EngineException(response.getFaultMessage());
        }
        BaseLogManager.info(this.getClass(), (String)"Data binding: Service invocation succeeded. Returning response message.");
        if (targetRule != null) {
            return this.applyMappingRule(response.getResponseMessage(), targetDef, mappingRuleIdOut, caller, userLocale.getLanguage());
        }
        return response.getResponseMessage();
    }

    public IEndpointRegistry getEndpointRegistry() {
        return this.m_bridge;
    }

    public IMessageValue executeOperation(IMessageValue sourceMessage, String mappingRuleIdIn, String serviceId, String operationName, String mappingRuleIdOut, IUser caller, Locale userLocale) throws InvocationException, EngineException, ExternalException {
        return this.executeOperationCommon(sourceMessage, mappingRuleIdIn, serviceId, operationName, mappingRuleIdOut, null, caller, userLocale);
    }
}

