/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.mmr;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.ISimpleServicesRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;

public class SimpleServiceRegistryWrapper
implements ISimpleServicesRegistry {
    private ISimpleServicesRegistry m_internal;

    public SimpleServiceRegistryWrapper(ISimpleServicesRegistry internal) {
        this.m_internal = internal;
    }

    private void handleNestedException(Exception ex) throws InvocationException, EngineException {
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException iex = (InvocationTargetException)ex;
            Throwable nested = iex.getTargetException();
            if (nested instanceof InvocationException) {
                throw (InvocationException)nested;
            }
            if (nested instanceof EngineException) {
                throw (EngineException)nested;
            }
            throw new EngineException(nested.getMessage());
        }
        throw new EngineException(ex);
    }

    public Enumeration getServiceDefinitionIds() throws EngineException {
        try {
            return this.m_internal.getServiceDefinitionIds();
        }
        catch (EngineException ex) {
            throw ex;
        }
        catch (Exception ex) {
            try {
                this.handleNestedException(ex);
                return null;
            }
            catch (InvocationException ex2) {
                throw new EngineException((Exception)((Object)ex2));
            }
        }
    }

    public IServiceDefinition readServiceDefinition(String id) throws InvocationException, EngineException {
        try {
            return this.m_internal.readServiceDefinition(id);
        }
        catch (InvocationException ex) {
            throw ex;
        }
        catch (EngineException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.handleNestedException(ex);
            return null;
        }
    }
}

