/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.bag;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.bag.ITextbag;
import com.sap.caf.mp.core.bag.ITextbagEntry;
import java.util.Enumeration;
import java.util.Hashtable;

public class Textbag
implements ITextbag {
    private Hashtable m_hashtable = new Hashtable();
    private String m_language = null;

    public ITextbagEntry addTextbagEntry(ITextbagEntry entry) throws InvocationException {
        if (entry == null) {
            throw new InvocationException("Entry invalid");
        }
        return this.m_hashtable.put(entry.getLanguage(), entry);
    }

    public String getPrimaryLanguage() {
        return this.m_language;
    }

    public ITextbagEntry getTextbagEntry(String language) throws InvocationException {
        if (language == null || language.length() != 2) {
            throw new InvocationException("Language invalid");
        }
        return (ITextbagEntry)this.m_hashtable.get(language);
    }

    public Enumeration getTextbagEntryEnumeration() {
        return this.m_hashtable.elements();
    }

    public ITextbagEntry removeTextbagEntry(String language) throws InvocationException {
        if (language == null || language.length() != 2) {
            throw new InvocationException("Language invalid");
        }
        return (ITextbagEntry)this.m_hashtable.remove(language);
    }

    public void setPrimaryLanguage(String language) throws InvocationException {
        if (language.length() != 2) {
            throw new InvocationException("Language invalid");
        }
        this.m_language = language;
    }
}

