/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.impl.undo.providers.resource.FileTrackerImpl;
import com.tssap.selena.model.impl.undo.providers.resource.Messages;
import com.tssap.selena.model.impl.undo.providers.resource.WhatToDo;
import com.tssap.selena.model.platform.PlatformAdapter;
import com.tssap.selena.model.platform.PlatformListener;
import com.tssap.selena.model.undo.providers.IUndoStateListener;
import com.tssap.selena.model.undo.providers.IUndoSupport;
import com.tssap.selena.model.undo.providers.UndoCommand;
import com.tssap.selena.model.undo.providers.UndoFailedException;
import com.tssap.selena.model.undo.providers.UndoProvider;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class UndoSupportImpl
extends PlatformAdapter
implements IUndoSupport,
PlatformListener {
    private int myMaxUndoLevel;
    private static List ourProviders;
    private final List myUndoStateListeners;
    private Stack myUndoStack;
    private Stack myRedoStack;
    private SortedSet myUnusedMarkers;

    public UndoSupportImpl(int maxUndoLevel) {
        UndoSupportImpl.loadUndoProviders();
        this.myUndoStateListeners = new LinkedList();
        this.myUndoStack = new Stack();
        this.myRedoStack = new Stack();
        this.myUnusedMarkers = new TreeSet();
        this.setMaxUndoLevel(maxUndoLevel);
    }

    public void undoMarkerStarted() {
        this.setUndoMarker();
    }

    public void addUndoStateListener(IUndoStateListener listener) {
        boolean canUndo = this.canUndo();
        boolean canRedo = this.canRedo();
        List list = this.myUndoStateListeners;
        synchronized (list) {
            this.myUndoStateListeners.add(listener);
            listener.undoStateChanged(canUndo, canRedo);
        }
    }

    public void removeUndoStateListener(IUndoStateListener listener) {
        List list = this.myUndoStateListeners;
        synchronized (list) {
            this.myUndoStateListeners.remove(listener);
        }
    }

    public void fireUndoStateChanged() {
        boolean canUndo = this.canUndo();
        boolean canRedo = this.canRedo();
        List list = this.myUndoStateListeners;
        synchronized (list) {
            IUndoStateListener[] listeners = this.myUndoStateListeners.toArray(new IUndoStateListener[this.myUndoStateListeners.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].undoStateChanged(canUndo, canRedo);
                ++i;
            }
        }
    }

    private boolean isChangedSinceLastMarker() {
        Long lastRedoMarker;
        Long lastUndoMarker = this.myUndoStack.isEmpty() ? null : (Long)this.myUndoStack.peek();
        Long l = lastRedoMarker = this.myRedoStack.isEmpty() ? null : (Long)this.myRedoStack.peek();
        if (lastUndoMarker == null && lastRedoMarker == null) {
            return true;
        }
        if (lastUndoMarker == null) {
            return this.isChangedSinceMarker(lastRedoMarker);
        }
        if (lastRedoMarker == null) {
            return this.isChangedSinceMarker(lastUndoMarker);
        }
        return lastRedoMarker.compareTo(lastUndoMarker) > 0 ? this.isChangedSinceMarker(lastRedoMarker) : this.isChangedSinceMarker(lastUndoMarker);
    }

    private void setUndoMarker() {
        if (!this.isChangedSinceLastMarker()) {
            return;
        }
        Long newMarker = this.generateNewMarker();
        this.myUndoStack.push(newMarker);
        this.clearUnusedMarkers();
    }

    private boolean isChangedSinceMarker(Long marker) {
        Iterator providers = this.getUndoProviders().iterator();
        while (providers.hasNext()) {
            UndoProvider cur = (UndoProvider)providers.next();
            if (!cur.isChangedSinceMarker(marker)) continue;
            return true;
        }
        return false;
    }

    public boolean canUndo() {
        boolean bl;
        if (this.myUndoStack.isEmpty()) {
            return false;
        }
        Long lastMarker = (Long)this.myUndoStack.peek();
        if (this.isChangedSinceMarker(lastMarker)) {
            return this.canRestoreMarker(lastMarker);
        }
        if (this.myUndoStack.size() == 1) {
            return false;
        }
        try {
            this.myUndoStack.pop();
            Long nextToLast = (Long)this.myUndoStack.peek();
            Assert.isLegal((boolean)this.isChangedSinceMarker(nextToLast), (String)"setMarker should check changeSinceLastMarker");
            bl = this.canRestoreMarker(nextToLast);
            Object var5_4 = null;
            this.myUndoStack.push(lastMarker);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.myUndoStack.push(lastMarker);
            throw throwable;
        }
        return bl;
    }

    public void undo() {
        if (!this.canUndo()) {
            System.err.println("undo() without canUndo()");
            return;
        }
        Long undoMarker = (Long)this.myUndoStack.pop();
        this.myUnusedMarkers.add(undoMarker);
        if (!this.isChangedSinceMarker(undoMarker)) {
            undoMarker = (Long)this.myUndoStack.pop();
            this.myUnusedMarkers.add(undoMarker);
        }
        Long derivedRedoMarker = this.generateNewMarker();
        this.myRedoStack.push(derivedRedoMarker);
        this.restoreMarker(undoMarker);
    }

    public void redo() {
        if (!this.canRedo()) {
            System.err.println("redo() without canRedo()");
            return;
        }
        Long redoMarker = (Long)this.myRedoStack.pop();
        this.myUnusedMarkers.add(redoMarker);
        Long derivedUndoMarker = this.generateNewMarker();
        this.myUndoStack.push(derivedUndoMarker);
        this.restoreMarker(redoMarker);
    }

    public boolean canRedo() {
        if (this.myRedoStack.isEmpty()) {
            return false;
        }
        Long redoMarker = (Long)this.myRedoStack.peek();
        return this.canRestoreMarker(redoMarker);
    }

    public void setMaxUndoLevel(int level) {
        this.myMaxUndoLevel = level;
        this.clearUnusedMarkers();
        this.fireUndoStateChanged();
    }

    private void restoreMarker(Long marker) {
        HashMap<UndoProvider, UndoCommand> commandsMap = new HashMap<UndoProvider, UndoCommand>(this.getUndoProviders().size() * 2 + 1);
        Iterator providers = this.getUndoProviders().iterator();
        while (providers.hasNext()) {
            UndoProvider curProvider = (UndoProvider)providers.next();
            UndoCommand curCommand = curProvider.getUndoCommand(marker);
            commandsMap.put(curProvider, curCommand);
        }
        this.fireRestoreMarker(commandsMap);
    }

    private void fireRestoreMarker(final HashMap commandsMap) {
        Runnable compositeUndoCommand = new Runnable(){

            public void run() {
                HashSet<UndoProvider> successProviders = new HashSet<UndoProvider>();
                Iterator entries = commandsMap.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry curEntry = entries.next();
                    UndoProvider curProvider = (UndoProvider)curEntry.getKey();
                    UndoCommand curCommand = (UndoCommand)curEntry.getValue();
                    try {
                        curCommand.run();
                    }
                    catch (UndoFailedException failed) {
                        UndoSupportImpl.this.flushUndoInfo();
                        UndoSupportImpl.this.handleFail(successProviders, failed);
                        break;
                    }
                    successProviders.add(curProvider);
                }
            }
        };
        UndoSupportImpl.runLaterInSingleCommand(compositeUndoCommand);
    }

    private void handleFail(HashSet successProviders, UndoFailedException failed) {
        Iterator providers = successProviders.iterator();
        while (providers.hasNext()) {
            UndoProvider cur = (UndoProvider)providers.next();
            try {
                cur.handleFailure(failed);
            }
            catch (UndoFailedException unrecoverable) {
                UndoSupportImpl.notifyUnrecoverableUndoError(unrecoverable);
                this.setMaxUndoLevel(0);
            }
        }
    }

    private void flushUndoInfo() {
        while (!this.myUndoStack.isEmpty()) {
            this.myUnusedMarkers.add(this.myUndoStack.pop());
        }
        while (!this.myRedoStack.isEmpty()) {
            this.myUnusedMarkers.add(this.myRedoStack.pop());
        }
        this.clearUnusedMarkers();
    }

    private static void notifyUnrecoverableUndoError(UndoFailedException unrecoverable) {
        WhatToDo.problem("How to notify?");
        unrecoverable.printStackTrace();
        System.err.println("ATTENTION: Subsequent problems when attemting to recover problems in undo");
        System.err.println("Model state is undefined");
        System.err.println("It is recommended to exit from Workbench");
    }

    private static void runLaterInSingleCommand(final Runnable compositeCommand) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                ModelAccess.runCommand((Runnable)compositeCommand, (String)Messages.getString("UndoSupportImpl.perfoming_undo"));
            }
        });
    }

    private void clearUnusedMarkers() {
        while (!this.myRedoStack.isEmpty()) {
            this.myUnusedMarkers.add(this.myRedoStack.pop());
        }
        if (this.myUndoStack.size() > this.myMaxUndoLevel) {
            Stack temp = new Stack();
            int i = 0;
            while (i < this.myMaxUndoLevel) {
                temp.push(this.myUndoStack.pop());
                ++i;
            }
            while (!this.myUndoStack.isEmpty()) {
                this.myUnusedMarkers.add(this.myUndoStack.pop());
            }
            while (!temp.isEmpty()) {
                this.myUndoStack.push(temp.pop());
            }
        }
        Long minUndoMarker = this.myUndoStack.isEmpty() ? null : (Long)this.myUndoStack.get(0);
        Iterator ascendingUnusedMarkers = this.myUnusedMarkers.iterator();
        while (ascendingUnusedMarkers.hasNext()) {
            Long next = (Long)ascendingUnusedMarkers.next();
            if (minUndoMarker != null && minUndoMarker.compareTo(next) < 0) break;
            this.flushMarker(next);
            ascendingUnusedMarkers.remove();
        }
    }

    private void dump() {
        System.err.println("\t Redo Stack: ");
        UndoSupportImpl.dumpMarkers(this.myRedoStack);
        System.err.println("\t Undo Stack: ");
        UndoSupportImpl.dumpMarkers(this.myUndoStack);
        System.err.println("\t Unused: ");
        UndoSupportImpl.dumpMarkers(this.myUnusedMarkers);
    }

    private static void dumpMarkers(Collection collection) {
        System.err.println("\t size: " + collection.size());
        Iterator markers = collection.iterator();
        while (markers.hasNext()) {
            Long next = (Long)markers.next();
            Date nextDate = new Date(next);
            System.err.println("\t\t : " + nextDate);
        }
        System.err.println("---------");
    }

    private Long generateNewMarker() {
        Long result = new Long(System.currentTimeMillis());
        this.fireSetMarker(result);
        return result;
    }

    private void flushMarker(Long marker) {
        Iterator providers = this.getUndoProviders().iterator();
        while (providers.hasNext()) {
            ((UndoProvider)providers.next()).flushUndoMarker(marker);
        }
    }

    private void fireSetMarker(Long newMarker) {
        Iterator providers = this.getUndoProviders().iterator();
        while (providers.hasNext()) {
            UndoProvider curProvider = (UndoProvider)providers.next();
            curProvider.setUndoMarker(newMarker);
        }
    }

    private boolean canRestoreMarker(Long marker) {
        Iterator providers = this.getUndoProviders().iterator();
        while (providers.hasNext()) {
            UndoProvider cur = (UndoProvider)providers.next();
            if (cur.canUndo(marker)) continue;
            return false;
        }
        return true;
    }

    private static void loadUndoProviders() {
        if (ourProviders == null) {
            ourProviders = new LinkedList();
            ourProviders.add(new FileTrackerImpl());
        }
    }

    private List getUndoProviders() {
        return ourProviders;
    }
}

