/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.impl.undo.providers.resource.FileTrackerImpl;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoMarker;
import com.tssap.selena.model.util.Assert;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;

public class UndoResourceListener
implements IResourceChangeListener {
    private FileTrackerImpl myTracker;
    private static UndoResourceListener ourInstance;

    UndoResourceListener(FileTrackerImpl fileTracker) {
        this.myTracker = fileTracker;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResource deltaResource;
            long startUpdateTime = System.currentTimeMillis();
            IResourceDelta delta = event.getDelta();
            if (delta != null && (deltaResource = delta.getResource()) != null) {
                Assert.isLegal((deltaResource.getType() == 8 ? 1 : 0) != 0, (String)"java doc for IResourceChangeEvent says that delta 'pointed to workspace' -- ");
                Object object = this.myTracker.ACTIVE_MARKER_LOCK;
                synchronized (object) {
                    IUndoMarker activeMarker = this.myTracker.getActiveUndoMarker();
                    if (activeMarker != null) {
                        activeMarker.fileModified(delta, startUpdateTime);
                    }
                }
            }
        }
    }
}

