/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.impl.undo.providers.resource.AbstractResourceUndoInfo;
import com.tssap.selena.model.impl.undo.providers.resource.FileTrackerImpl;
import com.tssap.selena.model.impl.undo.providers.resource.IFileInfo;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoFileTracker;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoMarker;
import com.tssap.selena.model.impl.undo.providers.resource.ProjectUndoInfo;
import com.tssap.selena.model.undo.providers.UndoAccess;
import com.tssap.selena.model.util.Assert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class UndoMarkerImplExt
implements IUndoMarker {
    private FileTrackerImpl myTracker;
    private long myCreatedTime;
    private HashMap myProjectInfos;
    private boolean myIsNotUndoableFlag;
    private boolean myFirstModifiedFlag;
    protected final Object LOCK = new Integer(11);

    public UndoMarkerImplExt(FileTrackerImpl tracker, long createdTime) {
        this.myTracker = tracker;
        this.myCreatedTime = createdTime;
        this.myIsNotUndoableFlag = false;
    }

    public IUndoFileTracker getFileTracker() {
        return this.myTracker;
    }

    public void fileModified(IResourceDelta delta, long updateStarted) {
        Assert.isLegal((boolean)Path.ROOT.equals((Object)delta.getFullPath()));
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsNotUndoableFlag) {
                return;
            }
            if (this.myProjectInfos == null) {
                this.myProjectInfos = new HashMap(5);
            }
            Iterator<IResourceDelta> projects = Arrays.asList(delta.getAffectedChildren()).iterator();
            while (projects.hasNext()) {
                IResourceDelta nextProjectDelta = projects.next();
                if (this.isProjectOpenOrClosed(nextProjectDelta)) {
                    this.setNotUndoable();
                    return;
                }
                AbstractResourceUndoInfo projectInfo = (AbstractResourceUndoInfo)this.myProjectInfos.get(nextProjectDelta.getFullPath());
                if (projectInfo == null) {
                    projectInfo = new ProjectUndoInfo(this, nextProjectDelta, updateStarted);
                    this.myProjectInfos.put(nextProjectDelta.getFullPath(), projectInfo);
                    continue;
                }
                projectInfo.acceptNextModification(nextProjectDelta);
            }
        }
        if (!this.myFirstModifiedFlag) {
            this.myFirstModifiedFlag = true;
            UndoAccess.getUndoSupport().fireUndoStateChanged();
        }
    }

    public long getMarkerTime() {
        return this.myCreatedTime;
    }

    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = this.myProjectInfos == null;
            return bl;
        }
    }

    public void setNotUndoable() {
        this.myIsNotUndoableFlag = true;
        UndoAccess.getUndoSupport().fireUndoStateChanged();
    }

    public boolean canUndo() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsNotUndoableFlag) {
                boolean bl = false;
                return bl;
            }
            if (this.myProjectInfos != null) {
                Iterator projectInfos = this.myProjectInfos.values().iterator();
                while (projectInfos.hasNext()) {
                    IFileInfo next = (IFileInfo)projectInfos.next();
                    if (next.canUndo()) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public IWorkspaceRunnable getRestoreCommand() {
        Assert.isLegal((boolean)this.canUndo());
        final LinkedList<IWorkspaceRunnable> restoreProjectsCommands = new LinkedList<IWorkspaceRunnable>();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myProjectInfos == null) {
                IWorkspaceRunnable iWorkspaceRunnable = null;
                return iWorkspaceRunnable;
            }
            Iterator projectInfos = this.myProjectInfos.values().iterator();
            while (projectInfos.hasNext()) {
                IFileInfo next = (IFileInfo)projectInfos.next();
                IWorkspaceRunnable command = next.getRestoreCommand();
                if (command == null) continue;
                restoreProjectsCommands.add(command);
            }
        }
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator commands = restoreProjectsCommands.iterator();
                while (commands.hasNext()) {
                    ((IWorkspaceRunnable)commands.next()).run(monitor);
                }
            }
        };
    }

    private boolean isProjectOpenOrClosed(IResourceDelta projectDelta) {
        Assert.isLegal((projectDelta.getResource().getType() == 4 ? 1 : 0) != 0);
        return (projectDelta.getFlags() & 0x4000) > 0;
    }
}

