/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.impl.undo.providers.resource.AbstractResourceUndoInfo;
import com.tssap.selena.model.impl.undo.providers.resource.FileStateNotFoundException;
import com.tssap.selena.model.impl.undo.providers.resource.FileUndoInfo;
import com.tssap.selena.model.impl.undo.providers.resource.IFileInfo;
import com.tssap.selena.model.impl.undo.providers.resource.IFileStateNotFoundResolver;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoMarker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FolderUndoInfo
extends AbstractResourceUndoInfo
implements IFileInfo {
    private HashMap myChildFolders;
    private HashMap myChildFiles;

    public FolderUndoInfo(IUndoMarker undoMarker, IResourceDelta fileDelta, long updateStarted) {
        super(undoMarker, fileDelta, updateStarted);
        this.dispatchSubDeltas(fileDelta);
    }

    public IWorkspaceRunnable getRestoreCommand() {
        final LinkedList commandsList = new LinkedList();
        Object object = AbstractResourceUndoInfo.ourLock;
        synchronized (object) {
            commandsList.addAll(this.getRestoreFolderStructureCommands());
            commandsList.addAll(this.getRestoreFilesCommands());
        }
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator commands = commandsList.iterator();
                while (commands.hasNext()) {
                    ((IWorkspaceRunnable)commands.next()).run(monitor);
                }
            }
        };
    }

    protected void dispatchSubDeltas(IResourceDelta delta) {
        Iterator<IResourceDelta> subDeltas = Arrays.asList(delta.getAffectedChildren()).iterator();
        while (subDeltas.hasNext()) {
            IResourceDelta subDelta = subDeltas.next();
            IResource subResource = subDelta.getResource();
            if (subResource == null) continue;
            switch (subResource.getType()) {
                case 2: {
                    this.addSubFolderDelta(subDelta);
                    break;
                }
                case 1: {
                    this.addSubFileDelta(subDelta);
                    break;
                }
                default: {
                    System.err.println("Modified resource :" + subResource + " with unknown type: " + subResource.getType());
                }
            }
        }
    }

    public void acceptNextModification(IResourceDelta nextDelta) {
        this.checkNextDelta(nextDelta);
        this.processNextDeltaKind(nextDelta);
        this.dispatchSubDeltas(nextDelta);
    }

    public boolean canUndo() {
        Object object = AbstractResourceUndoInfo.ourLock;
        synchronized (object) {
            Iterator selfFiles = this.getFilesIterator();
            while (selfFiles.hasNext()) {
                IFileInfo next = (IFileInfo)selfFiles.next();
                if (next.canUndo()) continue;
                boolean bl = false;
                return bl;
            }
            Iterator subFolders = this.getSubFoldersIterator();
            while (subFolders.hasNext()) {
                FolderUndoInfo next = (FolderUndoInfo)subFolders.next();
                if (next.canUndo()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private Iterator getFilesIterator() {
        return this.myChildFiles == null ? Collections.EMPTY_LIST.iterator() : this.myChildFiles.values().iterator();
    }

    private Iterator getSubFoldersIterator() {
        return this.myChildFolders == null ? Collections.EMPTY_LIST.iterator() : this.myChildFolders.values().iterator();
    }

    private List getRestoreFolderStructureCommands() {
        LinkedList<IWorkspaceRunnable> result = new LinkedList<IWorkspaceRunnable>();
        IWorkspaceRunnable selfRestoreCommand = this.getSelfRestoreCommand();
        if (selfRestoreCommand != null) {
            result.add(selfRestoreCommand);
        }
        if (!this.isNew()) {
            Iterator subFolderInfos = this.getSubFoldersIterator();
            while (subFolderInfos.hasNext()) {
                FolderUndoInfo next = (FolderUndoInfo)subFolderInfos.next();
                result.addAll(next.getRestoreFolderStructureCommands());
            }
        }
        return result;
    }

    private List getRestoreFilesCommands() {
        if (this.isNew()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IWorkspaceRunnable> result = new LinkedList<IWorkspaceRunnable>();
        Iterator selfFiles = this.getFilesIterator();
        while (selfFiles.hasNext()) {
            IFileInfo next = (IFileInfo)selfFiles.next();
            result.add(next.getRestoreCommand());
        }
        Iterator subFolders = this.getSubFoldersIterator();
        while (subFolders.hasNext()) {
            FolderUndoInfo next = (FolderUndoInfo)subFolders.next();
            result.addAll(next.getRestoreFilesCommands());
        }
        return result;
    }

    protected IWorkspaceRunnable getSelfRestoreCommand() {
        if (this.isNew()) {
            return new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFolder folderToDelete = AbstractResourceUndoInfo.getWorkspace().getRoot().getFolder(FolderUndoInfo.this.getFullPath());
                    if (folderToDelete != null && folderToDelete.exists()) {
                        folderToDelete.delete(3, null);
                    }
                }
            };
        }
        if (this.isDeleted()) {
            return new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFolder folderToCreate = AbstractResourceUndoInfo.getWorkspace().getRoot().getFolder(FolderUndoInfo.this.getFullPath());
                    if (folderToCreate != null && !folderToCreate.exists()) {
                        folderToCreate.create(true, true, monitor);
                    }
                }
            };
        }
        return null;
    }

    protected void addSubFolderDelta(IResourceDelta subDelta) {
        FolderUndoInfo childInfo;
        IResource resource = subDelta.getResource();
        if (resource != null && resource.isDerived()) {
            return;
        }
        if (this.myChildFolders == null) {
            this.myChildFolders = new HashMap(5);
        }
        if ((childInfo = (FolderUndoInfo)this.myChildFolders.get(subDelta.getFullPath())) == null) {
            childInfo = new FolderUndoInfo(this.getUndoMarker(), subDelta, this.activationTime());
            this.myChildFolders.put(subDelta.getFullPath(), childInfo);
        } else {
            childInfo.acceptNextModification(subDelta);
        }
    }

    protected void addSubFileDelta(IResourceDelta subDelta) {
        FileUndoInfo childInfo;
        IResource resource = subDelta.getResource();
        if (resource != null && resource.isDerived()) {
            return;
        }
        if (AbstractResourceUndoInfo.isChanged(subDelta.getKind()) && (subDelta.getFlags() & 0x100) == 0) {
            return;
        }
        if (this.myChildFiles == null) {
            this.myChildFiles = new HashMap(5);
        }
        if ((childInfo = (FileUndoInfo)this.myChildFiles.get(subDelta.getFullPath())) == null) {
            try {
                childInfo = new FileUndoInfo(this.getUndoMarker(), subDelta, this.activationTime());
                this.myChildFiles.put(subDelta.getFullPath(), childInfo);
            }
            catch (FileStateNotFoundException notFound) {
                boolean recoverable;
                IFileStateNotFoundResolver resolver = this.getUndoMarker().getFileTracker().getFileStateProblemResolver();
                boolean bl = recoverable = resolver != null && resolver.isProblemRecoverable(notFound);
                if (!recoverable) {
                    System.err.println("can not find state for file: " + notFound.getFullPath());
                    System.err.println("Now not undoable");
                    this.getUndoMarker().setNotUndoable();
                }
            }
        } else {
            childInfo.acceptNextModification(subDelta);
        }
    }
}

