/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.impl.undo.providers.resource.FileStateNotFoundException;
import com.tssap.selena.model.impl.undo.providers.resource.IFileInfo;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoMarker;
import com.tssap.selena.model.impl.undo.providers.resource.WhatToDo;
import com.tssap.selena.model.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FileUndoInfo
implements IFileInfo {
    private IUndoMarker myUndoMarker;
    private long myResourceUpdateStarted;
    private int myKind;
    private IPath myFullPath;
    private IFileState myRestorableState;

    public FileUndoInfo(IUndoMarker undoMarker, IResourceDelta fileDelta, long updateStarted) throws FileStateNotFoundException {
        this.myUndoMarker = undoMarker;
        this.myKind = fileDelta.getKind();
        this.myFullPath = fileDelta.getFullPath();
        this.myResourceUpdateStarted = updateStarted;
        this.myRestorableState = !this.isNew() ? this.initRestoreableState(fileDelta) : null;
    }

    public boolean canUndo() {
        if (this.isNew()) {
            return true;
        }
        return this.myRestorableState != null && this.myRestorableState.exists();
    }

    public IWorkspaceRunnable getRestoreCommand() {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                block8: {
                    IFile file;
                    block10: {
                        block9: {
                            file = ResourcesPlugin.getWorkspace().getRoot().getFile(FileUndoInfo.this.myFullPath.makeRelative());
                            FileUndoInfo.check(file != null);
                            if (!FileUndoInfo.this.isChanged()) break block9;
                            FileUndoInfo.check(file.exists());
                            FileUndoInfo.check(FileUndoInfo.this.myRestorableState != null);
                            FileUndoInfo.check(FileUndoInfo.this.myRestorableState.exists());
                            file.setContents(FileUndoInfo.this.myRestorableState, true, true, monitor);
                            break block8;
                        }
                        if (!FileUndoInfo.this.isDeleted()) break block10;
                        FileUndoInfo.check(!file.exists());
                        FileUndoInfo.check(FileUndoInfo.this.myRestorableState != null);
                        FileUndoInfo.check(FileUndoInfo.this.myRestorableState.exists());
                        InputStream contentsToRestore = null;
                        try {
                            contentsToRestore = FileUndoInfo.this.myRestorableState.getContents();
                            file.create(contentsToRestore, true, monitor);
                            Object var5_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            try {
                                if (contentsToRestore != null) {
                                    contentsToRestore.close();
                                }
                            }
                            catch (IOException cantCloseStream) {
                                cantCloseStream.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            if (contentsToRestore != null) {
                                contentsToRestore.close();
                            }
                            break block8;
                        }
                        catch (IOException cantCloseStream) {
                            cantCloseStream.printStackTrace();
                        }
                        break block8;
                    }
                    if (FileUndoInfo.this.isNew()) {
                        FileUndoInfo.check(file.exists());
                        file.delete(3, monitor);
                    }
                }
            }
        };
    }

    private static void check(boolean test) {
        if (!test) {
            WhatToDo.problem("fail here should provoke attempt to restore before state");
        }
        Assert.isLegal((boolean)test);
    }

    public void acceptNextModification(IResourceDelta nextDelta) {
        this.checkNextDelta(nextDelta);
        if (FileUndoInfo.isChanged(nextDelta.getKind())) {
            return;
        }
        if (FileUndoInfo.isDeleted(nextDelta.getKind()) && this.isNew()) {
            this.myKind = 4;
            return;
        }
        if (FileUndoInfo.isNew(nextDelta.getKind()) && this.isDeleted()) {
            this.myKind = 4;
            return;
        }
        this.myKind = nextDelta.getKind();
    }

    public IUndoMarker getUndoMarker() {
        return this.myUndoMarker;
    }

    public long activationTime() {
        return this.myResourceUpdateStarted;
    }

    public boolean isNew() {
        return FileUndoInfo.isNew(this.myKind);
    }

    public boolean isChanged() {
        return FileUndoInfo.isChanged(this.myKind);
    }

    public boolean isDeleted() {
        return FileUndoInfo.isDeleted(this.myKind);
    }

    public IPath getFullPath() {
        return this.myFullPath;
    }

    private IFileState initRestoreableState(IResourceDelta delta) throws FileStateNotFoundException {
        IPath path = delta.getFullPath();
        try {
            IFile file = (IFile)delta.getResource();
            IFileState[] states = file.getHistory((IProgressMonitor)new NullProgressMonitor());
            if (states == null) {
                throw new FileStateNotFoundException(path);
            }
            IFileState result = null;
            int i = 0;
            while (i < states.length) {
                result = states[i];
                if (result.getModificationTime() < this.getUndoMarker().getMarkerTime()) break;
                ++i;
            }
            if (result == null) {
                throw new FileStateNotFoundException(path);
            }
            return result;
        }
        catch (CoreException historyNotAvailable) {
            historyNotAvailable.printStackTrace();
            throw new FileStateNotFoundException(path);
        }
    }

    private void checkNextDelta(IResourceDelta nextDelta) {
        Assert.isLegal((boolean)this.getFullPath().equals((Object)nextDelta.getFullPath()));
    }

    private static boolean isNew(int deltaKind) {
        return (deltaKind & 1) > 0;
    }

    private static boolean isDeleted(int deltaKind) {
        return (deltaKind & 2) > 0;
    }

    private static boolean isChanged(int deltaKind) {
        return (deltaKind & 4) > 0;
    }
}

