/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.impl.undo.providers.resource.DefaultFileStateResolver;
import com.tssap.selena.model.impl.undo.providers.resource.IFileStateNotFoundResolver;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoFileTracker;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoMarker;
import com.tssap.selena.model.impl.undo.providers.resource.UndoMarkerImplExt;
import com.tssap.selena.model.impl.undo.providers.resource.UndoResourceListener;
import com.tssap.selena.model.undo.providers.UndoCommand;
import com.tssap.selena.model.undo.providers.UndoFailedException;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FileTrackerImpl
implements IUndoFileTracker {
    final Object ACTIVE_MARKER_LOCK = new Integer(17);
    private boolean myIsShutDowned;
    private HashMap myMarkers;
    private IUndoMarker myActiveMarker;
    private IFileStateNotFoundResolver myFileStateNotFoundResolver;
    private UndoResourceListener myResourceListener;
    private static final UndoCommand EMPTY_COMMAND = new UndoCommand(){

        public void run() throws UndoFailedException {
        }
    };

    public FileTrackerImpl() {
        this.setFileStateProblemResolver(DefaultFileStateResolver.getInstance());
        this.myMarkers = new HashMap(10);
        this.myResourceListener = new UndoResourceListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.myResourceListener);
    }

    public void shutDown() {
        this.myMarkers = null;
        Object object = this.ACTIVE_MARKER_LOCK;
        synchronized (object) {
            this.myActiveMarker = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.myResourceListener);
        this.myResourceListener = null;
        this.setFileStateProblemResolver(null);
        this.myIsShutDowned = true;
    }

    public void handleFailure(UndoFailedException exception) throws UndoFailedException {
        throw exception;
    }

    public IUndoMarker getActiveUndoMarker() {
        Object object = this.ACTIVE_MARKER_LOCK;
        synchronized (object) {
            IUndoMarker iUndoMarker = this.myActiveMarker;
            return iUndoMarker;
        }
    }

    public void flushUndoMarker(long markerTime) {
        if (this.isShutDowned()) {
            return;
        }
        HashMap hashMap = this.myMarkers;
        synchronized (hashMap) {
            this.myMarkers.remove(new Long(markerTime));
        }
    }

    public boolean canUndo(long markerTime) {
        if (this.isShutDowned()) {
            return true;
        }
        IUndoMarker marker = (IUndoMarker)this.myMarkers.get(new Long(markerTime));
        if (marker == null) {
            return false;
        }
        return marker.canUndo();
    }

    public boolean isChangedSinceMarker(long markerTime) {
        if (this.isShutDowned()) {
            return false;
        }
        if (this.getActiveUndoMarker() != this.myMarkers.get(new Long(markerTime))) {
            return true;
        }
        if (this.getActiveUndoMarker() == null) {
            return false;
        }
        return !this.getActiveUndoMarker().isEmpty();
    }

    public void setUndoMarker(long markerTime) {
        if (this.isShutDowned()) {
            return;
        }
        UndoMarkerImplExt newMarker = new UndoMarkerImplExt(this, markerTime);
        this.myMarkers.put(new Long(markerTime), newMarker);
        Object object = this.ACTIVE_MARKER_LOCK;
        synchronized (object) {
            this.myActiveMarker = newMarker;
        }
    }

    public UndoCommand getUndoCommand(final long markerTime) {
        if (this.isShutDowned()) {
            return EMPTY_COMMAND;
        }
        Assert.isLegal((boolean)this.canUndo(markerTime));
        final IUndoMarker markerToRestore = (IUndoMarker)this.myMarkers.get(new Long(markerTime));
        return new UndoCommand(){

            public void run() throws UndoFailedException {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IWorkspaceRunnable command = 2.access$000(this.this$1).getRestoreCommand();
                            if (command != null) {
                                command.run(monitor);
                            }
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    throw new UndoFailedException(markerTime, FileTrackerImpl.this, e);
                }
            }

            static /* synthetic */ IUndoMarker access$000(2 x0) {
                return x0.markerToRestore;
            }
        };
    }

    public IFileStateNotFoundResolver getFileStateProblemResolver() {
        return this.myFileStateNotFoundResolver;
    }

    public void setFileStateProblemResolver(IFileStateNotFoundResolver resolver) {
        this.myFileStateNotFoundResolver = resolver;
    }

    private boolean isShutDowned() {
        return this.myIsShutDowned;
    }
}

