/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.impl.undo.providers.resource;

import com.tssap.selena.model.impl.undo.providers.resource.IFileInfo;
import com.tssap.selena.model.impl.undo.providers.resource.IUndoMarker;
import com.tssap.selena.model.util.Assert;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractResourceUndoInfo
implements IFileInfo {
    protected static final Object ourLock = new Integer(1);
    private IUndoMarker myUndoMarker;
    private long myResourceUpdateStarted;
    private int myKind;
    private IPath myFullPath;

    public AbstractResourceUndoInfo(IUndoMarker undoMarker, IResourceDelta fileDelta, long updateStarted) {
        this.myUndoMarker = undoMarker;
        this.myKind = fileDelta.getKind();
        this.myFullPath = fileDelta.getFullPath();
        this.myResourceUpdateStarted = updateStarted;
    }

    public abstract boolean canUndo();

    public abstract void acceptNextModification(IResourceDelta var1);

    public final IUndoMarker getUndoMarker() {
        return this.myUndoMarker;
    }

    public final long activationTime() {
        return this.myResourceUpdateStarted;
    }

    public final boolean isNew() {
        return AbstractResourceUndoInfo.isNew(this.myKind);
    }

    public final boolean isChanged() {
        return AbstractResourceUndoInfo.isChanged(this.myKind);
    }

    public final boolean isDeleted() {
        return AbstractResourceUndoInfo.isDeleted(this.myKind);
    }

    public final IPath getFullPath() {
        return this.myFullPath;
    }

    protected final void processNextDeltaKind(IResourceDelta nextDelta) {
        this.checkNextDelta(nextDelta);
        if (AbstractResourceUndoInfo.isChanged(nextDelta.getKind())) {
            return;
        }
        if (AbstractResourceUndoInfo.isDeleted(nextDelta.getKind()) && this.isNew()) {
            this.myKind = 4;
            return;
        }
        if (AbstractResourceUndoInfo.isNew(nextDelta.getKind()) && this.isDeleted()) {
            this.myKind = 4;
            return;
        }
        this.myKind = nextDelta.getKind();
    }

    protected final void checkNextDelta(IResourceDelta nextDelta) {
        Assert.isLegal((boolean)this.getFullPath().equals((Object)nextDelta.getFullPath()), (String)("marker for path: " + this.getFullPath() + " \n\t can not accept delta for path: " + nextDelta.getFullPath()));
    }

    protected static boolean isNew(int deltaKind) {
        return (deltaKind & 1) > 0;
    }

    protected static boolean isDeleted(int deltaKind) {
        return (deltaKind & 2) > 0;
    }

    protected static boolean isChanged(int deltaKind) {
        return (deltaKind & 4) > 0;
    }

    protected static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public abstract IWorkspaceRunnable getRestoreCommand();
}

