/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.catalog.Column;
import com.sap.sql.tablebuffer.BufferHostVars;
import com.sap.sql.tablebuffer.LikePredicateEvaluator;
import com.sap.sql.tablebuffer.TableBufferException;
import com.sap.sql.tablebuffer.TableBufferRTIllegalArgumentException;
import com.sap.sql.tablebuffer.TableBufferRTUnsupportedOperationException;
import com.sap.sql.tablebuffer.TypeConverter;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BigDecimalLiteral;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.DefaultValue;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.FloatLiteral;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.IntegerLiteral;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.Literal;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.NullValue;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.ValueExpression;
import com.sap.sql.types.CommonTypes;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SearchConditionEvaluator {
    protected SearchCondition sc = null;
    protected BufferHostVars hvv = null;
    protected BufferRecord bufferRecord = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public SearchConditionEvaluator(SearchCondition sc, BufferHostVars hostVariableValues) {
        this.sc = sc;
        this.hvv = hostVariableValues;
    }

    public boolean verify(BufferRecord bufferRecord) throws SQLException {
        this.bufferRecord = bufferRecord;
        Boolean result = this.evaluate(this.sc);
        return result == null ? false : result;
    }

    protected Boolean evaluate(SearchCondition node) throws SQLException {
        if (node instanceof ComparisonPredicate) {
            return this.doComparisonPredicate(node);
        }
        if (node instanceof BooleanAnd) {
            Boolean returnValue = Boolean.TRUE;
            SearchCondition[] operands = ((BooleanAnd)node).getOperands();
            int op_i = 0;
            while (op_i < operands.length) {
                Boolean result = this.evaluate(operands[op_i]);
                if (Boolean.FALSE == result) {
                    return Boolean.FALSE;
                }
                if (null == result) {
                    returnValue = null;
                }
                ++op_i;
            }
            return returnValue;
        }
        if (node instanceof BooleanOr) {
            Boolean returnValue = Boolean.FALSE;
            SearchCondition[] operands = ((BooleanOr)node).getOperands();
            int op_i = 0;
            while (op_i < operands.length) {
                Boolean result = this.evaluate(operands[op_i]);
                if (Boolean.TRUE == result) {
                    return Boolean.TRUE;
                }
                if (null == result) {
                    returnValue = null;
                }
                ++op_i;
            }
            return returnValue;
        }
        if (node instanceof BooleanNot) {
            Boolean result = this.evaluate(((BooleanNot)node).getOperand());
            if (Boolean.TRUE == result) {
                return Boolean.FALSE;
            }
            if (Boolean.FALSE == result) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (node instanceof LikePredicate) {
            return this.doLikePredicate(node);
        }
        if (node instanceof BetweenPredicate) {
            return this.doBetweenPredicate(node);
        }
        if (node instanceof InListPredicate) {
            return this.doInListPredicate(node);
        }
        if (node instanceof NullPredicate) {
            return this.doNullPredicate(node);
        }
        if (node instanceof InSubqueryPredicate) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "node", String.valueOf(node.getClass()));
        }
        if (node instanceof ExistsPredicate) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "node", String.valueOf(node.getClass()));
        }
        if (node instanceof QuantifiedComparisonPredicate) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "node", String.valueOf(node.getClass()));
        }
        throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "node", null != node ? node.getClass().toString() : "null");
    }

    private Boolean doNullPredicate(SearchCondition node) throws SQLException {
        ValueExpression value = ((NullPredicate)node).getValue();
        boolean isNotNullFlag = ((NullPredicate)node).isNotNull();
        Object val = this.getValue((RowValue)value, null);
        return null != val == isNotNullFlag ? Boolean.TRUE : Boolean.FALSE;
    }

    private Boolean doInListPredicate(SearchCondition node) throws SQLException {
        Boolean returnValue = Boolean.TRUE;
        ValueExpression value = ((InListPredicate)node).getValue();
        ValueExpression[] vlist = ((InListPredicate)node).getValueList();
        boolean isNotIn = ((InListPredicate)node).isNotIn();
        ResultDescriptor rd = value.getResultDescriptor();
        int index = 0;
        while (index < vlist.length) {
            ResultDescriptor vrd = vlist[index].getResultDescriptor();
            int resJDBCType = this.getJDBCType(rd, vrd);
            Class resJavaClass = CommonTypes.defaultMapping((int)resJDBCType);
            if (resJavaClass == null) {
                throw TableBufferRTUnsupportedOperationException.getAndLog(this.getClass(), "ResultDescriptor.defaultMapping(resJDBCType) = null");
            }
            Comparable vlistValue = (Comparable)this.getValue((RowValue)vlist[index], resJavaClass);
            Comparable val = (Comparable)this.getValue((RowValue)value, resJavaClass);
            if (null == val) {
                return null;
            }
            if (null == vlistValue) {
                returnValue = null;
            } else if (0 == val.compareTo(vlistValue)) {
                return isNotIn ? Boolean.FALSE : Boolean.TRUE;
            }
            ++index;
        }
        return returnValue;
    }

    private Boolean doBetweenPredicate(SearchCondition node) throws SQLException {
        ResultDescriptor rd;
        ResultDescriptor lrd;
        ResultDescriptor hrd;
        RowValue hrv = ((BetweenPredicate)node).getHighValue();
        RowValue lrv = ((BetweenPredicate)node).getLowValue();
        RowValue rv = ((BetweenPredicate)node).getValue();
        Boolean isNotBetween = ((BetweenPredicate)node).isNotBetween() ? Boolean.TRUE : Boolean.FALSE;
        try {
            hrd = ((RowValueElement)hrv).getResultDescriptor();
            lrd = ((RowValueElement)lrv).getResultDescriptor();
            rd = ((RowValueElement)rv).getResultDescriptor();
        }
        catch (ClassCastException e) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "node.get[High,Low]Value()", "RowValueElementList");
        }
        int resJDBCType = this.getJDBCType(lrd, rd);
        Class resJavaClass = CommonTypes.defaultMapping((int)resJDBCType);
        if (resJavaClass == null) {
            throw TableBufferRTUnsupportedOperationException.getAndLog(this.getClass(), "ResultDescriptor.defaultMapping(resJDBCType) = null");
        }
        Comparable lowValue = (Comparable)this.getValue(lrv, resJavaClass);
        Comparable value = (Comparable)this.getValue(rv, resJavaClass);
        if (null == lowValue || null == value) {
            return null;
        }
        int res = lowValue.compareTo(value);
        if (res > 0) {
            return isNotBetween;
        }
        resJDBCType = this.getJDBCType(rd, hrd);
        resJavaClass = CommonTypes.defaultMapping((int)resJDBCType);
        Comparable highValue = (Comparable)this.getValue(hrv, resJavaClass);
        if (null == highValue) {
            return null;
        }
        res = value.compareTo(highValue);
        if (res > 0) {
            return isNotBetween;
        }
        return isNotBetween == Boolean.FALSE ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean doLikePredicate(SearchCondition node) throws SQLException {
        ValueExpression escape = ((LikePredicate)node).getEscapeValue();
        ValueExpression pattern = ((LikePredicate)node).getPatternValue();
        ValueExpression matchValue = ((LikePredicate)node).getMatchValue();
        boolean isNotLikeFlag = ((LikePredicate)node).isNotLike();
        Character escapeChar = null;
        if (escape != null) {
            escapeChar = new Character(((String)this.getValue((RowValue)escape, class$java$lang$String == null ? (class$java$lang$String = SearchConditionEvaluator.class$("java.lang.String")) : class$java$lang$String)).charAt(0));
        }
        String matchString = (String)this.getValue((RowValue)matchValue, class$java$lang$String == null ? (class$java$lang$String = SearchConditionEvaluator.class$("java.lang.String")) : class$java$lang$String);
        String patternString = (String)this.getValue((RowValue)pattern, class$java$lang$String == null ? (class$java$lang$String = SearchConditionEvaluator.class$("java.lang.String")) : class$java$lang$String);
        if (null == matchString || null == patternString) {
            return null;
        }
        boolean eval = LikePredicateEvaluator.match(patternString, matchString, escapeChar);
        return isNotLikeFlag != eval ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean doComparisonPredicate(SearchCondition node) throws SQLException {
        Boolean returnValue;
        ResultDescriptor rrd;
        RowValue lo = ((ComparisonPredicate)node).getLeftOperand();
        RowValue ro = ((ComparisonPredicate)node).getRightOperand();
        ResultDescriptor lrd = ((RowValueElement)lo).getResultDescriptor();
        int resJDBCType = this.getJDBCType(lrd, rrd = ((RowValueElement)ro).getResultDescriptor());
        Class resJavaClass = CommonTypes.defaultMapping((int)resJDBCType);
        if (resJavaClass == null) {
            throw TableBufferRTUnsupportedOperationException.getAndLog(this.getClass(), "ResultDescriptor.defaultMapping(resJDBCType) = null");
        }
        Object leftValue = this.getValue(lo, resJavaClass);
        Object rightValue = this.getValue(ro, resJavaClass);
        if (null == leftValue || null == rightValue) {
            return null;
        }
        int res = 0;
        if (leftValue instanceof Comparable) {
            res = ((Comparable)leftValue).compareTo(rightValue);
        } else if (leftValue instanceof byte[] && rightValue instanceof byte[]) {
            res = this.compareByteArray((byte[])leftValue, (byte[])rightValue);
        } else {
            throw TableBufferRTUnsupportedOperationException.getAndLog(this.getClass(), "doComparisonPredicate 1: " + lrd.getJdbcTypeName() + ", " + "2: " + rrd.getJdbcTypeName());
        }
        switch (((ComparisonPredicate)node).getOperator()) {
            case 1: {
                returnValue = res == 0 ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 2: {
                returnValue = res == 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 4: {
                returnValue = res > 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 3: {
                returnValue = res < 0 ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 6: {
                returnValue = res < 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 5: {
                returnValue = res > 0 ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            default: {
                returnValue = Boolean.FALSE;
            }
        }
        return returnValue;
    }

    private int compareByteArray(byte[] leftArray, byte[] rightArray) {
        if (leftArray.length != rightArray.length) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "leftArray, rightArray", "byte[" + leftArray.length + "], " + "byte[" + rightArray.length + "]");
        }
        int i = 0;
        while (i < leftArray.length) {
            int result = leftArray[i] - rightArray[i];
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    protected int getJDBCType(ResultDescriptor lrd, ResultDescriptor rrd) throws TableBufferException {
        int resJDBCType;
        if (lrd.isCharacterLike() && rrd.isCharacterLike()) {
            resJDBCType = lrd.getJdbcType();
        } else if (lrd.isNumeric && rrd.isNumeric) {
            int lJDBCType = lrd.getJdbcType();
            int rJDBCType = rrd.getJdbcType();
            resJDBCType = CommonTypes.jdbcTypeArithmeticExpression((int)lJDBCType, (int)rJDBCType);
        } else if (lrd.getJdbcType() == rrd.getJdbcType()) {
            resJDBCType = lrd.getJdbcType();
        } else {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "lrd.getJdbcTypeName(), rrd.getJdbcTypeName()", lrd.getJdbcTypeName() + ", " + rrd.getJdbcTypeName());
        }
        return resJDBCType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getValue(RowValue rowValue, Class javaClass) throws SQLException {
        Object value = null;
        if (rowValue instanceof HostVariable) {
            int pos = ((HostVariable)rowValue).getPosition();
            value = this.hvv.get(pos, javaClass);
            return TypeConverter.convert(value, javaClass);
        } else if (rowValue instanceof ColumnReference) {
            ResultDescriptor rd = ((ColumnReference)rowValue).getResultDescriptor();
            int index = rd.getColumnIndex();
            value = this.bufferRecord.getValue(index);
            return TypeConverter.convert(value, javaClass);
        } else if (rowValue instanceof Literal) {
            if (rowValue instanceof StringLiteral) {
                value = ((StringLiteral)rowValue).getValue();
                return TypeConverter.convert(value, javaClass);
            } else if (rowValue instanceof IntegerLiteral) {
                value = ((IntegerLiteral)rowValue).getValue();
                return TypeConverter.convert(value, javaClass);
            } else if (rowValue instanceof FloatLiteral) {
                value = new Float(((FloatLiteral)rowValue).getValue());
                return TypeConverter.convert(value, javaClass);
            } else {
                if (!(rowValue instanceof BigDecimalLiteral)) throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
                value = ((BigDecimalLiteral)rowValue).getValue();
            }
            return TypeConverter.convert(value, javaClass);
        } else if (rowValue instanceof ArithmeticExpression) {
            value = this.doArithmeticExpression((ArithmeticExpression)rowValue, javaClass);
            return TypeConverter.convert(value, javaClass);
        } else {
            if (rowValue instanceof NullValue) {
                return null;
            }
            if (rowValue instanceof DefaultValue) {
                Column col = ((ColumnReference)rowValue).getColumnDescriptor();
                return col.getDefault();
            }
            if (rowValue instanceof CountAll) {
                throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
            }
            if (rowValue instanceof Query) {
                throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
            }
            if (rowValue instanceof SetFunction) {
                throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
            }
            if (rowValue instanceof TableValue) {
                throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
            }
            if (rowValue != null) throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "rowValue", String.valueOf(rowValue.getClass()));
        }
    }

    Object doArithmeticExpression(ArithmeticExpression arithmExpression, Class javaClass) throws SQLException {
        Object lv;
        ValueExpression lo = arithmExpression.getLeftOperand();
        ValueExpression ro = arithmExpression.getRightOperand();
        Object rv = this.getValue((RowValue)ro, javaClass);
        if (null == rv) {
            return null;
        }
        int op = arithmExpression.getOperator();
        if (null == lo) {
            switch (op) {
                case 1: {
                    return ro;
                }
                case 2: {
                    if (javaClass.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = SearchConditionEvaluator.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(javaClass)) {
                        return new Short(-((Short)rv).shortValue());
                    }
                    if (javaClass.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = SearchConditionEvaluator.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(javaClass)) {
                        return new Integer(-((Integer)rv).intValue());
                    }
                    if (javaClass.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = SearchConditionEvaluator.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(javaClass)) {
                        return new Long(-((Long)rv).longValue());
                    }
                    if (javaClass.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = SearchConditionEvaluator.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(javaClass)) {
                        return new Float(-((Float)rv).floatValue());
                    }
                    if (javaClass.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = SearchConditionEvaluator.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(javaClass)) {
                        return new Double(-((Double)rv).doubleValue());
                    }
                    if (!(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SearchConditionEvaluator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass)) break;
                    return ((BigDecimal)rv).negate();
                }
                case 3: {
                    throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "arithmExpression", "arithmExpression.getOperator() = " + String.valueOf(arithmExpression.getOperator() + " and left operand is null"));
                }
                case 4: {
                    throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "arithmExpression", "arithmExpression.getOperator() = " + String.valueOf(arithmExpression.getOperator() + " and left operand is null"));
                }
            }
        }
        if (null == (lv = this.getValue((RowValue)lo, javaClass))) {
            return null;
        }
        switch (op) {
            case 1: {
                if (javaClass.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = SearchConditionEvaluator.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(javaClass)) {
                    return new Short((short)((Short)lv + (Short)rv));
                }
                if (javaClass.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = SearchConditionEvaluator.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(javaClass)) {
                    return new Integer((Integer)lv + (Integer)rv);
                }
                if (javaClass.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = SearchConditionEvaluator.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(javaClass)) {
                    return new Long((Long)lv + (Long)rv);
                }
                if (javaClass.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = SearchConditionEvaluator.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(javaClass)) {
                    return new Float(((Float)lv).floatValue() + ((Float)rv).floatValue());
                }
                if (javaClass.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = SearchConditionEvaluator.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(javaClass)) {
                    return new Double((Double)lv + (Double)rv);
                }
                if (!(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SearchConditionEvaluator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass)) break;
                return ((BigDecimal)lv).add((BigDecimal)rv);
            }
            case 2: {
                if (javaClass.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = SearchConditionEvaluator.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(javaClass)) {
                    return new Short((short)((Short)lv - (Short)rv));
                }
                if (javaClass.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = SearchConditionEvaluator.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(javaClass)) {
                    return new Integer((Integer)lv - (Integer)rv);
                }
                if (javaClass.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = SearchConditionEvaluator.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(javaClass)) {
                    return new Long((Long)lv - (Long)rv);
                }
                if (javaClass.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = SearchConditionEvaluator.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(javaClass)) {
                    return new Float(((Float)lv).floatValue() - ((Float)rv).floatValue());
                }
                if (javaClass.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = SearchConditionEvaluator.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(javaClass)) {
                    return new Double((Double)lv - (Double)rv);
                }
                if (!(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SearchConditionEvaluator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass)) break;
                return ((BigDecimal)lv).subtract((BigDecimal)rv);
            }
            case 3: {
                if (javaClass.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = SearchConditionEvaluator.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(javaClass)) {
                    return new Short((short)((Short)lv * (Short)rv));
                }
                if (javaClass.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = SearchConditionEvaluator.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(javaClass)) {
                    return new Integer((Integer)lv * (Integer)rv);
                }
                if (javaClass.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = SearchConditionEvaluator.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(javaClass)) {
                    return new Long((Long)lv * (Long)rv);
                }
                if (javaClass.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = SearchConditionEvaluator.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(javaClass)) {
                    return new Float(((Float)lv).floatValue() * ((Float)rv).floatValue());
                }
                if (javaClass.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = SearchConditionEvaluator.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(javaClass)) {
                    return new Double((Double)lv * (Double)rv);
                }
                if (!(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SearchConditionEvaluator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass)) break;
                return ((BigDecimal)lv).multiply((BigDecimal)rv);
            }
            case 4: {
                if (javaClass.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = SearchConditionEvaluator.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(javaClass)) {
                    return new Short((short)((Short)lv / (Short)rv));
                }
                if (javaClass.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = SearchConditionEvaluator.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(javaClass)) {
                    return new Integer((Integer)lv / (Integer)rv);
                }
                if (javaClass.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = SearchConditionEvaluator.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(javaClass)) {
                    return new Long((Long)lv / (Long)rv);
                }
                if (javaClass.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = SearchConditionEvaluator.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(javaClass)) {
                    return new Float(((Float)lv).floatValue() / ((Float)rv).floatValue());
                }
                if (javaClass.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = SearchConditionEvaluator.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(javaClass)) {
                    return new Double((Double)lv / (Double)rv);
                }
                if (!(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SearchConditionEvaluator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass)) break;
                int scale = ((BigDecimal)lv).scale() + ((BigDecimal)rv).scale();
                return ((BigDecimal)lv).divide((BigDecimal)rv, scale, 5);
            }
        }
        throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "arithmExpression", "arithmExpression.getOperator() = " + String.valueOf(arithmExpression.getOperator()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

