/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncRecordInputStream;
import com.sap.sql.sync.Synchronizer;
import com.sap.sql.tablebuffer.BufferSyncRecord;
import java.sql.SQLException;

public class BufferSynchronizer
implements Synchronizer {
    private BufferAccess access;

    public BufferSynchronizer(BufferAccess access) {
        this.access = access;
    }

    public void synchronize(SyncRecordInputStream sris) {
        String tableName = null;
        try {
            BufferSyncRecord syncRecord = BufferSyncRecord.readSyncRecord(sris, this.access);
            tableName = syncRecord.getTableName();
            switch (syncRecord.getAction()) {
                case 1: {
                    this.access.invalidateObject(null, tableName, syncRecord.getBufferKey());
                    break;
                }
                case 2: {
                    this.access.removeObject(tableName);
                }
            }
        }
        catch (SQLException ex) {
            Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql_0011", (Object[])new Object[0], (Throwable)ex);
        }
    }
}

