/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.tablebuffer.TableBufferException;
import com.sap.sql.tablebuffer.TableBufferGetObjectException;
import com.sap.sql.tablebuffer.TableBufferRTIndexOutOfBoundsException;
import com.sap.sql.tablebuffer.TypeConverter;

public class BufferHostVars
implements Cloneable {
    private static final Object UNDEFINED = new Object();
    private Object[] objects;
    private int[] sqlType;
    private Object[] castObjects;
    private int size;

    public BufferHostVars(int size) {
        this.size = size;
        this.sqlType = new int[size];
        this.objects = new Object[size];
        this.castObjects = new Object[size];
        int i = 0;
        while (i < size) {
            this.objects[i] = UNDEFINED;
            this.castObjects[i] = UNDEFINED;
            ++i;
        }
    }

    private BufferHostVars(int size, int[] sqlType, Object[] objects, Object[] castObjects) {
        this.size = size;
        this.sqlType = sqlType;
        this.objects = objects;
        this.castObjects = castObjects;
    }

    public Object clone() {
        return new BufferHostVars(this.size, (int[])this.sqlType.clone(), (Object[])this.objects.clone(), (Object[])this.castObjects.clone());
    }

    public void set(int index, Object obj) throws TableBufferException {
        if (index < 1 || index > this.size) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.size);
        }
        this.objects[index - 1] = obj;
        this.castObjects[index - 1] = UNDEFINED;
    }

    public void setNull(int index, int sqlType) throws TableBufferException {
        if (index < 1 || index > this.size) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.size);
        }
        this.objects[index - 1] = null;
        this.castObjects[index - 1] = null;
        this.sqlType[index - 1] = sqlType;
    }

    public Object get(int index) throws TableBufferException {
        if (index < 1 || index > this.size) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.size);
        }
        if (this.objects[index - 1] == UNDEFINED) {
            throw TableBufferGetObjectException.getAndLog(this.getClass(), "com.sap.sql.tablebuffer_1201", new Object[]{new Integer(index)});
        }
        return this.objects[index - 1];
    }

    public Object get(int index, Class javaClass) throws TableBufferException {
        if (index < 1 || index > this.size) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.size);
        }
        if (this.castObjects[index - 1] == UNDEFINED) {
            this.castObjects[index - 1] = TypeConverter.convert(this.get(index), javaClass);
            return this.castObjects[index - 1];
        }
        return this.castObjects[index - 1];
    }

    public int getSqlType(int index) throws TableBufferException {
        if (index < 1 || index > this.size) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.size);
        }
        if (this.objects[index - 1] != null) {
            throw TableBufferGetObjectException.getAndLog(this.getClass(), "com.sap.sql.tablebuffer_1203", new Object[]{new Integer(index)});
        }
        return this.sqlType[index - 1];
    }

    public int indexOfUndefined() {
        int i = 0;
        while (i < this.size) {
            if (this.objects[i] == UNDEFINED) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public void remove(int index) throws TableBufferException {
        if (index < 1 || index > this.size) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.size);
        }
        this.objects[index - 1] = UNDEFINED;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            this.objects[i] = UNDEFINED;
            ++i;
        }
    }
}

