/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.sqlparser.HostVarDescriptor;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BigDecimalLiteral;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.CreateViewStatement;
import com.sap.sql.tree.DefaultValue;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.DerivedTable;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.FloatLiteral;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.IntegerLiteral;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NonJoinQuery;
import com.sap.sql.tree.NotNullableResultDescriptor;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.NullValue;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.SortSpecification;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.UpdateStatement;
import com.sap.sql.types.CommonTypes;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class CheckTypeVisitor
extends CheckVisitor {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlparser$CheckTypeVisitor == null ? (class$com$sap$sql$sqlparser$CheckTypeVisitor = CheckTypeVisitor.class$("com.sap.sql.sqlparser.CheckTypeVisitor")) : class$com$sap$sql$sqlparser$CheckTypeVisitor));
    private Stack stack = new Stack();
    private Vector debugLog = new Vector();
    private Vector inputVector = null;
    private static final int INTEGER_PRECISION = 10;
    private static final int SMALLINT_PRECISION = 5;
    private static final int DOUBLE_PRECISION = 10;
    private static final boolean debugging = true;
    private final boolean strongUnionTest = false;
    static /* synthetic */ Class class$com$sap$sql$sqlparser$CheckTypeVisitor;

    public CheckTypeVisitor(Vector errorLog, int inputSetSize) {
        super(errorLog);
        this.inputVector = new Vector(inputSetSize);
        this.inputVector.setSize(inputSetSize);
    }

    public ResultDescriptor[] getResultSetDescription() throws CommonSQLParserException {
        if (this.stack.empty()) {
            throw new CommonSQLParserException("internal error: attempt to get an empty result set");
        }
        ArrayList resultList = (ArrayList)this.stack.peek();
        ResultDescriptor[] resultSet = new ResultDescriptor[resultList.size()];
        resultList.toArray(resultSet);
        return resultSet;
    }

    public ResultDescriptor[] getInputSetDescription() {
        ResultDescriptor[] inputArray = new ResultDescriptor[this.inputVector.size()];
        this.inputVector.toArray(inputArray);
        return inputArray;
    }

    private final void logError(String text) {
        String message = CommonSQLParserErrors.msg("typeCheckError", text);
        this.errorLog.add(new LogEntry(message, 0, 0));
    }

    private final void checkFailed(String key) {
        this.logError(CommonSQLParserErrors.msg(key));
    }

    private final void checkFailed(String key, String arg1) {
        this.logError(CommonSQLParserErrors.msg(key, arg1));
    }

    private final void checkFailed(String key, String arg1, String arg2) {
        this.logError(CommonSQLParserErrors.msg(key, arg1, arg2));
    }

    private final void checkFailed(String key, String arg1, String arg2, String arg3) {
        this.logError(CommonSQLParserErrors.msg(key, arg1, arg2, arg3));
    }

    private final void checkFailed(String key, String arg1, String arg2, String arg3, String arg4) {
        this.logError(CommonSQLParserErrors.msg(key, arg1, arg2, arg3, arg4));
    }

    private final void checkFailed(String key, int columnIndexStartingWithZero) {
        int colIndex = columnIndexStartingWithZero + 1;
        this.logError(CommonSQLParserErrors.msg(key, Integer.toString(colIndex)));
    }

    private final void checkFailed(String key, int columnIndexStartingWithZero, String arg2) {
        int colIndex = columnIndexStartingWithZero + 1;
        this.logError(CommonSQLParserErrors.msg(key, Integer.toString(colIndex), arg2));
    }

    private void logDebug(String text) {
        this.debugLog.add(text);
    }

    private final ResultDescriptor getScalar() {
        Object obj = this.stack.pop();
        if (obj instanceof ArrayList) {
            ArrayList list = (ArrayList)obj;
            if (list.size() != 1) {
                this.checkFailed("typeExpectedScalar");
                return new ResultDescriptor();
            }
            return (ResultDescriptor)list.get(0);
        }
        return (ResultDescriptor)obj;
    }

    private final ArrayList getRow() {
        Object obj = this.stack.pop();
        if (obj instanceof ArrayList) {
            return (ArrayList)obj;
        }
        if (obj instanceof SQLTable) {
            return ((SQLTable)obj).getResultRow();
        }
        if (obj instanceof ResultDescriptor) {
            ArrayList result = new ArrayList(1);
            result.add(obj);
            return result;
        }
        throw new EmptyStackException();
    }

    private final boolean setHostVariable(ResultDescriptor source, ResultDescriptor result, boolean neverNullable) {
        if (source instanceof HostVarDescriptor) {
            HostVarDescriptor hostVar = (HostVarDescriptor)source;
            int index = hostVar.getPosition() - 1;
            if (index >= this.inputVector.size()) {
                this.inputVector.setSize(index + 1);
            }
            if (neverNullable) {
                result = new NotNullableResultDescriptor(result);
            }
            this.inputVector.setElementAt(result, index);
            hostVar.getHostVariable().setResultDescriptor(result);
            return true;
        }
        return false;
    }

    private void checkAssignment(ArrayList targetRow, ArrayList sourceRow, boolean isInsert) {
        int i = 0;
        while (i < sourceRow.size()) {
            ResultDescriptor target;
            ResultDescriptor source = (ResultDescriptor)sourceRow.get(i);
            if (!(this.setHostVariable(source, target = (ResultDescriptor)targetRow.get(i), false) || target.isUnknown() || source.isUnknown() || target.isNullable() && 0 == source.getJdbcType())) {
                if (target.isExactNumeric) {
                    if (!source.isExactNumeric) {
                        this.checkFailed("typeNewValueExactNumeric", i, target.getName());
                    }
                    if (source.isConstant() && target.isSupported) {
                        int targetTyp = target.getJdbcType();
                        int sourceTyp = source.getJdbcType();
                        if (5 == targetTyp) {
                            if (5 != sourceTyp) {
                                this.checkFailed("typeNewValueLiteralTooLarge", i, target.getName());
                            }
                        } else if (4 == targetTyp) {
                            if (sourceTyp != 4 && sourceTyp != 5) {
                                this.checkFailed("typeNewValueLiteralTooLarge", i, target.getName());
                            }
                        } else if (-5 == targetTyp && sourceTyp != 4 && sourceTyp != 5 && sourceTyp != -5) {
                            this.checkFailed("typeNewValueLiteralTooLarge", i, target.getName());
                        }
                    }
                }
                if (target.isCharacterLike() && source.isCharacterLike() && source.getSize() > target.getSize()) {
                    this.checkFailed("typeNewValueCharLength", i, target.getName());
                }
                if (!target.isAssignableFrom(source)) {
                    this.checkFailed("typeNewValueAssignable", i, target.getName());
                }
            }
            ++i;
        }
    }

    public void visitArithmeticExpression(ArithmeticExpression x) {
        ResultDescriptor rhs = null;
        ResultDescriptor lhs = null;
        try {
            rhs = this.getScalar();
        }
        catch (ClassCastException ex) {
            LOCATION.traceThrowableT(500, "unexpected state of the stack", (Throwable)ex);
            this.checkFailed("typeArithmeticScalar");
        }
        if (null != x.getLeftOperand()) {
            try {
                lhs = this.getScalar();
            }
            catch (ClassCastException ex) {
                LOCATION.traceThrowableT(500, "unexpected state of the stack", (Throwable)ex);
                this.checkFailed("typeArithmeticScalar");
            }
        }
        if (null == rhs) {
            this.stack.push(new ResultDescriptor());
            return;
        }
        if (null == lhs) {
            if (!rhs.isNumeric) {
                this.checkFailed("typeOperandNumeric");
            }
            if (x.getOperator() != 2) {
                this.checkFailed("typeMonadicNotMinus");
            }
            this.stack.push(rhs);
            x.setResultDescriptor(rhs);
            return;
        }
        if (!lhs.isNumeric) {
            this.checkFailed("typeOperandsNumeric");
            this.stack.push(rhs);
            return;
        }
        if (!rhs.isNumeric) {
            this.checkFailed("typeOperandsNumeric");
            this.stack.push(lhs);
            return;
        }
        if (lhs.isUnknown()) {
            this.stack.push(rhs);
            return;
        }
        if (rhs.isUnknown()) {
            this.stack.push(lhs);
            return;
        }
        int resultType = CommonTypes.jdbcTypeArithmeticExpression((int)lhs.getJdbcType(), (int)rhs.getJdbcType());
        long resultPrecision = Math.max(lhs.getSize(), rhs.getSize());
        int resultScale = x.getOperator() == 3 ? lhs.getDecimals() + rhs.getDecimals() : Math.max(lhs.getDecimals(), rhs.getDecimals());
        boolean resultIsConstant = lhs.isConstant() && rhs.isConstant();
        ResultDescriptor result = new ResultDescriptor(resultType, resultPrecision, resultScale, resultIsConstant);
        x.setResultDescriptor(result);
        this.stack.push(result);
    }

    public void visitBetweenPredicate(BetweenPredicate x) {
        ResultDescriptor high = this.getScalar();
        ResultDescriptor low = this.getScalar();
        ResultDescriptor value = this.getScalar();
        if (!value.isComparable()) {
            this.complainNotComparable(value, "BETWEEN", x.getValue());
        }
        if (this.setHostVariable(low, value, true)) {
            low = value;
        } else {
            if (!low.isComparable()) {
                this.complainNotComparable(low, "BETWEEN", x.getLowValue());
            }
            if (!value.isComparableWith(low)) {
                this.checkFailed("typeBetweenLower", CheckTypeVisitor.toText(x.getLowValue()), low.getJdbcTypeName(), CheckTypeVisitor.toText(x.getValue()), value.getJdbcTypeName());
            }
        }
        if (this.setHostVariable(high, value, true)) {
            high = value;
        } else {
            if (!high.isComparable()) {
                this.complainNotComparable(high, "BETWEEN", x.getHighValue());
            }
            if (!value.isComparableWith(high)) {
                this.checkFailed("typeBetweenUpper", CheckTypeVisitor.toText(x.getHighValue()), high.getJdbcTypeName(), CheckTypeVisitor.toText(x.getValue()), value.getJdbcTypeName());
            }
        }
        if (!low.isComparableWith(high)) {
            this.checkFailed("typeBetweenBounds", CheckTypeVisitor.toText(x.getLowValue()), low.getJdbcTypeName(), CheckTypeVisitor.toText(x.getHighValue()), high.getJdbcTypeName());
        }
        this.stack.push(new SQLBoolean());
    }

    private void complainNotComparable(ResultDescriptor rd, String operator, RowValue rowValue) {
        this.checkFailed("typeNotComparable", CheckTypeVisitor.toText(rowValue), rd.getJdbcTypeName(), operator);
    }

    public void visitBigDecimalLiteral(BigDecimalLiteral x) {
        this.stack.push(x.getResultDescriptor());
    }

    public void visitBooleanAnd(BooleanAnd x) {
        int i = 0;
        while (i < x.getOperands().length) {
            SQLBoolean operand = (SQLBoolean)this.stack.pop();
            this.logDebug("and popped an operand");
            ++i;
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitBooleanNot(BooleanNot x) {
    }

    public void visitBooleanOr(BooleanOr x) {
        int i = 0;
        while (i < x.getOperands().length) {
            SQLBoolean sQLBoolean = (SQLBoolean)this.stack.pop();
            ++i;
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitColumnReference(ColumnReference x) {
        Column aColumn = x.getColumnDescriptor();
        ResultDescriptor result = null == aColumn ? new ResultDescriptor() : new ResultDescriptor(aColumn);
        this.stack.push(result);
        x.setResultDescriptor(result);
    }

    public void visitComparisonPredicate(ComparisonPredicate x) {
        ResultDescriptor rhs = this.getScalar();
        ResultDescriptor lhs = this.getScalar();
        RowValue rowValue = x.getLeftOperand();
        if (!lhs.isComparable()) {
            this.complainNotComparable(lhs, CheckTypeVisitor.getOperatorText(x.getOperator()), x.getLeftOperand());
        }
        if (this.setHostVariable(rhs, lhs, true)) {
            rhs = lhs;
        } else {
            if (!rhs.isComparable()) {
                this.complainNotComparable(rhs, CheckTypeVisitor.getOperatorText(x.getOperator()), x.getRightOperand());
            }
            if (!lhs.isComparableWith(rhs)) {
                this.checkFailed("operandsNotComparable", CheckTypeVisitor.toText(x.getLeftOperand()), lhs.getJdbcTypeName(), CheckTypeVisitor.toText(x.getRightOperand()), rhs.getJdbcTypeName());
            }
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitConcatenationExpression(ConcatenationExpression x) {
        this.checkFailed("typeConcatNotEntryLevel");
        this.stack.pop();
    }

    public void visitCountAll(CountAll x) {
        this.stack.push(x.getResultDescriptor());
    }

    public void visitDefaultValue(DefaultValue x) {
        this.checkFailed("typeDefaultNotEntryLevel");
    }

    public void visitDeleteStatement(DeleteStatement x) {
        if (null != x.getWhereClause()) {
            SQLBoolean bool = (SQLBoolean)this.stack.pop();
        }
        SQLTable sQLTable = (SQLTable)this.stack.pop();
    }

    public void visitDerivedTable(DerivedTable x) {
        this.checkFailed("typeDerivedNotEntryLevel");
    }

    public void visitExistsPredicate(ExistsPredicate x) {
        ArrayList subquery = (ArrayList)this.stack.pop();
        this.stack.push(new SQLBoolean());
    }

    public void visitFloatLiteral(FloatLiteral x) {
        this.stack.push(x.getResultDescriptor());
    }

    public void visitHostVariable(HostVariable x) {
        HostVarDescriptor hostVar = new HostVarDescriptor(x);
        this.stack.push(hostVar);
    }

    public void visitInListPredicate(InListPredicate x) {
        ArrayList<ResultDescriptor> list = new ArrayList<ResultDescriptor>(x.getValueList().length);
        int i = 0;
        while (i < x.getValueList().length) {
            ResultDescriptor element = this.getScalar();
            list.add(0, element);
            ++i;
        }
        ResultDescriptor value = this.getScalar();
        if (!value.isComparable()) {
            this.complainNotComparable(value, "IN", (RowValue)x.getValue());
        }
        int i2 = 0;
        while (i2 < list.size()) {
            ResultDescriptor element = (ResultDescriptor)list.get(i2);
            if (this.setHostVariable(element, value, true)) {
                element = value;
            } else {
                if (!element.isComparable()) {
                    this.complainNotComparable(element, "IN", (RowValue)x.getValueList()[i2]);
                }
                if (!element.isComparableWith(value)) {
                    this.checkFailed("typeInListComparable", CheckTypeVisitor.toText((RowValue)x.getValueList()[i2]), element.getJdbcTypeName(), CheckTypeVisitor.toText((RowValue)x.getValue()), value.getJdbcTypeName());
                }
            }
            ++i2;
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitCreateViewStatement(CreateViewStatement x) {
        int i;
        String[] viewColumnList;
        ArrayList resultList = (ArrayList)this.stack.peek();
        int resultListSize = resultList.size();
        HashSet<String> set = new HashSet<String>();
        if (x.getColumnNameList() != null) {
            viewColumnList = x.getColumnNameList();
            if (resultListSize != viewColumnList.length) {
                this.checkFailed("wrongViewColumnListSize", Integer.toString(viewColumnList.length), Integer.toString(resultListSize));
            }
        } else {
            viewColumnList = new String[resultListSize];
            i = 0;
            while (i < resultListSize) {
                viewColumnList[i] = ((ResultDescriptor)resultList.get(i)).getName();
                ++i;
            }
        }
        i = 0;
        while (i < resultListSize) {
            String name = viewColumnList[i];
            if (name == null) {
                this.checkFailed("viewColumnUndefined", Integer.toString(i + 1));
            } else if (!set.add(name)) {
                this.checkFailed("viewColumnNotUnique", name);
            }
            ++i;
        }
    }

    public void visitInsertStatement(InsertStatement x) {
        this.logDebug("visit Insert Statement");
        ArrayList sourceRow = null;
        if (this.stack.peek() instanceof ResultDescriptor) {
            sourceRow = new ArrayList(1);
            ResultDescriptor source = this.getScalar();
            sourceRow.add(source);
        } else {
            sourceRow = (ArrayList)this.stack.pop();
        }
        this.logDebug("got source from stack");
        ArrayList targetRow = null;
        if (null != x.getColumnList()) {
            int degree = x.getColumnList().length;
            targetRow = new ArrayList(degree);
            int i = 0;
            while (i < degree) {
                ResultDescriptor target = this.getScalar();
                this.logDebug("got insert target column " + target.getName());
                targetRow.add(0, target);
                ++i;
            }
        }
        SQLTable table = (SQLTable)this.stack.pop();
        if (null == targetRow && null == (targetRow = table.getResultRow())) {
            this.logDebug("no columnlist to insert in table");
            return;
        }
        if (targetRow.size() != sourceRow.size()) {
            this.checkFailed("typeInsertNumberColumns");
            return;
        }
        this.checkAssignment(targetRow, sourceRow, true);
    }

    public void visitInSubqueryPredicate(InSubqueryPredicate x) {
        ArrayList list = (ArrayList)this.stack.pop();
        ResultDescriptor value = this.getScalar();
        if (!value.isComparable()) {
            this.complainNotComparable(value, "IN", x.getValue());
        }
        if (list.size() > 1) {
            this.checkFailed("typeInSubqueryScalar", CheckTypeVisitor.toText((RowValue)x.getSubquery()));
        }
        int i = 0;
        while (i < list.size()) {
            ResultDescriptor element = (ResultDescriptor)list.get(i);
            if (!element.isComparable()) {
                this.complainNotComparable(element, "IN", null);
            }
            if (!value.isComparableWith(element)) {
                this.checkFailed("typeInComparable", CheckTypeVisitor.toText(x.getValue()), value.getJdbcTypeName(), CheckTypeVisitor.toText((RowValue)x.getSubquery()), x.getSubquery().getResultDescriptor().getJdbcTypeName());
            }
            ++i;
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitIntegerLiteral(IntegerLiteral x) {
        this.stack.push(x.getResultDescriptor());
    }

    public void visitJoinedTable(JoinedTable x) {
        int joinType = x.getJoinType();
        switch (joinType) {
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                this.checkFailed("typeNaturalJoinNotSupported");
            }
        }
        if (x.getNamedColumns() != null) {
            this.checkFailed("typeNamedColumnsJoinNotSupported");
        }
        if (null != x.getJoinCondition()) {
            this.stack.pop();
        }
        ArrayList rightColumns = this.getRow();
        ArrayList leftColumns = this.getRow();
        ArrayList resultColumns = new ArrayList();
        if (null != leftColumns) {
            resultColumns.addAll(leftColumns);
        }
        if (null != rightColumns) {
            resultColumns.addAll(rightColumns);
        }
        this.stack.push(resultColumns);
        if (resultColumns.size() == 1) {
            x.setResultDescriptor((ResultDescriptor)resultColumns.get(0));
        }
    }

    public void visitLikePredicate(LikePredicate x) {
        ResultDescriptor matchValue;
        ResultDescriptor patternValue;
        ResultDescriptor escape;
        if (null != x.getEscapeValue() && !this.setHostVariable(escape = this.getScalar(), new ResultDescriptor(1, 1L, 0, false), true)) {
            if (!escape.isComparable()) {
                this.complainNotComparable(escape, "ESCAPE", (RowValue)x.getEscapeValue());
            }
            if (!escape.isCharacterLike()) {
                this.checkFailed("typeEscapeCharacter", CheckTypeVisitor.toText((RowValue)x.getEscapeValue()), escape.getJdbcTypeName());
            }
        }
        if (!this.setHostVariable(patternValue = this.getScalar(), matchValue = this.getScalar(), true)) {
            if (!patternValue.isComparable()) {
                this.complainNotComparable(patternValue, "LIKE", (RowValue)x.getPatternValue());
            }
            if (!patternValue.isCharacterLike()) {
                this.checkFailed("typeLikePatternCharacter", CheckTypeVisitor.toText((RowValue)x.getPatternValue()), patternValue.getJdbcTypeName());
            }
        }
        if (!matchValue.isComparable()) {
            this.complainNotComparable(matchValue, "LIKE", (RowValue)x.getMatchValue());
        }
        if (!matchValue.isCharacterLike()) {
            this.checkFailed("typeLikeMatchCharacter", CheckTypeVisitor.toText((RowValue)x.getMatchValue()), matchValue.getJdbcTypeName());
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitNonJoinQuery(NonJoinQuery x) {
        ArrayList right = (ArrayList)this.stack.pop();
        ArrayList left = (ArrayList)this.stack.peek();
        if (left.size() != right.size()) {
            this.checkFailed("typeUnionDegree");
        } else {
            int i = 0;
            while (i < left.size()) {
                ResultDescriptor rhs;
                ResultDescriptor lhs = (ResultDescriptor)left.get(i);
                if (!lhs.isAssignableFrom(rhs = (ResultDescriptor)right.get(i))) {
                    this.checkFailed("typeUnionIdenticalType", i);
                }
                ++i;
            }
        }
        if (left.size() == 1) {
            x.setResultDescriptor((ResultDescriptor)left.get(0));
        }
    }

    public void visitNullPredicate(NullPredicate x) {
        ResultDescriptor value = this.getScalar();
        this.stack.push(new SQLBoolean());
    }

    public void visitNullValue(NullValue x) {
        ResultDescriptor result = new ResultDescriptor(0, 0L, 0, true);
        x.setResultDescriptor(result);
        this.stack.push(result);
    }

    public void visitQuantifiedComparisonPredicate(QuantifiedComparisonPredicate x) {
        ArrayList subquery = (ArrayList)this.stack.pop();
        ResultDescriptor value = this.getScalar();
        if (!value.isComparable()) {
            this.complainNotComparable(value, CheckTypeVisitor.getOperatorText(x.getOperator()), x.getValue());
        }
        if (subquery.size() != 1) {
            this.checkFailed("typeQuantifiedDegree");
        }
        int i = 0;
        while (i < subquery.size()) {
            ResultDescriptor column = (ResultDescriptor)subquery.get(i);
            if (!column.isComparable()) {
                this.complainNotComparable(column, CheckTypeVisitor.getOperatorText(x.getOperator()), null);
            }
            if (!value.isComparableWith(column)) {
                this.checkFailed("typeQuantifiedComparable", CheckTypeVisitor.toText(x.getValue()), value.getJdbcTypeName(), CheckTypeVisitor.toText((RowValue)x.getSubquery()), column.getJdbcTypeName());
                break;
            }
            ++i;
        }
        this.stack.push(new SQLBoolean());
    }

    public void visitQuerySpecification(QuerySpecification x) {
        int i;
        SQLBoolean bool;
        if (null != x.getHavingClause()) {
            bool = (SQLBoolean)this.stack.pop();
            this.logDebug("having popped");
        }
        if (null != x.getGroupByList()) {
            int i2 = 0;
            while (i2 < x.getGroupByList().length) {
                ResultDescriptor elem = this.getScalar();
                if (!elem.isComparable()) {
                    this.checkFailed("typeGroupByNotAllowed", elem.getName(), elem.getJdbcTypeName());
                }
                ++i2;
            }
            this.logDebug("group by list popped");
        }
        if (null != x.getWhereClause()) {
            bool = (SQLBoolean)this.stack.pop();
            this.logDebug("where popped");
        }
        int nTables = x.getFromClause().length;
        this.logDebug("tables: " + nTables);
        ArrayList<ResultDescriptor> resultRow = new ArrayList<ResultDescriptor>();
        if (null == x.getSelectList()) {
            this.logDebug("SELECT *");
            i = 0;
            while (i < nTables) {
                ArrayList columns = this.getRow();
                if (null != columns) {
                    resultRow.addAll(0, columns);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < nTables) {
                this.stack.pop();
                ++i;
            }
            resultRow.ensureCapacity(x.getSelectList().length);
            this.logDebug("rows: " + x.getSelectList().length);
            int i3 = 0;
            while (i3 < x.getSelectList().length) {
                ResultDescriptor element = this.getScalar();
                this.logDebug("got column " + element.getName());
                resultRow.add(0, element);
                ++i3;
            }
        }
        if (x.isDistinct()) {
            i = 0;
            while (i < resultRow.size()) {
                ResultDescriptor resultColumn = (ResultDescriptor)resultRow.get(i);
                if (!resultColumn.isComparable()) {
                    this.checkFailed("typeDistinctNotAllowed", resultColumn.getName(), resultColumn.getJdbcTypeName());
                }
                ++i;
            }
        }
        this.stack.push(resultRow);
        if (resultRow.size() == 1) {
            x.setResultDescriptor((ResultDescriptor)resultRow.get(0));
        }
    }

    public void visitRowValueElementList(RowValueElementList x) {
        ArrayList<ResultDescriptor> row = new ArrayList<ResultDescriptor>(x.getValueList().length);
        int i = 0;
        while (i < x.getValueList().length) {
            ResultDescriptor element = this.getScalar();
            row.add(0, element);
            ++i;
        }
        this.stack.push(row);
    }

    public void visitSelectForUpdate(SelectForUpdateStatement x) {
        ColumnReference[] updateColumns = x.getUpdateFieldList();
        if (null != updateColumns) {
            int i = 0;
            while (i < updateColumns.length) {
                this.stack.pop();
                ++i;
            }
        }
    }

    public void visitSelectStatement(SelectStatement x) {
        SortSpecification[] sortSpecification = x.getOrderByList();
        if (null != sortSpecification) {
            ArrayList row = (ArrayList)this.stack.peek();
            HashMap<String, Integer> rowMap = new HashMap<String, Integer>(row.size() * 4 / 3, 0.75f);
            HashSet<String> ambiSet = new HashSet<String>();
            int i = 0;
            while (i < row.size()) {
                ResultDescriptor elem = (ResultDescriptor)row.get(i);
                String name = elem.getName();
                if (rowMap.put(name, new Integer(i)) != null) {
                    ambiSet.add(name);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < sortSpecification.length) {
                SortSpecification sortSpec = sortSpecification[i2];
                String checkName = sortSpec.getColumnName();
                if (ambiSet.contains(checkName)) {
                    this.checkFailed("orderFieldNotUni", checkName);
                } else {
                    Integer index = (Integer)rowMap.get(checkName);
                    if (index == null) {
                        this.checkFailed("noOrderField", checkName);
                    } else {
                        sortSpecification[i2] = new SortSpecification(index + 1, checkName, sortSpec.isDescending());
                        ResultDescriptor sortDescriptor = (ResultDescriptor)row.get(index);
                        if (!sortDescriptor.isComparable()) {
                            this.checkFailed("typeOrderByNotAllowed", checkName, sortDescriptor.getJdbcTypeName());
                        }
                    }
                }
                ++i2;
            }
        }
    }

    public void visitSelectSublist(SelectSublist x) {
        ResultDescriptor result = this.getScalar();
        if (null != x.getAliasName()) {
            result.setName(x.getAliasName());
        }
        this.stack.push(result);
        this.logDebug("column " + result.getName() + " is in select sublist");
    }

    public void visitSetClause(SetClause x) {
    }

    public void visitSetFunction(SetFunction x) {
        ResultDescriptor result;
        ResultDescriptor argument = this.getScalar();
        switch (x.getSetFunctionType()) {
            case 2: 
            case 3: {
                result = new ResultDescriptor(argument);
                break;
            }
            case 4: {
                if (argument.isNumeric) {
                    if (argument.isUnknown()) {
                        result = new ResultDescriptor(5, 5L, 0, false);
                        break;
                    }
                    result = new ResultDescriptor(argument);
                    break;
                }
                this.checkFailed("typeArgNumeric", "SUM");
                result = new ResultDescriptor(5, 5L, 0, false);
                break;
            }
            case 1: {
                if (argument.isExactNumeric) {
                    result = new ResultDescriptor(3, argument.getSize(), argument.getDecimals(), false);
                    break;
                }
                if (argument.isApproxNumeric()) {
                    result = new ResultDescriptor(8, argument.getSize(), argument.getDecimals(), false);
                    break;
                }
                this.checkFailed("typeArgNumeric", "AVG");
                result = new ResultDescriptor(8, 0L, 0, false);
                break;
            }
            case 5: {
                result = new ResultDescriptor(4, 10L, 0, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SetFunction: " + x.getSetFunctionType());
            }
        }
        result.setName(null);
        this.stack.push(result);
        x.setResultDescriptor(result);
    }

    public void visitSortSpecification(SortSpecification x) {
    }

    public void visitStringLiteral(StringLiteral x) {
        String literalValue = x.getValue();
        int length = literalValue.length();
        switch (length) {
            case 0: {
                this.checkFailed("emptyStringLiteral");
            }
            case 1: {
                break;
            }
            default: {
                if (literalValue.charAt(length - 1) != ' ') break;
                this.checkFailed("trailingBlankStringLiteral");
            }
        }
        this.stack.push(x.getResultDescriptor());
    }

    public void visitTableReference(TableReference x) {
        this.stack.push(new SQLTable(x.getTableDescriptor()));
    }

    public void visitTableValue(TableValue x) {
    }

    public void visitUpdateStatement(UpdateStatement x) {
        if (x.getWhereClause() != null) {
            SQLBoolean cond = (SQLBoolean)this.stack.pop();
        }
        int degree = x.getSetClauseList().length;
        ArrayList<ResultDescriptor> sourceRow = new ArrayList<ResultDescriptor>(degree);
        ArrayList<ResultDescriptor> targetRow = new ArrayList<ResultDescriptor>(degree);
        int i = 0;
        while (i < degree) {
            ResultDescriptor source = this.getScalar();
            sourceRow.add(0, source);
            ResultDescriptor target = this.getScalar();
            targetRow.add(0, target);
            ++i;
        }
        SQLTable table = (SQLTable)this.stack.pop();
        this.checkAssignment(targetRow, sourceRow, false);
    }

    private static String toText(RowValue rowValue) {
        StringBuffer buffer = new StringBuffer();
        rowValue.toSqlTxt(buffer);
        return buffer.toString();
    }

    private static String getOperatorText(int operator) {
        switch (operator) {
            case 1: {
                return "=";
            }
            case 2: {
                return "<>";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return ">";
            }
            case 6: {
                return ">=";
            }
        }
        throw new IllegalArgumentException("unexpected opearator value: " + operator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SQLTable {
        private Table table;

        SQLTable(Table aTable) {
            this.table = aTable;
        }

        ArrayList getResultRow() {
            if (null == this.table) {
                return null;
            }
            int colCnt = this.table.getColumnCnt();
            ArrayList<ResultDescriptor> result = new ArrayList<ResultDescriptor>(colCnt);
            int i = 0;
            while (i < colCnt) {
                result.add(new ResultDescriptor(this.table.getColumn(i + 1)));
                ++i;
            }
            return result;
        }

        ArrayList getResultRow(String[] columnNames) {
            if (null == this.table) {
                return null;
            }
            if (null == columnNames) {
                return this.getResultRow();
            }
            ArrayList<ResultDescriptor> result = new ArrayList<ResultDescriptor>(columnNames.length);
            int i = 0;
            while (i < columnNames.length) {
                result.add(new ResultDescriptor(this.table.getColumn(columnNames[i])));
                ++i;
            }
            return result;
        }
    }

    private class SQLBoolean {
        SQLBoolean() {
        }
    }
}

