/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SetFunction;
import java.util.Stack;
import java.util.Vector;

public class CheckDistinctVisitor
extends CheckVisitor {
    private boolean checked = false;
    private boolean hasDistinct = false;
    private Stack stack = new Stack();

    public CheckDistinctVisitor(Vector anErrorLog) {
        super(anErrorLog);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean hasDistinct() {
        return this.checked && this.hasDistinct;
    }

    private void logError() {
        String txt = CommonSQLParserErrors.msg("duplicateDistinct");
        this.errorLog.add(new LogEntry(txt, 0, 0));
    }

    public void visitQuerySpecificationBefore(QuerySpecification aQuery) {
        this.stack.push(new Integer(0));
    }

    public void visitQuerySpecification(QuerySpecification aQuery) {
        int count = (Integer)this.stack.pop();
        if (aQuery.isDistinct()) {
            ++count;
        }
        this.checked = true;
        if (count > 1) {
            this.logError();
        }
        if (this.stack.empty() && count > 0) {
            this.hasDistinct = true;
        }
    }

    public void visitSetFunction(SetFunction aSetFunction) {
        if (aSetFunction.isDistinct()) {
            this.stack.push(new Integer((Integer)this.stack.pop() + 1));
        }
    }
}

