/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.CreateViewStatement;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetFunction;
import java.util.Vector;

public class CheckCreateViewVisitor
extends CheckVisitor {
    private boolean checked = false;
    private boolean isPossiblyUpdatable = true;
    private boolean isGroupedView = false;
    private int subqueryCount = 0;
    private boolean shallBeUpdateable;

    public CheckCreateViewVisitor(Vector anErrorLog) {
        super(anErrorLog);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isGroupedView() {
        return this.checked && this.isGroupedView;
    }

    public void visitHostVariable(HostVariable x) {
        String txt = CommonSQLParserErrors.msg("hostvarInCreateView");
        this.errorLog.add(new LogEntry(txt, 0, 0));
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        ++this.subqueryCount;
        if (this.subqueryCount == 1) {
            if (x.getHavingClause() != null) {
                this.isGroupedView = true;
                if (this.shallBeUpdateable) {
                    this.checkFailed("havingViolatesUpdate");
                }
                this.isPossiblyUpdatable = false;
            }
            if (x.getGroupByList() != null) {
                this.isGroupedView = false;
                if (this.shallBeUpdateable) {
                    this.checkFailed("groupViolatesUpdate");
                    this.isPossiblyUpdatable = false;
                }
            }
        } else if (this.shallBeUpdateable) {
            this.checkFailed("subqueryViolatesUpdate");
            this.isPossiblyUpdatable = false;
        }
        if (x.getFromClause().length > 1 && this.shallBeUpdateable) {
            this.checkFailed("joinViolatesUpdate");
            this.isPossiblyUpdatable = false;
        }
    }

    public void visitJoinedTable(JoinedTable x) {
        if (this.shallBeUpdateable) {
            this.checkFailed("joinViolatesUpdate");
            this.isPossiblyUpdatable = false;
        }
    }

    public void visitSelectSublist(SelectSublist x) {
        if (this.shallBeUpdateable && !(x.getValue() instanceof ColumnReference)) {
            this.checkFailed("sublistNotColumnReferenceViolatesUpdate");
            this.isPossiblyUpdatable = false;
        }
    }

    public void visitSetFunction(SetFunction x) {
        if (this.subqueryCount == 1) {
            this.isGroupedView = true;
        }
    }

    public void visitQuerySpecification(QuerySpecification x) {
        --this.subqueryCount;
    }

    public void visitCreateViewStatementBefore(CreateViewStatement x) {
        this.shallBeUpdateable = x.hasCheckOption();
    }

    public void visitCreateViewStatement(CreateViewStatement x) {
        if (x.hasCheckOption() && !this.isPossiblyUpdatable) {
            this.checkFailed("withCheckOptionNotUpdateable");
        }
        x.setGrouped(this.isGroupedView);
        x.setPossiblyUpdatable(this.isPossiblyUpdatable);
    }

    private final void logError(String text) {
        String message = CommonSQLParserErrors.msg("viewCheckError", text);
        this.errorLog.add(new LogEntry(message, 0, 0));
    }

    private final void checkFailed(String key) {
        this.logError(CommonSQLParserErrors.msg(key));
    }
}

