/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.nametab;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Table;
import com.sap.sql.jdbc.DatabaseVendor;
import com.sap.sql.log.ExceptionType;
import com.sap.sql.nametab.NametabException;
import com.sap.sql.nametab.NametabNotFound;
import com.sap.sql.nametab.NametabTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class NametabReader
implements CatalogReader {
    private Connection conn = null;
    private PreparedStatement selectNametabStmt = null;
    private PreparedStatement selectPhysicalClusterNametabStmt = null;
    private PreparedStatement selectLogicClusterNametabStmt = null;
    private PreparedStatement existsNametabStmt = null;
    static final int VERS_0 = 0;
    static final int VERS_A = 1;
    static final int VERS_B = 2;
    private int version = 2;
    private String cp = "UTF-16BE";
    private int unicodeLg = 2;
    private boolean skipTwoBytes = false;
    private boolean fieldsAsBlob = false;
    private DatabaseMetaData md = null;

    public NametabReader(Connection conn) throws NametabException {
        this.conn = conn;
        try {
            this.md = conn.getMetaData();
        }
        catch (SQLException e) {
            throw new NametabException("NametabReader", "NametabReader", ExceptionType.INTERNAL_ERROR, "Unexpected SQL Error occurred: " + e.getMessage());
        }
        this.initNametabReader(-1);
    }

    public NametabReader(String systemID, Connection conn) throws NametabException {
        this.conn = conn;
        try {
            this.md = conn.getMetaData();
        }
        catch (SQLException e) {
            throw new NametabException("NametabReader", "NametabReader", ExceptionType.INTERNAL_ERROR, "Unexpected SQL Error occurred: " + e.getMessage());
        }
        this.initNametabReader(-1);
    }

    public Table getTable(String tableName) throws NametabException {
        return this.createNametabTable(tableName, null, this.selectNametabStmt);
    }

    public Table getTable(String schemaName, String tableName) throws NametabException {
        PreparedStatement pstmt = null;
        if (schemaName == null) {
            pstmt = this.selectNametabStmt;
        } else {
            try {
                pstmt = this.conn.prepareStatement("SELECT DDNTT.FLDCNT, DDNTT.KEYCNT, DDNTT.TABTYPE, DDNTT.HFLAG, DDNTT.BUFSTATE, DDNTT.BUFPARM, DDNTT.CLIENTPOS, DDNTF.BLOCKNR, DDNTF.FIELDSLG, DDNTF.FIELDS FROM " + schemaName + ".DDNTT DDNTT, " + schemaName + ".DDNTF DDNTF " + "WHERE DDNTT.TABNAME = ? AND " + "DDNTF.TABNAME = DDNTT.TABNAME AND " + "DDNTT.TABFORM = 'T' AND " + "(DDNTT.TABTYPE = 'T' OR DDNTT.TABTYPE = 'J') " + "ORDER BY DDNTF.BLOCKNR");
            }
            catch (SQLException e) {
                throw new NametabException("NametabReader", "getTable", ExceptionType.INTERNAL_ERROR, "Unexpected SQL error occured during prepareStement, schemaName: '" + schemaName + "', tableName: '" + tableName + "': " + e.getMessage());
            }
        }
        Table t = this.createNametabTable(tableName, schemaName, pstmt);
        if (schemaName != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                throw new NametabException("NametabReader", "getTable", ExceptionType.INTERNAL_ERROR, "Unexpected SQL error occured during pstmt.close, schemaName: '" + schemaName + "', tableName: '" + tableName + "': " + e.getMessage());
            }
        }
        return t;
    }

    public Table getPhysicalClusterTable(String tableName) throws NametabException {
        return this.createNametabTable(tableName, null, this.selectPhysicalClusterNametabStmt);
    }

    public Table getLogicClusterTable(String tableName) throws NametabException {
        return this.createNametabTable(tableName, null, this.selectLogicClusterNametabStmt);
    }

    public boolean existsTable(String tableName) throws NametabException {
        return NametabTable.existsNametab(tableName, this.existsNametabStmt);
    }

    public boolean existsTable(String schemaName, String tableName) throws NametabException {
        PreparedStatement pstmt = null;
        if (schemaName == null) {
            pstmt = this.existsNametabStmt;
        } else {
            try {
                pstmt = this.conn.prepareStatement("SELECT TABNAME FROM " + schemaName + ".DDNTT WHERE " + "TABNAME = ? AND TABFORM = 'T' AND " + "(TABTYPE = 'T' OR TABTYPE = 'J')");
            }
            catch (SQLException e) {
                throw new NametabException("NametabReader", "existsTable", ExceptionType.INTERNAL_ERROR, "Unexpected SQL error occured during prepareStement, schemaName: '" + schemaName + "', tableName: '" + tableName + "': " + e.getMessage());
            }
        }
        boolean rc = NametabTable.existsNametab(tableName, pstmt);
        if (schemaName != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                throw new NametabException("NametabReader", "existsTable", ExceptionType.INTERNAL_ERROR, "Unexpected SQL error occured during pstmt.close, schemaName: '" + schemaName + "', tableName: '" + tableName + "': " + e.getMessage());
            }
        }
        return rc;
    }

    public boolean isLogicalCatalogReader() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initNametabReader(int vendorID) throws NametabException {
        String selectBasisStr = "SELECT DDNTT.FLDCNT, DDNTT.KEYCNT, DDNTT.TABTYPE, DDNTT.HFLAG, DDNTT.BUFSTATE, DDNTT.BUFPARM, DDNTT.CLIENTPOS, DDNTF.BLOCKNR, DDNTF.FIELDSLG, DDNTF.FIELDS FROM DDNTT DDNTT, DDNTF DDNTF WHERE DDNTT.TABNAME = ? AND DDNTF.TABNAME = DDNTT.TABNAME AND ";
        try {
            ResultSet rs;
            PreparedStatement pstmt;
            block21: {
                this.selectNametabStmt = this.conn.prepareStatement(selectBasisStr + "DDNTT.TABFORM = 'T' AND " + "(DDNTT.TABTYPE = 'T' OR DDNTT.TABTYPE = 'J') " + "ORDER BY DDNTF.BLOCKNR");
                this.selectPhysicalClusterNametabStmt = this.conn.prepareStatement(selectBasisStr + "DDNTT.TABFORM = 'T' AND DDNTT.TABTYPE = 'C' " + "ORDER BY DDNTF.BLOCKNR");
                this.selectLogicClusterNametabStmt = this.conn.prepareStatement(selectBasisStr + "DDNTT.TABFORM = 'C' AND DDNTT.TABTYPE = 'T' " + "ORDER BY DDNTF.BLOCKNR");
                this.existsNametabStmt = this.conn.prepareStatement("SELECT TABNAME FROM DDNTT WHERE TABNAME = ? AND TABFORM = 'T' AND (TABTYPE = 'T' OR TABTYPE = 'J')");
                PreparedStatement pstmtB = null;
                PreparedStatement pstmtA = null;
                PreparedStatement pstmt0 = null;
                this.version = 2;
                try {
                    try {
                        pstmtB = this.conn.prepareStatement("SELECT COMPCNT FROM DDNTT WHERE TABNAME = 'SVERS'");
                        pstmtB.executeQuery();
                    }
                    catch (SQLException e) {
                        block20: {
                            this.version = 1;
                            try {
                                try {
                                    pstmtA = this.conn.prepareStatement("SELECT VERSION FROM DDNTT WHERE TABNAME = 'SVERS'");
                                    pstmtA.executeQuery();
                                }
                                catch (SQLException e2) {
                                    this.version = 0;
                                    pstmt0 = this.conn.prepareStatement("SELECT DBASE FROM DDNTT WHERE TABNAME = 'SVERS'");
                                    pstmt0.executeQuery();
                                    Object var9_13 = null;
                                    if (pstmtA != null) {
                                        pstmtA.close();
                                    }
                                    break block20;
                                }
                                Object var9_12 = null;
                                if (pstmtA == null) break block20;
                            }
                            catch (Throwable throwable) {
                                Object var9_14 = null;
                                if (pstmtA == null) throw throwable;
                                pstmtA.close();
                                throw throwable;
                            }
                            pstmtA.close();
                        }
                        Object var11_8 = null;
                        if (pstmtB != null) {
                            pstmtB.close();
                        }
                        break block21;
                    }
                    Object var11_7 = null;
                    if (pstmtB == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    if (pstmtB == null) throw throwable;
                    pstmtB.close();
                    throw throwable;
                }
                pstmtB.close();
            }
            if (vendorID == -1) {
                vendorID = DatabaseVendor.getVendorID((Connection)this.conn);
            }
            if (vendorID == 6 || vendorID == 5) {
                this.skipTwoBytes = true;
            }
            if (vendorID == 3) {
                this.fieldsAsBlob = true;
            }
            if (this.version == 2) {
                pstmt = this.conn.prepareStatement("SELECT UNICODELG FROM DDNTT WHERE TABNAME = 'SVERS'");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.unicodeLg = rs.getByte("UNICODELG");
                }
                rs.close();
                pstmt.close();
            } else {
                this.unicodeLg = 1;
            }
            if (this.unicodeLg == 2) {
                this.cp = "UTF-16BE";
                return;
            }
            this.cp = "ASCII";
            if (vendorID != 1) return;
            this.cp = "CP500";
            pstmt = this.conn.prepareStatement("SELECT COUNT(*) FROM SYSCOLUMNS WHERE TABLE_NAME='SVERS' AND COLUMN_NAME='VERSION' AND DATA_TYPE='GRAPHIC'");
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                this.cp = "ASCII";
            }
            rs.close();
            return;
        }
        catch (SQLException sqle) {
            throw new NametabException("NametabReader", "initNametabReader", ExceptionType.INTERNAL_ERROR, "Unexpected SQL Error occurred: " + sqle.getMessage());
        }
    }

    private Table createNametabTable(String tableName, String schemaName, PreparedStatement selStmt) throws NametabException {
        NametabTable table = null;
        try {
            table = new NametabTable(tableName, schemaName, selStmt, this.version, this.cp, this.unicodeLg, this.skipTwoBytes, this.fieldsAsBlob, this.md);
        }
        catch (NametabException e) {
            if (e instanceof NametabNotFound) {
                table = null;
            }
            throw e;
        }
        return table;
    }
}

