/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.dbds;

import com.sap.sql.jdbc.ExtendedStatement;
import com.sap.sql.jdbc.dbds.DBDSAccess;
import com.sap.sql.jdbc.dbds.DBDSResultSet;
import com.sap.sql.trace.TraceContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class DBDSStatement
implements ExtendedStatement {
    protected ResultSet rs;
    protected Connection conn;
    protected int updCount = -1;

    public DBDSStatement(Connection conn) throws SQLException {
        this.conn = conn;
    }

    public ResultSet executeQuery(String sql, TraceContext traceContext) throws SQLException {
        return this.executeQuery(sql);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        DBDSAccess.dbdsPrepare(sql, null);
        DBDSAccess.dbdsExecuteQuery(null);
        this.rs = new DBDSResultSet();
        return this.rs;
    }

    public int executeUpdate(String sql, TraceContext traceContext) throws SQLException {
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        DBDSAccess.dbdsPrepare(sql, null);
        this.updCount = DBDSAccess.dbdsExecuteUpdate(null);
        return this.updCount;
    }

    public int getUpdateCount() throws SQLException {
        return this.updCount;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public void close() throws SQLException {
        this.conn = null;
        this.updCount = -1;
        this.rs = null;
        DBDSAccess.dbdsFree();
    }

    public void prepareResultSet(Object[] resultSetColumns) throws SQLException {
        if (this.rs != null) {
            ((DBDSResultSet)this.rs).setOutputParams(resultSetColumns);
        }
    }

    public boolean execute(String sql, TraceContext traceContext) throws SQLException {
        return this.execute(sql);
    }

    public boolean execute(String x) throws SQLException {
        DBDSStatement.throwUnsupported("execute");
        return false;
    }

    public ResultSet getResultSet() throws SQLException {
        DBDSStatement.throwUnsupported("getResultSet");
        return null;
    }

    public void clearParameters() throws SQLException {
        DBDSStatement.throwUnsupported("clearParameters");
    }

    public void addBatch() throws SQLException {
        DBDSStatement.throwUnsupported("addBatch");
    }

    public int[] executeBatch() throws SQLException {
        DBDSStatement.throwUnsupported("executeBatch");
        return null;
    }

    public void clearBatch() throws SQLException {
        DBDSStatement.throwUnsupported("clearBatch");
    }

    public void addBatch(String sql) throws SQLException {
        DBDSStatement.throwUnsupported("addBatch");
    }

    public int getFetchSize() throws SQLException {
        DBDSStatement.throwUnsupported("getFetchSize");
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
        DBDSStatement.throwUnsupported("setFetchSize");
    }

    public int getMaxFieldSize() throws SQLException {
        DBDSStatement.throwUnsupported("getMaxFieldSize");
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        DBDSStatement.throwUnsupported("setMaxFieldSize");
    }

    public int getMaxRows() throws SQLException {
        DBDSStatement.throwUnsupported("getMaxRows");
        return 0;
    }

    public void setMaxRows(int max) throws SQLException {
        DBDSStatement.throwUnsupported("setMaxRows");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        DBDSStatement.throwUnsupported("setEscapeProcessing");
    }

    public int getQueryTimeout() throws SQLException {
        DBDSStatement.throwUnsupported("getQueryTimeout");
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        DBDSStatement.throwUnsupported("setQueryTimeout");
    }

    public void cancel() throws SQLException {
        DBDSStatement.throwUnsupported("cancel");
    }

    public void setCursorName(String name) throws SQLException {
        DBDSStatement.throwUnsupported("setCursorName");
    }

    public boolean getMoreResults() throws SQLException {
        DBDSStatement.throwUnsupported("getMoreResults");
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        DBDSStatement.throwUnsupported("setFetchDirection");
    }

    public int getFetchDirection() throws SQLException {
        DBDSStatement.throwUnsupported("getFetchDirection");
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        DBDSStatement.throwUnsupported("getResultSetConcurrency");
        return 0;
    }

    public int getResultSetType() throws SQLException {
        DBDSStatement.throwUnsupported("getResultSetType");
        return 0;
    }

    public void clearWarnings() throws SQLException {
        DBDSStatement.throwUnsupported("clearWarnings");
    }

    public SQLWarning getWarnings() throws SQLException {
        DBDSStatement.throwUnsupported("getWarnings");
        return null;
    }

    protected static void throwUnsupported(String method) {
        throw new UnsupportedOperationException("Method " + method + "() not supported by DBDS JDBC");
    }
}

