/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.jdbc.common.StatementAnalyzer;
import com.sap.sql.log.Syslog;
import com.sap.sql.sqlparser.CollectTablesVisitor;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.sqlparser.CommonSQLStatement;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.trace.SQLTraceContext;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SQLVisitor;
import com.sap.tc.logging.Location;
import java.sql.SQLException;

public class StatementAnalyzerImpl
implements StatementAnalyzer {
    private CommonSQLStatement commonSQLStatement = new CommonSQLStatement();
    private static final Location trace = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$StatementAnalyzerImpl == null ? (class$com$sap$sql$jdbc$common$StatementAnalyzerImpl = StatementAnalyzerImpl.class$("com.sap.sql.jdbc.common.StatementAnalyzerImpl")) : class$com$sap$sql$jdbc$common$StatementAnalyzerImpl));
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$StatementAnalyzerImpl;

    private SQLStatement check(CatalogReader catalogReader, SQLTraceContext traceContext) throws SQLException {
        try {
            this.commonSQLStatement.checkSemantics(catalogReader);
        }
        catch (CommonSQLParserException e) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1123", (Object[])new Object[]{this.commonSQLStatement.getSQLStatement().toSqlString(-1), e.getMessage()}, (Throwable)e);
        }
        SQLStatement stmt = this.commonSQLStatement.getSQLStatement();
        CollectTablesVisitor colTablesVisitor = new CollectTablesVisitor();
        stmt.accept((SQLVisitor)colTablesVisitor);
        if (traceContext != null) {
            traceContext.setTableNames(colTablesVisitor.getTables());
            stmt.setTraceContext((TraceContext)traceContext);
        }
        BufferManager.checkSQLStatement(stmt);
        return stmt;
    }

    private SQLStatement parse(String sql) throws SQLException {
        try {
            this.commonSQLStatement.parse(sql);
            return this.commonSQLStatement.getSQLStatement();
        }
        catch (CommonSQLParserException e) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1122", (Object[])new Object[]{sql, e.getMessage()}, (Throwable)e);
        }
    }

    public SQLStatement parseSyntax(String sql) throws SQLException {
        String methodName = "parseSyntax(String, TraceContext)";
        trace.pathT("parseSyntax(String, TraceContext)");
        return this.parse(sql);
    }

    public SQLStatement preprepareStatement(String sql, CatalogReader reader) throws SQLException {
        return this.preprepareStatement(sql, "", 0, 0L, reader);
    }

    public SQLStatement preprepareStatement(String sql, String progName, int lineNumber, long generationTimeMillis, CatalogReader reader) throws SQLException {
        String methodName = "preprepareStatement(String sql, String progName, int lineNumber, long generationTimeMillis, CatalogReader reader)";
        trace.pathT("preprepareStatement(String sql, String progName, int lineNumber, long generationTimeMillis, CatalogReader reader)");
        this.parse(sql);
        this.check(reader, new SQLTraceContext(generationTimeMillis, progName, lineNumber));
        return this.commonSQLStatement.getSQLStatement();
    }

    public SQLStatement checkSemantics(SQLStatement tree, CatalogReader reader) throws SQLException {
        String methodName = "checkSemantics(SQLStatement tree, CatalogReader reader)";
        trace.pathT("checkSemantics(SQLStatement tree, CatalogReader reader)");
        try {
            this.commonSQLStatement.setStatement(tree);
        }
        catch (CommonSQLParserException e) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1122", (Object[])new Object[]{tree.toSqlString(-1), e.getMessage()}, (Throwable)e);
        }
        return this.check(reader, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

