/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.jdbc.XAResourceWrapper;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.sync.SyncWriter;
import com.sap.sql.tablebuffer.BufferManager;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CommonXAResource
implements XAResource,
XAResourceWrapper {
    private XAResource wrappedXAResource;
    private BufferManager bufferManager;
    private SyncWriter syncWriter;

    CommonXAResource(XAResource xaResource, CommonConnectionContext connectionContext) {
        this.wrappedXAResource = xaResource;
        this.bufferManager = connectionContext.getBufferManager();
        this.syncWriter = connectionContext.getSyncWriter();
    }

    public void start(Xid xid, int flags) throws XAException {
        this.wrappedXAResource.start(xid, flags);
        this.bufferManager.startXA(xid);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.wrappedXAResource.end(xid, flags);
        this.bufferManager.endXA(xid);
    }

    public int prepare(Xid xid) throws XAException {
        if (this.syncWriter != null) {
            try {
                this.syncWriter.flushRequests();
            }
            catch (SQLException syncEx) {
                throw new XAException(syncEx.getMessage());
            }
        }
        return this.wrappedXAResource.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (onePhase && this.syncWriter != null) {
            try {
                this.syncWriter.flushRequests();
            }
            catch (SQLException syncEx) {
                this.bufferManager.rollbackXA(xid);
                try {
                    this.wrappedXAResource.rollback(xid);
                }
                catch (XAException dbEx) {
                    // empty catch block
                }
                throw new XAException(syncEx.getMessage());
            }
        }
        try {
            this.wrappedXAResource.commit(xid, onePhase);
        }
        catch (XAException dbEx) {
            this.bufferManager.rollbackXA(xid);
            throw dbEx;
        }
        this.bufferManager.commitXA(xid);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.syncWriter != null) {
            this.syncWriter.undoRequests();
        }
        this.bufferManager.rollbackXA(xid);
        this.wrappedXAResource.rollback(xid);
    }

    public void forget(Xid xid) throws XAException {
        this.wrappedXAResource.forget(xid);
        this.bufferManager.forgetXA(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.wrappedXAResource.recover(flag);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAResource xar = xares;
        while (xar instanceof XAResourceWrapper) {
            xar = ((XAResourceWrapper)xar).getWrappedXAResource();
        }
        return this.wrappedXAResource.isSameRM(xar);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.wrappedXAResource.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this.wrappedXAResource.getTransactionTimeout();
    }

    public XAResource getWrappedXAResource() {
        return this.wrappedXAResource;
    }
}

