/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.DuplicateKeyException;
import com.sap.sql.jdbc.ExtendedPreparedStatement;
import com.sap.sql.jdbc.ExtendedStatement;
import com.sap.sql.jdbc.ExtendedStatementAdapter;
import com.sap.sql.jdbc.common.AbstractCommonStatement;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonResultSetMetaData;
import com.sap.sql.jdbc.common.CommonStatement;
import com.sap.sql.log.Syslog;
import com.sap.sql.tablebuffer.BufferCommonStatement;
import com.sap.sql.tablebuffer.BufferStatement;
import com.sap.sql.tabstat.TableStatistics;
import com.sap.sql.trace.SQLTraceContext;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.SQLStatement;
import com.sap.tc.logging.Location;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommonStatementImpl
extends AbstractCommonStatement
implements CommonStatement,
BufferCommonStatement {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$CommonStatementImpl == null ? (class$com$sap$sql$jdbc$common$CommonStatementImpl = CommonStatementImpl.class$("com.sap.sql.jdbc.common.CommonStatementImpl")) : class$com$sap$sql$jdbc$common$CommonStatementImpl));
    private ExtendedStatement wrappedStmt = null;
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$CommonStatementImpl;

    public CommonStatementImpl(CommonConnectionContext connectionContext) {
        super(connectionContext);
    }

    public ResultSet executeQuery(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        this.validate();
        return this.executeQuery(tree, (TraceContext)new SQLTraceContext(timestamp, source, line));
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.validate();
        if (null == sql) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"sql"});
        }
        SQLStatement tree = this.connectionContext.getStatementAnalyzer().preprepareStatement(sql, this.connectionContext.getCatalogReader());
        return this.executeQuery(tree, null);
    }

    public final int executeUpdate(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        this.validate();
        return this.executeUpdate(tree, (TraceContext)new SQLTraceContext(timestamp, source, line));
    }

    public int executeUpdate(String sql) throws SQLException {
        this.validate();
        if (null == sql) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{sql});
        }
        SQLStatement tree = this.connectionContext.getStatementAnalyzer().preprepareStatement(sql, this.connectionContext.getCatalogReader());
        return this.executeUpdate(tree, null);
    }

    public final boolean execute(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        this.validate();
        return this.execute(tree, (TraceContext)new SQLTraceContext(timestamp, source, line));
    }

    public boolean execute(String sql) throws SQLException {
        this.validate();
        if (null == sql) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{sql});
        }
        SQLStatement tree = this.connectionContext.getStatementAnalyzer().preprepareStatement(sql, this.connectionContext.getCatalogReader());
        return this.execute(tree, null);
    }

    public final ExtendedStatement getDbStmt(int stmtType) throws SQLException {
        if (this.wrappedDbStmt == null) {
            Statement stmt = this.connectionContext.getWrappedConnection().createStatement();
            this.wrappedDbStmt = stmt instanceof ExtendedStatement ? (ExtendedStatement)stmt : new ExtendedStatementAdapter(stmt);
            this.initStmt((Statement)this.wrappedDbStmt);
        }
        if (stmtType >= 0) {
            this.commonConnection.setActiveTransactionState(stmtType, -1);
        }
        return this.wrappedDbStmt;
    }

    public ExtendedPreparedStatement getDbPrepStmt() throws SQLException {
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getDbPrepStmt()");
    }

    public final void addBatch(String sql) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"addBatch(String)");
    }

    public final void clearBatch() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"clearBatch()");
    }

    public final int[] executeBatch() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"executeBatch()");
    }

    protected final void invalidate() {
        this.wrappedStmt = null;
    }

    final void setURL(int parameterIndex, URL x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"setURL()");
    }

    private final boolean execute(SQLStatement tree, TraceContext traceContext) throws SQLException {
        if (tree instanceof GeneralSelectStatement) {
            this.executeQuery(tree, traceContext);
            return true;
        }
        this.executeUpdate(tree, traceContext);
        return false;
    }

    private ResultSet executeQuery(SQLStatement tree, TraceContext traceContext) throws SQLException {
        String methodName = "executeQuery()";
        if (TRACE.bePath()) {
            TRACE.entering("executeQuery()");
        }
        try {
            this.updateCount = -1;
            this.closeResultSet();
            switch (tree.getStatementType()) {
                case 2: {
                    break;
                }
                case 32: {
                    if (!this.connectionContext.getConnection().getAutoCommit()) break;
                    throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1102", null);
                }
                default: {
                    throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1103", (Object[])new Object[]{tree.getStatementTypeName(), "executeQuery()"});
                }
            }
            if (TableStatistics.isSwitchedOn()) {
                this.gatherTableStatistics(tree, 1L);
            }
            CommonResultSetMetaData md = this.createMetaData((GeneralSelectStatement)tree);
            String stmt = this.setWrappedStmt(tree);
            ResultSet basicResultSet = this.wrappedStmt.executeQuery(stmt, traceContext);
            this.wrappedStmt.prepareResultSet((Object[])((GeneralSelectStatement)tree).getResultSetColumns());
            this.resultSet = this.createResultSet(this, basicResultSet, md, this.pedanticTypeChecking, tree);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return this.resultSet;
    }

    private int executeUpdate(SQLStatement tree, TraceContext traceContext) throws SQLException {
        String methodName = "executeUpdate()";
        if (TRACE.bePath()) {
            TRACE.entering("executeUpdate()");
        }
        this.closeResultSet();
        this.updateCount = -1;
        try {
            switch (tree.getStatementType()) {
                case 4: 
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1103", (Object[])new Object[]{tree.getStatementTypeName(), "executeUpdate()"});
                }
            }
            if (TableStatistics.isSwitchedOn()) {
                this.gatherTableStatistics(tree, 1L);
            }
            try {
                String stmt = this.setWrappedStmt(tree);
                this.updateCount = this.wrappedStmt.executeUpdate(stmt, traceContext);
            }
            catch (SQLException sqlEx) {
                throw this.isDuplicateKeyException(sqlEx) ? new DuplicateKeyException(sqlEx) : sqlEx;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return this.updateCount;
    }

    private String setWrappedStmt(SQLStatement tree) throws SQLException {
        this.setStatement(tree);
        this.wrappedStmt = this.bufferManager.checkStatement(this.connectionContext, tree, (BufferStatement)this.wrappedBufStmt, this);
        if (this.wrappedStmt != null) {
            this.wrappedBufStmt = this.wrappedStmt;
            this.initStmt((Statement)this.wrappedBufStmt);
            this.commonConnection.setActiveTransactionStateMin();
            return null;
        }
        this.wrappedStmt = this.getDbStmt(tree.getStatementType());
        return this.getStatementString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

