/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import java.io.IOException;
import java.io.InputStream;

final class CommonSecureLengthInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final int expectedLength;
    private int bytesRead = 0;

    CommonSecureLengthInputStream(InputStream aStream, int aLength) {
        this.wrappedStream = aStream;
        this.expectedLength = aLength;
    }

    public int read() throws IOException {
        int value = this.wrappedStream.read();
        if (value == -1) {
            if (this.bytesRead < this.expectedLength) {
                throw new IOException("unexpected end of stream");
            }
        } else {
            ++this.bytesRead;
            if (this.bytesRead > this.expectedLength) {
                throw new IOException("stream exeeds expected length");
            }
        }
        return value;
    }

    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    public void close() throws IOException {
        this.wrappedStream.close();
    }
}

