/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonResultSetMetaData;
import com.sap.sql.jdbc.common.CommonWrappedBlob;
import com.sap.sql.jdbc.common.CommonWrappedClob;
import com.sap.sql.jdbc.common.UTCCalendar;
import com.sap.sql.log.Syslog;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CommonResultSet
implements ResultSet {
    protected CommonConnectionContext connectionContext;
    protected Statement stmt;
    protected ResultSet rs;
    private static final Location trace = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$CommonResultSet == null ? (class$com$sap$sql$jdbc$common$CommonResultSet = CommonResultSet.class$("com.sap.sql.jdbc.common.CommonResultSet")) : class$com$sap$sql$jdbc$common$CommonResultSet));
    private boolean doTracePath = trace.bePath();
    private CommonResultSetMetaData md;
    private boolean pedanticTypeChecking;
    private HashMap columnMap = null;
    private Object[] lobMap;
    private boolean[] indexGetAllowed;
    private boolean isClosed = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$CommonResultSet;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    CommonResultSet(CommonConnectionContext connectionContext, Statement stmt, ResultSet rs, CommonResultSetMetaData md, boolean pedantic, boolean isSelectAsterisk) throws SQLException {
        this.connectionContext = connectionContext;
        this.stmt = stmt;
        this.rs = rs;
        this.md = md;
        this.pedanticTypeChecking = pedantic;
        this.indexGetAllowed = new boolean[md.getColumnCount()];
        if (isSelectAsterisk) {
            Arrays.fill(this.indexGetAllowed, false);
        } else {
            Arrays.fill(this.indexGetAllowed, true);
        }
        this.lobMap = null;
        this.columnMap = md.getColumnMap();
    }

    public Array getArray(int i) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getArray(int)");
    }

    public Array getArray(String colName) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getArray(String)");
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getAsciiStream(int)");
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getAsciiStream(int)");
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Byte.TYPE);
        return this.rs.getByte(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        return this.rs.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getBigDecimal(int, int)");
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getBigDecimal(int, String)");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        ResultDescriptor rd = this.checkColumnType(columnIndex, class$java$io$InputStream == null ? (class$java$io$InputStream = CommonResultSet.class$("java.io.InputStream")) : class$java$io$InputStream);
        if (rd.getJdbcType() == 2004) {
            Blob blob = this.getBlob(columnIndex);
            if (null == blob) {
                return null;
            }
            return blob.getBinaryStream();
        }
        byte[] rsBytes = this.rs.getBytes(columnIndex);
        return null != rsBytes ? new ByteArrayInputStream(rsBytes) : null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, class$java$sql$Blob == null ? (class$java$sql$Blob = CommonResultSet.class$("java.sql.Blob")) : class$java$sql$Blob);
        if (this.lobMap == null) {
            this.lobMap = new Object[this.md.getColumnCount()];
        }
        if (null == this.lobMap[columnIndex - 1]) {
            this.lobMap[columnIndex - 1] = this.createBlob(columnIndex);
        }
        return (Blob)this.lobMap[columnIndex - 1];
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Boolean.TYPE);
        return this.rs.getBoolean(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        ResultDescriptor rd = this.checkColumnType(columnIndex, array$B == null ? (array$B = CommonResultSet.class$("[B")) : array$B);
        if (rd.getJdbcType() == 2004) {
            Blob blob = this.getBlob(columnIndex);
            if (null == blob) {
                return null;
            }
            return blob.getBytes(1L, (int)blob.length());
        }
        return this.rs.getBytes(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        ResultDescriptor rd = this.checkColumnType(columnIndex, class$java$io$Reader == null ? (class$java$io$Reader = CommonResultSet.class$("java.io.Reader")) : class$java$io$Reader);
        if (rd.getJdbcType() == 2005) {
            Clob clob = this.getClob(columnIndex);
            if (null == clob) {
                return null;
            }
            return clob.getCharacterStream();
        }
        String rsString = this.rs.getString(columnIndex);
        if (null != rsString) {
            return new StringReader(rsString);
        }
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, class$java$sql$Clob == null ? (class$java$sql$Clob = CommonResultSet.class$("java.sql.Clob")) : class$java$sql$Clob);
        if (this.lobMap == null) {
            this.lobMap = new Object[this.md.getColumnCount()];
        }
        if (null == this.lobMap[columnIndex - 1]) {
            this.lobMap[columnIndex - 1] = this.createClob(columnIndex);
        }
        return (Clob)this.lobMap[columnIndex - 1];
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public int getConcurrency() throws SQLException {
        this.validate();
        return 1007;
    }

    public String getCursorName() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getCursorName()");
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, class$java$sql$Date == null ? (class$java$sql$Date = CommonResultSet.class$("java.sql.Date")) : class$java$sql$Date);
        return this.rs.getDate(columnIndex);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getDate(int, Calendar)");
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getDate(String, Calendar)");
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Double.TYPE);
        return this.rs.getDouble(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public int getFetchDirection() throws SQLException {
        this.validate();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getFetchSize()");
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Float.TYPE);
        return this.rs.getFloat(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Integer.TYPE);
        return this.rs.getInt(columnIndex);
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Long.TYPE);
        return this.rs.getLong(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.validate();
        return this.md;
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.validate();
        ResultDescriptor col = this.md.getColumn(columnIndex);
        Class clazz = col.defaultMapping();
        if (clazz == Short.TYPE) {
            short value = this.getShort(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Short(value);
        }
        if (clazz == Integer.TYPE) {
            int value = this.getInt(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Integer(value);
        }
        if (clazz == Long.TYPE) {
            long value = this.getLong(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Long(value);
        }
        if (clazz == Float.TYPE) {
            float value = this.getFloat(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Float(value);
        }
        if (clazz == Double.TYPE) {
            double value = this.getDouble(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Double(value);
        }
        if (clazz == Boolean.TYPE) {
            boolean value = this.getBoolean(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Boolean(value);
        }
        if (clazz == Byte.TYPE) {
            byte value = this.getByte(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new Byte(value);
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = CommonResultSet.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getString(columnIndex);
        }
        if (clazz == (array$B == null ? (array$B = CommonResultSet.class$("[B")) : array$B)) {
            return this.getBytes(columnIndex);
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return this.getBigDecimal(columnIndex);
        }
        if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = CommonResultSet.class$("java.sql.Date")) : class$java$sql$Date)) {
            return this.getDate(columnIndex);
        }
        if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = CommonResultSet.class$("java.sql.Time")) : class$java$sql$Time)) {
            return this.getTime(columnIndex);
        }
        if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CommonResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return this.getTimestamp(columnIndex);
        }
        if (clazz == (class$java$io$Reader == null ? (class$java$io$Reader = CommonResultSet.class$("java.io.Reader")) : class$java$io$Reader)) {
            return this.getCharacterStream(columnIndex);
        }
        if (clazz == (class$java$io$InputStream == null ? (class$java$io$InputStream = CommonResultSet.class$("java.io.InputStream")) : class$java$io$InputStream)) {
            return this.getBinaryStream(columnIndex);
        }
        if (clazz == (class$java$sql$Clob == null ? (class$java$sql$Clob = CommonResultSet.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            return this.getClob(columnIndex);
        }
        if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = CommonResultSet.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return this.getBlob(columnIndex);
        }
        throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1118", (Object[])new Object[]{new Integer(columnIndex), col.getJdbcTypeName(), clazz.getName()});
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getObject(int, Map)");
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getObject(String, Map)");
    }

    public Ref getRef(int i) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getRef(int)");
    }

    public Ref getRef(String colName) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getRef(int)");
    }

    public int getRow() throws SQLException {
        this.validate();
        return this.rs.getRow();
    }

    public short getShort(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, Short.TYPE);
        return this.rs.getShort(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public Statement getStatement() throws SQLException {
        this.validate();
        return this.stmt;
    }

    public String getString(int columnIndex) throws SQLException {
        ResultDescriptor rd = this.checkColumnType(columnIndex, class$java$lang$String == null ? (class$java$lang$String = CommonResultSet.class$("java.lang.String")) : class$java$lang$String);
        String result = null;
        if (rd.getJdbcType() == 2005) {
            Clob clob = this.getClob(columnIndex);
            if (null != clob) {
                result = clob.getSubString(1L, (int)clob.length());
            }
        } else {
            result = this.rs.getString(columnIndex);
            if (result != null && result.length() == 0) {
                result = " ";
            }
        }
        return result;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, class$java$sql$Time == null ? (class$java$sql$Time = CommonResultSet.class$("java.sql.Time")) : class$java$sql$Time);
        return this.rs.getTime(columnIndex);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getTime(int, Calendar)");
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getTime(String, Calendar)");
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkColumnType(columnIndex, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CommonResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        return this.rs.getTimestamp(columnIndex, UTCCalendar.getInstance());
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public int getType() throws SQLException {
        this.validate();
        return 1003;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getUnicodeStream(int)");
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"getUnicodeStream(String)");
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed) {
            return null;
        }
        return this.rs.getWarnings();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() throws SQLException {
        boolean result = false;
        if (this.doTracePath) {
            trace.entering("next()");
        }
        this.lobMap = null;
        try {
            this.validate();
            result = this.rs.next();
            Object var3_2 = null;
            if (!this.doTracePath) return result;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.doTracePath) throw throwable;
            trace.exiting((Object)new Boolean(result));
            throw throwable;
        }
        trace.exiting((Object)new Boolean(result));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        block10: {
            block8: {
                block9: {
                    if (this.doTracePath) {
                        trace.entering("close()");
                    }
                    try {
                        if (this.isClosed) {
                            Object var2_1 = null;
                            if (this.isClosed) break block8;
                            break block9;
                        }
                        if (this.rs != null) {
                            this.rs.close();
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        if (!this.isClosed && this.connectionContext.getState() == 0) {
                            this.columnMap = null;
                            this.connectionContext = null;
                            this.indexGetAllowed = null;
                            this.lobMap = null;
                            this.md = null;
                            this.rs = null;
                            this.stmt = null;
                        }
                        this.isClosed = true;
                        if (!this.doTracePath) throw throwable;
                        trace.exiting();
                        throw throwable;
                    }
                }
                if (this.connectionContext.getState() == 0) {
                    this.columnMap = null;
                    this.connectionContext = null;
                    this.indexGetAllowed = null;
                    this.lobMap = null;
                    this.md = null;
                    this.rs = null;
                    this.stmt = null;
                }
            }
            this.isClosed = true;
            if (!this.doTracePath) return;
            trace.exiting();
            return;
        }
        Object var2_2 = null;
        if (!this.isClosed && this.connectionContext.getState() == 0) {
            this.columnMap = null;
            this.connectionContext = null;
            this.indexGetAllowed = null;
            this.lobMap = null;
            this.md = null;
            this.rs = null;
            this.stmt = null;
        }
        this.isClosed = true;
        if (!this.doTracePath) return;
        trace.exiting();
    }

    public boolean wasNull() throws SQLException {
        this.validate();
        return this.rs.wasNull();
    }

    public void clearWarnings() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.rs.clearWarnings();
    }

    public int findColumn(String columnName) throws SQLException {
        this.validate();
        String upper = columnName.toUpperCase();
        Integer value = (Integer)this.columnMap.get(upper);
        if (value != null) {
            int index = value;
            this.indexGetAllowed[index - 1] = true;
            return index;
        }
        throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1116", (Object[])new Object[]{columnName});
    }

    public boolean isBeforeFirst() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"isBeforeFirst()");
    }

    public boolean isAfterLast() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"isAfterLast()");
    }

    public boolean isFirst() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"isFirst()");
    }

    public boolean isLast() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"isLast()");
    }

    public void beforeFirst() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"beforeFirst()");
    }

    public void afterLast() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"afterLast()");
    }

    public boolean first() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"first()");
    }

    public boolean last() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"last()");
    }

    public boolean absolute(int row) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"absolute(int)");
    }

    public boolean relative(int rows) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"relative(int)");
    }

    public boolean previous() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"previous(int)");
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"setFetchDirection(int)");
    }

    public void setFetchSize(int rows) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"setFetchSize(int)");
    }

    public boolean rowUpdated() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"rowUpdated()");
    }

    public boolean rowInserted() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"rowInserted()");
    }

    public boolean rowDeleted() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"rowDeleted()");
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateNull(int)");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBoolean(int, boolean)");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateByte(int, byte)");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateShort(int, short)");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateInt(int, int)");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateLong(int, long)");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateFloat(int, float)");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateDouble(int, double)");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBigDecimal(int, BigDecimal)");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateString(int, String)");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBytes(int, byte[])");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateDate(int, Date)");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"last()");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateTimestamp(int, Timestamp)");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateAsciiStream(int, InputStream, int)");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBinaryStream(int, InputStream, int)");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateCharacterStream(int, Reader, int)");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateObject(int, Object, int)");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateObjec(int, Object)");
    }

    public void updateNull(String columnName) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateNull(String)");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBoolean(String, boolean)");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateByte(String, byte)");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateShort(String, short)");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateInt(String, int)");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateLong(String, long)");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateFloat(String, float)");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateDouble(String, double)");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBigDecimal(String, BigDecimal)");
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateString(String, String)");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBytes(String, byte[])");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateDate(String, Date)");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateTime(String, Time)");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateTimestamp(String, Timestamp)");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateAsciiStream(String, InputStream, int)");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateBinaryStream(String, InputStream, int)");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateCharacterStream(String, Reader, int)");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateObject(String, Object, int)");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateObject(String, Object)");
    }

    public void insertRow() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"insertRow()");
    }

    public void updateRow() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"updateRow()");
    }

    public void deleteRow() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"deleteRow()");
    }

    public void refreshRow() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"refreshRow()");
    }

    public void cancelRowUpdates() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"cancelRowUpdates()");
    }

    public void moveToInsertRow() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"moveToInsertRow()");
    }

    public void moveToCurrentRow() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError((Object)this, (String)"moveToCurrentRow()");
    }

    protected void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql_0017", (Object[])new Object[]{this});
        }
    }

    protected Blob createBlob(int columnIndex) throws SQLException {
        Blob basicBlob = this.rs.getBlob(columnIndex);
        if (null == basicBlob) {
            return null;
        }
        return new CommonWrappedBlob(basicBlob, this.connectionContext.getConnection());
    }

    protected Clob createClob(int columnIndex) throws SQLException {
        Clob basicClob = this.rs.getClob(columnIndex);
        if (null == basicClob) {
            return null;
        }
        return new CommonWrappedClob(basicClob, this.connectionContext.getConnection());
    }

    private ResultDescriptor checkColumnType(int columnIndex, Class javaClass) throws SQLException {
        this.validate();
        if (!this.indexGetAllowed[columnIndex - 1]) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1117", null);
        }
        ResultDescriptor col = this.md.getColumn(columnIndex);
        if (!col.isGetableInto(javaClass, this.pedanticTypeChecking)) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql.jdbc.common_1118", (Object[])new Object[]{new Integer(columnIndex), col.getJdbcTypeName(), javaClass.getName()});
        }
        return col;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

