/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.exception.BaseRuntimeException;
import com.sap.sql.jdbc.ExtendedPooledConnection;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonConnectionFactory;
import com.sap.sql.jdbc.common.CommonConnectionImpl;
import com.sap.sql.jdbc.common.CommonContextFactory;
import com.sap.sql.log.OpenSQLException;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class CommonPooledConnection
implements PooledConnection,
ConnectionEventListener {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$CommonPooledConnection == null ? (class$com$sap$sql$jdbc$common$CommonPooledConnection = CommonPooledConnection.class$("com.sap.sql.jdbc.common.CommonPooledConnection")) : class$com$sap$sql$jdbc$common$CommonPooledConnection));
    private final ConnectionEvent closeEvent = new ConnectionEvent(this);
    private CommonContextFactory factory;
    private CommonConnectionContext connContext;
    private PooledConnection pooledConn = null;
    private Connection physicalConn;
    private Connection logicalConn = null;
    private ArrayList listeners = new ArrayList();
    private boolean supportsUncommitedRead;
    private boolean isClosed = false;
    private boolean listenerNotifying = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$CommonPooledConnection;

    CommonPooledConnection(PooledConnection pooledConnection, CommonContextFactory factory) throws SQLException {
        this.pooledConn = pooledConnection;
        this.factory = factory;
        this.connContext = factory.getCommonConnectionContext();
        this.physicalConn = this.connContext.getWrappedConnection();
        this.supportsUncommitedRead = this.physicalConn.getMetaData().supportsTransactionIsolationLevel(1);
    }

    public Connection getConnection() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("getConnection()");
        }
        try {
            this.validate();
            if (this.logicalConn != null) {
                try {
                    this.logicalConn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.logicalConn = CommonConnectionFactory.createCommonConnectionHandle(this, this.factory);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return this.logicalConn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        block15: {
            block13: {
                block14: {
                    if (TRACE.bePath()) {
                        TRACE.entering("close()");
                    }
                    try {
                        if (this.isClosed) {
                            Object var3_1 = null;
                            if (this.isClosed) break block13;
                            break block14;
                        }
                        if (this.logicalConn != null) {
                            try {
                                this.logicalConn.close();
                            }
                            catch (SQLException ex) {
                                // empty catch block
                            }
                        }
                        try {
                            this.physicalConn.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        if (this.pooledConn != null) {
                            this.pooledConn.close();
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        if (!this.isClosed && this.connContext.getState() == 0) {
                            CommonContextFactory.closeCommonConnectionContext(this.connContext, true);
                            this.connContext = null;
                            this.factory = null;
                            this.listeners = null;
                            this.logicalConn = null;
                            this.physicalConn = null;
                            this.pooledConn = null;
                        }
                        this.isClosed = true;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting();
                        throw throwable;
                    }
                }
                if (this.connContext.getState() == 0) {
                    CommonContextFactory.closeCommonConnectionContext(this.connContext, true);
                    this.connContext = null;
                    this.factory = null;
                    this.listeners = null;
                    this.logicalConn = null;
                    this.physicalConn = null;
                    this.pooledConn = null;
                }
            }
            this.isClosed = true;
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var3_2 = null;
        if (!this.isClosed && this.connContext.getState() == 0) {
            CommonContextFactory.closeCommonConnectionContext(this.connContext, true);
            this.connContext = null;
            this.factory = null;
            this.listeners = null;
            this.logicalConn = null;
            this.physicalConn = null;
            this.pooledConn = null;
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (TRACE.bePath()) {
            TRACE.entering("addConnectionEventListener(ConnectionEventListener)", new Object[]{listener});
        }
        try {
            this.validateRTE();
            this.listeners.add(listener);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (TRACE.bePath()) {
            TRACE.entering("removeConnectionEventListener(ConnectionEventListener)", new Object[]{listener});
        }
        try {
            this.validateRTE();
            ((AbstractCollection)this.listeners).remove(listener);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void connectionClosed(ConnectionEvent event) {
        this.validateRTE();
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this.validateRTE();
        this.connectionErrorOccurred(event.getSQLException());
    }

    void connectionClosed() {
        if (TRACE.bePath()) {
            TRACE.entering("connectionClosed()");
        }
        try {
            this.validateRTE();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ConnectionEventListener)this.listeners.get(i)).connectionClosed(this.closeEvent);
                ++i;
            }
            if (this.pooledConn != null && this.pooledConn instanceof ExtendedPooledConnection) {
                ((ExtendedPooledConnection)this.pooledConn).connectionHandleClosed();
            }
            Object var3_2 = null;
            this.logicalConn = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.logicalConn = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void connectionErrorOccurred(SQLException exception) {
        block9: {
            block8: {
                if (TRACE.bePath()) {
                    TRACE.entering("connectionErrorOccurred(SQLException)", new Object[]{exception});
                }
                try {
                    this.validateRTE();
                    if (this.listenerNotifying) {
                        Object var4_2 = null;
                        this.listenerNotifying = false;
                        break block8;
                    }
                    if (this.logicalConn != null) {
                        ((CommonConnectionImpl)((Object)this.logicalConn)).getConnectionContext().setState(1);
                    } else {
                        this.connContext.setState(1);
                    }
                    this.listenerNotifying = true;
                    int i = 0;
                    while (true) {
                        if (i >= this.listeners.size()) {
                            break block9;
                        }
                        ((ConnectionEventListener)this.listeners.get(i)).connectionErrorOccurred(new ConnectionEvent(this, exception));
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.listenerNotifying = false;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_3 = null;
        this.listenerNotifying = false;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    boolean supportsUncommitedRead() {
        return this.supportsUncommitedRead;
    }

    private void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql_0004", (Object[])new Object[]{this});
        }
    }

    private void validateRTE() {
        if (this.isClosed) {
            OpenSQLException ex = Syslog.createAndLogOpenSQLException((Object)this, (String)"com.sap.sql_0004", (Object[])new Object[]{this});
            throw new BaseRuntimeException((Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

