/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.impl.CatalogBufferManagerImpl;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.DataSourceContext;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.StatementAnalyzer;
import com.sap.sql.jdbc.common.StatementAnalyzerImpl;
import com.sap.sql.sync.SyncWriter;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.tablebuffer.BufferManagerFactory;

public class CommonContextFactory
extends ContextFactory {
    private CommonConnectionContextImpl context;

    public ConnectionContext createConnectionContext(DataSourceContext dataSourceContext) {
        return this.createCommonConnectionContext(dataSourceContext);
    }

    public CommonConnectionContext createCommonConnectionContext(DataSourceContext dataSourceContext) {
        this.context = new CommonConnectionContextImpl(dataSourceContext);
        this.cloneContext = this.context;
        ((ContextFactory)this).context = this.context;
        return this.context;
    }

    public ConnectionContext createConnectionContextClone() {
        return this.createCommonConnectionContextClone();
    }

    public CommonConnectionContext createCommonConnectionContextClone() {
        this.context = new CommonConnectionContextImpl((CommonConnectionContextImpl)this.cloneContext);
        ((ContextFactory)this).context = this.context;
        return this.context;
    }

    public CommonConnectionContext getCommonConnectionContext() {
        return this.context;
    }

    public static void closeCommonConnectionContext(CommonConnectionContext context, boolean release) {
        if (release) {
            CatalogBufferManagerImpl.releaseCatalogBuffer(context.getConnectionID());
            BufferManagerFactory.releaseBufferManager(context);
        }
        ContextFactory.closeConnectionContext((ConnectionContext)context);
        CommonConnectionContextImpl ctx = (CommonConnectionContextImpl)context;
        ctx.catalogSyncID = null;
        ctx.bufferSyncID = null;
        ctx.syncWriter = null;
        ctx.catalogReader = null;
        ctx.bufferManager = null;
        ctx.statementAnalyzer = null;
    }

    public void setCatalogSyncID(String catalogSyncID) {
        this.context.catalogSyncID = catalogSyncID;
    }

    public void setBufferSyncID(String bufferSyncID) {
        this.context.bufferSyncID = bufferSyncID;
    }

    public void setSyncWriter(SyncWriter syncWriter) {
        this.context.syncWriter = syncWriter;
    }

    public void setCatalogReader(CatalogReader catalogReader) {
        this.context.catalogReader = catalogReader;
        this.context.statementAnalyzer = new StatementAnalyzerImpl();
    }

    public void setBufferManager(BufferManager bufferManager) {
        this.context.bufferManager = bufferManager;
    }

    private class CommonConnectionContextImpl
    extends ContextFactory.ConnectionContextImpl
    implements CommonConnectionContext {
        private String catalogSyncID;
        private String bufferSyncID;
        private SyncWriter syncWriter;
        private CatalogReader catalogReader;
        private BufferManager bufferManager;
        private StatementAnalyzer statementAnalyzer;

        protected CommonConnectionContextImpl(DataSourceContext dataSourceContext) {
            super(dataSourceContext);
            super.setCommonSQL(true);
        }

        protected CommonConnectionContextImpl(CommonConnectionContextImpl parent) {
            super((ContextFactory.ConnectionContextImpl)parent);
            this.catalogSyncID = parent.catalogSyncID;
            this.bufferSyncID = parent.bufferSyncID;
            this.syncWriter = parent.syncWriter;
            this.catalogReader = parent.catalogReader;
            this.bufferManager = parent.bufferManager;
            this.statementAnalyzer = parent.statementAnalyzer;
        }

        public String getCatalogSyncID() {
            return this.catalogSyncID;
        }

        public String getBufferSyncID() {
            return this.bufferSyncID;
        }

        public SyncWriter getSyncWriter() {
            return this.syncWriter;
        }

        public CatalogReader getCatalogReader() {
            return this.catalogReader;
        }

        public BufferManager getBufferManager() {
            return this.bufferManager;
        }

        public StatementAnalyzer getStatementAnalyzer() {
            return this.statementAnalyzer;
        }
    }
}

