/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.CatalogReaderFactory;
import com.sap.sql.catalog.impl.CatalogBufferManagerImpl;
import com.sap.sql.j2ee.EventRegistry;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ConnectionWrapper;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.jdbc.common.CommonClientConnectionImpl;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonConnectionImpl;
import com.sap.sql.jdbc.common.CommonContextFactory;
import com.sap.sql.jdbc.common.CommonPooledConnection;
import com.sap.sql.jdbc.common.CommonXAConnection;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncReaderFactory;
import com.sap.sql.sync.SyncWriter;
import com.sap.sql.sync.SyncWriterFactory;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.tablebuffer.BufferManagerFactory;
import com.sap.sql.tabstat.TableStatistics;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

public class CommonConnectionFactory {
    public static final String CONNECTION_NAME = "jndiName";
    public static final String CATALOG_READER_URI = "com.sap.sql.catalog.reader.uri";

    private CommonConnectionFactory() {
    }

    public static Connection createCommonConnection(Connection basicConnection, Properties properties) throws SQLException {
        return CommonConnectionFactory.createConnection(basicConnection, properties, false);
    }

    public static Connection createCommonClientConnection(Connection basicConnection, Properties properties) throws SQLException {
        return CommonConnectionFactory.createConnection(basicConnection, properties, true);
    }

    public static PooledConnection createCommonPooledConnection(Connection basicConnection, Properties properties) throws SQLException {
        PooledConnection wrappedPooledConnection = DirectConnectionFactory.createDirectPooledConnection((Connection)basicConnection, (Properties)properties);
        Connection wrappedConnection = wrappedPooledConnection.getConnection();
        CommonContextFactory factory = CommonConnectionFactory.createCommonContextFactory(wrappedConnection);
        CommonPooledConnection pooledConnection = new CommonPooledConnection(wrappedPooledConnection, factory);
        wrappedPooledConnection.addConnectionEventListener(pooledConnection);
        return pooledConnection;
    }

    public static PooledConnection createCommonPooledConnection(PooledConnection basicPooledConnection, Properties properties) throws SQLException {
        PooledConnection wrappedPooledConnection = DirectConnectionFactory.createDirectPooledConnection((PooledConnection)basicPooledConnection, (Properties)properties);
        Connection wrappedConnection = wrappedPooledConnection.getConnection();
        CommonContextFactory factory = CommonConnectionFactory.createCommonContextFactory(wrappedConnection);
        CommonPooledConnection pooledConnection = new CommonPooledConnection(wrappedPooledConnection, factory);
        basicPooledConnection.addConnectionEventListener(pooledConnection);
        return pooledConnection;
    }

    public static XAConnection createCommonXAConnection(XAConnection basicXAConnection, Properties properties) throws SQLException {
        XAConnection wrappedXAConnection = DirectConnectionFactory.createDirectXAConnection((XAConnection)basicXAConnection, (Properties)properties);
        Connection wrappedConnection = wrappedXAConnection.getConnection();
        CommonContextFactory factory = CommonConnectionFactory.createCommonContextFactory(wrappedConnection);
        CommonXAConnection xaConnection = new CommonXAConnection(wrappedXAConnection, factory);
        basicXAConnection.addConnectionEventListener(xaConnection);
        return xaConnection;
    }

    static Connection createCommonConnectionHandle(CommonPooledConnection pooledConnection, CommonContextFactory factory) throws SQLException {
        CommonConnectionContext context = factory.createCommonConnectionContextClone();
        CommonConnectionImpl conn = new CommonConnectionImpl(pooledConnection, context);
        factory.setConnection((Connection)((Object)conn));
        return conn;
    }

    private static Connection createConnection(Connection basicConnection, Properties properties, boolean client) throws SQLException {
        Connection wrappedConnection = DirectConnectionFactory.createDirectConnection((Connection)basicConnection, (Properties)properties);
        CommonContextFactory factory = CommonConnectionFactory.createCommonContextFactory(wrappedConnection);
        CommonConnectionContext dstContext = factory.getCommonConnectionContext();
        CommonConnectionImpl connection = client ? new CommonClientConnectionImpl(dstContext) : new CommonConnectionImpl(dstContext);
        factory.setConnection((Connection)((Object)connection));
        return connection;
    }

    private static CommonContextFactory createCommonContextFactory(Connection wrappedConnection) throws SQLException {
        ConnectionContext srcContext = ((ConnectionWrapper)wrappedConnection).getConnectionContext();
        Properties srcProperties = srcContext.getProperties();
        VMContext.initInstance((Properties)srcProperties);
        EventRegistry.initInstance(srcProperties);
        CommonContextFactory factory = new CommonContextFactory();
        CommonConnectionContext dstContext = factory.createCommonConnectionContext(srcContext.getDataSourceContext());
        String connectionID = srcContext.getConnectionID();
        String catalogSyncID = CatalogBufferManagerImpl.getCatalogSyncID(connectionID);
        String bufferSyncID = BufferManagerFactory.getBufferSyncID(connectionID);
        factory.setWrappedConnection(wrappedConnection);
        factory.setConnectionID(connectionID);
        factory.setUserName(srcContext.getUserName());
        factory.setStatementPool(srcContext.getStatementPool());
        factory.setDbPortingServices(srcContext.getDbPortingServices());
        factory.setSQLExceptionAnalyzer(srcContext.getSQLExceptionAnalyzer());
        factory.setAutoCommit(srcContext.getAutoCommit());
        factory.setTransactionIsolation(srcContext.getTransactionIsolation());
        factory.setProperties(srcProperties);
        factory.setCatalogSyncID(catalogSyncID);
        factory.setBufferSyncID(bufferSyncID);
        int entryCount = Integer.parseInt(srcProperties.getProperty("com.sap.sql.catalog.buffer.entrycount"));
        String uri = srcProperties.getProperty(CATALOG_READER_URI);
        if (uri == null) {
            String schema = srcProperties.getProperty("com.sap.sql.catalog.reader.schema");
            uri = schema + "://" + connectionID;
        }
        CatalogReader catalogReader = CatalogReaderFactory.isConnectionRequired(uri) ? CatalogReaderFactory.createCatalogReader(uri, entryCount, wrappedConnection) : CatalogReaderFactory.createCatalogReader(uri, entryCount);
        factory.setCatalogReader(catalogReader);
        BufferManager bufferManager = BufferManagerFactory.createBufferManager(dstContext);
        factory.setBufferManager(bufferManager);
        SyncWriter syncWriter = SyncWriterFactory.createSyncWriter(dstContext);
        if (syncWriter != null) {
            factory.setSyncWriter(syncWriter);
            SyncManager.getInstance().registerSender(catalogSyncID);
            SyncManager.getInstance().registerSender(bufferSyncID);
        }
        if (VMContext.addConnectionID((String)connectionID)) {
            SyncReaderFactory.createSyncReader(dstContext);
            TableStatistics.init(dstContext);
        }
        return factory;
    }
}

