/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.dbcatalog;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Table;
import com.sap.sql.dbcatalog.AdaCatalogExpert;
import com.sap.sql.dbcatalog.Db2CatalogExpert;
import com.sap.sql.dbcatalog.Db4CatalogExpert;
import com.sap.sql.dbcatalog.Db6CatalogExpert;
import com.sap.sql.dbcatalog.DbCatalogException;
import com.sap.sql.dbcatalog.DbCatalogExpert;
import com.sap.sql.dbcatalog.DbCatalogTable;
import com.sap.sql.dbcatalog.InfCatalogExpert;
import com.sap.sql.dbcatalog.MssCatalogExpert;
import com.sap.sql.dbcatalog.OraCatalogExpert;
import com.sap.sql.jdbc.DatabaseVendor;
import com.sap.sql.log.ExceptionType;
import com.sap.sql.types.CommonTypes;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

public class DbCatalogReader
implements CatalogReader {
    private DatabaseMetaData md = null;
    private Connection conn = null;
    private int vendor;
    private DbCatalogExpert catExpert = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public DbCatalogReader(Connection conn) throws DbCatalogException {
        this.conn = conn;
        this.initDbCatalogReader(-1);
    }

    public DbCatalogReader(String systemID, Connection conn) throws DbCatalogException {
        this.conn = conn;
        this.initDbCatalogReader(-1);
    }

    public Table getTable(String tableName) throws DbCatalogException {
        return this.getTable(null, tableName);
    }

    public Table getTable(String schemaName, String tableName) throws DbCatalogException {
        try {
            String userSchema = schemaName == null ? this.catExpert.identifyUserSchema() : schemaName;
            int tableType = this.catExpert.identifyTableType(userSchema, tableName);
            if (tableType == 0) {
                return null;
            }
            DbCatalogTable table = new DbCatalogTable(schemaName, tableName, tableType, false, false);
            HashMap pKeysMap = this.catExpert.identifyPrimaryKeys(userSchema, tableName);
            ResultSet rs = this.catExpert.identifyColumns(userSchema, tableName);
            int i = 1;
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                boolean isPKeyColumn = pKeysMap.get(columnName) != null;
                int mdJdbcType = (int)rs.getLong("DATA_TYPE");
                String mdTypeName = rs.getString("TYPE_NAME");
                long mdSize = rs.getLong("COLUMN_SIZE");
                int mdDecimals = rs.getInt("DECIMAL_DIGITS");
                boolean nullable = 1 == rs.getInt("NULLABLE");
                String defaultStr = rs.getString("COLUMN_DEF");
                int jdbcType = this.catExpert.identifyJdbcType(mdJdbcType, mdTypeName, userSchema, tableName, columnName);
                long size = this.catExpert.identifySize(jdbcType, mdTypeName, mdSize);
                int decimals = this.catExpert.identifyDecimals(jdbcType, mdDecimals);
                Object defaultObject = defaultStr != null ? this.createDefaultObj(jdbcType, defaultStr) : null;
                table.addColumn(columnName, isPKeyColumn, isPKeyColumn ? (Integer)pKeysMap.get(columnName) : new Integer(0), jdbcType, mdTypeName, size, decimals, nullable, defaultObject);
                ++i;
            }
            rs.close();
            if (this.catExpert.identifyRemoveLastColumn()) {
                table.removeLastColumn();
            }
            return table;
        }
        catch (SQLException e) {
            throw new DbCatalogException("DbCatalogReader", "getTable", ExceptionType.INTERNAL_ERROR, "schema: '" + schemaName + "', table: '" + tableName + "', unexpected SQL Error occured: " + e.getMessage());
        }
    }

    public boolean existsTable(String tableName) throws DbCatalogException {
        return this.existsTable(null, tableName);
    }

    public boolean existsTable(String schemaName, String tableName) throws DbCatalogException {
        try {
            boolean rc = false;
            ResultSet rs = this.md.getTables(null, schemaName, tableName, new String[]{"TABLE", "VIEW"});
            rc = rs.next();
            rs.close();
            return rc;
        }
        catch (SQLException e) {
            throw new DbCatalogException("DbCatalogReader", "existsTable", ExceptionType.INTERNAL_ERROR, "schema: '" + schemaName + "', table: '" + tableName + "', unexpected SQL Error occured: " + e.getMessage());
        }
    }

    public boolean isLogicalCatalogReader() {
        return false;
    }

    private void initDbCatalogReader(int vendorID) throws DbCatalogException {
        try {
            this.md = this.conn.getMetaData();
            this.vendor = vendorID == -1 ? DatabaseVendor.getVendorID((Connection)this.conn) : vendorID;
            switch (this.vendor) {
                case 0: {
                    this.catExpert = new Db6CatalogExpert(this.conn, this.md);
                    break;
                }
                case 1: {
                    this.catExpert = new Db4CatalogExpert(this.conn, this.md);
                    break;
                }
                case 2: {
                    this.catExpert = new Db2CatalogExpert(this.conn, this.md);
                    break;
                }
                case 3: {
                    this.catExpert = new InfCatalogExpert(this.conn, this.md);
                    break;
                }
                case 4: {
                    this.catExpert = new MssCatalogExpert(this.conn, this.md);
                    break;
                }
                case 5: {
                    this.catExpert = new OraCatalogExpert(this.conn, this.md);
                    break;
                }
                case 6: {
                    this.catExpert = new AdaCatalogExpert(this.conn, this.md);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new DbCatalogException("DbCatalogReader", "initDbCatalogReader", ExceptionType.INTERNAL_ERROR, "Unexpected SQL Error occured: " + e.getMessage());
        }
    }

    private Object createDefaultObj(int jdbcType, String givenDefaultStr) {
        int k;
        Object defaultObj = null;
        Class defaultClass = CommonTypes.defaultMapping((int)jdbcType);
        String defaultStr = givenDefaultStr.trim();
        if (defaultStr.startsWith("create default")) {
            int beg = defaultStr.indexOf(" as ");
            defaultStr = defaultStr.substring(beg += 4);
            if ((defaultStr = defaultStr.trim()).startsWith("'")) {
                int end = defaultStr.length();
                defaultStr = defaultStr.substring(1, end - 1);
            }
            if (defaultStr.startsWith("0x") || defaultStr.startsWith("0X")) {
                defaultStr = defaultStr.substring(2);
            }
        }
        if (defaultClass == (class$java$lang$String == null ? (class$java$lang$String = DbCatalogReader.class$("java.lang.String")) : class$java$lang$String) || defaultClass == (class$java$sql$Clob == null ? (class$java$sql$Clob = DbCatalogReader.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            defaultObj = new String(defaultStr);
        } else if (defaultClass == (array$B == null ? (array$B = DbCatalogReader.class$("[B")) : array$B) || defaultClass == (class$java$sql$Blob == null ? (class$java$sql$Blob = DbCatalogReader.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            String byteStr = defaultStr.toUpperCase();
            if (byteStr.charAt(0) == '\'' || byteStr.charAt(0) == '\"') {
                byteStr = byteStr.substring(1, byteStr.length() - 1);
            }
            if (byteStr.length() > 0) {
                int k2 = 0;
                while (k2 <= byteStr.length() / 2) {
                    String subStr = byteStr.substring(k2, k2 + 2);
                    int sum = 0;
                    int k22 = 1;
                    while (k22 >= 0) {
                        int h = 0;
                        switch (subStr.charAt(-1 * (k22 - 1))) {
                            case '0': {
                                h = 0;
                                break;
                            }
                            case '1': {
                                h = 1;
                                break;
                            }
                            case '2': {
                                h = 2;
                                break;
                            }
                            case '3': {
                                h = 3;
                                break;
                            }
                            case '4': {
                                h = 4;
                                break;
                            }
                            case '5': {
                                h = 5;
                                break;
                            }
                            case '6': {
                                h = 6;
                                break;
                            }
                            case '7': {
                                h = 7;
                                break;
                            }
                            case '8': {
                                h = 8;
                                break;
                            }
                            case '9': {
                                h = 9;
                                break;
                            }
                            case 'A': {
                                h = 10;
                                break;
                            }
                            case 'B': {
                                h = 11;
                                break;
                            }
                            case 'C': {
                                h = 12;
                                break;
                            }
                            case 'D': {
                                h = 13;
                                break;
                            }
                            case 'E': {
                                h = 14;
                                break;
                            }
                            case 'F': {
                                h = 15;
                            }
                        }
                        sum = (byte)(sum + (16 * k22 * h + h * -1 * (k22 - 1)));
                        --k22;
                    }
                    bStream.write(sum);
                    k2 += 2;
                }
            }
            defaultObj = bStream.toByteArray();
        } else if (defaultClass == Short.TYPE) {
            k = 0;
            while (k < defaultStr.length() && defaultStr.charAt(k) == ' ') {
                ++k;
            }
            String helpStr = defaultStr.substring(k, defaultStr.length());
            if (helpStr.startsWith("(")) {
                helpStr = helpStr.substring(1, helpStr.length() - 1);
            }
            defaultObj = helpStr.indexOf(32) > 0 ? new Short(helpStr.substring(0, helpStr.indexOf(32))) : new Short(helpStr);
        } else if (defaultClass == Integer.TYPE) {
            k = 0;
            while (k < defaultStr.length() && defaultStr.charAt(k) == ' ') {
                ++k;
            }
            String helpStr = defaultStr.substring(k, defaultStr.length());
            if (helpStr.startsWith("(")) {
                helpStr = helpStr.substring(1, helpStr.length() - 1);
            }
            defaultObj = helpStr.indexOf(32) > 0 ? new Integer(helpStr.substring(0, helpStr.indexOf(32))) : new Integer(helpStr);
        } else if (defaultClass == Long.TYPE) {
            defaultObj = new Long(defaultStr);
        } else if (defaultClass == Float.TYPE) {
            defaultObj = new Float(defaultStr);
        } else if (defaultClass == Double.TYPE) {
            defaultObj = new Double(defaultStr);
        } else if (defaultClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DbCatalogReader.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            k = 0;
            while (k < defaultStr.length() && defaultStr.charAt(k) == ' ') {
                ++k;
            }
            String helpStr = defaultStr.substring(k, defaultStr.length());
            defaultObj = helpStr.indexOf(32) > 0 ? new BigDecimal(helpStr.substring(0, helpStr.indexOf(32))) : new BigDecimal(helpStr);
        } else if (defaultClass == (class$java$sql$Date == null ? (class$java$sql$Date = DbCatalogReader.class$("java.sql.Date")) : class$java$sql$Date)) {
            defaultObj = Date.valueOf(defaultStr);
        } else if (defaultClass == (class$java$sql$Time == null ? (class$java$sql$Time = DbCatalogReader.class$("java.sql.Time")) : class$java$sql$Time)) {
            defaultObj = Time.valueOf(defaultStr);
        } else if (defaultClass == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DbCatalogReader.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            if (!defaultStr.startsWith("DEFAULT")) {
                defaultObj = Timestamp.valueOf(defaultStr);
            }
        } else if (defaultClass == Boolean.TYPE) {
            defaultObj = new Boolean(defaultStr);
        }
        return defaultObj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

