/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.dbcatalog;

import com.sap.sql.dbcatalog.DbCatalogExpert;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class Db6CatalogExpert
implements DbCatalogExpert {
    private Connection conn = null;
    private DatabaseMetaData md = null;
    private String userSchema = null;
    private int db6Codepage = 1208;

    Db6CatalogExpert(Connection conn, DatabaseMetaData md) throws SQLException {
        this.conn = conn;
        this.md = md;
    }

    public String identifyUserSchema() throws SQLException {
        if (this.userSchema == null) {
            this.userSchema = this.md.getUserName().toUpperCase();
        }
        return this.userSchema;
    }

    public int identifyTableType(String schemaName, String tableName) throws SQLException {
        int tableType = 0;
        ResultSet rs = this.md.getTables(null, schemaName, tableName, null);
        if (rs.next()) {
            String tableTypeStr = rs.getString("TABLE_TYPE");
            if (tableTypeStr.compareTo("TABLE") == 0) {
                tableType = 1;
            } else if (tableTypeStr.compareTo("VIEW") == 0) {
                tableType = 2;
            }
        }
        rs.close();
        return tableType;
    }

    public HashMap identifyPrimaryKeys(String schemaName, String tableName) throws SQLException {
        HashMap<String, Integer> pKeysMap = new HashMap<String, Integer>(20);
        ResultSet rs = this.md.getPrimaryKeys(null, schemaName, tableName);
        int i = 1;
        while (rs.next()) {
            pKeysMap.put(rs.getString("COLUMN_NAME"), new Integer(i));
            ++i;
        }
        rs.close();
        return pKeysMap;
    }

    public ResultSet identifyColumns(String schemaName, String tableName) throws SQLException {
        return this.md.getColumns(null, schemaName, tableName, null);
    }

    public int identifyJdbcType(int origJdbcType, String typeName, String schemaName, String tableName, String columnName) throws SQLException {
        return origJdbcType;
    }

    public long identifySize(int jdbcType, String typeName, long origSize) {
        if (this.db6Codepage == 1208 && (jdbcType == 12 || jdbcType == 1)) {
            return origSize / 3L;
        }
        if (jdbcType == 2004 || jdbcType == 2005) {
            return 0L;
        }
        return origSize;
    }

    public int identifyDecimals(int jdbcType, int origDecimals) {
        if (jdbcType == 93) {
            return 0;
        }
        return origDecimals;
    }

    public boolean identifyRemoveLastColumn() {
        return false;
    }
}

