/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.impl;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.CatalogReaderFactorySpi;
import com.sap.sql.catalog.impl.BufferedCatalogReader;
import com.sap.sql.catalog.impl.CatalogBufferManagerImpl;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.log.Syslog;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;

public class CatalogReaderFactoryImpl
implements CatalogReaderFactorySpi {
    private static final int CATALOG_BUFFER_OFF = -1;
    private static final int CATALOG_BUFFER_ENTRYCOUNT_DEFAULT = -11;
    private static final Class[] CONN_PARAMS = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = CatalogReaderFactoryImpl.class$("java.sql.Connection")) : class$java$sql$Connection};
    private static final Class[] SID_PARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CatalogReaderFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    private static CatalogReaderFactoryImpl instance = new CatalogReaderFactoryImpl();
    private static Hashtable schemas = new Hashtable(5);
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl;

    private CatalogReaderFactoryImpl() {
    }

    public static CatalogReaderFactoryImpl getInstance() {
        return instance;
    }

    public CatalogReader createCatalogReader(String connectionURI, boolean buffered) throws SQLException {
        return CatalogReaderFactoryImpl.createReader(connectionURI, buffered, -11, null);
    }

    public CatalogReader createCatalogReader(String connectionURI, boolean buffered, Connection connection) throws SQLException {
        return CatalogReaderFactoryImpl.createReader(connectionURI, buffered, -11, connection);
    }

    public CatalogReader createCatalogReader(String connectionURI, int entryCount) throws SQLException {
        if (entryCount < -1) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0002", new Object[]{"entryCount", new Integer(entryCount), new Integer(-1)});
        }
        return CatalogReaderFactoryImpl.createReader(connectionURI, true, entryCount, null);
    }

    public CatalogReader createCatalogReader(String connectionURI, int entryCount, Connection connection) throws SQLException {
        if (entryCount < -1) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0002", new Object[]{"entryCount", new Integer(entryCount), new Integer(-1)});
        }
        return CatalogReaderFactoryImpl.createReader(connectionURI, true, entryCount, connection);
    }

    public boolean isConnectionRequired(String connectionURI) throws SQLException {
        return CatalogReaderFactoryImpl.getSchemaInfo(connectionURI).connRequired;
    }

    private static void registerSchema(String schema, String className, Class[] constructorParams) {
        schemas.put(schema, new SchemaInfo(className, constructorParams));
    }

    private static CatalogReader createReader(String connectionURI, boolean buffered, int entryCount, Connection connection) throws SQLException {
        SchemaInfo info = CatalogReaderFactoryImpl.getSchemaInfo(connectionURI);
        String connectionID = connectionURI.substring(connectionURI.indexOf("://") + 3);
        String className = info.className;
        CatalogReader reader = null;
        try {
            Object[] objectArray;
            Class<?> clazz = Class.forName(className);
            Class[] params = info.constructorParams;
            Constructor<?> constructor = clazz.getConstructor(params);
            if (info.constructorParams == CONN_PARAMS) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = connection;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = connectionID;
            }
            Object[] args = objectArray;
            reader = (CatalogReader)constructor.newInstance(args);
        }
        catch (ClassNotFoundException ex) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql_0006", (Object[])new Object[]{className}, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql_0007", (Object[])new Object[]{className}, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql_0007", (Object[])new Object[]{className}, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql_0007", (Object[])new Object[]{className}, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql_0007", (Object[])new Object[]{className}, (Throwable)ex.getTargetException());
        }
        if (buffered && entryCount != -1) {
            if (entryCount == -11) {
                entryCount = Integer.parseInt(ContextFactory.mergeProperties(null).getProperty("com.sap.sql.catalog.buffer.entrycount"));
            }
            return new BufferedCatalogReader(reader, CatalogBufferManagerImpl.getCatalogBuffer(connectionID, entryCount));
        }
        return reader;
    }

    private static SchemaInfo getSchemaInfo(String connectionURI) throws SQLException {
        int index = connectionURI.indexOf("://");
        if (index == -1) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql.catalog_1001", (Object[])new Object[]{connectionURI});
        }
        String schema = connectionURI.substring(0, index);
        SchemaInfo info = (SchemaInfo)schemas.get(schema);
        if (info == null) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl == null ? (class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl = CatalogReaderFactoryImpl.class$("com.sap.sql.catalog.impl.CatalogReaderFactoryImpl")) : class$com$sap$sql$catalog$impl$CatalogReaderFactoryImpl), (String)"com.sap.sql.catalog_1001", (Object[])new Object[]{connectionURI});
        }
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CatalogReaderFactoryImpl.registerSchema("dbcat", "com.sap.dictionary.database.catalog.DbCatalogReader", CONN_PARAMS);
        CatalogReaderFactoryImpl.registerSchema("file", "com.sap.dictionary.database.catalog.XmlCatalogReader", SID_PARAMS);
        CatalogReaderFactoryImpl.registerSchema("jdic", "com.sap.dictionary.database.catalog.XmlCatalogReader", CONN_PARAMS);
    }

    private static class SchemaInfo {
        private String className;
        private Class[] constructorParams;
        private boolean connRequired;

        SchemaInfo(String className, Class[] constructorParams) {
            this.className = className;
            this.constructorParams = constructorParams;
            this.connRequired = constructorParams == CONN_PARAMS;
        }
    }
}

