/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.impl;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Table;
import com.sap.sql.catalog.data.TableData;
import com.sap.sql.catalog.impl.CatalogBuffer;
import java.sql.SQLException;

public class BufferedCatalogReader
implements CatalogReader {
    private CatalogReader reader;
    private CatalogBuffer buffer;

    public BufferedCatalogReader(CatalogReader catalogReader, CatalogBuffer catalogBuffer) {
        this.reader = catalogReader;
        this.buffer = catalogBuffer;
    }

    public Table getTable(String tableName) throws SQLException {
        return this.getTable(null, tableName);
    }

    public Table getTable(String schemaName, String tableName) throws SQLException {
        Table table = this.buffer.getTable(schemaName, tableName);
        if (table == null) {
            table = schemaName != null ? this.reader.getTable(schemaName, tableName) : this.reader.getTable(tableName);
            BufferedCatalogReader bufferedCatalogReader = this;
            synchronized (bufferedCatalogReader) {
                if (table != null) {
                    this.buffer.setTable(schemaName, tableName, (Table)new TableData(table, false));
                    this.buffer.setTableExistence(schemaName, tableName, Boolean.TRUE);
                } else {
                    this.buffer.setTableExistence(schemaName, tableName, Boolean.FALSE);
                }
            }
        }
        return table;
    }

    public boolean existsTable(String tableName) throws SQLException {
        return this.existsTable(null, tableName);
    }

    public boolean existsTable(String schemaName, String tableName) throws SQLException {
        Boolean exists = this.buffer.getTableExistence(schemaName, tableName);
        if (exists == null) {
            boolean exists2 = this.reader.existsTable(schemaName, tableName);
            this.buffer.setTableExistence(schemaName, tableName, new Boolean(exists2));
            return exists2;
        }
        return exists;
    }

    public boolean isLogicalCatalogReader() {
        return this.reader.isLogicalCatalogReader();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.reader.getClass().getName();
    }
}

