/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer.monitor.impl;

import com.sap.sql.buffer.Buffer;
import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferException;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.monitor.BufferMonitor;
import com.sap.sql.buffer.monitor.BufferMonitorGlobalInfo;
import com.sap.sql.tablebuffer.BufferManagerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BufferMonitorImpl
implements BufferMonitor {
    private static BufferMonitorImpl instance = new BufferMonitorImpl();
    private Map buffers = new HashMap();

    private BufferMonitorImpl() {
    }

    public static BufferMonitor getInstance() {
        return instance;
    }

    public String[] getBufferIds() {
        int i = 0;
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            try {
                this.updateBufferMap();
                String[] result = new String[this.buffers.size()];
                Iterator iter = this.buffers.keySet().iterator();
                while (iter.hasNext()) {
                    result[i] = (String)iter.next();
                    ++i;
                }
                String[] stringArray = result;
                Object var7_6 = null;
                this.clearBufferMap();
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.clearBufferMap();
                throw throwable;
            }
        }
    }

    public BufferMonitorGlobalInfo getGlobalInfo(String bufferId) {
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            BufferMonitorGlobalInfo bufferMonitorGlobalInfo;
            try {
                this.updateBufferMap();
                Buffer buffer = (Buffer)this.buffers.get(bufferId);
                if (buffer == null) {
                    BufferMonitorGlobalInfo bufferMonitorGlobalInfo2 = null;
                    Object var6_6 = null;
                    this.clearBufferMap();
                    return bufferMonitorGlobalInfo2;
                }
                bufferMonitorGlobalInfo = (BufferMonitorGlobalInfo)buffer.getInfo();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.clearBufferMap();
                throw throwable;
            }
            Object var6_7 = null;
            this.clearBufferMap();
            return bufferMonitorGlobalInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getObjectInfo(String bufferId, String name) {
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            Collection collection;
            try {
                try {
                    this.updateBufferMap();
                    Buffer buffer = (Buffer)this.buffers.get(bufferId);
                    if (buffer == null) {
                        Collection collection2 = null;
                        Object var8_8 = null;
                        this.clearBufferMap();
                        return collection2;
                    }
                    collection = buffer.listObjects(name);
                }
                catch (BufferException ex) {
                    Collection collection3 = null;
                    Object var8_10 = null;
                    this.clearBufferMap();
                    return collection3;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.clearBufferMap();
                throw throwable;
            }
            Object var8_9 = null;
            this.clearBufferMap();
            return collection;
        }
    }

    public void resetBuffer() {
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            try {
                this.updateBufferMap();
                Iterator iter = this.buffers.values().iterator();
                while (iter.hasNext()) {
                    Buffer buffer = (Buffer)iter.next();
                    try {
                        buffer.reset();
                    }
                    catch (BufferNotAvailableException ex) {
                        // empty catch block
                    }
                }
                Object var6_5 = null;
                this.clearBufferMap();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.clearBufferMap();
                throw throwable;
            }
        }
    }

    public boolean resetBuffer(String bufferId) {
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            boolean bl;
            try {
                this.updateBufferMap();
                Buffer buffer = (Buffer)this.buffers.get(bufferId);
                if (buffer == null) {
                    boolean bl2 = false;
                    Object var7_7 = null;
                    this.clearBufferMap();
                    return bl2;
                }
                try {
                    buffer.reset();
                }
                catch (BufferNotAvailableException ex) {
                    boolean bl3 = false;
                    Object var7_8 = null;
                    this.clearBufferMap();
                    return bl3;
                }
                bl = true;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.clearBufferMap();
                throw throwable;
            }
            Object var7_9 = null;
            this.clearBufferMap();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeBufferObject(String bufferId, String name) {
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            boolean bl;
            try {
                try {
                    this.updateBufferMap();
                    Buffer buffer = (Buffer)this.buffers.get(bufferId);
                    if (buffer == null) {
                        boolean bl2 = false;
                        Object var9_8 = null;
                        this.clearBufferMap();
                        return bl2;
                    }
                    BufferAccess access = buffer.getBufferAccess();
                    access.removeObject(name);
                    bl = true;
                }
                catch (BufferException ex) {
                    boolean bl3 = false;
                    Object var9_10 = null;
                    this.clearBufferMap();
                    return bl3;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.clearBufferMap();
                throw throwable;
            }
            Object var9_9 = null;
            this.clearBufferMap();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resetBufferObject(String bufferId, String name) {
        BufferMonitorImpl bufferMonitorImpl = this;
        synchronized (bufferMonitorImpl) {
            boolean bl;
            try {
                try {
                    this.updateBufferMap();
                    Buffer buffer = (Buffer)this.buffers.get(bufferId);
                    if (buffer == null) {
                        boolean bl2 = false;
                        Object var9_8 = null;
                        this.clearBufferMap();
                        return bl2;
                    }
                    BufferAccess access = buffer.getBufferAccess();
                    access.resetObject(name, null);
                    bl = true;
                }
                catch (BufferException ex) {
                    boolean bl3 = false;
                    Object var9_10 = null;
                    this.clearBufferMap();
                    return bl3;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.clearBufferMap();
                throw throwable;
            }
            Object var9_9 = null;
            this.clearBufferMap();
            return bl;
        }
    }

    private void updateBufferMap() {
        Buffer[] allBuffers = BufferManagerFactory.getBuffers();
        this.clearBufferMap();
        if (allBuffers != null) {
            int i = 0;
            while (i < allBuffers.length) {
                this.buffers.put(allBuffers[i].getId(), allBuffers[i]);
                ++i;
            }
        }
    }

    private void clearBufferMap() {
        this.buffers.clear();
    }
}

