/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferDirectory;
import com.sap.sql.buffer.TBJBufferDirectoryIterator;
import com.sap.sql.buffer.TBJBufferGenericDirectory;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.tc.logging.Location;

class TBJBufferTable {
    static final int FULL = 0;
    static final int GENERIC = 1;
    static final int SINGLE = 2;
    static final int DUMMY = 3;
    static final int TABLE_SIZE = 64;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferTable == null ? (class$com$sap$sql$buffer$TBJBufferTable = TBJBufferTable.class$("com.sap.sql.buffer.TBJBufferTable")) : class$com$sap$sql$buffer$TBJBufferTable));
    private TBJBufferDirectory dir;
    private String tableName;
    private int keyCount;
    private int genKeyCount;
    private int columnCount;
    private int[] keyIndex;
    private int bufType;
    private TBJBufferObject object;
    private TBJBufferGenericDirectory genDir;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferTable;

    TBJBufferTable(TBJBuffer buffer, TBJBufferDirectory dir, String tableName, int keyCount, int genKeyCount, int columnCount, int[] keyIndex) {
        this.dir = dir;
        this.tableName = tableName;
        this.keyCount = keyCount;
        this.genKeyCount = genKeyCount;
        this.columnCount = columnCount;
        this.keyIndex = keyIndex;
        this.bufType = keyCount == 0 && genKeyCount == 0 && columnCount == 0 ? 3 : (genKeyCount == 0 ? 0 : (genKeyCount == keyCount ? 2 : 1));
        if (this.bufType != 1) {
            this.object = new TBJBufferObject(buffer, this);
            this.genDir = null;
        } else {
            this.object = null;
            this.genDir = new TBJBufferGenericDirectory(buffer, this);
        }
        buffer.reduceFreeBytes(64L);
    }

    static String printType(int type) {
        if (type == 0) {
            return "FULL";
        }
        if (type == 1) {
            return "GENERIC";
        }
        if (type == 2) {
            return "SINGLE";
        }
        return "DUMMY";
    }

    int clear(TBJBuffer buffer) {
        int clearedObjects = 0;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferTable.clear");
        }
        if (this.object != null) {
            this.object.clear(buffer);
            clearedObjects = 1;
        }
        if (this.genDir != null) {
            clearedObjects = this.genDir.clear(buffer);
        }
        this.object = null;
        buffer.incrementFreeBytes(93 * clearedObjects);
        this.keyIndex = null;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferTable.clear: #clearedObjects= " + clearedObjects);
        }
        return clearedObjects;
    }

    TBJBufferObject getObject() {
        return this.object;
    }

    TBJBufferDirectory getDirectory() {
        return this.dir;
    }

    TBJBufferGenericDirectory getGenericDirectory() {
        return this.genDir;
    }

    String getTableName() {
        return this.tableName;
    }

    int getKeyCount() {
        return this.keyCount;
    }

    int getGenKeyCount() {
        return this.genKeyCount;
    }

    int getColumnCount() {
        return this.columnCount;
    }

    int[] getKeyIndex() {
        return this.keyIndex;
    }

    boolean isGeneric() {
        return this.bufType == 1;
    }

    boolean isDummy() {
        return this.bufType == 3;
    }

    int getBufType() {
        return this.bufType;
    }

    long size() {
        long sum = 64L;
        sum = this.bufType == 1 ? (sum += this.genDir.size()) : (sum += this.object.size());
        return sum;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" TableName= " + this.tableName);
        buf.append(" KeyCount= " + this.keyCount);
        buf.append(" GenKeyCount= " + this.genKeyCount);
        buf.append(" ColumnCount= " + this.columnCount);
        if (this.genKeyCount == 0) {
            buf.append(this.object.toString());
        } else if (this.genDir != null) {
            buf.append(" GenericDirectory= ");
            TBJBufferDirectoryIterator iter = this.genDir.getObjects();
            while (iter.hasNext()) {
                TBJBufferObject object = iter.next();
                if (object == null) continue;
                buf.append(object.getGenKey().toString());
            }
        } else {
            buf.append(" GenericDirectory= null");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

