/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferDate;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferTime;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

abstract class TBJBufferRecordAbstract
implements BufferRecord {
    protected static final Object UNDEFINED = new Object();
    protected Object[] columns;

    TBJBufferRecordAbstract() {
    }

    public Object getValue(int index) throws IllegalArgumentException {
        if (index <= 0 || index > this.columns.length) {
            throw (IllegalArgumentException)TBJBuffer.getAndLogBufferException(1, this.getClass(), "getValue", new Object[]{"", "index (" + index + ") out of range"}, null, false, 0);
        }
        Object obj = this.columns[index - 1];
        if (obj instanceof TBJBufferTime) {
            return ((TBJBufferTime)obj).getTime();
        }
        if (obj instanceof TBJBufferDate) {
            return ((TBJBufferDate)obj).getDate();
        }
        return obj;
    }

    public void setString(int index, String value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setInteger(int index, Integer value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setShort(int index, Short value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setLong(int index, Long value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setFloat(int index, Float value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setDouble(int index, Double value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setBigInteger(int index, BigInteger value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setBigDecimal(int index, BigDecimal value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setBoolean(int index, Boolean value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setByte(int index, Byte value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setByteArray(int index, byte[] value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setCharArray(int index, char[] value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setCharacter(int index, Character value) throws IllegalArgumentException {
        this.setValue(index, value);
    }

    public void setDate(int index, Date value) throws IllegalArgumentException {
        TBJBufferDate copy = value == null ? null : new TBJBufferDate(value.toString());
        this.setValue(index, copy);
    }

    public void setTime(int index, Time value) throws IllegalArgumentException {
        TBJBufferTime copy = value == null ? null : new TBJBufferTime(value.toString());
        this.setValue(index, copy);
    }

    public void setTimestamp(int index, Timestamp value) throws IllegalArgumentException {
        Timestamp copy = value == null ? null : (Timestamp)value.clone();
        this.setValue(index, copy);
    }

    public void setNull(int index) throws IllegalArgumentException {
        this.setValue(index, null);
    }

    public int getValueCount() {
        return this.columns.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (this.columns != null) {
            int i = 0;
            while (i < this.columns.length) {
                String objString;
                Object obj = this.columns[i];
                String string = objString = obj == null ? "null" : obj.toString();
                if (i != 0) {
                    buf.append("," + objString);
                } else {
                    buf.append(objString);
                }
                ++i;
            }
        }
        buf.append(")");
        return buf.toString();
    }

    protected TBJBufferKey getKey(int keyCount, int[] keyIndex) {
        Object[] keyColumns = new Object[keyCount];
        if (keyIndex != null) {
            int i = 0;
            while (i < keyCount) {
                int keyPos = keyIndex[i];
                keyColumns[i] = this.columns[keyPos - 1];
                ++i;
            }
        } else {
            System.arraycopy(this.columns, 0, keyColumns, 0, keyCount);
        }
        return new TBJBufferKey(keyColumns);
    }

    protected boolean isValid() {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i] == UNDEFINED) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void setValue(int index, Object value) throws IllegalArgumentException {
        if (index <= 0 || index > this.columns.length) {
            throw (IllegalArgumentException)TBJBuffer.getAndLogBufferException(1, this.getClass(), "setValue", new Object[]{"", "index (" + index + ") out of range"}, null, false, 0);
        }
        if (this.columns[index - 1] != UNDEFINED) {
            throw (IllegalArgumentException)TBJBuffer.getAndLogBufferException(1, this.getClass(), "setValue", new Object[]{"", "value already set at index (" + index + ")"}, null, false, 0);
        }
        this.columns[index - 1] = value;
    }

    void clear() {
        this.columns = null;
    }
}

