/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferData;
import com.sap.sql.buffer.TBJBufferDirectory;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferObjectInfo;
import com.sap.sql.buffer.TBJBufferStatus;
import com.sap.sql.buffer.TBJBufferTable;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.tc.logging.Location;

class TBJBufferObject {
    static final TBJBufferObject OBJECT_NULL = new TBJBufferObject();
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferObject == null ? (class$com$sap$sql$buffer$TBJBufferObject = TBJBufferObject.class$("com.sap.sql.buffer.TBJBufferObject")) : class$com$sap$sql$buffer$TBJBufferObject));
    static final int OBJECT_SIZE = 93;
    private TBJBufferTable table;
    private TBJBufferKey genKey;
    private TBJBufferData data = null;
    private int status;
    private boolean isDummy = false;
    private int reloadCounter;
    private volatile int hotObjectLocks;
    private volatile int openCursors;
    private volatile int fixingCounter;
    private volatile int beginCounter;
    private volatile int endCounter;
    private int usedCounter;
    private TBJBufferObject next = null;
    private TBJBufferObject previous = null;
    private long missedReads = 0L;
    private long successfulReads = 0L;
    private long invalidations = 0L;
    private long missedModifications = 0L;
    private long successfulModifications = 0L;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferObject;

    TBJBufferObject() {
        this.table = null;
        this.genKey = null;
    }

    TBJBufferObject(TBJBuffer buffer, TBJBufferTable table) {
        this.table = table;
        this.genKey = null;
        this.init(buffer);
        if (table.isDummy()) {
            this.isDummy = true;
            this.status = 3;
        }
        buffer.reduceFreeBytes(93L);
    }

    TBJBufferObject(TBJBuffer buffer, TBJBufferTable table, TBJBufferKey genKey, boolean isDummy) {
        this.table = table;
        this.genKey = genKey;
        this.isDummy = isDummy;
        this.init(buffer);
        if (genKey.getValueCount() < table.getGenKeyCount()) {
            this.isDummy = true;
            this.status = 3;
        }
        buffer.reduceFreeBytes(93L);
    }

    void invalidate(TBJBuffer buffer, boolean txRuns) {
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.invalidate: txRuns = " + txRuns + " " + this.table.getTableName() + "  " + this.genKey);
        }
        this.incrementInvalidations();
        if (!txRuns) {
            if (this.status == 1 || this.status == 2) {
                if (this.fixingCounter == 0) {
                    this.status = 0;
                    this.resetReloadCounter();
                } else {
                    this.status = 3;
                }
            }
        } else if (this.status == 0 || this.status == 1 || this.status == 2) {
            this.status = 3;
        }
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.invalidate");
        }
    }

    void reactivate(TBJBuffer buffer) {
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.reactivate: " + this.table.getTableName() + "  " + this.genKey);
        }
        this.status = this.fixingCounter > 0 ? 3 : 0;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.reactivate");
        }
    }

    void reset(TBJBuffer buffer) {
        this.beginModification();
        this.waitBusyForHotObject(buffer);
        this.clearData(buffer);
        this.init(buffer);
        this.endModification();
    }

    long clearData(TBJBuffer buffer) {
        long clearedBytes = 0L;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.clearData: " + this.getName());
        }
        if (this.data != null) {
            clearedBytes = this.data.clear(buffer);
        }
        this.openCursors = 0;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.clearData");
        }
        return clearedBytes;
    }

    void clear(TBJBuffer buffer) {
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.clear: " + this.getName());
        }
        this.beginModification();
        this.waitBusyForHotObject(buffer);
        this.status = 5;
        if (this.data != null) {
            this.data.clear(buffer);
            buffer.incrementFreeBytes(68L);
        }
        this.data = null;
        this.table.getDirectory().removeFromQueue(this);
        this.table.getDirectory().getTxHandling().clearModifications(buffer, this);
        this.endModification();
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.clear");
        }
    }

    TBJBufferData getData() {
        return this.data;
    }

    boolean dataIsNull() {
        return this.data == null;
    }

    void setData(TBJBufferData data) {
        this.data = data;
    }

    int getStatus() {
        return this.status;
    }

    String getTableName() {
        return this.table.getTableName();
    }

    int getKeyCount() {
        return this.table.getKeyCount();
    }

    int getGenKeyCount() {
        return this.table.getGenKeyCount();
    }

    int getColumnCount() {
        return this.table.getColumnCount();
    }

    TBJBufferTable getTable() {
        return this.table;
    }

    TBJBufferKey getGenKey() {
        return this.genKey;
    }

    TBJBufferObject getPrevious() {
        return this.previous;
    }

    TBJBufferObject getNext() {
        return this.next;
    }

    void setPrevious(TBJBufferObject object) {
        this.previous = object;
    }

    void setNext(TBJBufferObject object) {
        this.next = object;
    }

    int setStatus(int status) {
        this.status = status;
        return status;
    }

    void incrementFixingCounter() {
        ++this.fixingCounter;
    }

    int getFixingCounter() {
        return this.fixingCounter;
    }

    int getReloadCounter() {
        return this.reloadCounter;
    }

    void initReloadCounter(TBJBuffer buffer) {
        this.reloadCounter = buffer.getReloadDelay();
    }

    long size() {
        if (this.data != null) {
            return this.data.sizeOfContainer() + 68L + 93L;
        }
        return 93L;
    }

    long sizeData() {
        if (this.data != null) {
            return this.data.sizeOfContainer() + 68L;
        }
        return 0L;
    }

    boolean isLoadable(TBJBuffer buffer) {
        ++this.reloadCounter;
        return this.reloadCounter > buffer.getReloadDelay();
    }

    void incrementReads(boolean successful) {
        if (successful) {
            ++this.successfulReads;
        } else {
            ++this.missedReads;
        }
    }

    void incrementInvalidations() {
        ++this.invalidations;
    }

    void incrementModifications(boolean successful) {
        if (successful) {
            ++this.successfulModifications;
        } else {
            ++this.missedModifications;
        }
    }

    void endTransaction(TBJBuffer buffer, boolean rollback) {
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.endTransaction(" + (rollback ? "rollback): " : "commit): ") + this.getName());
        }
        this.beginModification();
        if (this.fixingCounter > 0) {
            --this.fixingCounter;
        } else if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "    tried to decrement fixingCounter = " + this.fixingCounter);
        }
        if (this.fixingCounter == 0 && this.status == 3) {
            this.status = 0;
            this.resetReloadCounter();
        } else if (this.fixingCounter == 0 && this.status == 2 && rollback) {
            this.status = 0;
            this.resetReloadCounter();
        } else if (this.status == 2 && rollback) {
            this.status = 3;
        } else if (this.status == 1) {
            this.status = 5;
            if (buffer.isDebugOn()) {
                buffer.trace(100, TRACE, "    status is LOADING: set status to ERROR");
            }
        }
        this.endModification();
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.endTransaction: status = " + TBJBufferStatus.printStatus(this.status));
        }
    }

    boolean isDummy() {
        return this.isDummy;
    }

    int waitAndLockHotObject(TBJBuffer buffer) throws BufferResetException {
        int localCounter = this.endCounter;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.waitAndLockHotObject: " + this.getName() + "  localCounter = " + localCounter);
        }
        while (true) {
            if (localCounter != this.beginCounter) {
                if (buffer.isDebugOn()) {
                    buffer.trace(100, TRACE, "    Wait for buffer mutex while locking hot object");
                }
                TBJBuffer tBJBuffer = buffer;
                synchronized (tBJBuffer) {
                    buffer.syncBegin(this);
                    buffer.syncEnd();
                }
                localCounter = this.endCounter;
            }
            ++this.hotObjectLocks;
            if (localCounter == this.beginCounter) break;
            --this.hotObjectLocks;
        }
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.waitAndLockHotObject: localCounter = " + localCounter);
        }
        return localCounter;
    }

    int waitAndOpenCursor(TBJBuffer buffer) throws BufferResetException {
        int localCounter = this.endCounter;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.waitAndOpenCursor: " + this.getName());
        }
        while (true) {
            if (localCounter != this.beginCounter) {
                if (buffer.isDebugOn()) {
                    buffer.trace(100, TRACE, "    Wait for buffer mutex while opening cursor");
                }
                TBJBuffer tBJBuffer = buffer;
                synchronized (tBJBuffer) {
                    buffer.syncBegin(this);
                    buffer.syncEnd();
                }
                localCounter = this.endCounter;
            }
            if (this.status != 2) break;
            ++this.openCursors;
            if (localCounter == this.beginCounter) break;
            --this.openCursors;
        }
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.waitAndOpenCursor: status = " + TBJBufferStatus.printStatus(this.status));
        }
        return localCounter;
    }

    void waitBusyForHotObject(TBJBuffer buffer) {
        int busyWait = 100000000;
        int busyWaitLoops = 5;
        int delay = 100000000;
        int loopNr = 0;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.waitBusyForHotObject: " + this.getName());
        }
        while (this.hotObjectLocks > 0) {
            if (--delay > 0) continue;
            if (buffer.isDebugOn()) {
                buffer.trace(300, TRACE, "Waiting for Hot Object " + this.getName());
            }
            if (++loopNr < 5) {
                delay = 100000000;
                continue;
            }
            buffer.log(400, this.getClass(), "waitBusyForHotObject", "com.sap.sql.buffer_1322", new Object[]{buffer.getBufferId(), "Forced unlocking of \"" + this.getName() + "\""});
            this.hotObjectLocks = 0;
            this.openCursors = 0;
        }
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.waitBusyForHotObject");
        }
    }

    synchronized void closeCursor() {
        if (this.openCursors > 0) {
            --this.openCursors;
        } else if (this.openCursors < 0) {
            this.openCursors = 0;
        }
    }

    synchronized void unlockHotObject() {
        if (this.hotObjectLocks > 0) {
            --this.hotObjectLocks;
        } else if (this.hotObjectLocks < 0) {
            this.hotObjectLocks = 0;
        }
    }

    boolean isHotObject() {
        return this.hotObjectLocks > 0;
    }

    boolean hasOpenCursors() {
        return this.openCursors > 0;
    }

    void beginModification() {
        ++this.beginCounter;
    }

    void endModification() {
        this.endCounter = this.beginCounter;
    }

    int getConsistencyCounter() {
        return this.beginCounter;
    }

    boolean hasChanged(int localCounter) {
        return this.beginCounter != localCounter;
    }

    boolean inChange() {
        return this.beginCounter != this.endCounter;
    }

    boolean matchKey(TBJBuffer buffer, TBJBufferKey key) throws TypeMismatchException {
        if (key == null || this.genKey == null) {
            return false;
        }
        int keyLength = key.getValueCount();
        if (keyLength > this.genKey.getValueCount()) {
            return false;
        }
        return this.genKey.matchTo(buffer, key, keyLength);
    }

    boolean isDisplaceable() {
        if (this.status == 1) {
            return false;
        }
        if (this.hasOpenCursors() || this.isHotObject()) {
            return false;
        }
        if (this.status == 2) {
            return this.usedCounter == 0;
        }
        return true;
    }

    boolean isReleasible() {
        return (this.status == 5 || this.status == 4 || this.status == 0 || this.status == 3) && !this.hasOpenCursors() && !this.isHotObject();
    }

    boolean isExistent(TBJBuffer buffer) {
        TBJBufferDirectory dir = buffer.getDirectory();
        TBJBufferTable table = this.getTable();
        TBJBufferTable actTable = dir.getTable(this.getTableName());
        int bufType = table.getBufType();
        boolean result = false;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferObject.isExistent");
        }
        if (actTable == table) {
            TBJBufferObject actObject;
            if (bufType != 1) {
                actObject = actTable.getObject();
            } else {
                try {
                    if (actTable.getGenericDirectory() == null) {
                        return false;
                    }
                    actObject = actTable.getGenericDirectory().getObject(buffer, this.getGenKey());
                }
                catch (TypeMismatchException ex) {
                    return false;
                }
            }
            if (actObject == this) {
                result = true;
            }
        }
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferObject.isExistent: " + result);
        }
        return result;
    }

    long getUsedCounter() {
        return this.usedCounter;
    }

    void resetUsedCounter() {
        this.usedCounter = 0;
    }

    void incrementUsedCounter() {
        ++this.usedCounter;
    }

    int setStrongReachability() {
        if (this.data != null) {
            return this.data.setStrongReachability();
        }
        return 1;
    }

    int getReachability() {
        if (this.data != null) {
            return this.data.getReachability();
        }
        return 1;
    }

    TBJBufferObjectInfo getInfo() {
        return new TBJBufferObjectInfo(this.table.getTableName(), this.genKey, this.table.getBufType(), this.isDummy, this.data != null ? this.data.getRecordCount() : 0, this.data != null ? this.data.getNotFounds() : 0, this.table.getKeyCount(), this.table.getGenKeyCount(), this.table.getColumnCount(), this.successfulReads, this.missedReads, this.invalidations, this.successfulModifications, this.missedModifications, this.sizeData(), this.size(), this.reloadCounter, this.fixingCounter, this.hotObjectLocks, this.openCursors, this.usedCounter, this.dataIsNull(), this.data != null ? this.data.getReachability() : 1, this.status);
    }

    String getName() {
        return this.table.getTableName() + (this.table.isGeneric() ? ", " + this.genKey.toString() : "");
    }

    private void resetReloadCounter() {
        this.reloadCounter = 0;
    }

    private void init(TBJBuffer buffer) {
        this.status = 0;
        this.beginCounter = 0;
        this.endCounter = 0;
        this.fixingCounter = 0;
        this.hotObjectLocks = 0;
        this.openCursors = 0;
        this.usedCounter = 0;
        this.initReloadCounter(buffer);
        this.successfulReads = 0L;
        this.missedReads = 0L;
        this.invalidations = 0L;
        this.successfulModifications = 0L;
        this.missedModifications = 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

