/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferInfo;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.monitor.BufferMonitorGlobalInfo;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Properties;

public class TBJBufferInfo
extends BufferInfo
implements BufferMonitorGlobalInfo {
    private static DecimalFormat formatter = new DecimalFormat("###,###,###,###,###,###,###");
    private static FieldPosition pos = new FieldPosition(0);
    private Date startUpDate;
    private Date resetDate;
    private Date reinstallDate;
    private long resets;
    private long reinstalls;
    private long tableCount;
    private long objectCount;
    private long queueSize;
    private long bufferSize;
    private long maxRecordSize;
    private long maxLobSize;
    private long freeBytes;
    private boolean traceOn;
    private int traceSeverity;
    private boolean pathOn;
    private boolean debugOn;
    private long reloadDelay;
    private long displacements;
    private long displacedObjects;
    private long displacedData;
    private long displacedBytes;
    private long displacedTables;
    private long sumDisplacedObjects;
    private long sumDisplacedData;
    private long sumDisplacedBytes;
    private long sumDisplacedTables;
    private long txCount;
    private long modCount;
    private long hitReads;
    private long missedReads;

    public TBJBufferInfo(String id, Properties props, boolean isReady, Date startUpDate, Date resetDate, Date reinstallDate, long resets, long reinstalls, int tableCount, int objectCount, int queueSize, long bufferSize, long freeBytes, long maxRecordSize, long maxLobSize, boolean traceOn, int traceSeverity, boolean pathOn, boolean debugOn, int reloadDelay, int txCount, long modCount, long displacements, long displacedBytes, long displacedData, long displacedObjects, long displacedTables, long sumDisplacedBytes, long sumDisplacedData, long sumDisplacedObjects, long sumDisplacedTables, long hitReads, long missedReads) {
        super(id, props, isReady);
        this.startUpDate = startUpDate;
        this.resetDate = resetDate;
        this.reinstallDate = reinstallDate;
        this.resets = resets;
        this.reinstalls = reinstalls;
        this.tableCount = tableCount;
        this.objectCount = objectCount;
        this.queueSize = queueSize;
        this.bufferSize = bufferSize;
        this.freeBytes = freeBytes;
        this.maxRecordSize = maxRecordSize;
        this.maxLobSize = maxLobSize;
        this.traceOn = traceOn;
        this.traceSeverity = traceSeverity;
        this.pathOn = pathOn;
        this.debugOn = debugOn;
        this.reloadDelay = reloadDelay;
        this.txCount = txCount;
        this.modCount = modCount;
        this.displacements = displacements;
        this.displacedBytes = displacedBytes;
        this.displacedData = displacedData;
        this.displacedObjects = displacedObjects;
        this.displacedTables = displacedTables;
        this.sumDisplacedBytes = sumDisplacedBytes;
        this.sumDisplacedData = sumDisplacedData;
        this.sumDisplacedObjects = sumDisplacedObjects;
        this.sumDisplacedTables = sumDisplacedTables;
        this.hitReads = hitReads;
        this.missedReads = missedReads;
    }

    public Date getStartDate() {
        return this.startUpDate;
    }

    public Date getResetDate() {
        return this.resetDate;
    }

    public Date getReinstallDate() {
        return this.reinstallDate;
    }

    public long getReinstalls() {
        return this.reinstalls;
    }

    public long getResets() {
        return this.resets;
    }

    public long getTableCount() {
        return this.tableCount;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public long getTxCount() {
        return this.txCount;
    }

    public long getModCount() {
        return this.modCount;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public long getDisplacements() {
        return this.displacements;
    }

    public long getDisplacedBytes() {
        return this.displacedBytes;
    }

    public long getDisplacedData() {
        return this.displacedData;
    }

    public long getDisplacedObjects() {
        return this.displacedObjects;
    }

    public long getDisplacedTables() {
        return this.displacedTables;
    }

    public long getSumDisplacedBytes() {
        return this.sumDisplacedBytes;
    }

    public long getSumDisplacedData() {
        return this.sumDisplacedData;
    }

    public long getSumDisplacedObjects() {
        return this.sumDisplacedObjects;
    }

    public long getSumDisplacedTables() {
        return this.sumDisplacedTables;
    }

    public long getMaxRecordSize() {
        return this.maxRecordSize;
    }

    public long getMaxLobSize() {
        return this.maxLobSize;
    }

    public long getReloadDelay() {
        return this.reloadDelay;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public boolean isPathOn() {
        return this.pathOn;
    }

    public boolean isDebugOn() {
        return this.debugOn;
    }

    public String getTraceSeverity() {
        return TBJBuffer.printSeverity(this.traceSeverity);
    }

    public long getRequests() {
        return this.hitReads + this.missedReads;
    }

    public long getHits() {
        return this.hitReads;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id = " + this.id);
        buf.append(", isReady = " + this.isReady);
        buf.append(", StartUpDate = " + this.startUpDate);
        buf.append(", ResetDate = " + this.resetDate);
        buf.append(", ReinstallDate = " + this.reinstallDate);
        buf.append(", #resets = " + this.resets);
        buf.append(", #reinstalls = " + this.reinstalls);
        buf.append(", #Tables = " + this.tableCount);
        buf.append(", #DefinedObjects = " + this.objectCount);
        buf.append("  loadQueueSize = " + this.queueSize);
        buf.append(", bufferSize = " + this.bufferSize);
        buf.append(", freeBytes = " + this.freeBytes);
        buf.append(", hitReads = " + this.hitReads);
        buf.append(", missedReads = " + this.missedReads);
        buf.append(", maxRecordSize = " + this.maxRecordSize);
        buf.append(", maxLobSize = " + this.maxLobSize);
        buf.append(", traceOn = " + this.traceOn);
        buf.append(", traceSeverity = " + this.getTraceSeverity());
        buf.append(", pathOn = " + this.pathOn);
        buf.append(", debugOn = " + this.debugOn);
        buf.append(", reloadDelay = " + this.reloadDelay);
        buf.append(", txCount = " + this.txCount);
        buf.append(", modCount = " + this.modCount);
        buf.append(", displacements = " + this.displacements);
        buf.append(", displBytes = " + this.displacedBytes);
        buf.append(", displData = " + this.displacedData);
        buf.append(", displObjects = " + this.displacedObjects);
        buf.append(", displTables = " + this.displacedTables);
        buf.append(", sumDisplBytes = " + this.sumDisplacedBytes);
        buf.append(", sumDisplData = " + this.sumDisplacedData);
        buf.append(", sumDisplObjects = " + this.sumDisplacedObjects);
        buf.append(", sumDisplTables = " + this.sumDisplacedTables);
        return buf.toString();
    }

    public String getHtmlOverviewHeader() {
        StringBuffer header = new StringBuffer();
        header.append("<th>Ready</th>");
        header.append("<th>Size</th>");
        header.append("<th>Free Bytes</th>");
        header.append("<th>Buffer Objects</th>");
        header.append("<th>Requests</th>");
        header.append("<th>Hits</th>");
        header.append("<th>Efficiency</th>");
        return header.toString();
    }

    public String getHtmlOverviewRow() {
        StringBuffer row = new StringBuffer();
        long efficiency = this.getRequests() == 0L ? 100L : this.getHits() * 100L / this.getRequests();
        row.append("<td>" + this.isReady + "</td><td>");
        formatter.format(this.bufferSize, row, pos);
        row.append("</td><td>");
        formatter.format(this.freeBytes, row, pos);
        row.append("</td><td>");
        formatter.format(this.objectCount, row, pos);
        row.append("</td><td>");
        formatter.format(this.getRequests(), row, pos);
        row.append("</td><td>");
        formatter.format(this.getHits(), row, pos);
        row.append("</td>");
        row.append("<td>" + efficiency + "</td>");
        return row.toString();
    }

    public String getHtmlDetailHeader() {
        StringBuffer header = new StringBuffer();
        header.append("<th>Ready</th>");
        header.append("<th>Startup Date</th>");
        header.append("<th>Reset Date</th>");
        header.append("<th>Reinstall Date</th>");
        header.append("<th>Size</th>");
        header.append("<th>Free</th>");
        header.append("<th>#Resets</th>");
        header.append("<th>#Reinstalls</th>");
        header.append("<th>#Tables</th>");
        header.append("<th>#Objects</th>");
        header.append("<th>#Requests</th>");
        header.append("<th>#Hits</th>");
        header.append("<th>LoadQueueSize</th>");
        header.append("<th>maxRecordSize</th>");
        header.append("<th>maxLobSize</th>");
        header.append("<th>ReloadDelay</th>");
        header.append("<th>TxCount</th>");
        header.append("<th>ModCount</th>");
        header.append("<th>#Displacements</th>");
        header.append("<th>DisplBytes</th>");
        header.append("<th>DisplData</th>");
        header.append("<th>DisplObjects</th>");
        header.append("<th>DisplTables</th>");
        header.append("<th>sumDisplBytes</th>");
        header.append("<th>sumDisplData</th>");
        header.append("<th>sumDisplObjects</th>");
        header.append("<th>sumDisplTables</th>");
        header.append("<th>TraceOn</th>");
        header.append("<th>TraceSeverity</th>");
        header.append("<th>PathOn</th>");
        header.append("<th>DebugOn</th>");
        return header.toString();
    }

    public String getHtmlDetailRow() {
        StringBuffer row = new StringBuffer();
        row.append("<td>" + this.isReady + "</td>");
        row.append("<td>" + this.startUpDate + "</td>");
        row.append("<td>" + this.resetDate + "</td>");
        row.append("<td>" + this.reinstallDate + "</td><td>");
        formatter.format(this.bufferSize, row, pos);
        row.append("</td><td>");
        formatter.format(this.freeBytes, row, pos);
        row.append("</td><td>");
        formatter.format(this.resets, row, pos);
        row.append("</td><td>");
        formatter.format(this.reinstalls, row, pos);
        row.append("</td><td>");
        formatter.format(this.tableCount, row, pos);
        row.append("</td><td>");
        formatter.format(this.objectCount, row, pos);
        row.append("</td><td>");
        formatter.format(this.getRequests(), row, pos);
        row.append("</td><td>");
        formatter.format(this.getHits(), row, pos);
        row.append("</td><td>");
        formatter.format(this.queueSize, row, pos);
        row.append("</td><td>");
        formatter.format(this.maxRecordSize, row, pos);
        row.append("</td><td>");
        formatter.format(this.maxLobSize, row, pos);
        row.append("</td><td>");
        formatter.format(this.reloadDelay, row, pos);
        row.append("</td><td>");
        formatter.format(this.txCount, row, pos);
        row.append("</td><td>");
        formatter.format(this.modCount, row, pos);
        row.append("</td><td>");
        formatter.format(this.displacements, row, pos);
        row.append("</td><td>");
        formatter.format(this.displacedBytes, row, pos);
        row.append("</td><td>");
        formatter.format(this.displacedData, row, pos);
        row.append("</td><td>");
        formatter.format(this.displacedObjects, row, pos);
        row.append("</td><td>");
        formatter.format(this.displacedTables, row, pos);
        row.append("</td><td>");
        formatter.format(this.sumDisplacedBytes, row, pos);
        row.append("</td><td>");
        formatter.format(this.sumDisplacedData, row, pos);
        row.append("</td><td>");
        formatter.format(this.sumDisplacedObjects, row, pos);
        row.append("</td><td>");
        formatter.format(this.sumDisplacedTables, row, pos);
        row.append("</td>");
        row.append("<td>" + this.traceOn + "</td>");
        row.append("<td>" + this.getTraceSeverity() + "</td>");
        row.append("<td>" + this.pathOn + "</td>");
        row.append("<td>" + this.debugOn + "</td>");
        return row.toString();
    }
}

