/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.ObjectExistsException;
import com.sap.sql.buffer.ObjectInconsistentException;
import com.sap.sql.buffer.ObjectNotDefinedException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferDirectoryIterator;
import com.sap.sql.buffer.TBJBufferGenericDirectory;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.sql.buffer.TBJBufferTable;
import com.sap.sql.buffer.TBJBufferTransactionHandling;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class TBJBufferDirectory {
    static final int DIR_SIZE = 104;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferDirectory == null ? (class$com$sap$sql$buffer$TBJBufferDirectory = TBJBufferDirectory.class$("com.sap.sql.buffer.TBJBufferDirectory")) : class$com$sap$sql$buffer$TBJBufferDirectory));
    private TBJBuffer buffer;
    private SortedMap tables;
    private TBJBufferTransactionHandling txHandling;
    private LoadQueue loadQueue;
    private int objectCount = 0;
    private long displacements = 0L;
    private long sumDisplacedBytes = 0L;
    private long sumDisplacedData = 0L;
    private long sumDisplacedObjects = 0L;
    private long sumDisplacedTables = 0L;
    private long displacedBytes;
    private long displacedData;
    private long displacedObjects;
    private long displacedTables;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferDirectory;

    TBJBufferDirectory(TBJBuffer buffer) {
        this.buffer = buffer;
        this.tables = new TreeMap();
        this.txHandling = new TBJBufferTransactionHandling(buffer);
        this.loadQueue = new LoadQueue();
        buffer.reduceFreeBytes(104L);
    }

    TBJBufferTable getTable(String tabName) {
        return (TBJBufferTable)this.tables.get(tabName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TBJBufferObject locateObjectWithWait(String tabName, TBJBufferKey key, boolean create, boolean fullKeyRequired) throws ObjectNotDefinedException, ObjectInconsistentException, IllegalArgumentException, BufferResetException {
        Object object;
        TBJBufferTable table = null;
        TBJBufferKey genericKey = null;
        TBJBufferObject object2 = null;
        int keyCount = 0;
        int genKeyCount = 0;
        int columnCount = 0;
        int givenKeyCount = key == null ? 0 : key.getValueCount();
        int counter = this.buffer.getEndCounter();
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.locateObjectWithWait");
        }
        try {
            try {}
            catch (TypeMismatchException ex) {
                TBJBuffer tBJBuffer = this.buffer;
                synchronized (tBJBuffer) {
                    this.buffer.syncBegin();
                    this.buffer.beginModification();
                    this.removeTable(table.getTableName());
                    this.buffer.endModification();
                    this.buffer.syncEnd();
                    throw (ObjectInconsistentException)this.buffer.getAndLogBufferException(5, this.getClass(), "locateObjectWithWait", new Object[]{table.getTableName()}, (Throwable)((Object)ex));
                }
            }
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            if (!this.buffer.isDebugOn()) throw throwable;
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.locateObjectWithWait: " + (object2 != null ? object2.getName() : null));
            throw throwable;
        }
        do {
            if (counter != this.buffer.getBeginCounter()) {
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    Try to get mutex for buffer");
                }
                object = this.buffer;
                synchronized (object) {
                    this.buffer.syncBegin();
                    this.buffer.syncEnd();
                }
                counter = this.buffer.getEndCounter();
            }
            if ((table = this.getTable(tabName)) == null) {
                throw (ObjectNotDefinedException)this.buffer.getAndLogBufferException(4, this.getClass(), "locateObjectWithWait", new Object[]{tabName});
            }
            keyCount = table.getKeyCount();
            genKeyCount = table.getGenKeyCount();
            columnCount = table.getColumnCount();
            int[] keyIndex = table.getKeyIndex();
            int bufType = table.getBufType();
            if ((bufType == 1 || bufType == 2 && fullKeyRequired) && givenKeyCount < genKeyCount) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "locateObjectWithWait", new Object[]{"given key count < required key count for \"" + tabName + "\""});
            }
            genericKey = bufType == 1 ? (givenKeyCount > genKeyCount ? key.getKey(genKeyCount, null) : key) : null;
            object2 = this.getObject(table, genericKey);
            if (object2 != null || !create) continue;
            object = this.buffer;
            synchronized (object) {
                try {
                    this.buffer.syncBegin();
                    this.buffer.beginModification();
                    object2 = this.createObject(tabName, true, genericKey, keyCount, genKeyCount, columnCount, keyIndex);
                }
                catch (ObjectInconsistentException ex) {
                    this.buffer.endModification();
                    this.buffer.syncEnd();
                    throw ex;
                }
                catch (BufferResetException ex) {
                    throw ex;
                }
                this.buffer.endModification();
                this.buffer.syncEnd();
            }
            TBJBufferObject tBJBufferObject = object2;
            Object var21_21 = null;
            if (!this.buffer.isDebugOn()) return tBJBufferObject;
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.locateObjectWithWait: " + (object2 != null ? object2.getName() : null));
            return tBJBufferObject;
        } while (counter != this.buffer.getBeginCounter());
        object = object2;
        Object var21_22 = null;
        if (!this.buffer.isDebugOn()) return object;
        this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.locateObjectWithWait: " + (object2 != null ? object2.getName() : null));
        return object;
    }

    TBJBufferObject locateObject(String tabName, TBJBufferKey key, boolean create, boolean fullKeyRequired) throws ObjectNotDefinedException, IllegalArgumentException, ObjectInconsistentException {
        TBJBufferTable table = null;
        TBJBufferKey genericKey = null;
        TBJBufferObject object = null;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.locateObject");
        }
        try {
            try {
                int givenKeyCount;
                table = this.getTable(tabName);
                if (table == null) {
                    throw (ObjectNotDefinedException)this.buffer.getAndLogBufferException(4, this.getClass(), "locateObject", new Object[]{tabName});
                }
                int keyCount = table.getKeyCount();
                int genKeyCount = table.getGenKeyCount();
                int columnCount = table.getColumnCount();
                int[] keyIndex = table.getKeyIndex();
                int bufType = table.getBufType();
                int n = givenKeyCount = key == null ? 0 : key.getValueCount();
                if (bufType == 1 && fullKeyRequired && givenKeyCount < genKeyCount) {
                    throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "locateObject", new Object[]{"given generic key count < required generic key count for \"" + tabName + "\""});
                }
                if (bufType == 2 && fullKeyRequired && givenKeyCount < keyCount) {
                    throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "locateObject", new Object[]{"given key count < required key count for \"" + tabName + "\""});
                }
                genericKey = bufType == 1 ? (givenKeyCount > genKeyCount ? key.getKey(genKeyCount, null) : key) : null;
                object = this.getObject(table, genericKey);
                if (object == null && create) {
                    this.buffer.beginModification();
                    try {
                        object = this.createObject(tabName, false, genericKey, keyCount, genKeyCount, columnCount, keyIndex);
                    }
                    catch (ObjectInconsistentException ex) {
                        this.buffer.endModification();
                        throw ex;
                    }
                    this.buffer.endModification();
                }
                TBJBufferObject ex = object;
                Object var16_17 = null;
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.locateObject: " + (object != null ? object.getName() : ""));
                }
                return ex;
            }
            catch (TypeMismatchException ex) {
                this.buffer.beginModification();
                this.removeTable(table.getTableName());
                this.buffer.endModification();
                throw (ObjectInconsistentException)this.buffer.getAndLogBufferException(5, this.getClass(), "locateObject", new Object[]{table.getTableName()}, (Throwable)((Object)ex));
            }
        }
        catch (Throwable throwable) {
            block12: {
                Object var16_18 = null;
                if (!this.buffer.isDebugOn()) break block12;
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.locateObject: " + (object != null ? object.getName() : ""));
            }
            throw throwable;
        }
    }

    TBJBufferObject getObject(TBJBufferTable table, TBJBufferKey genericKey) throws TypeMismatchException {
        if (!table.isGeneric()) {
            return table.getObject();
        }
        TBJBufferGenericDirectory genDir = table.getGenericDirectory();
        return genDir.getObject(this.buffer, genericKey);
    }

    TBJBufferObject createObject(String tabName, boolean checkConsistency, TBJBufferKey givenKey, int keyCount, int genKeyCount, int columnCount, int[] keyIndex) throws ObjectInconsistentException {
        TBJBufferObject object = null;
        TBJBufferTable table = this.getTable(tabName);
        TBJBufferKey genericKey = givenKey != null ? givenKey : new TBJBufferKey();
        boolean consistent = true;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.createObject");
        }
        try {
            if (table == null) {
                table = new TBJBufferTable(this.buffer, this, tabName, keyCount, genKeyCount, columnCount, keyIndex);
                this.tables.put(tabName, table);
                if (!table.isGeneric()) {
                    ++this.objectCount;
                }
            }
            if (checkConsistency) {
                if (table.getKeyCount() != keyCount || table.getGenKeyCount() != genKeyCount || table.getColumnCount() != columnCount) {
                    if (this.buffer.isDebugOn()) {
                        this.buffer.trace(100, TRACE, "    table definition changed.");
                    }
                    consistent = false;
                } else if (table.isGeneric() && genKeyCount != genericKey.getValueCount()) {
                    if (this.buffer.isDebugOn()) {
                        this.buffer.trace(100, TRACE, "    generic key only partly given");
                    }
                    consistent = false;
                }
                if (!consistent) {
                    this.removeTable(tabName);
                    throw (ObjectInconsistentException)this.buffer.getAndLogBufferException(5, this.getClass(), "createObject", new Object[]{tabName + " " + givenKey});
                }
            }
            try {
                if (!table.isGeneric()) {
                    object = table.getObject();
                } else {
                    TBJBufferGenericDirectory genDir = table.getGenericDirectory();
                    if (genDir.checkDummies(this.buffer, genericKey) == null && (object = this.getObject(table, genericKey)) == null) {
                        TBJBufferKey savedKey = genericKey.getKey(genKeyCount, null);
                        object = genDir.addObject(this.buffer, savedKey, false);
                        ++this.objectCount;
                    }
                }
            }
            catch (TypeMismatchException ex) {
                this.removeTable(tabName);
                throw (ObjectInconsistentException)this.buffer.getAndLogBufferException(5, this.getClass(), "createObject", new Object[]{tabName + " " + givenKey}, (Throwable)((Object)ex));
            }
            TBJBufferObject tBJBufferObject = object;
            Object var15_15 = null;
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createObject: " + (object != null ? object.getName() : null));
            }
            return tBJBufferObject;
        }
        catch (Throwable throwable) {
            block18: {
                Object var15_16 = null;
                if (!this.buffer.isDebugOn()) break block18;
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createObject: " + (object != null ? object.getName() : null));
            }
            throw throwable;
        }
    }

    TBJBufferTable createTable(String tabName, int keyCount, int genKeyCount, int columnCount, int[] keyIndex) throws ObjectExistsException {
        TBJBufferTable table = this.getTable(tabName);
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.createTable");
        }
        try {
            if (table == null) {
                table = new TBJBufferTable(this.buffer, this, tabName, keyCount, genKeyCount, columnCount, keyIndex);
                this.tables.put(tabName, table);
                if (!table.isGeneric()) {
                    ++this.objectCount;
                }
            } else {
                throw (ObjectExistsException)this.buffer.getAndLogBufferException(3, this.getClass(), "createTable", new Object[]{tabName});
            }
            TBJBufferTable tBJBufferTable = table;
            Object var9_8 = null;
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createTable");
            }
            return tBJBufferTable;
        }
        catch (Throwable throwable) {
            block7: {
                Object var9_9 = null;
                if (!this.buffer.isDebugOn()) break block7;
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createTable");
            }
            throw throwable;
        }
    }

    TBJBufferObject createDummyObject(TBJBufferTable table, TBJBufferKey genericKey) throws TypeMismatchException {
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.createDummyObject");
        }
        try {
            TBJBufferObject object;
            ++this.objectCount;
            TBJBufferObject tBJBufferObject = object = table.getGenericDirectory().addObject(this.buffer, genericKey, true);
            Object var6_5 = null;
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createDummyObject");
            }
            return tBJBufferObject;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_6 = null;
                if (!this.buffer.isDebugOn()) break block4;
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createDummyObject");
            }
            throw throwable;
        }
    }

    TBJBufferTable createDummyTable(String tableName) {
        TBJBufferTable table;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.createDummyTable");
        }
        try {
            table = this.createTable(tableName, 0, 0, 0, null);
        }
        catch (ObjectExistsException ex) {
            table = this.getTable(tableName);
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.createDummyTable");
        }
        return table;
    }

    void clear() {
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.clear");
        }
        if (this.tables != null) {
            Iterator iter = this.tables.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TBJBufferTable table = (TBJBufferTable)entry.getValue();
                table.clear(this.buffer);
            }
        }
        this.buffer.incrementFreeBytes(64 * this.tables.size());
        this.tables.clear();
        this.txHandling.clear(this.buffer);
        this.loadQueue.clear();
        this.objectCount = 0;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.clear");
        }
    }

    TBJBufferDirectoryIterator getObjects() {
        return new TBJBufferDirectoryIterator(this.tables, null);
    }

    TBJBufferDirectoryIterator getObjects(String tabName) {
        TBJBufferTable table;
        SortedMap relevantGenericRegions = null;
        if (this.tables.containsKey(tabName) && (table = (TBJBufferTable)this.tables.get(tabName)).isGeneric()) {
            relevantGenericRegions = table.getGenericDirectory().getGenericRegions();
        }
        if (relevantGenericRegions != null) {
            return new TBJBufferDirectoryIterator(relevantGenericRegions);
        }
        SortedMap relevantTables = this.tables.tailMap(tabName);
        return new TBJBufferDirectoryIterator(relevantTables, relevantGenericRegions);
    }

    void removeInconsistentTable(String tabName, Object transaction) {
        boolean txRuns = transaction != null;
        this.removeTable(tabName);
        if (txRuns) {
            TBJBufferTable table = this.createDummyTable(tabName);
            TBJBufferObject object = table.getObject();
            object.beginModification();
            object.invalidate(this.buffer, txRuns);
            this.txHandling.setModification(this.buffer, transaction, object);
            object.endModification();
        }
    }

    void removeTable(String tabName) {
        TBJBufferTable table;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.removeTable: " + tabName);
        }
        if ((table = this.getTable(tabName)) != null) {
            this.objectCount -= table.clear(this.buffer);
            this.tables.remove(tabName);
            this.buffer.incrementFreeBytes(64L);
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeTable: objectCount= " + this.objectCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeObject(TBJBufferObject object) {
        block13: {
            block12: {
                block11: {
                    TBJBufferTable table = object.getTable();
                    String tabName = table.getTableName();
                    if (this.buffer.isDebugOn()) {
                        this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.removeObject: " + object.getName() + " objectCount= " + this.objectCount);
                    }
                    try {
                        if (!this.containsTable(tabName)) {
                            Object var7_4 = null;
                            if (!this.buffer.isDebugOn()) return;
                            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeObject: objectCount= " + this.objectCount);
                            return;
                        }
                        if (table.isDummy()) {
                            this.tables.remove(tabName);
                            table.clear(this.buffer);
                            --this.objectCount;
                            this.buffer.incrementFreeBytes(64L);
                            break block11;
                        }
                        if (!table.isGeneric()) {
                            this.tables.remove(tabName);
                            table.clear(this.buffer);
                            --this.objectCount;
                            this.buffer.incrementFreeBytes(64L);
                            break block12;
                        }
                        TBJBufferGenericDirectory genDir = table.getGenericDirectory();
                        try {
                            if (genDir.delObject(this.buffer, object.getGenKey())) {
                                --this.objectCount;
                            }
                        }
                        catch (TypeMismatchException ex) {
                            // empty catch block
                        }
                        if (genDir.getGenericRegionCount() == 0) {
                            this.tables.remove(tabName);
                            table.clear(this.buffer);
                            this.buffer.incrementFreeBytes(64L);
                            break block13;
                        } else {
                            object.clear(this.buffer);
                            this.buffer.incrementFreeBytes(93L);
                        }
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (!this.buffer.isDebugOn()) throw throwable;
                        this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeObject: objectCount= " + this.objectCount);
                        throw throwable;
                    }
                }
                Object var7_5 = null;
                if (!this.buffer.isDebugOn()) return;
                this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeObject: objectCount= " + this.objectCount);
                return;
            }
            Object var7_6 = null;
            if (!this.buffer.isDebugOn()) return;
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeObject: objectCount= " + this.objectCount);
            return;
        }
        Object var7_7 = null;
        if (!this.buffer.isDebugOn()) return;
        this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeObject: objectCount= " + this.objectCount);
    }

    void invalidate() {
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.invalidate: directory");
        }
        TBJBufferDirectoryIterator iter = this.getObjects();
        while (iter.hasNext()) {
            TBJBufferObject object = iter.next();
            if (object == null) continue;
            object.beginModification();
            object.invalidate(this.buffer, false);
            object.endModification();
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.invalidate: directory");
        }
    }

    boolean addToQueue(TBJBufferObject object) {
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.addToQueue: " + object.getName());
        }
        boolean succeeded = this.loadQueue.setFirst(object);
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.addToQueue");
        }
        return succeeded;
    }

    void removeFromQueue(TBJBufferObject object) {
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.removeFromQueue: " + object.getName());
        }
        this.loadQueue.remove(object);
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.removeFromQueue");
        }
    }

    int getObjectCount() {
        return this.objectCount;
    }

    int getQueueSize() {
        return this.loadQueue.getSize();
    }

    void dumpLoadQueue() {
        this.loadQueue.dump();
    }

    int getTableCount() {
        return this.tables.size();
    }

    TBJBufferTransactionHandling getTxHandling() {
        return this.txHandling;
    }

    TBJBuffer getBuffer() {
        return this.buffer;
    }

    long cleanUp() {
        long cleanedBytes = 0L;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.cleanUp");
        }
        TBJBufferDirectoryIterator dirIter = this.getObjects();
        while (dirIter.hasNext()) {
            TBJBufferObject object = dirIter.next();
            if (object == null || !object.isReleasible()) continue;
            object.beginModification();
            cleanedBytes += object.clearData(this.buffer);
            this.loadQueue.remove(object);
            object.endModification();
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.cleanUp");
        }
        return cleanedBytes;
    }

    void reactivateObjects() {
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.reactivateObjects");
        }
        TBJBufferDirectoryIterator dirIter = this.getObjects();
        while (dirIter.hasNext()) {
            TBJBufferObject object = dirIter.next();
            if (object == null || object.getStatus() != 4) continue;
            object.beginModification();
            object.reactivate(this.buffer);
            object.endModification();
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.reactivateObjects");
        }
    }

    long displaceAttempt(long neededBytes, TBJBufferObject excluding) {
        long displBytes = 0L;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.displaceAttempt: ");
        }
        ++this.displacements;
        this.displacedBytes = 0L;
        this.displacedData = 0L;
        this.displacedObjects = 0L;
        this.displacedTables = 0L;
        if (this.loadQueue.getSize() > 0) {
            displBytes += this.loadQueue.displaceData(neededBytes, excluding);
        }
        if (neededBytes > displBytes) {
            displBytes += this.displaceObjects(neededBytes, excluding);
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.tryToDisplace: displaceAttempt = " + displBytes);
        }
        return displBytes;
    }

    long displaceObjects(long neededBytes, TBJBufferObject excluding) {
        TBJBufferDirectoryIterator iterator = this.getObjects();
        ArrayList<TBJBufferObject> toBeRemoved = new ArrayList<TBJBufferObject>();
        long displBytes = 0L;
        long displObjects = 0L;
        long displTables = 0L;
        TBJBufferTable lastDisplTable = null;
        int displGenRegionCount = 1;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "---> TBJBufferDirectory.displaceObjects: ");
        }
        while (iterator.hasNext()) {
            int actGenRegionCount;
            TBJBufferObject object = iterator.next();
            if (object == null || object == excluding || !object.isDisplaceable()) continue;
            toBeRemoved.add(object);
            TBJBufferTable table = object.getTable();
            if (table == lastDisplTable) {
                ++displGenRegionCount;
            }
            if (table.getBufType() != 1 || (actGenRegionCount = table.getGenericDirectory().getGenericRegionCount()) == 1 || table == lastDisplTable && actGenRegionCount == displGenRegionCount) {
                displBytes += 64L;
                ++displTables;
            }
            lastDisplTable = table;
            ++displObjects;
            if ((displBytes += 161L + object.sizeData()) >= neededBytes) break;
        }
        int i = 0;
        while (i < toBeRemoved.size()) {
            this.removeObject((TBJBufferObject)toBeRemoved.get(i));
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "\tObject displaced: " + ((TBJBufferObject)toBeRemoved.get(i)).getName());
            }
            ++i;
        }
        this.displacedBytes += displBytes;
        this.displacedTables += displTables;
        this.displacedObjects += displObjects;
        this.sumDisplacedBytes += displBytes;
        this.sumDisplacedTables += displTables;
        this.sumDisplacedObjects += displObjects;
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "<--- TBJBufferDirectory.displaceObjects: displacedBytes = " + displBytes);
        }
        return displBytes;
    }

    long getDisplacements() {
        return this.displacements;
    }

    long getDisplacedBytes() {
        return this.displacedBytes;
    }

    long getDisplacedData() {
        return this.displacedData;
    }

    long getDisplacedObjects() {
        return this.displacedObjects;
    }

    long getDisplacedTables() {
        return this.displacedTables;
    }

    long getSumDisplacedBytes() {
        return this.sumDisplacedBytes;
    }

    long getSumDisplacedData() {
        return this.sumDisplacedData;
    }

    long getSumDisplacedObjects() {
        return this.sumDisplacedObjects;
    }

    long getSumDisplacedTables() {
        return this.sumDisplacedTables;
    }

    long size() {
        long sum = 104L;
        Set entrySet = this.tables.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TBJBufferTable table = (TBJBufferTable)entry.getValue();
            sum += table.size();
        }
        return sum;
    }

    int check(TBJBufferObject[] tempDir, HashMap objectIndex) {
        TBJBufferDirectoryIterator iter = this.getObjects();
        int objCount = 0;
        int errorCode = 0;
        while (iter.hasNext()) {
            String tabName;
            TBJBufferObject object = iter.next();
            if (object == null) continue;
            ++objCount;
            TBJBufferTable table = object.getTable();
            if (table != this.getTable(tabName = table.getTableName())) {
                errorCode = 100;
                this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Table not found in directory");
                return errorCode;
            }
            TBJBufferKey genKey = object.getGenKey();
            if (genKey != null) {
                TBJBufferGenericDirectory genDir = table.getGenericDirectory();
                try {
                    if (object != genDir.getObject(this.buffer, genKey)) {
                        errorCode = 101;
                        this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Generic Region not found in generic directory");
                        return errorCode;
                    }
                }
                catch (TypeMismatchException ex) {}
            } else if (object != table.getObject()) {
                errorCode = 102;
                this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Object not found in table");
                return errorCode;
            }
            if (objCount > this.objectCount) continue;
            tempDir[objCount - 1] = object;
            objectIndex.put(object, new Integer(objCount - 1));
        }
        if (objCount != this.objectCount) {
            errorCode = 103;
            this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Object count is false");
            return errorCode;
        }
        errorCode = this.loadQueue.checkLoadQueue(tempDir, objectIndex);
        return errorCode;
    }

    private boolean containsTable(String tabName) {
        return this.tables.containsKey(tabName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LoadQueue {
        static final int LOAD_QUEUE_SIZE = 12;
        private int size = 0;
        private TBJBufferObject first = TBJBufferObject.OBJECT_NULL;
        private TBJBufferObject last = TBJBufferObject.OBJECT_NULL;

        private LoadQueue() {
        }

        private boolean setFirst(TBJBufferObject object) {
            if (object.getPrevious() == null) {
                this.add(object);
            } else {
                this.update(object);
            }
            return true;
        }

        private void remove(TBJBufferObject object) {
            if (object.getPrevious() != null && object != TBJBufferObject.OBJECT_NULL) {
                --this.size;
                if (this.first == object) {
                    this.first = object.getNext();
                } else {
                    object.getPrevious().setNext(object.getNext());
                }
                if (this.last == object) {
                    this.last = object.getPrevious();
                } else {
                    object.getNext().setPrevious(object.getPrevious());
                }
                object.setNext(null);
                object.setPrevious(null);
            }
        }

        private int getSize() {
            return this.size;
        }

        private void clear() {
            this.size = 0;
            this.first = TBJBufferObject.OBJECT_NULL;
            this.last = TBJBufferObject.OBJECT_NULL;
        }

        private long displaceData(long neededBytes, TBJBufferObject excluding) {
            TBJBufferObject object = this.last;
            int loops = 0;
            long displBytes = 0L;
            long displData = 0L;
            while (object != TBJBufferObject.OBJECT_NULL && neededBytes > displBytes && loops <= 1) {
                TBJBufferObject previous = object.getPrevious();
                if (object.isDisplaceable() && object != excluding) {
                    object.beginModification();
                    if (object.isDisplaceable()) {
                        displBytes += object.clearData(TBJBufferDirectory.this.buffer);
                        object.setStatus(4);
                        if (TBJBufferDirectory.this.buffer.isDebugOn()) {
                            TBJBufferDirectory.this.buffer.trace(100, TRACE, "\tObject displaced: " + object.getName());
                        }
                        this.remove(object);
                        ++displData;
                    }
                    object.endModification();
                }
                object.resetUsedCounter();
                object = previous;
                if (object != TBJBufferObject.OBJECT_NULL) continue;
                ++loops;
                object = this.last;
            }
            TBJBufferDirectory.this.displacedData += displData;
            TBJBufferDirectory.this.displacedBytes += displBytes;
            TBJBufferDirectory.this.sumDisplacedData += displData;
            TBJBufferDirectory.this.sumDisplacedBytes += displBytes;
            return displBytes;
        }

        private void add(TBJBufferObject object) {
            if (this.first == TBJBufferObject.OBJECT_NULL) {
                this.size = 1;
                object.setPrevious(TBJBufferObject.OBJECT_NULL);
                object.setNext(TBJBufferObject.OBJECT_NULL);
                this.first = object;
                this.last = object;
            } else {
                ++this.size;
                object.setNext(this.first);
                object.setPrevious(TBJBufferObject.OBJECT_NULL);
                this.first.setPrevious(object);
                this.first = object;
            }
        }

        private void update(TBJBufferObject object) {
            if (object != this.first) {
                if (this.last == object) {
                    this.first.setPrevious(object);
                    this.last = object.getPrevious();
                    object.setPrevious(TBJBufferObject.OBJECT_NULL);
                    object.setNext(this.first);
                    this.first = object;
                    this.last.setNext(TBJBufferObject.OBJECT_NULL);
                } else {
                    object.getPrevious().setNext(object.getNext());
                    object.getNext().setPrevious(object.getPrevious());
                    object.setNext(this.first);
                    object.setPrevious(TBJBufferObject.OBJECT_NULL);
                    this.first.setPrevious(object);
                    this.first = object;
                }
            }
        }

        private void dump() {
            TBJBufferObject temp = this.first;
            System.out.println("QUEUE: size= " + this.size);
            while (temp != TBJBufferObject.OBJECT_NULL) {
                System.out.print("Table= " + temp.getTableName());
                if (temp.getTable().isGeneric()) {
                    System.out.println(", GenKey= " + temp.getGenKey());
                } else {
                    System.out.println();
                }
                temp = temp.getNext();
            }
        }

        private int checkLoadQueue(TBJBufferObject[] tempDir, HashMap objectIndex) {
            TBJBufferObject dirObject = null;
            TBJBufferObject lastObject = TBJBufferObject.OBJECT_NULL;
            int queueSize = 0;
            int errorCode = 0;
            int[] occurrences = new int[tempDir.length];
            int i = 0;
            while (i < occurrences.length) {
                occurrences[i] = 0;
                ++i;
            }
            TBJBufferObject object = this.first;
            while (object != TBJBufferObject.OBJECT_NULL) {
                int index;
                ++queueSize;
                try {
                    dirObject = TBJBufferDirectory.this.getObject(object.getTable(), object.getGenKey());
                }
                catch (TypeMismatchException ex) {
                    // empty catch block
                }
                if (object != dirObject) {
                    errorCode = 150;
                    TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Queue object not found within directory");
                    return errorCode;
                }
                TBJBufferObject nextObject = object.getNext();
                if (nextObject != TBJBufferObject.OBJECT_NULL && nextObject.getPrevious() != object) {
                    errorCode = 151;
                    TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Chaining is false");
                    return errorCode;
                }
                int n = index = ((Integer)objectIndex.get(object)).intValue();
                occurrences[n] = occurrences[n] + 1;
                lastObject = object;
                object = nextObject;
            }
            if (this.size != queueSize) {
                errorCode = 152;
                if (TBJBufferDirectory.this.buffer.isDebugOn()) {
                    TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Queue size is false");
                }
                return errorCode;
            }
            if (lastObject != this.last) {
                errorCode = 153;
                TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Last queue object not found");
                return errorCode;
            }
            int i2 = 0;
            while (i2 < tempDir.length) {
                int occValue = occurrences[i2];
                object = tempDir[i2];
                int status = object.getStatus();
                if (occValue == 0) {
                    if (status == 2) {
                        errorCode = 154;
                        TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Valid object (" + object.getName() + ") not in load queue");
                        return errorCode;
                    }
                    if (object.getNext() != null || object.getPrevious() != null) {
                        errorCode = 155;
                        TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Object (" + object.getName() + ") not in load queue but has references");
                    }
                } else if (occValue == 1) {
                    if (status == 5 || status == 4) {
                        errorCode = 156;
                        TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Object (" + object.getName() + ") is in load queue but has status ERROR or ABSENT");
                    }
                } else {
                    errorCode = 157;
                    TBJBufferDirectory.this.buffer.trace(500, TRACE, "Check-Error(" + errorCode + "): Object (" + object.getName() + ") in load queue several times");
                }
                ++i2;
            }
            return errorCode;
        }
    }
}

