/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferLoadAccess;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.BufferRecordProcessor;
import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.DataLockedException;
import com.sap.sql.buffer.DataNotLoadableException;
import com.sap.sql.buffer.DataWasDisplacedException;
import com.sap.sql.buffer.ExternalBufferException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.NoMemoryAvailableException;
import com.sap.sql.buffer.ObjectInconsistentException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferDirectory;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.sql.buffer.TBJBufferRecord;
import com.sap.sql.buffer.TBJBufferStatus;
import com.sap.sql.buffer.TBJBufferTable;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class TBJBufferData
implements BufferLoadAccess {
    static final int IS_STRONGLY_REACHABLE = 0;
    static final int IS_NOT_REACHABLE = 1;
    static final int DATA_SIZE = 68;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferData == null ? (class$com$sap$sql$buffer$TBJBufferData = TBJBufferData.class$("com.sap.sql.buffer.TBJBufferData")) : class$com$sap$sql$buffer$TBJBufferData));
    private static final String putMethod = "put(BufferRecord)";
    private static final String putMethodName = "put";
    private static final String endMethod = "end()";
    private static final String endMethodName = "end";
    private static final String abortMethod = "abort()";
    private static final String abortMethodName = "abort";
    private static final String insertRecordMethodName = "insertRecord";
    private static final String updateRecordMethodName = "updateRecord";
    private static final String deleteRecordsMethodName = "deleteRecords";
    private TBJBufferObject object;
    private SortedMap container;
    private TBJBufferKey keyForNotFoundRecord = null;
    private TBJBufferRecord recordForSingleLoad = null;
    private int savedConsistencyCounter;
    private int notFounds = 0;
    private long sizeOfContainer = 0L;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferData;

    public TBJBufferData(TBJBuffer buffer, TBJBufferObject object, TBJBufferKey key, boolean allocContainer) {
        this.object = object;
        this.keyForNotFoundRecord = key;
        this.savedConsistencyCounter = object.getConsistencyCounter();
        if (allocContainer) {
            this.allocContainer();
        }
        buffer.reduceFreeBytes(68L);
    }

    public void put(BufferRecord record) throws BufferNotAvailableException, NoMemoryAvailableException, DataLockedException, DataNotLoadableException, ObjectInconsistentException, IllegalArgumentException, BufferResetException {
        TBJBufferTable table = this.object.getTable();
        TBJBufferDirectory dir = table.getDirectory();
        TBJBuffer buffer = dir.getBuffer();
        TBJBufferRecord rec = (TBJBufferRecord)record;
        if (buffer.isPathOn()) {
            buffer.entering(TRACE, putMethod, new Object[]{record});
        }
        try {
            int definedColumnCount;
            if (!buffer.isReady()) {
                throw buffer.getAndLogBufferNotAvailableException(this.getClass(), putMethodName);
            }
            if (rec == null || !rec.isValid()) {
                throw (IllegalArgumentException)buffer.getAndLogBufferException(1, this.getClass(), putMethodName, new Object[]{"record is null or not valid for \"" + this.object.getName() + "\""});
            }
            int bufType = table.getBufType();
            long recSize = rec.size();
            int columnCount = rec.getValueCount();
            if (columnCount != (definedColumnCount = table.getColumnCount())) {
                if (buffer.isDebugOn()) {
                    buffer.trace(100, TRACE, "    inconsistent column count.");
                }
                TBJBuffer tBJBuffer = buffer;
                synchronized (tBJBuffer) {
                    buffer.syncBegin();
                    if (!this.object.isExistent(buffer)) {
                        if (buffer.isDebugOn()) {
                            buffer.trace(100, TRACE, "    object non-existant: " + this.object.getName());
                        }
                        this.object.clear(buffer);
                    }
                    buffer.beginModification();
                    dir.removeInconsistentTable(this.object.getTableName(), null);
                    buffer.endModification();
                    buffer.syncEnd();
                }
                this.clearLoadArea(buffer);
                throw (ObjectInconsistentException)buffer.getAndLogBufferException(5, this.getClass(), putMethodName, new Object[]{this.object.getName()});
            }
            int status = this.object.getStatus();
            if (status == 1) {
                if (buffer.isDebugOn()) {
                    buffer.trace(100, TRACE, "    status= LOADING");
                }
                if (recSize > buffer.getMaxRecordSize()) {
                    int newStatus = bufType == 2 ? 4 : 5;
                    this.setStatusSynchronized(buffer, dir, newStatus);
                    this.clearLoadArea(buffer);
                    throw (IllegalArgumentException)buffer.getAndLogBufferException(1, this.getClass(), putMethodName, new Object[]{"record of object \"" + this.object.getName() + "\" with size (" + recSize + ") exceeds max. record size (" + buffer.getMaxRecordSize() + ")"});
                }
                if (!(buffer.memoryIsAvailable(recSize) || buffer.isDisplacementOn() && buffer.displace(recSize, this.object))) {
                    this.setStatusSynchronized(buffer, dir, 4);
                    this.clearLoadArea(buffer);
                    throw (NoMemoryAvailableException)buffer.getAndLogBufferException(2, this.getClass(), putMethodName);
                }
                if (this.object.hasChanged(this.savedConsistencyCounter)) {
                    this.clearLoadArea(buffer);
                    throw (DataLockedException)buffer.getAndLogBufferException(8, this.getClass(), putMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus()), "consistency counters changed"});
                }
                try {
                    this.addRecord(buffer, this.keyForNotFoundRecord, rec);
                }
                catch (TypeMismatchException ex) {
                    this.setStatusSynchronized(buffer, dir, 5);
                    this.clearLoadArea(buffer);
                    throw (DataNotLoadableException)buffer.getAndLogBufferException(9, this.getClass(), putMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus())}, (Throwable)((Object)ex));
                }
                this.recordForSingleLoad = (TBJBufferRecord)record;
            } else if (bufType == 2 && status == 2) {
                if (buffer.isDebugOn()) {
                    buffer.trace(100, TRACE, "    SINGLE buffered: status= VALID");
                }
                if (recSize > buffer.getMaxRecordSize()) {
                    this.clearLoadArea(buffer);
                    throw (IllegalArgumentException)buffer.getAndLogBufferException(1, this.getClass(), putMethodName, new Object[]{"record of object \"" + this.object.getName() + "\" with size (" + recSize + ") exceeds max. record size (" + buffer.getMaxRecordSize() + ")"});
                }
                if (!(buffer.memoryIsAvailable(recSize) || buffer.isDisplacementOn() && buffer.displace(recSize, this.object))) {
                    this.clearLoadArea(buffer);
                    throw (NoMemoryAvailableException)buffer.getAndLogBufferException(2, this.getClass(), "put: no memory available");
                }
                this.recordForSingleLoad = rec;
            } else {
                this.clearLoadArea(buffer);
                if (status == 5) {
                    throw (DataNotLoadableException)buffer.getAndLogBufferException(9, this.getClass(), putMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus())});
                }
                throw (DataLockedException)buffer.getAndLogBufferException(8, this.getClass(), putMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus()), "consistency counters changed"});
            }
            Object var15_15 = null;
            if (buffer.isPathOn()) {
                buffer.exiting(TRACE, putMethodName);
            }
            return;
        }
        catch (Throwable throwable) {
            block27: {
                Object var15_16 = null;
                if (!buffer.isPathOn()) break block27;
                buffer.exiting(TRACE, putMethodName);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void end() throws BufferNotAvailableException, DataLockedException, DataNotLoadableException, ObjectInconsistentException, BufferResetException {
        TBJBufferTable table = this.object.getTable();
        TBJBufferDirectory dir = table.getDirectory();
        TBJBuffer buffer = dir.getBuffer();
        boolean inconsistent = false;
        boolean consistencyCounterChanged = false;
        boolean oldDataExists = false;
        if (buffer.isPathOn()) {
            buffer.entering(TRACE, endMethod);
        }
        try {
            if (!buffer.isReady()) {
                throw buffer.getAndLogBufferNotAvailableException(this.getClass(), endMethodName);
            }
            int bufType = table.getBufType();
            TBJBuffer tBJBuffer = buffer;
            synchronized (tBJBuffer) {
                buffer.syncBegin(this.object);
                try {
                    try {
                        TBJBufferData oldData = this.object.getData();
                        int status = this.object.getStatus();
                        if (!this.object.isExistent(buffer)) {
                            inconsistent = true;
                        }
                        if (this.object.hasChanged(this.savedConsistencyCounter)) {
                            consistencyCounterChanged = true;
                        }
                        if (inconsistent) {
                            this.clearLoadArea(buffer);
                            this.object.clear(buffer);
                            throw (ObjectInconsistentException)buffer.getAndLogBufferException(5, this.getClass(), endMethodName, new Object[]{this.object.getName()});
                        }
                        this.object.beginModification();
                        if (oldData != null && (bufType != 2 || status != 2)) {
                            this.object.waitBusyForHotObject(buffer);
                            this.object.clearData(buffer);
                            oldDataExists = true;
                        }
                        if (status == 1) {
                            if (consistencyCounterChanged) {
                                this.clearLoadArea(buffer);
                                this.object.clear(buffer);
                                throw (DataNotLoadableException)buffer.getAndLogBufferException(9, this.getClass(), endMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus()), "consistency counters changed"});
                            }
                            if (bufType == 2 && this.recordForSingleLoad == null) {
                                this.addRecord(buffer, this.keyForNotFoundRecord, null);
                            }
                            this.keyForNotFoundRecord = null;
                            this.recordForSingleLoad = null;
                            this.object.setData(this);
                            this.object.setStatus(2);
                            this.object.endModification();
                            if (oldDataExists) {
                                buffer.incrementFreeBytes(68L);
                            }
                            if (buffer.isDebugOn()) {
                                buffer.trace(100, TRACE, "    record count= " + this.getRecordCount());
                            }
                            Object var13_11 = null;
                            buffer.syncEnd();
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 4, 20] lbl55 : MonitorExitStatement: MONITOREXIT : var10_8
                            Object var16_15 = null;
                            if (!buffer.isPathOn()) return;
                            buffer.exiting(TRACE, endMethodName);
                            return;
                        }
                        if (bufType == 2 && status == 2) {
                            if (this.object.isHotObject()) {
                                this.clearLoadArea(buffer);
                                this.object.endModification();
                                throw (DataLockedException)buffer.getAndLogBufferException(8, this.getClass(), endMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus()), "object is hot"});
                            }
                            if (this.keyForNotFoundRecord == null && this.recordForSingleLoad == null) {
                                this.clearLoadArea(buffer);
                                this.object.endModification();
                                if (buffer.isDebugOn()) {
                                    buffer.trace(500, TRACE, "end: key= null and record= null of " + this.object.getName());
                                }
                                Object var13_12 = null;
                                buffer.syncEnd();
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 4, 13, 15] lbl74 : MonitorExitStatement: MONITOREXIT : var10_8
                                Object var16_16 = null;
                                if (!buffer.isPathOn()) return;
                                buffer.exiting(TRACE, endMethodName);
                                return;
                            }
                            if (!oldData.addRecord(buffer, this.keyForNotFoundRecord, this.recordForSingleLoad) && dir.addToQueue(this.object)) {
                                oldData.allocContainer();
                                oldData.addRecord(buffer, this.keyForNotFoundRecord, this.recordForSingleLoad);
                            }
                            this.clearLoadArea(buffer);
                            this.object.endModification();
                            if (buffer.isDebugOn()) {
                                buffer.trace(100, TRACE, "    record count= " + oldData.getRecordCount());
                            }
                            Object var13_13 = null;
                            buffer.syncEnd();
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 4, 15] lbl91 : MonitorExitStatement: MONITOREXIT : var10_8
                            Object var16_17 = null;
                            if (!buffer.isPathOn()) return;
                            buffer.exiting(TRACE, endMethodName);
                            return;
                        }
                        this.clearLoadArea(buffer);
                        this.object.endModification();
                        if (status == 5) {
                            throw (DataNotLoadableException)buffer.getAndLogBufferException(9, this.getClass(), endMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus())});
                        }
                        throw (DataLockedException)buffer.getAndLogBufferException(8, this.getClass(), endMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus()), "status of object changed"});
                    }
                    catch (TypeMismatchException ex) {
                        this.object.clear(buffer);
                        if (buffer.isDebugOn()) {
                            buffer.trace(100, TRACE, "    set status= ERROR");
                        }
                        this.clearLoadArea(buffer);
                        throw (DataNotLoadableException)buffer.getAndLogBufferException(9, this.getClass(), endMethodName, new Object[]{this.object.getName(), TBJBufferStatus.printStatus(this.object.getStatus())}, (Throwable)((Object)ex));
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    buffer.syncEnd();
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (!buffer.isPathOn()) throw throwable;
            buffer.exiting(TRACE, endMethodName);
            throw throwable;
        }
    }

    public void abort() throws BufferNotAvailableException {
        TBJBufferTable table = this.object.getTable();
        TBJBufferDirectory dir = table.getDirectory();
        TBJBuffer buffer = dir.getBuffer();
        if (buffer.isPathOn()) {
            buffer.entering(TRACE, abortMethod);
        }
        try {
            try {
                if (!buffer.isReady()) {
                    throw buffer.getAndLogBufferNotAvailableException(this.getClass(), abortMethodName);
                }
                int bufType = table.getBufType();
                TBJBuffer tBJBuffer = buffer;
                synchronized (tBJBuffer) {
                    buffer.syncBegin(this.object);
                    if (buffer.isDebugOn()) {
                        buffer.trace(100, TRACE, "   " + this.object + " Directory: " + dir.getObjectCount());
                    }
                    TBJBufferData oldData = this.object.getData();
                    int status = this.object.getStatus();
                    this.object.beginModification();
                    if (oldData != null && (bufType != 2 || status == 5) || !this.object.isExistent(buffer)) {
                        this.object.waitBusyForHotObject(buffer);
                        this.object.clearData(buffer);
                        dir.removeFromQueue(this.object);
                    }
                    if (bufType != 2 && status != 4) {
                        dir.removeFromQueue(this.object);
                        this.object.setStatus(5);
                    }
                    this.clearLoadArea(buffer);
                    this.object.endModification();
                    if (buffer.isDebugOn()) {
                        buffer.trace(100, TRACE, "    " + this.object.getName() + ", Directory: " + buffer.getDirectory().getObjectCount());
                    }
                    buffer.syncEnd();
                }
                Object var10_10 = null;
                if (buffer.isPathOn()) {
                    buffer.exiting(TRACE, abortMethodName);
                }
                return;
            }
            catch (BufferResetException ex) {
                Object var10_11 = null;
                if (buffer.isPathOn()) {
                    buffer.exiting(TRACE, abortMethodName);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            block15: {
                Object var10_12 = null;
                if (!buffer.isPathOn()) break block15;
                buffer.exiting(TRACE, abortMethodName);
            }
            throw throwable;
        }
    }

    TBJBufferObject getObject() {
        return this.object;
    }

    TBJBufferRecord getRecord(TBJBuffer buffer, TBJBufferKey key) throws DataWasDisplacedException, TypeMismatchException {
        SortedMap tempContainer = this.getContainer();
        if (tempContainer == null) {
            throw (DataWasDisplacedException)buffer.getAndLogBufferException(10, this.getClass(), "getRecord", new Object[]{this.object.getName()});
        }
        return this.getRecordInContainer(buffer, tempContainer, key);
    }

    Iterator locateRecord(TBJBuffer buffer, TBJBufferKey key) throws DataWasDisplacedException, TypeMismatchException {
        SortedMap tempContainer = this.getContainer();
        if (tempContainer == null) {
            throw (DataWasDisplacedException)buffer.getAndLogBufferException(10, this.getClass(), "locateRecord", new Object[]{this.object.getName()});
        }
        return this.locateRecordInContainer(buffer, tempContainer, key);
    }

    boolean addRecord(TBJBuffer buffer, TBJBufferKey key, TBJBufferRecord record) throws TypeMismatchException {
        SortedMap tempContainer = this.getContainer();
        if (tempContainer == null) {
            return false;
        }
        this.putRecordInContainer(buffer, tempContainer, key, record);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean insertRecord(TBJBuffer buffer, int bufType, TBJBufferKey key, TBJBufferRecord record) throws DataWasDisplacedException, TypeMismatchException {
        SortedMap tempContainer = this.getContainer();
        boolean found = false;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferData.insertRecord: bufType= " + TBJBufferTable.printType(bufType) + " key= " + key + " record= " + record);
        }
        try {
            boolean bl;
            try {
                if (tempContainer == null) {
                    throw (DataWasDisplacedException)buffer.getAndLogBufferException(10, this.getClass(), insertRecordMethodName, new Object[]{this.object.getName()});
                }
                this.object.incrementUsedCounter();
                TBJBufferRecord oldRecord = this.getRecordInContainer(buffer, tempContainer, key);
                if (oldRecord == null || bufType == 2 && oldRecord == TBJBufferRecord.NOT_FOUND_RECORD) {
                    this.putRecordInContainer(buffer, tempContainer, key, record);
                    if (oldRecord == TBJBufferRecord.NOT_FOUND_RECORD) {
                        --this.notFounds;
                    }
                    found = true;
                } else {
                    found = false;
                }
                bl = found;
                Object var10_10 = null;
            }
            catch (ClassCastException ex) {
                throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), insertRecordMethodName, new Object[]{"while inserting record \"" + record + "\" in object \"" + this.object.getName() + "\""}, ex);
            }
            if (!buffer.isDebugOn()) return bl;
            buffer.trace(100, TRACE, "<--- TBJBufferData.insertRecord: " + found);
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!buffer.isDebugOn()) throw throwable;
            buffer.trace(100, TRACE, "<--- TBJBufferData.insertRecord: " + found);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateRecord(TBJBuffer buffer, int bufType, TBJBufferKey key, TBJBufferRecord record) throws DataWasDisplacedException, TypeMismatchException {
        SortedMap tempContainer = this.getContainer();
        boolean found = false;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferData.updateRecord: bufType= " + TBJBufferTable.printType(bufType) + " key= " + key + " record= " + record);
        }
        try {
            boolean deletedBytes2;
            try {
                if (tempContainer == null) {
                    throw (DataWasDisplacedException)buffer.getAndLogBufferException(10, this.getClass(), updateRecordMethodName, new Object[]{this.object.getName()});
                }
                this.object.incrementUsedCounter();
                TBJBufferRecord oldRecord = this.getRecordInContainer(buffer, tempContainer, key);
                if (oldRecord == null && bufType == 2) {
                    found = true;
                } else if (oldRecord != null && (bufType != 2 || oldRecord != TBJBufferRecord.NOT_FOUND_RECORD)) {
                    long deletedBytes2 = this.sizeOfRecordInContainer(oldRecord, key.getValueCount());
                    buffer.incrementFreeBytes(deletedBytes2);
                    record.update(buffer, oldRecord);
                    this.sizeOfContainer -= deletedBytes2;
                    this.putRecordInContainer(buffer, tempContainer, key, record);
                    found = true;
                } else {
                    found = false;
                }
                deletedBytes2 = found;
                Object var11_11 = null;
            }
            catch (ClassCastException ex) {
                throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), updateRecordMethodName, new Object[]{"while updating record \"" + record + "\" of object \"" + this.object.getName() + "\""}, ex);
            }
            if (!buffer.isDebugOn()) return deletedBytes2;
            buffer.trace(100, TRACE, "<--- TBJBufferData.updateRecord: " + found);
            return deletedBytes2;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!buffer.isDebugOn()) throw throwable;
            buffer.trace(100, TRACE, "<--- TBJBufferData.updateRecord: " + found);
            throw throwable;
        }
    }

    boolean deleteRecords(TBJBuffer buffer, boolean fullKeyGiven, int definedKeyCount, TBJBufferKey key, BufferRecordProcessor processor) throws DataWasDisplacedException, TypeMismatchException, ExternalBufferException {
        SortedMap tempContainer = this.getContainer();
        int bufType = this.object.getTable().getBufType();
        int deleted = 0;
        String methodName = deleteRecordsMethodName;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferData.deleteRecords (fullKeyGiven= " + fullKeyGiven + " key= " + key + " ): " + this.object.getName());
        }
        try {
            block19: {
                block16: {
                    TBJBufferRecord oldRecord;
                    block17: {
                        block20: {
                            block18: {
                                if (tempContainer == null) {
                                    throw (DataWasDisplacedException)buffer.getAndLogBufferException(10, this.getClass(), deleteRecordsMethodName, new Object[]{this.object.getName()});
                                }
                                this.object.incrementUsedCounter();
                                if (!fullKeyGiven) break block16;
                                oldRecord = this.getRecordInContainer(buffer, tempContainer, key);
                                if (bufType != 2) break block17;
                                if (oldRecord != TBJBufferRecord.NOT_FOUND_RECORD) break block18;
                                this.delRecordInContainer(buffer, tempContainer, key);
                                --this.notFounds;
                                break block19;
                            }
                            if (oldRecord != null) break block20;
                            deleted = 1;
                            break block19;
                        }
                        boolean found = true;
                        if (processor != null) {
                            try {
                                found = processor.verifySearchCondition(oldRecord);
                            }
                            catch (Exception ex) {
                                String objName = this.object.getName();
                                throw (ExternalBufferException)buffer.getAndLogBufferException(16, this.getClass(), deleteRecordsMethodName, new Object[]{"Exception while verifying search condition on record \" " + oldRecord + "\" of \"" + objName + "\""}, ex);
                            }
                        }
                        if (!found) break block19;
                        this.delRecordInContainer(buffer, tempContainer, key);
                        deleted = 1;
                        break block19;
                    }
                    if (oldRecord == null) break block19;
                    boolean found = true;
                    if (processor != null) {
                        try {
                            found = processor.verifySearchCondition(oldRecord);
                        }
                        catch (Exception ex) {
                            String objName = this.object.getName();
                            throw (ExternalBufferException)buffer.getAndLogBufferException(16, this.getClass(), deleteRecordsMethodName, new Object[]{"Exception while verifying search condition on record \" " + oldRecord + "\" of \"" + objName + "\""}, ex);
                        }
                    }
                    if (!found) break block19;
                    this.delRecordInContainer(buffer, tempContainer, key);
                    deleted = 1;
                    break block19;
                }
                Iterator recordIterator = this.locateRecordInContainer(buffer, tempContainer, key);
                while (recordIterator.hasNext()) {
                    long deletedBytes;
                    Map.Entry entry = (Map.Entry)recordIterator.next();
                    TBJBufferKey recordKey = (TBJBufferKey)entry.getKey();
                    TBJBufferRecord oldRecord = (TBJBufferRecord)entry.getValue();
                    if (!recordKey.matchTo(buffer, key, key.getValueCount())) break;
                    if (bufType == 2 && oldRecord == TBJBufferRecord.NOT_FOUND_RECORD) {
                        recordIterator.remove();
                        deletedBytes = this.sizeOfRecordInContainer(oldRecord, definedKeyCount);
                        buffer.incrementFreeBytes(deletedBytes);
                        this.sizeOfContainer -= deletedBytes;
                        --this.notFounds;
                        continue;
                    }
                    boolean found = true;
                    if (processor != null) {
                        try {
                            found = processor.verifySearchCondition(oldRecord);
                        }
                        catch (Exception ex) {
                            String objName = this.object.getName();
                            throw (ExternalBufferException)buffer.getAndLogBufferException(16, this.getClass(), deleteRecordsMethodName, new Object[]{"Exception while verifying search condition on record \" " + oldRecord + "\" of \"" + objName + "\""}, ex);
                        }
                    }
                    if (!found) continue;
                    recordIterator.remove();
                    deletedBytes = this.sizeOfRecordInContainer(oldRecord, definedKeyCount);
                    buffer.incrementFreeBytes(deletedBytes);
                    this.sizeOfContainer -= deletedBytes;
                    ++deleted;
                }
            }
            boolean bl = deleted > 0;
            Object var20_26 = null;
            if (buffer.isDebugOn()) {
                buffer.trace(100, TRACE, "<--- TBJBufferData.deleteRecords: deleted= " + deleted);
            }
            return bl;
        }
        catch (Throwable throwable) {
            block21: {
                Object var20_27 = null;
                if (!buffer.isDebugOn()) break block21;
                buffer.trace(100, TRACE, "<--- TBJBufferData.deleteRecords: deleted= " + deleted);
            }
            throw throwable;
        }
    }

    void allocContainer() {
        this.container = new TreeMap();
        this.notFounds = 0;
    }

    void clearLoadArea(TBJBuffer buffer) {
        this.clear(buffer);
        buffer.incrementFreeBytes(68L);
    }

    long clear(TBJBuffer buffer) {
        SortedMap tempContainer;
        long oldSize = this.sizeOfContainer;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferData.clear: ");
        }
        if ((tempContainer = this.getContainer()) != null) {
            tempContainer.clear();
        }
        this.container = null;
        this.keyForNotFoundRecord = null;
        this.recordForSingleLoad = null;
        buffer.incrementFreeBytes(this.sizeOfContainer);
        this.sizeOfContainer = 0L;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferData.clear");
        }
        return oldSize;
    }

    int setStrongReachability() {
        return this.getReachability();
    }

    int getReachability() {
        if (this.container != null) {
            return 0;
        }
        return 1;
    }

    static String printReachability(int reachable) {
        if (reachable == 0) {
            return "STRONGLY_REACHABLE";
        }
        return "NOT_REACHABLE";
    }

    int getRecordCount() {
        SortedMap tempContainer = this.getContainer();
        if (tempContainer == null) {
            return 0;
        }
        return tempContainer.size();
    }

    long sizeOfContainer() {
        return this.sizeOfContainer;
    }

    int getNotFounds() {
        if (this.getRecordCount() > 0) {
            return this.notFounds;
        }
        return 0;
    }

    void setKey(TBJBufferKey key) {
        this.keyForNotFoundRecord = key;
    }

    void setConsistencyCounter() {
        this.savedConsistencyCounter = this.object.getConsistencyCounter();
    }

    private SortedMap getContainer() {
        return this.container;
    }

    private TBJBufferRecord getRecordInContainer(TBJBuffer buffer, SortedMap recordContainer, TBJBufferKey key) throws TypeMismatchException {
        try {
            return (TBJBufferRecord)recordContainer.get(key);
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "getRecordInContainer", new Object[]{"while locating record with key \"" + key.toString() + "\" within object \"" + this.object.getName() + "\""}, ex);
        }
    }

    private Iterator locateRecordInContainer(TBJBuffer buffer, SortedMap recordContainer, TBJBufferKey key) throws TypeMismatchException {
        try {
            Set set = recordContainer.tailMap(key).entrySet();
            return set.iterator();
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "locateRecordInContainer", new Object[]{"while locating key \"" + key + "\" within object \"" + this.object.getName() + "\""}, ex);
        }
    }

    private void putRecordInContainer(TBJBuffer buffer, SortedMap recordContainer, TBJBufferKey key, TBJBufferRecord record) throws TypeMismatchException {
        int keyCount = this.object.getKeyCount();
        try {
            if (record != null) {
                TBJBufferKey recordKey = record.getKey(keyCount, this.object.getTable().getKeyIndex());
                recordContainer.put(recordKey, record);
            } else if (key != null) {
                TBJBufferKey recordKey = key.getKey(keyCount, null);
                recordContainer.put(recordKey, TBJBufferRecord.NOT_FOUND_RECORD);
                ++this.notFounds;
            }
            long addedBytes = this.sizeOfRecordInContainer(record, keyCount);
            buffer.reduceFreeBytes(addedBytes);
            this.sizeOfContainer += addedBytes;
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "putRecordInContainer", new Object[]{"while putting record \"" + record.toString() + "\" into object \"" + this.object.getName() + "\""}, ex);
        }
        catch (NullPointerException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "putRecordInContainer", new Object[]{"while putting record \"" + record.toString() + "\" into object \"" + this.object.getName() + "\""}, ex);
        }
    }

    private void delRecordInContainer(TBJBuffer buffer, SortedMap recordContainer, TBJBufferKey key) throws TypeMismatchException {
        try {
            TBJBufferRecord deleted = (TBJBufferRecord)recordContainer.remove(key);
            long deletedBytes = this.sizeOfRecordInContainer(deleted, key.getValueCount());
            buffer.incrementFreeBytes(deletedBytes);
            this.sizeOfContainer -= deletedBytes;
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "delRecordInContainer", new Object[]{"while deleting record with key \"" + key + "\" in object \"" + this.object.getName() + "\""}, ex);
        }
    }

    private void setStatusSynchronized(TBJBuffer buffer, TBJBufferDirectory dir, int status) throws BufferResetException {
        TBJBuffer tBJBuffer = buffer;
        synchronized (tBJBuffer) {
            buffer.syncBegin(this.object);
            dir.removeFromQueue(this.object);
            this.object.beginModification();
            this.object.setStatus(status);
            this.object.endModification();
            if (buffer.isDebugOn()) {
                buffer.trace(100, TRACE, "    set status= " + TBJBufferStatus.printStatus(status));
            }
            buffer.syncEnd();
        }
    }

    private long sizeOfRecordInContainer(TBJBufferRecord record, int keyCount) {
        return (record == null ? 0L : record.size()) + 8L + (long)(keyCount * 4) + 32L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

