/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.sql.buffer.Buffer;
import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferException;
import com.sap.sql.buffer.BufferInfo;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.DataLockedException;
import com.sap.sql.buffer.DataNotLoadableException;
import com.sap.sql.buffer.DataWasDisplacedException;
import com.sap.sql.buffer.DuplicateKeyException;
import com.sap.sql.buffer.ExternalBufferException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.NoMemoryAvailableException;
import com.sap.sql.buffer.ObjectExistsException;
import com.sap.sql.buffer.ObjectInconsistentException;
import com.sap.sql.buffer.ObjectNotDefinedException;
import com.sap.sql.buffer.RecordNotFoundException;
import com.sap.sql.buffer.ResultSetClosedException;
import com.sap.sql.buffer.ResultSetExhaustedException;
import com.sap.sql.buffer.ResultSetNotOpenedException;
import com.sap.sql.buffer.TBJBufferAccess;
import com.sap.sql.buffer.TBJBufferDirectory;
import com.sap.sql.buffer.TBJBufferDirectoryIterator;
import com.sap.sql.buffer.TBJBufferInfo;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.sql.buffer.TBJBufferObjectInfo;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.sql.log.OpenSQLResourceAccessor;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;

public class TBJBuffer
implements Buffer {
    static final int BUFFER_SIZE = 394;
    private static final long BUFFER_SIZE_DEFAULT = 0x1000000L;
    private static final long MAX_LOB_SIZE_DEFAULT = 0x100000L;
    private static final long MAX_RECORD_SIZE_DEFAULT = 0x200000L;
    private static final int RELOAD_DELAY_DEFAULT = 5;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBuffer == null ? (class$com$sap$sql$buffer$TBJBuffer = TBJBuffer.class$("com.sap.sql.buffer.TBJBuffer")) : class$com$sap$sql$buffer$TBJBuffer));
    private String bufferId;
    private boolean isReady = false;
    private volatile int beginCounter = 0;
    private volatile int endCounter = 0;
    private boolean inChange = false;
    private TBJBufferDirectory directory = null;
    private Properties properties = null;
    private Date startUpDate;
    private Date resetDate;
    private Date reinstallDate;
    private long resets = 0L;
    private long reinstalls = 0L;
    private int reloadDelay;
    private long bufferSize;
    private long freeBytes;
    private long maxLobSize;
    private long maxRecordSize;
    private long hitReads = 0L;
    private long missedReads = 0L;
    private boolean displacementOn = true;
    private boolean traceOn = false;
    private int traceSeverity = 500;
    private boolean pathOn = false;
    private boolean debugOn = false;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBuffer;

    public TBJBuffer(String id) {
        this.bufferId = id;
        this.resetDate = this.startUpDate = new Date();
        this.reinstallDate = this.startUpDate;
    }

    public void open() {
        String method = "open()";
        String methodName = "open";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "open()");
        }
        TBJBuffer tBJBuffer = this;
        synchronized (tBJBuffer) {
            if (!this.isReady) {
                this.openBuffer(null);
            }
        }
        if (this.pathOn) {
            this.exiting(TRACE, "open");
        }
    }

    public void open(Properties props) {
        String method = "open(Properties)";
        String methodName = "open";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "open(Properties)", new Object[]{props});
        }
        TBJBuffer tBJBuffer = this;
        synchronized (tBJBuffer) {
            if (!this.isReady) {
                this.openBuffer(props);
            }
        }
        if (this.pathOn) {
            this.exiting(TRACE, "open");
        }
    }

    public void close() {
        String method = "close()";
        String methodName = "close";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "close()");
        }
        TBJBuffer tBJBuffer = this;
        synchronized (tBJBuffer) {
            if (!this.isReady) {
                return;
            }
            this.beginModification();
            this.isReady = false;
            this.directory.clear();
            this.log(300, this.getClass(), "close", "com.sap.sql.buffer_1303", new Object[]{this.bufferId, new Date()});
            if (this.debugOn) {
                this.trace(100, TRACE, "    freeBytes= " + this.freeBytes);
            }
            this.endModification();
            this.syncEnd();
        }
        if (this.pathOn) {
            this.exiting(TRACE, "close");
        }
    }

    public void reset() throws BufferNotAvailableException {
        String method = "reset()";
        String methodName = "reset";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "reset()");
        }
        try {
            TBJBuffer tBJBuffer = this;
            synchronized (tBJBuffer) {
                if (!this.isReady) {
                    throw this.getAndLogBufferNotAvailableException(this.getClass(), "reset");
                }
                try {
                    this.syncBegin();
                }
                catch (BufferResetException ex) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var7_5 = null;
                    if (this.pathOn) {
                        this.exiting(TRACE, "reset");
                    }
                    return;
                }
                this.beginModification();
                this.directory.invalidate();
                this.resetDate = new Date();
                ++this.resets;
                this.log(300, this.getClass(), "reset", "com.sap.sql.buffer_1302", new Object[]{this.bufferId, this.resetDate});
                this.endModification();
                this.syncEnd();
            }
            Object var7_6 = null;
            if (this.pathOn) {
                this.exiting(TRACE, "reset");
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.pathOn) {
                this.exiting(TRACE, "reset");
            }
            throw throwable;
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public BufferAccess getBufferAccess() throws BufferNotAvailableException {
        String method = "getBufferAccess()";
        String methodName = "getBufferAccess";
        if (this.pathOn) {
            this.entering(TRACE, "getBufferAccess()");
        }
        try {
            if (!this.isReady) {
                throw this.getAndLogBufferNotAvailableException(this.getClass(), "getBufferAccess");
            }
            TBJBufferAccess tBJBufferAccess = new TBJBufferAccess(this);
            Object var5_4 = null;
            if (this.pathOn) {
                this.exiting(TRACE, "getBufferAccess");
            }
            return tBJBufferAccess;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!this.pathOn) break block5;
                this.exiting(TRACE, "getBufferAccess");
            }
            throw throwable;
        }
    }

    public Collection listObjects(String tableName) throws BufferNotAvailableException, BufferResetException {
        String method = "listObjects(String)";
        String methodName = "listObjects";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "listObjects(String)", new Object[]{tableName});
        }
        try {
            ArrayList<TBJBufferObjectInfo> infos;
            TBJBuffer tBJBuffer = this;
            synchronized (tBJBuffer) {
                if (!this.isReady) {
                    throw this.getAndLogBufferNotAvailableException(this.getClass(), "listObjects");
                }
                this.syncBegin();
                int objectCount = this.directory.getObjectCount();
                if (objectCount == 0) {
                    infos = new ArrayList<TBJBufferObjectInfo>(0);
                } else {
                    infos = new ArrayList(objectCount);
                    TBJBufferDirectoryIterator iterator = tableName == null ? this.directory.getObjects() : this.directory.getObjects(tableName);
                    while (iterator.hasNext()) {
                        TBJBufferObject object = iterator.next();
                        if (object == null) continue;
                        if (tableName != null && !tableName.equals(object.getTableName())) break;
                        TBJBufferObjectInfo info = object.getInfo();
                        infos.add(info);
                    }
                }
                this.syncEnd();
            }
            ArrayList<TBJBufferObjectInfo> arrayList = infos;
            Object var12_12 = null;
            if (this.pathOn) {
                this.exiting(TRACE, "listObjects");
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            block11: {
                Object var12_13 = null;
                if (!this.pathOn) break block11;
                this.exiting(TRACE, "listObjects");
            }
            throw throwable;
        }
    }

    public String getId() {
        return this.bufferId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferInfo getInfo() {
        TBJBufferInfo tBJBufferInfo;
        String method = "getInfo()";
        String methodName = "getInfo";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "getInfo()");
        }
        try {
            TBJBuffer tBJBuffer = this;
            synchronized (tBJBuffer) {
                if (!this.isReady) {
                    TBJBufferInfo tBJBufferInfo2 = new TBJBufferInfo(this.bufferId, this.properties, this.isReady, this.startUpDate, this.resetDate, this.reinstallDate, this.resets, this.reinstalls, 0, 0, 0, this.bufferSize, this.freeBytes, this.maxRecordSize, this.maxLobSize, this.traceOn, this.traceSeverity, this.pathOn, this.debugOn, this.reloadDelay, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var9_3
                    Object var13_7 = null;
                    if (!this.pathOn) return tBJBufferInfo2;
                    this.exiting(TRACE, "getInfo");
                    return tBJBufferInfo2;
                }
                try {
                    this.syncBegin();
                }
                catch (BufferResetException ex) {
                    // empty catch block
                }
                int tableCount = this.directory.getTableCount();
                int objectCount = this.directory.getObjectCount();
                int queueSize = this.directory.getQueueSize();
                int txCount = this.directory.getTxHandling().getTxCount();
                long modCount = this.directory.getTxHandling().getModCount();
                this.syncEnd();
                tBJBufferInfo = new TBJBufferInfo(this.bufferId, this.properties, this.isReady, this.startUpDate, this.resetDate, this.reinstallDate, this.resets, this.reinstalls, tableCount, objectCount, queueSize, this.bufferSize, this.freeBytes, this.maxRecordSize, this.maxLobSize, this.traceOn, this.traceSeverity, this.pathOn, this.debugOn, this.reloadDelay, txCount, modCount, this.directory.getDisplacements(), this.directory.getDisplacedBytes(), this.directory.getDisplacedData(), this.directory.getDisplacedObjects(), this.directory.getDisplacedTables(), this.directory.getSumDisplacedBytes(), this.directory.getSumDisplacedData(), this.directory.getSumDisplacedObjects(), this.directory.getSumDisplacedTables(), this.hitReads, this.missedReads);
            }
        }
        catch (Throwable throwable) {
            Object var13_9 = null;
            if (!this.pathOn) throw throwable;
            this.exiting(TRACE, "getInfo");
            throw throwable;
        }
        Object var13_8 = null;
        if (!this.pathOn) return tBJBufferInfo;
        this.exiting(TRACE, "getInfo");
        return tBJBufferInfo;
    }

    public void dumpDirectory() throws BufferNotAvailableException {
        String method = "dumpDirectory()";
        String methodName = "dumpDirectory";
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "dumpDirectory()");
        }
        try {
            try {
                TBJBuffer tBJBuffer = this;
                synchronized (tBJBuffer) {
                    if (!this.isReady) {
                        throw this.getAndLogBufferNotAvailableException(this.getClass(), "dumpDirectory");
                    }
                    this.syncBegin();
                    System.out.println("+++++++++++++++++++++++++++++++++++++++");
                    System.out.println("DIRECTORY: size = " + this.directory.getObjectCount());
                    TBJBufferDirectoryIterator iterator = this.directory.getObjects();
                    while (iterator.hasNext()) {
                        TBJBufferObject object = iterator.next();
                        if (object == null) continue;
                        System.out.println(object.getInfo().toString());
                    }
                    System.out.println();
                    this.directory.dumpLoadQueue();
                    System.out.println("+++++++++++++++++++++++++++++++++++++++");
                    this.syncEnd();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl26 : MonitorExitStatement: MONITOREXIT : var5_3
                    Object var8_7 = null;
                    if (this.pathOn) {
                        this.exiting(TRACE, "dumpDirectory");
                    }
                    return;
                }
            }
            catch (BufferResetException ex) {
                if (this.debugOn) {
                    this.trace(100, TRACE, "Buffer inconsistency was detected and buffer was reinstalled.");
                }
                Object var8_8 = null;
                if (this.pathOn) {
                    this.exiting(TRACE, "dumpDirectory");
                }
                return;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var8_9 = null;
                if (!this.pathOn) break block13;
                this.exiting(TRACE, "dumpDirectory");
            }
            throw throwable;
        }
    }

    public int check() {
        String method = "check()";
        String methodName = "check";
        TBJBufferObject[] tempDir = new TBJBufferObject[this.directory.getObjectCount()];
        HashMap objectIndex = new HashMap();
        int errorCode = 0;
        this.checkAndSetTraceLevel(TRACE);
        if (this.pathOn) {
            this.entering(TRACE, "check()");
        }
        try {
            try {
                TBJBuffer tBJBuffer = this;
                synchronized (tBJBuffer) {
                    if (!this.isReady) {
                        throw this.getAndLogBufferNotAvailableException(this.getClass(), "check");
                    }
                    this.syncBegin();
                    errorCode = this.directory.check(tempDir, objectIndex);
                    if (errorCode == 0) {
                        errorCode = this.checkSizes();
                    }
                    if (errorCode > 0) {
                        this.log(500, this.getClass(), "check", "com.sap.sql.buffer_1322", new Object[]{this.bufferId, "Check error: " + errorCode});
                    }
                    this.syncEnd();
                }
                Object var9_9 = null;
                if (this.pathOn) {
                    this.exiting(TRACE, "check");
                }
            }
            catch (BufferException ex) {
                this.log(500, this.getClass(), "check", "com.sap.sql.buffer_1322", new Object[]{this.bufferId, "Unexpected buffer exception : " + ((Throwable)((Object)ex)).getMessage()});
                Object var9_10 = null;
                if (this.pathOn) {
                    this.exiting(TRACE, "check");
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.pathOn) {
                this.exiting(TRACE, "check");
            }
            throw throwable;
        }
        return errorCode;
    }

    void beginModification() {
        ++this.beginCounter;
    }

    void endModification() {
        this.endCounter = this.beginCounter;
    }

    int getBeginCounter() {
        return this.beginCounter;
    }

    int getEndCounter() {
        return this.endCounter;
    }

    void syncBegin() throws BufferResetException {
        if (this.beginCounter != this.endCounter || this.inChange) {
            this.reinstall();
            throw (BufferResetException)this.getAndLogBufferException(15, this.getClass(), "syncBegin", new Object[]{this.reinstallDate});
        }
        this.inChange = true;
    }

    void syncBegin(TBJBufferObject object) throws BufferResetException {
        boolean reset = false;
        if (this.beginCounter != this.endCounter || this.inChange) {
            reset = true;
        } else if (object.inChange()) {
            this.log(500, this.getClass(), "syncBegin", "com.sap.sql.buffer_1322", new Object[]{this.bufferId, "Consistency counters of object " + object.getName() + " differ."});
            reset = true;
        }
        if (reset) {
            this.reinstall();
            throw (BufferResetException)this.getAndLogBufferException(15, this.getClass(), "syncBegin(TBJBufferObject)", new Object[]{this.reinstallDate});
        }
        this.inChange = true;
    }

    void syncEnd() {
        this.inChange = false;
    }

    boolean memoryIsAvailable(long neededBytes) {
        return neededBytes <= this.freeBytes;
    }

    void reduceFreeBytes(long bytes) {
        this.freeBytes -= bytes;
        if (this.debugOn) {
            this.trace(100, TRACE, "Free Bytes --- " + bytes);
        }
    }

    void incrementFreeBytes(long bytes) {
        this.freeBytes += bytes;
        if (this.debugOn) {
            this.trace(100, TRACE, "Free Bytes +++ " + bytes);
        }
    }

    boolean isDisplacementOn() {
        return this.displacementOn;
    }

    boolean displace(long neededBytes, TBJBufferObject excluding) throws BufferResetException {
        long displBytes = 0L;
        boolean result = false;
        TBJBuffer tBJBuffer = this;
        synchronized (tBJBuffer) {
            if (this.freeBytes >= neededBytes) {
                boolean bl = true;
                return bl;
            }
            this.syncBegin();
            this.beginModification();
            if ((displBytes += this.directory.displaceAttempt(neededBytes, excluding)) >= neededBytes) {
                result = true;
                this.directory.reactivateObjects();
            }
            this.endModification();
            this.syncEnd();
        }
        return result;
    }

    TBJBufferDirectory getDirectory() {
        return this.directory;
    }

    int getReloadDelay() {
        return this.reloadDelay;
    }

    long getMaxRecordSize() {
        return this.maxRecordSize;
    }

    long getMaxLobSize() {
        return this.maxLobSize;
    }

    String getBufferId() {
        return this.bufferId;
    }

    void setReinstallDate() {
        this.reinstallDate = new Date();
        ++this.reinstalls;
    }

    void missedReads() {
        ++this.missedReads;
    }

    void hitReads() {
        ++this.hitReads;
    }

    static BufferException getAndLogBufferException(int errorCode, Class c, String method, Object[] msgArgs, Throwable cause, boolean localTraceIsOn, int localTraceSeverity) {
        BufferException e = null;
        switch (errorCode) {
            case 0: {
                e = new BufferNotAvailableException(c, msgArgs, cause);
                break;
            }
            case 1: {
                e = new IllegalArgumentException(c, msgArgs, cause);
                break;
            }
            case 2: {
                e = new NoMemoryAvailableException(c, msgArgs, cause);
                break;
            }
            case 3: {
                e = new ObjectExistsException(c, msgArgs, cause);
                break;
            }
            case 4: {
                e = new ObjectNotDefinedException(c, msgArgs, cause);
                break;
            }
            case 5: {
                e = new ObjectInconsistentException(c, msgArgs, cause);
                break;
            }
            case 6: {
                e = new DuplicateKeyException(c, msgArgs, cause);
                break;
            }
            case 7: {
                e = new RecordNotFoundException(c, msgArgs, cause);
                break;
            }
            case 8: {
                e = new DataLockedException(c, msgArgs, cause);
                break;
            }
            case 9: {
                e = new DataNotLoadableException(c, msgArgs, cause);
                break;
            }
            case 10: {
                e = new DataWasDisplacedException(c, msgArgs, cause);
                break;
            }
            case 11: {
                e = new ResultSetClosedException(c, msgArgs, cause);
                break;
            }
            case 12: {
                e = new ResultSetNotOpenedException(c, msgArgs, cause);
                break;
            }
            case 13: {
                e = new ResultSetExhaustedException(c, msgArgs, cause);
                break;
            }
            case 14: {
                e = new TypeMismatchException(c, msgArgs, cause);
                break;
            }
            case 15: {
                e = new BufferResetException(c, msgArgs, cause);
                break;
            }
            case 16: {
                e = new ExternalBufferException(c, msgArgs, cause);
                break;
            }
            default: {
                e = new ExternalBufferException(c, msgArgs, cause);
            }
        }
        int severity = e.getSeverity();
        if (severity == 500 || severity == 300) {
            TBJBuffer.logSQLException(c, e);
        }
        if (TRACE.beLogged(severity)) {
            TRACE.logT(severity, TBJBuffer.getText(method, e));
        }
        if (TBJBuffer.isTraceOn(localTraceIsOn, localTraceSeverity, severity)) {
            System.out.println(TBJBuffer.printSeverity(severity) + ": " + TBJBuffer.getText(method, e));
        }
        return e;
    }

    static BufferNotAvailableException getAndLogBufferNotAvailableException(Class c, String bufferId, String method, boolean localTraceIsOn, int localTraceSeverity) {
        Object[] msgArgs = new Object[]{bufferId};
        BufferNotAvailableException e = new BufferNotAvailableException(c, msgArgs, null);
        int severity = e.getSeverity();
        TBJBuffer.logSQLException(c, e);
        if (TRACE.beLogged(severity)) {
            TRACE.logT(severity, TBJBuffer.getText(method, e));
        }
        if (TBJBuffer.isTraceOn(localTraceIsOn, localTraceSeverity, severity)) {
            System.out.println(TBJBuffer.printSeverity(severity) + ": " + TBJBuffer.getText(method, e));
        }
        return e;
    }

    BufferException getAndLogBufferException(int errorCode, Class c, String method) {
        return this.getAndLogBufferException(errorCode, c, method, null, null);
    }

    BufferException getAndLogBufferException(int errorCode, Class c, String method, Object[] msgArgs) {
        return this.getAndLogBufferException(errorCode, c, method, msgArgs, null);
    }

    BufferException getAndLogBufferException(int errorCode, Class c, String method, Object[] msgArgs, Throwable cause) {
        Object[] msgArgsNew;
        if (msgArgs == null) {
            msgArgsNew = new Object[]{this.bufferId};
        } else {
            msgArgsNew = new Object[msgArgs.length + 1];
            msgArgsNew[0] = this.bufferId;
            int i = 0;
            while (i < msgArgs.length) {
                msgArgsNew[i + 1] = msgArgs[i];
                ++i;
            }
        }
        return TBJBuffer.getAndLogBufferException(errorCode, c, method, msgArgsNew, cause, this.traceOn, this.traceSeverity);
    }

    BufferNotAvailableException getAndLogBufferNotAvailableException(Class c, String method) {
        return TBJBuffer.getAndLogBufferNotAvailableException(c, this.bufferId, method, this.traceOn, this.traceSeverity);
    }

    static String printSeverity(int severity) {
        switch (severity) {
            case 600: {
                return "FATAL";
            }
            case 500: {
                return "ERROR";
            }
            case 400: {
                return "WARNING";
            }
            case 300: {
                return "INFO";
            }
            case 200: {
                return "PATH";
            }
            case 100: {
                return "DEBUG";
            }
        }
        return new Integer(severity).toString();
    }

    void entering(Location loc, String method, Object[] values) {
        if (loc.bePath()) {
            loc.entering(method, values);
        }
        if (this.isTraceOn(200)) {
            System.out.print("{ " + method + ": ");
            int i = 0;
            while (i < values.length) {
                System.out.print(values[i] != null ? values[i].toString() : null);
                if (i < values.length - 1) {
                    System.out.print(", ");
                }
                ++i;
            }
            System.out.println();
        }
    }

    void entering(Location loc, String method) {
        if (loc.bePath()) {
            loc.entering(method);
        }
        if (this.isTraceOn(200)) {
            System.out.println("{ " + method);
        }
    }

    void exiting(Location loc, String methodName) {
        if (loc.bePath()) {
            loc.exiting();
        }
        if (this.isTraceOn(200)) {
            System.out.println("} " + methodName);
        }
    }

    void exiting(Location loc, String methodName, Object result) {
        if (loc.bePath()) {
            loc.exiting();
        }
        if (this.isTraceOn(200)) {
            System.out.println("} " + methodName + ": " + (result != null ? result.toString() : result));
        }
    }

    void trace(int severity, Location loc, String text) {
        if (loc.beLogged(severity)) {
            loc.logT(severity, text);
        }
        if (this.isTraceOn(severity)) {
            System.out.println(text);
        }
    }

    void log(int severity, Class c, String method, String msgKey, Object[] msgArgs) {
        Syslog.log((int)severity, (Class)c, (String)msgKey, (Object[])msgArgs);
        if (this.isTraceOn(severity)) {
            LocalizableTextFormatter formatter = new LocalizableTextFormatter(OpenSQLResourceAccessor.getResourceAccessor(), msgKey, msgArgs);
            String msgClear = null;
            try {
                msgClear = formatter.format();
            }
            catch (LocalizationException e) {
                // empty catch block
            }
            System.out.println(TBJBuffer.printSeverity(severity) + ": " + method + ": " + msgClear);
        }
    }

    boolean isTraceOn(int severity) {
        if (!this.traceOn) {
            return false;
        }
        return severity >= this.traceSeverity;
    }

    void switchTraceOn() {
        this.traceOn = true;
    }

    void switchTraceOff() {
        this.traceOn = false;
    }

    void checkAndSetTraceLevel(Location loc) {
        if (loc.bePath() || this.isTraceOn(200)) {
            this.pathOn = true;
            this.debugOn = loc.beLogged(100) || this.isTraceOn(100);
        } else if (this.pathOn || this.debugOn) {
            this.pathOn = false;
            this.debugOn = false;
        }
    }

    boolean isPathOn() {
        return this.pathOn;
    }

    boolean isDebugOn() {
        return this.debugOn;
    }

    private void reinstall() {
        if (this.isDebugOn()) {
            this.trace(100, TRACE, "---> TBJBuffer.reinstall");
        }
        this.inChange = true;
        this.beginModification();
        this.directory.clear();
        this.resetStatistics();
        this.setReinstallDate();
        this.endModification();
        this.inChange = false;
        if (this.isDebugOn()) {
            this.trace(100, TRACE, "<--- TBJBuffer.reinstall");
        }
    }

    private void resetStatistics() {
        this.hitReads = 0L;
        this.missedReads = 0L;
    }

    private static String getText(String method, BufferException e) {
        StringBuffer buf = new StringBuffer();
        buf.append("SQLException raised");
        if (method != null) {
            buf.append(" in method ");
            buf.append(method);
        }
        buf.append(": code=");
        buf.append(((SQLException)((Object)e)).getErrorCode());
        buf.append(", state=");
        buf.append(((SQLException)((Object)e)).getSQLState());
        buf.append(", msg=" + ((Throwable)((Object)e)).getMessage());
        return buf.toString();
    }

    private static void logSQLException(Class c, BufferException e) {
        int severity = e.getSeverity();
        if (severity == 500) {
            Syslog.logSQLException((Class)c, (SQLException)((Object)e));
        } else {
            Syslog.log((int)severity, (Class)c, (String)e.getMessageKey(), (Object[])e.getMessageArguments());
        }
    }

    private static boolean isTraceOn(boolean localTraceIsOn, int localTraceSeverity, int severity) {
        if (!localTraceIsOn) {
            return false;
        }
        return severity >= localTraceSeverity;
    }

    private void openBuffer(Properties props) {
        String methodName = "openBuffer";
        if (!this.init(props)) {
            this.log(500, this.getClass(), "openBuffer", "com.sap.sql.buffer_1305", new Object[]{this.bufferId});
            return;
        }
        this.checkAndSetTraceLevel(TRACE);
        if (this.directory == null) {
            this.directory = new TBJBufferDirectory(this);
        }
        this.isReady = true;
        this.log(300, this.getClass(), "openBuffer", "com.sap.sql.buffer_1301", new Object[]{this.bufferId, new Long(this.bufferSize), this.startUpDate, new Long(this.maxRecordSize), new Long(this.maxLobSize), new Boolean(this.displacementOn), new Integer(this.reloadDelay)});
    }

    private boolean init(Properties props) {
        String methodName = "init";
        long givenMaxRecordSize = 0L;
        long givenMaxLobSize = 0L;
        int givenReloadDelay = 0;
        long givenBufferSize = 0L;
        boolean recordSizeAdjusted = false;
        this.properties = props;
        if (props != null) {
            String property = this.properties.getProperty("com.sap.sql.buffer.displacement.active");
            if (property != null) {
                this.displacementOn = Boolean.valueOf(property);
            }
            if ((property = this.properties.getProperty("com.sap.sql.buffer.trace.active")) != null) {
                this.traceOn = Boolean.valueOf(property);
            }
            if ((property = this.properties.getProperty("com.sap.sql.buffer.trace.severity")) != null) {
                this.traceSeverity = this.getSeverity(property);
            }
            if ((property = this.properties.getProperty("com.sap.sql.buffer.maxlobsize")) != null) {
                givenMaxLobSize = Long.valueOf(property);
                if (givenMaxLobSize <= 0L) {
                    this.log(300, this.getClass(), "init", "com.sap.sql.buffer_1320", new Object[]{this.bufferId, new Long(givenMaxLobSize), "com.sap.sql.buffer.maxlobsize", new Long(0x100000L)});
                    this.maxLobSize = 0x100000L;
                } else {
                    this.maxLobSize = givenMaxLobSize;
                }
            } else {
                this.maxLobSize = 0x100000L;
            }
            property = this.properties.getProperty("com.sap.sql.buffer.maxrecordsize");
            if (property != null) {
                givenMaxRecordSize = Long.valueOf(property);
                if (givenMaxRecordSize <= 0L) {
                    recordSizeAdjusted = true;
                    this.maxRecordSize = 0x200000L;
                } else {
                    this.maxRecordSize = givenMaxRecordSize;
                }
            } else {
                this.maxRecordSize = 0x200000L;
            }
            property = this.properties.getProperty("com.sap.sql.buffer.buffersize_kb");
            if (property != null) {
                givenBufferSize = Long.valueOf(property) * 1024L;
                if (givenBufferSize <= 0L) {
                    this.bufferSize = 0x1000000L;
                    this.log(300, this.getClass(), "init", "com.sap.sql.buffer_1320", new Object[]{this.bufferId, new Long(givenBufferSize), "com.sap.sql.buffer.buffersize_kb", new Long(0x1000000L)});
                } else {
                    this.bufferSize = givenBufferSize;
                }
            } else {
                this.bufferSize = 0x1000000L;
            }
            property = this.properties.getProperty("com.sap.sql.buffer.reloaddelay");
            if (property != null) {
                givenReloadDelay = Integer.valueOf(property);
                if (givenReloadDelay < 0) {
                    this.reloadDelay = 5;
                    this.log(300, this.getClass(), "init", "com.sap.sql.buffer_1320", new Object[]{this.bufferId, new Integer(givenReloadDelay), "com.sap.sql.buffer.reloaddelay", new Integer(this.reloadDelay)});
                } else {
                    this.reloadDelay = givenReloadDelay;
                }
            } else {
                this.reloadDelay = 5;
            }
        } else {
            this.maxLobSize = 0x100000L;
            this.reloadDelay = 5;
            this.maxRecordSize = 0x200000L;
            this.bufferSize = 0x1000000L;
        }
        if (this.maxRecordSize < this.maxLobSize) {
            recordSizeAdjusted = true;
            this.maxRecordSize = this.maxLobSize;
        }
        if (recordSizeAdjusted) {
            this.log(300, this.getClass(), "init", "com.sap.sql.buffer_1320", new Object[]{this.bufferId, new Long(givenMaxRecordSize), "com.sap.sql.buffer.maxrecordsize", new Long(this.maxRecordSize)});
        }
        if (this.bufferSize < this.getMinimalBufferSize()) {
            this.log(500, this.getClass(), "init", "com.sap.sql.buffer_1321", new Object[]{this.bufferId, new Long(this.bufferSize / 1024L)});
            return false;
        }
        this.freeBytes = this.bufferSize - 394L;
        return true;
    }

    private int getSeverity(String severity) {
        if (severity.equalsIgnoreCase("PATH")) {
            return 200;
        }
        if (severity.equalsIgnoreCase("ERROR")) {
            return 500;
        }
        if (severity.equalsIgnoreCase("DEBUG")) {
            return 100;
        }
        if (severity.equalsIgnoreCase("FATAL")) {
            return 600;
        }
        if (severity.equalsIgnoreCase("GROUP")) {
            return 800;
        }
        if (severity.equalsIgnoreCase("INFO")) {
            return 300;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return 400;
        }
        return 700;
    }

    private long getMinimalBufferSize() {
        long minimum = 771L + this.maxRecordSize;
        return minimum;
    }

    private int checkSizes() {
        long tx;
        int errorCode = 0;
        long admin = 394L;
        long dir = this.directory.size();
        long occupied = admin + dir + (tx = this.directory.getTxHandling().size());
        long free = this.bufferSize - occupied;
        if (free != this.freeBytes) {
            errorCode = 10;
            this.trace(500, TRACE, "Check-Error(" + errorCode + "): Calculated free size = " + free + ", real free size = " + this.freeBytes);
        }
        return errorCode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MemoryManager {
        static final int INTEGER_OBJECT_SIZE = 16;
        static final int LONG_OBJECT_SIZE = 16;
        static final int SHORT_OBJECT_SIZE = 16;
        static final int FLOAT_OBJECT_SIZE = 16;
        static final int DOUBLE_OBJECT_SIZE = 16;
        static final int BIG_DECIMAL_SIZE = 48;
        static final int BIG_INTEGER_SIZE = 48;
        static final int STRING_SIZE = 24;
        static final int BOOLEAN_OBJECT_SIZE = 16;
        static final int BYTE_OBJECT_SIZE = 16;
        static final int DATE_SIZE = 96;
        static final int TIME_SIZE = 96;
        static final int TIMESTAMP_SIZE = 24;
        static final int ARRAY_SIZE = 8;
        static final int REF_SIZE = 4;
        static final int MAP_SIZE = 36;
        static final int MAP_ELEM_SIZE = 16;
        static final int SET_SIZE = 36;
        static final int SET_ELEM_SIZE = 16;
        static final int INT_SIZE = 4;
        static final int LONG_SIZE = 8;
        static final int SHORT_SIZE = 2;
        static final int FLOAT_SIZE = 4;
        static final int DOUBLE_SIZE = 8;
        static final int BOOLEAN_SIZE = 1;
        static final int BYTE_SIZE = 1;
        static final int CHAR_SIZE = 2;

        MemoryManager() {
        }
    }
}

