/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.ws.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.ws.implementation.DocumentationState;
import com.sap.ide.metamodel.ws.implementation.SoapApplicationState;
import com.sap.ide.metamodel.ws.implementation.UDDITModelPublicationState;
import com.sap.ide.metamodel.ws.implementation.VirtualInterfaceReferenceState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class WebServiceDefinitionState
extends DevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private String mGuid = null;
    private boolean mHasGuid = false;
    private DocumentationState mDocumentation = null;
    private HashMap mSoapApplications = new HashMap();
    private HashMap mVirtualInterfaceReferences = new HashMap();
    private HashMap muddiTModelPublications = new HashMap();

    WebServiceDefinitionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        WebServiceDefinitionState lState = (WebServiceDefinitionState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            return false;
        }
        return String.valueOf(this.mGuid).equals(String.valueOf(lState.mGuid));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        WebServiceDefinitionState lState = (WebServiceDefinitionState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
        if (!String.valueOf(this.mGuid).equals(String.valueOf(lState.mGuid))) {
            compareContext.addPropertyDelta(sourceObject, "guid", (Object)lState.mGuid);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WebServiceDefinitionState lState = (WebServiceDefinitionState)((Object)super.clone());
        if (this.mDocumentation != null) {
            lState.mDocumentation = (DocumentationState)((Object)this.mDocumentation.clone());
        }
        lState.mSoapApplications = new HashMap();
        Iterator it = this.mSoapApplications.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mSoapApplications.put(lKey, ((SoapApplicationState)((Object)this.mSoapApplications.get(lKey))).clone());
        }
        lState.mVirtualInterfaceReferences = new HashMap();
        Iterator it2 = this.mVirtualInterfaceReferences.keySet().iterator();
        while (it2.hasNext()) {
            String lKey = (String)it2.next();
            lState.mVirtualInterfaceReferences.put(lKey, ((VirtualInterfaceReferenceState)((Object)this.mVirtualInterfaceReferences.get(lKey))).clone());
        }
        lState.muddiTModelPublications = new HashMap();
        Iterator it3 = this.muddiTModelPublications.keySet().iterator();
        while (it3.hasNext()) {
            String lKey = (String)it3.next();
            lState.muddiTModelPublications.put(lKey, ((UDDITModelPublicationState)((Object)this.muddiTModelPublications.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        if (this.mDocumentation != null) {
            this.mDocumentation.removeExternalReferences(innerObjectKeys);
        }
        Iterator it = this.mSoapApplications.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mVirtualInterfaceReferences.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = this.muddiTModelPublications.values().iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.setPackage(clipboardService.getNewPackage(this.mProxyRef));
            this.mProxyRef = null;
        }
        if (this.mDocumentation != null) {
            if (clipboardService.isExcluded((Reference)this.mDocumentation.getProxyReference())) {
                this.mDocumentation = null;
            } else {
                this.mDocumentation.refactor(clipboardService);
            }
        }
        Iterator it = this.mSoapApplications.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mVirtualInterfaceReferences.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = this.muddiTModelPublications.values().iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        if (this.mDocumentation != null) {
            this.mDocumentation.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it = this.mSoapApplications.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mVirtualInterfaceReferences.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = this.muddiTModelPublications.values().iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    void setGuid(String value) {
        if (value == null) {
            this.unsetGuid();
            return;
        }
        this.mGuid = value;
        this.mHasGuid = true;
    }

    String getGuid() {
        return this.mGuid;
    }

    boolean hasGuid() {
        return this.mHasGuid;
    }

    void unsetGuid() {
        this.mGuid = null;
        this.mHasGuid = false;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void setDocumentation(DocumentationState state) {
        this.mDocumentation = state;
    }

    DocumentationState getDocumentation() {
        return this.mDocumentation;
    }

    void addSoapApplication(SoapApplicationState state) {
        this.mSoapApplications.put(state.getName().toLowerCase(), state);
    }

    int getSoapApplicationCount() {
        return this.mSoapApplications.size();
    }

    SoapApplicationState getSoapApplication(String name) {
        return (SoapApplicationState)((Object)this.mSoapApplications.get(name.toLowerCase()));
    }

    Vector getSoapApplications() {
        return new Vector(this.mSoapApplications.values());
    }

    void removeSoapApplication(String aggregationKey) {
        this.mSoapApplications.remove(aggregationKey.toLowerCase());
    }

    void removeSoapApplication(SoapApplicationState state) {
        this.mSoapApplications.remove(state.getName().toLowerCase());
    }

    void removeAllSoapApplications() {
        this.mSoapApplications.clear();
    }

    void addVirtualInterfaceReference(VirtualInterfaceReferenceState state) {
        this.mVirtualInterfaceReferences.put(state.getName().toLowerCase(), state);
    }

    int getVirtualInterfaceReferenceCount() {
        return this.mVirtualInterfaceReferences.size();
    }

    VirtualInterfaceReferenceState getVirtualInterfaceReference(String name) {
        return (VirtualInterfaceReferenceState)((Object)this.mVirtualInterfaceReferences.get(name.toLowerCase()));
    }

    Vector getVirtualInterfaceReferences() {
        return new Vector(this.mVirtualInterfaceReferences.values());
    }

    void removeVirtualInterfaceReference(String aggregationKey) {
        this.mVirtualInterfaceReferences.remove(aggregationKey.toLowerCase());
    }

    void removeVirtualInterfaceReference(VirtualInterfaceReferenceState state) {
        this.mVirtualInterfaceReferences.remove(state.getName().toLowerCase());
    }

    void removeAllVirtualInterfaceReferences() {
        this.mVirtualInterfaceReferences.clear();
    }

    void adduddiTModelPublication(UDDITModelPublicationState state) {
        this.muddiTModelPublications.put(state.getName().toLowerCase(), state);
    }

    int getuddiTModelPublicationCount() {
        return this.muddiTModelPublications.size();
    }

    UDDITModelPublicationState getuddiTModelPublication(String name) {
        return (UDDITModelPublicationState)((Object)this.muddiTModelPublications.get(name.toLowerCase()));
    }

    Vector getuddiTModelPublications() {
        return new Vector(this.muddiTModelPublications.values());
    }

    void removeuddiTModelPublication(String aggregationKey) {
        this.muddiTModelPublications.remove(aggregationKey.toLowerCase());
    }

    void removeuddiTModelPublication(UDDITModelPublicationState state) {
        this.muddiTModelPublications.remove(state.getName().toLowerCase());
    }

    void removeAlluddiTModelPublications() {
        this.muddiTModelPublications.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("guid")) {
            this.setGuid((String)value);
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Documentation")) {
            this.setDocumentation((DocumentationState)((Object)data));
        } else if (roleName.equals("SoapApplications")) {
            this.addSoapApplication((SoapApplicationState)((Object)data));
        } else if (roleName.equals("VirtualInterfaceReferences")) {
            this.addVirtualInterfaceReference((VirtualInterfaceReferenceState)((Object)data));
        } else if (roleName.equals("uddiTModelPublications")) {
            this.adduddiTModelPublication((UDDITModelPublicationState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

