/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.ws.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.marshalling.XMLMarshaller;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.ws.WSDMDOEnum;
import com.sap.ide.metamodel.ws.implementation.DocumentationState;
import com.sap.ide.metamodel.ws.implementation.FeatureState;
import com.sap.ide.metamodel.ws.implementation.FunctionState;
import com.sap.ide.metamodel.ws.implementation.PropertyState;
import com.sap.ide.metamodel.ws.implementation.SoapApplicationState;
import com.sap.ide.metamodel.ws.implementation.UDDITModelPublicationState;
import com.sap.ide.metamodel.ws.implementation.VirtualInterfaceReferenceState;
import com.sap.ide.metamodel.ws.implementation.WebServiceDefinitionState;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class WSDXMLMarshaller
extends XMLMarshaller {
    protected String mMDOPackage;
    protected String mMDOName;
    protected MDOEnum mMDOType;
    static /* synthetic */ Class class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState;

    public void marshal(DevelopmentObjectState state, String path) throws SaveException {
        try {
            this.getMDOProperties(state);
            this.resetIndent();
            String lFolder = new File(path).getParent();
            if (!new File(lFolder).exists()) {
                new File(lFolder).mkdirs();
            }
            BufferedWriter lWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
            lWriter.write(this.buildXMLString(state));
            lWriter.close();
        }
        catch (Exception ex) {
            throw new SaveException(ex);
        }
    }

    public void marshal(DevelopmentObjectState state, OutputStreamWriter writer) throws SaveException {
        try {
            this.getMDOProperties(state);
            this.resetIndent();
            writer.write(this.buildXMLString(state));
        }
        catch (Exception ex) {
            throw new SaveException(ex);
        }
    }

    private void getMDOProperties(DevelopmentObjectState state) {
        if (state.getClass() == (class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState == null ? (class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState = WSDXMLMarshaller.class$("com.sap.ide.metamodel.ws.implementation.WebServiceDefinitionState")) : class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState)) {
            this.mMDOType = WSDMDOEnum.WEBSERVICEDEFINITION;
        }
        this.mMDOPackage = ((MainDevelopmentObjectState)state).getPackage();
        this.mMDOName = state.getName();
    }

    private String buildXMLString(DevelopmentObjectState state) {
        StringBuffer lBuf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (state.getClass() == (class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState == null ? (class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState = WSDXMLMarshaller.class$("com.sap.ide.metamodel.ws.implementation.WebServiceDefinitionState")) : class$com$sap$ide$metamodel$ws$implementation$WebServiceDefinitionState)) {
            this.serializeWebServiceDefinition((WebServiceDefinitionState)state, lBuf, true);
        }
        return lBuf.toString();
    }

    private void serializeDocumentation(DocumentationState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<Documentation");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</Documentation>\n");
        }
    }

    private void serializeFeature(FeatureState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<Feature");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        if (state.getPropertyCount() > 0) {
            Vector lVector = state.getProperties();
            buf.append(this.indent() + "<Feature.Properties>\n");
            this.pushIndent();
            int i = 0;
            while (i < state.getPropertyCount()) {
                this.serializeProperty((PropertyState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</Feature.Properties>\n");
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</Feature>\n");
        }
    }

    private void serializeFunction(FunctionState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<Function");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        if (state.getSoapApplication() != null) {
            SoapApplicationState lSoapApplicationState = state.getSoapApplication();
            buf.append(this.indent() + "<Function.SoapApplication>\n");
            this.pushIndent();
            this.serializeSoapApplication(lSoapApplicationState, buf, true);
            buf.append(this.popIndent() + "</Function.SoapApplication>\n");
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</Function>\n");
        }
    }

    private void serializeProperty(PropertyState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<Property");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            if (state.hasValue()) {
                buf.append(" value=\"" + this.escapeXML(state.getValue()) + "\"");
            }
            buf.append(">\n");
            this.pushIndent();
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</Property>\n");
        }
    }

    private void serializeSoapApplication(SoapApplicationState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<SoapApplication");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        if (state.getFeatureCount() > 0) {
            Vector lVector = state.getFeatures();
            buf.append(this.indent() + "<SoapApplication.Features>\n");
            this.pushIndent();
            int i = 0;
            while (i < state.getFeatureCount()) {
                this.serializeFeature((FeatureState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</SoapApplication.Features>\n");
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</SoapApplication>\n");
        }
    }

    private void serializeUDDITModelPublication(UDDITModelPublicationState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<UDDITModelPublication");
            if (state.hasInquiryUrl()) {
                buf.append(" inquiryUrl=\"" + this.escapeXML(state.getInquiryUrl()) + "\"");
            }
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            if (state.hasPublishUrl()) {
                buf.append(" publishUrl=\"" + this.escapeXML(state.getPublishUrl()) + "\"");
            }
            buf.append(">\n");
            this.pushIndent();
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</UDDITModelPublication>\n");
        }
    }

    private void serializeVirtualInterfaceReference(VirtualInterfaceReferenceState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<VirtualInterfaceReference");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            if (state.hasPackage()) {
                buf.append(" package=\"" + this.escapeXML(state.getPackage()) + "\"");
            }
            if (state.hasViGuid()) {
                buf.append(" viGuid=\"" + this.escapeXML(state.getViGuid()) + "\"");
            }
            buf.append(">\n");
            this.pushIndent();
        }
        if (state.getFunctionCount() > 0) {
            Vector lVector = state.getFunctions();
            buf.append(this.indent() + "<VirtualInterfaceReference.Functions>\n");
            this.pushIndent();
            int i = 0;
            while (i < state.getFunctionCount()) {
                this.serializeFunction((FunctionState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</VirtualInterfaceReference.Functions>\n");
        }
        if (state.getSoapApplication() != null) {
            SoapApplicationState lSoapApplicationState = state.getSoapApplication();
            buf.append(this.indent() + "<VirtualInterfaceReference.SoapApplication>\n");
            this.pushIndent();
            this.serializeSoapApplication(lSoapApplicationState, buf, true);
            buf.append(this.popIndent() + "</VirtualInterfaceReference.SoapApplication>\n");
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</VirtualInterfaceReference>\n");
        }
    }

    private void serializeWebServiceDefinition(WebServiceDefinitionState state, StringBuffer buf, boolean withEnclosingElements) {
        int i;
        Vector lVector;
        if (withEnclosingElements) {
            buf.append("<!-- MetaDataAPI generated on: Tuesday, May 4, 2004 10:35:52 AM CEST -->\n");
            buf.append(this.indent() + "<WebServiceDefinition");
            buf.append(" xmlns=\"http://xml.sap.com/2002/10/metamodel/wsd\"");
            buf.append(" xmlns:IDX=\"urn:sap.com:WSD.WebServiceDefinition:2.0\"");
            buf.append(" mmRelease=\"6.30\"");
            buf.append(" mmVersion=\"2.0\"");
            buf.append(" mmTimestamp=\"1083659752033\"");
            if (state.hasGuid()) {
                buf.append(" guid=\"" + this.escapeXML(state.getGuid()) + "\"");
            }
            buf.append(" name=\"" + state.getName() + "\"");
            buf.append(" package=\"" + state.getPackage() + "\"");
            buf.append(" masterLanguage=\"" + state.getMasterLanguage() + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        this.serializeMetamodelAnnotations(state, buf);
        if (state.getDocumentation() != null) {
            DocumentationState lDocumentationState = state.getDocumentation();
            buf.append(this.indent() + "<WebServiceDefinition.Documentation>\n");
            this.pushIndent();
            this.serializeDocumentation(lDocumentationState, buf, true);
            buf.append(this.popIndent() + "</WebServiceDefinition.Documentation>\n");
        }
        if (state.getSoapApplicationCount() > 0) {
            lVector = state.getSoapApplications();
            buf.append(this.indent() + "<WebServiceDefinition.SoapApplications>\n");
            this.pushIndent();
            i = 0;
            while (i < state.getSoapApplicationCount()) {
                this.serializeSoapApplication((SoapApplicationState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</WebServiceDefinition.SoapApplications>\n");
        }
        if (state.getVirtualInterfaceReferenceCount() > 0) {
            lVector = state.getVirtualInterfaceReferences();
            buf.append(this.indent() + "<WebServiceDefinition.VirtualInterfaceReferences>\n");
            this.pushIndent();
            i = 0;
            while (i < state.getVirtualInterfaceReferenceCount()) {
                this.serializeVirtualInterfaceReference((VirtualInterfaceReferenceState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</WebServiceDefinition.VirtualInterfaceReferences>\n");
        }
        if (state.getuddiTModelPublicationCount() > 0) {
            lVector = state.getuddiTModelPublications();
            buf.append(this.indent() + "<WebServiceDefinition.uddiTModelPublications>\n");
            this.pushIndent();
            i = 0;
            while (i < state.getuddiTModelPublicationCount()) {
                this.serializeUDDITModelPublication((UDDITModelPublicationState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</WebServiceDefinition.uddiTModelPublications>\n");
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</WebServiceDefinition>\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

