/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.ws.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.ws.implementation.FunctionState;
import com.sap.ide.metamodel.ws.implementation.SoapApplicationState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class VirtualInterfaceReferenceState
extends DevelopmentObjectState {
    private String mPackage = null;
    private boolean mHasPackage = false;
    private String mViGuid = null;
    private boolean mHasViGuid = false;
    private HashMap mFunctions = new HashMap();
    private SoapApplicationState mSoapApplication = null;

    VirtualInterfaceReferenceState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        VirtualInterfaceReferenceState lState = (VirtualInterfaceReferenceState)object;
        if (!String.valueOf(this.mPackage).equals(String.valueOf(lState.mPackage))) {
            return false;
        }
        return String.valueOf(this.mViGuid).equals(String.valueOf(lState.mViGuid));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        VirtualInterfaceReferenceState lState = (VirtualInterfaceReferenceState)object;
        if (!String.valueOf(this.mPackage).equals(String.valueOf(lState.mPackage))) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
        if (!String.valueOf(this.mViGuid).equals(String.valueOf(lState.mViGuid))) {
            compareContext.addPropertyDelta(sourceObject, "viGuid", (Object)lState.mViGuid);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VirtualInterfaceReferenceState lState = (VirtualInterfaceReferenceState)((Object)super.clone());
        lState.mFunctions = new HashMap();
        Iterator it = this.mFunctions.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mFunctions.put(lKey, ((FunctionState)((Object)this.mFunctions.get(lKey))).clone());
        }
        if (this.mSoapApplication != null) {
            lState.mSoapApplication = (SoapApplicationState)((Object)this.mSoapApplication.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        Iterator it = this.mFunctions.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mSoapApplication != null) {
            this.mSoapApplication.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.mProxyRef = null;
        }
        Iterator it = this.mFunctions.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        if (this.mSoapApplication != null) {
            if (clipboardService.isExcluded((Reference)this.mSoapApplication.getProxyReference())) {
                this.mSoapApplication = null;
            } else {
                this.mSoapApplication.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        Iterator it = this.mFunctions.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSoapApplication != null) {
            this.mSoapApplication.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
    }

    void setPackage(String value) {
        if (value == null) {
            this.unsetPackage();
            return;
        }
        this.mPackage = value;
        this.mHasPackage = true;
    }

    String getPackage() {
        return this.mPackage;
    }

    boolean hasPackage() {
        return this.mHasPackage;
    }

    void unsetPackage() {
        this.mPackage = null;
        this.mHasPackage = false;
    }

    void setViGuid(String value) {
        if (value == null) {
            this.unsetViGuid();
            return;
        }
        this.mViGuid = value;
        this.mHasViGuid = true;
    }

    String getViGuid() {
        return this.mViGuid;
    }

    boolean hasViGuid() {
        return this.mHasViGuid;
    }

    void unsetViGuid() {
        this.mViGuid = null;
        this.mHasViGuid = false;
    }

    void setSoapApplication(SoapApplicationState state) {
        this.mSoapApplication = state;
    }

    SoapApplicationState getSoapApplication() {
        return this.mSoapApplication;
    }

    void addFunction(FunctionState state) {
        this.mFunctions.put(state.getName().toLowerCase(), state);
    }

    int getFunctionCount() {
        return this.mFunctions.size();
    }

    FunctionState getFunction(String name) {
        return (FunctionState)((Object)this.mFunctions.get(name.toLowerCase()));
    }

    Vector getFunctions() {
        return new Vector(this.mFunctions.values());
    }

    void removeFunction(String aggregationKey) {
        this.mFunctions.remove(aggregationKey.toLowerCase());
    }

    void removeFunction(FunctionState state) {
        this.mFunctions.remove(state.getName().toLowerCase());
    }

    void removeAllFunctions() {
        this.mFunctions.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("viGuid")) {
            this.setViGuid((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Functions")) {
            this.addFunction((FunctionState)((Object)data));
        } else if (roleName.equals("SoapApplication")) {
            this.setSoapApplication((SoapApplicationState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

