/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.ora.DbOraStorage;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbOraTablespace {
    private String name = null;
    private Boolean locallyManaged = null;
    private Boolean autoallocated = null;
    private DbOraStorage defaultStorage = null;

    public DbOraTablespace(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isLocallyManaged() {
        return this.locallyManaged;
    }

    public Boolean isAutoallocated() {
        return this.autoallocated;
    }

    public DbOraStorage getDefaultStorage() {
        return this.defaultStorage;
    }

    protected void setContentViaDbCatalog(ResultSet resultSet) throws SQLException {
        String extentManagement = resultSet.getString("EXTENT_MANAGEMENT");
        if (!resultSet.wasNull()) {
            this.locallyManaged = extentManagement.equalsIgnoreCase("LOCAL") ? new Boolean(true) : new Boolean(false);
        }
        String allocationType = resultSet.getString("ALLOCATION_TYPE");
        if (!resultSet.wasNull()) {
            this.autoallocated = allocationType.equalsIgnoreCase("SYSTEM") ? new Boolean(true) : new Boolean(false);
        }
        DbOraStorage storage = new DbOraStorage();
        storage.setContentViaDbCatalog(resultSet, "USER_TABLESPACES");
        if (!storage.isNull()) {
            this.defaultStorage = storage;
        }
    }

    public String toString() {
        return "Tablespace Name       : " + this.name + "\n" + "Locally Managed       : " + this.locallyManaged + "\n" + "Autoallocated         : " + this.autoallocated + "\n" + "Default Storage       : " + "\n" + this.defaultStorage + "\n";
    }
}

