/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.mss;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbMssPrimaryKey
extends DbPrimaryKey {
    private String dataFilegroup = "DEFAULT";
    private boolean isClustered = false;
    private boolean withPadindex = false;
    private int withFillfactor = 0;
    private static Location loc = Logger.getLocation("mss.DbMssPrimaryKey");

    public DbMssPrimaryKey() {
    }

    public DbMssPrimaryKey(DbFactory factory, DbPrimaryKey other) {
        super(factory, other);
    }

    public DbMssPrimaryKey(DbFactory factory) {
        super(factory);
    }

    public DbMssPrimaryKey(DbFactory factory, DbSchema schema, String tableName) {
        super(factory, schema, tableName);
    }

    public DbMssPrimaryKey(DbFactory factory, String tableName) {
        super(factory, tableName);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering("setSpecificContentViaXml");
        try {
            XmlMap storage = xmlMap.getXmlMap("storage-parameters");
            if (!storage.isEmpty()) {
                this.dataFilegroup = storage.getString("filegroup");
                this.isClustered = storage.getBoolean("is-clustered");
                this.withFillfactor = storage.getInt("fillfactor");
                this.withPadindex = this.withFillfactor > 0 && this.withFillfactor < 100 ? storage.getBoolean("padindex") : false;
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaXml failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setCommonContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaXml");
        Connection con = this.getDbFactory().getConnection();
        String name = " ";
        String tabname = " ";
        boolean isUnique = false;
        boolean isPrimaryKey = false;
        ArrayList<DbIndexColumnInfo> columnList = new ArrayList<DbIndexColumnInfo>();
        Object dbmd = null;
        long sqlServerVersion = 7L;
        boolean status = false;
        int indid = 0;
        int id = 0;
        int colcnt = 0;
        tabname = this.getTableName();
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery("select @@microsoftversion / (1024*1024*16) ");
            if (drs.next()) {
                sqlServerVersion = drs.getLong(1);
            }
            drs.close();
            dstmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            String uidFct = "";
            uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
            ResultSet drs = dstmt.executeQuery("select si.indid, si.id, si.keycnt from sysindexes si, sysobjects sotab, sysobjects sopk where sotab.name = '" + tabname + "' and sotab.uid = " + uidFct + " and " + "sotab.id = sopk.parent_obj and sopk.xtype = 'PK' and " + "si.id = sotab.id and si.name = sopk.name");
            if (!drs.next()) {
                drs.close();
                dstmt.close();
                throw new JddException(ExType.NOT_ON_DB, "primary key to " + tabname + " doesn't exist on database");
            }
            indid = drs.getInt(1);
            id = drs.getInt(2);
            colcnt = drs.getInt(3);
            drs.close();
            dstmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        StringBuffer queryBuffer = new StringBuffer("select index_col('" + tabname + "', " + indid + ", 1)");
        int col_i = 2;
        while (col_i <= 16) {
            queryBuffer.append(", index_col('" + tabname + "', " + indid + ", " + col_i + ")");
            ++col_i;
        }
        String query = queryBuffer.toString();
        String colName = null;
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery(query);
            if (drs.next()) {
                int col_i2 = 1;
                while (col_i2 <= 16) {
                    colName = drs.getString(col_i2);
                    if (colName == null) break;
                    columnList.add(new DbIndexColumnInfo(colName, false));
                    ++col_i2;
                }
            }
            drs.close();
            dstmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        this.setContent(columnList);
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        String schemaName = null;
        schemaName = this.retrieveSchemaName(con);
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            String uidFct = "";
            uidFct = schemaName != null ? "user_id('" + schemaName + "')" : "user_id()";
            ResultSet drs = dstmt.executeQuery("select sf.groupname, si.indid, si.OrigFillFactor from sysindexes si, sysobjects sotab, sysobjects sopk, sysfilegroups sf  where sotab.uid = " + uidFct + " and sotab.name = '" + this.getTableName() + "' and " + "sotab.id = sopk.parent_obj and sopk.xtype = 'PK' and " + "si.groupid = sf.groupid and " + "si.id = so.id and " + "si.name = sopk.name");
            if (drs.next()) {
                String hlp = drs.getString(1);
                this.dataFilegroup = hlp.equals("PRIMARY") ? "DEFAULT" : hlp;
                this.isClustered = drs.getInt(2) == 1;
                this.withFillfactor = drs.getInt(3);
            }
            drs.close();
            dstmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        super.setDbSpecificIsSet(true);
        loc.exiting();
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        loc.entering("writeSpecificContentToXmlFile");
        try {
            file.println(offset0 + "<primary-key>");
            String offset1 = offset0 + XmlHelper.tabulate();
            String offset2 = offset1 + XmlHelper.tabulate();
            file.println(offset1 + "<storage-parameters>");
            file.println(offset2 + "<filegroup>" + this.dataFilegroup + "</filegroup>");
            file.println(offset2 + "<is-clustered>" + this.isClustered + "</is-clustered>");
            file.println(offset2 + "<fillfactor>" + this.withFillfactor + "</fillfactor>");
            file.println(offset2 + "<index-padded>" + this.withPadindex + "</index-padded>");
            file.println(offset1 + "</storage-parameters>");
            file.println(offset0 + "</primary-key>");
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeSpecificContentToXmlFile failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering("getDdlStatementsForCreate");
        DbObjectSqlStatements pkDef = new DbObjectSqlStatements(this.getTableName() + "$PK");
        DbSqlStatement createStatement = new DbSqlStatement();
        String clusteredStr = this.isClustered ? " CLUSTERED " : " ";
        String schemaName = null;
        if (this.getDbSchema() != null) {
            schemaName = this.getDbSchema().getSchemaName();
        }
        String userdot = "";
        if (schemaName != null) {
            userdot = schemaName + ".";
        }
        createStatement.addLine("ALTER TABLE " + userdot + "[" + this.getTableName() + "] " + "ADD PRIMARY KEY" + clusteredStr);
        createStatement.merge(this.getDdlColumnsClause());
        pkDef.add(createStatement);
        loc.exiting();
        return pkDef;
    }

    public DbSqlStatement getDdlColumnsClause() {
        loc.entering("getDdlColumnsClause");
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        ArrayList indexColumns = this.getColumnNames();
        Iterator icIterator = ((AbstractList)indexColumns).iterator();
        DbIndexColumnInfo indColumn = null;
        String sep = ",";
        while (icIterator.hasNext()) {
            indColumn = (DbIndexColumnInfo)icIterator.next();
            if (!icIterator.hasNext()) {
                sep = "";
            }
            if (indColumn.isDescending()) {
                colDef.addLine("  [" + indColumn.getName() + "] " + sep);
                continue;
            }
            colDef.addLine("  [" + indColumn.getName() + "]" + sep);
        }
        colDef.addLine(")");
        if (this.withPadindex || this.withFillfactor > 0) {
            colDef.addLine("WITH ");
            if (this.withPadindex) {
                colDef.addLine("PADINDEX,");
            }
            if (this.withFillfactor > 0) {
                colDef.addLine("FILLFACTOR = " + this.withFillfactor);
            }
        }
        loc.exiting();
        return colDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering("getDdlStatementsForDrop");
        DbObjectSqlStatements dropDef = new DbObjectSqlStatements(this.getTableName() + "$PK");
        DbSqlStatement dropLine = new DbSqlStatement(true);
        String schemaName = "";
        if (this.getDbSchema() != null) {
            schemaName = this.getDbSchema().getSchemaName();
        }
        String userdot = "";
        String uidFct = "";
        if (schemaName != null) {
            uidFct = "user_id('" + schemaName + "')";
            userdot = schemaName + ".";
        } else {
            uidFct = "user_id()";
        }
        dropLine.addLine("declare @pkName varchar(128)");
        dropLine.addLine("select @pkName = so1.name from sysobjects so1, sysobjects so2 where so2.uid = " + uidFct + " and so2.name = '" + this.getTableName() + "' and " + "so1.parent_obj = so2.id and so1.xtype = 'PK'");
        dropLine.addLine("if @pkName is not null exec ('ALTER TABLE " + userdot + "[" + this.getTableName() + "] DROP CONSTRAINT [' + @pkName + ']')");
        dropDef.add(dropLine);
        return dropDef;
    }

    public boolean checkWidth() {
        Object[] arguments;
        loc.entering("checkWidth");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getTable().getColumns();
        boolean check = true;
        int total = 0;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                check = false;
                arguments = new Object[]{this.getTableName(), colName};
                loc.errorT("checkWidth (PK to {0}, column {1}): no such column in table", arguments);
                continue;
            }
            switch (column.getJavaSqlType()) {
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    check = false;
                    arguments = new Object[]{this.getTableName(), colName, column.getJavaSqlTypeName()};
                    loc.errorT("checkWidth (PK to {0}, column {1}): type {2} not allowed for primary key", arguments);
                    break;
                }
                case -5: {
                    total += 8;
                    break;
                }
                case -3: 
                case -2: {
                    total = (int)((long)total + column.getLength());
                    break;
                }
                case 1: 
                case 12: {
                    total = (int)((long)total + column.getLength() * 2L);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    total += 8;
                    break;
                }
                case 2: 
                case 3: {
                    long prec = column.getLength();
                    if (prec < 10L) {
                        total += 5;
                        break;
                    }
                    if (prec < 20L) {
                        total += 9;
                        break;
                    }
                    if (prec < 29L) {
                        total += 13;
                        break;
                    }
                    total += 17;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    total += 8;
                    break;
                }
                case 4: {
                    total += 4;
                    break;
                }
                case 5: {
                    total += 4;
                    break;
                }
                case -6: {
                    total += 8;
                }
            }
        }
        if (total > 900) {
            check = false;
            arguments = new Object[]{this.getTableName(), new Integer(total)};
            loc.errorT("checkWidth (PK to {0}): total width of primary key ({1}) greater than allowed maximum (900)", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNumberOfColumns() {
        boolean check;
        loc.entering("checkNumberOfColumns");
        int numCols = this.getColumnNames().size();
        boolean bl = check = numCols > 0 && numCols <= 16;
        if (!check) {
            Object[] arguments = new Object[]{this.getTableName(), new Integer(numCols)};
            loc.errorT("checkNumberOfColumns (PK to {0}): column count {1} not in allowed range [1..16]", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkColumnsNotNull() {
        loc.entering("checkColumnsNotNull");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getTable().getColumns();
        boolean check = true;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column != null && column.isNotNull()) continue;
            check = false;
            Object[] arguments = new Object[]{this.getTableName(), colName};
            loc.errorT("checkColumnsNotNull (PK to {0}): column {1} must not be nullable", arguments);
        }
        loc.exiting();
        return check;
    }

    private String retrieveSchemaName(Connection con) throws JddException {
        String schemaName = null;
        if (this.getDbSchema() != null) {
            schemaName = this.getDbSchema().getSchemaName();
        } else {
            try {
                Statement schStmt = NativeSQLAccess.createNativeStatement((Connection)con);
                ResultSet rs = schStmt.executeQuery("select user");
                rs.next();
                schemaName = rs.getString(1);
                rs.close();
                schStmt.close();
            }
            catch (Exception ex) {
                Object[] arguments = new Object[]{ex.getMessage()};
                loc.errorT("retrieveSchemaName failed: {0}", arguments);
                loc.exiting();
                throw JddException.createInstance(ex);
            }
        }
        return schemaName;
    }
}

